/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuODY3MjMgNS41NDM0QzYuMTEyNTEgNS4xMDg3NyA1LjE0NzQ2IDUuMzY2NyA0LjcxMTczIDYuMTE5NDlDNC4yNzU5OSA2Ljg3MjI4IDQuNTM0NTggNy44MzQ4NyA1LjI4OTI5IDguMjY5NUw3LjkxODk0IDkuNzgzODZDOC4yMjg4OCA5Ljk2MjM1IDguNDE5OSAxMC4yOTI4IDguNDE5OSAxMC42NTA0VjE0LjE4NTZDOC40MTk5IDE0LjM2MTUgOC4zNzM0OSAxNC41MzQzIDguMjg1MzcgMTQuNjg2NUw1Ljg3NjYzIDE4Ljg0OEM1LjQ0MDg5IDE5LjYwMDggNS42OTk0OCAyMC41NjMzIDYuNDU0MTkgMjAuOTk4QzcuMjA4OTEgMjEuNDMyNiA4LjE3Mzk1IDIxLjE3NDcgOC42MDk2OSAyMC40MjE5TDExLjg2NzUgMTQuNzkzNUgxMi4xMjY0TDE1LjM4NDMgMjAuNDIxOUMxNS44MiAyMS4xNzQ3IDE2Ljc4NTEgMjEuNDMyNiAxNy41Mzk4IDIwLjk5OEMxOC4yOTQ1IDIwLjU2MzMgMTguNTUzMSAxOS42MDA4IDE4LjExNzMgMTguODQ4TDE1LjcxNDggMTQuNjk3MUMxNS42MjY2IDE0LjU0NDkgMTUuNTgwMiAxNC4zNzIxIDE1LjU4MDIgMTQuMTk2MlYxMC42NTA0QzE1LjU4MDIgMTAuMjkyOCAxNS43NzEyIDkuOTYyMzUgMTYuMDgxMiA5Ljc4Mzg2TDE4LjcxMDggOC4yNjk1QzE5LjQ2NTUgNy44MzQ4NyAxOS43MjQxIDYuODcyMjggMTkuMjg4NCA2LjExOTQ5QzE4Ljg1MjcgNS4zNjY3IDE3Ljg4NzYgNS4xMDg3NyAxNy4xMzI5IDUuNTQzNEwxMy40OTcyIDcuNjM3MTNDMTIuNTcwNSA4LjE3MDgyIDExLjQyOTcgOC4xNzA4MiAxMC41MDI5IDcuNjM3MTNMNi44NjcyMyA1LjU0MzRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE0LjYyMzIgNS40MTQyMUMxNC42MjMyIDYuODYyOTYgMTMuNDQ4OCA4LjAzNzQgMTIgOC4wMzc0QzEwLjU1MTMgOC4wMzc0IDkuMzc2ODMgNi44NjI5NiA5LjM3NjgzIDUuNDE0MjFDOS4zNzY4MyAzLjk2NTQ2IDEwLjU1MTMgMi43OTEwMiAxMiAyLjc5MTAyQzEzLjQ0ODggMi43OTEwMiAxNC42MjMyIDMuOTY1NDYgMTQuNjIzMiA1LjQxNDIxWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AccessibilityIcon: ProIcon;
export { AccessibilityIcon }
export { AccessibilityIcon as accessibility }

/**
 * @description Add Circle, Plus
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMiA4LjVWMTUuNU04LjUgMTJIMTUuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AddCircularIcon: ProIcon;
export { AddCircularIcon }
export { AddCircularIcon as addCircular }

/**
 * @description Plus, Create, New, Addition
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQgMTJIMTJNMTIgMTJMMjAgMTJNMTIgMTJWNE0xMiAxMkwxMiAyMCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AddIcon: ProIcon;
export { AddIcon }
export { AddIcon as AdditionIcon }
export { AddIcon as CreateIcon }
export { AddIcon as PlusIcon }
export { AddIcon as add }
export { AddIcon as addition }
export { AddIcon as create }
export { AddIcon as plus }

/**
 * @description Add Diamond, Plus, Keyframe, Component
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzc0ODYgMTQuNDc0OUMyLjQwODAzIDEzLjEwODEgMi40MDgwMyAxMC44OTIgMy43NzQ4NiA5LjUyNTE4TDkuNTI1MTEgMy43NzQ5MkMxMC44OTE5IDIuNDA4MDkgMTMuMTA4IDIuNDA4MDkgMTQuNDc0OSAzLjc3NDkyTDIwLjIyNTEgOS41MjUxN0MyMS41OTE5IDEwLjg5MiAyMS41OTE5IDEzLjEwODEgMjAuMjI1MSAxNC40NzQ5TDE0LjQ3NDkgMjAuMjI1MkMxMy4xMDggMjEuNTkyIDEwLjg5MTkgMjEuNTkyIDkuNTI1MTEgMjAuMjI1MkwzLjc3NDg2IDE0LjQ3NDlaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTguMjUgMTJIMTJNMTIgMTJMMTUuNzUgMTJNMTIgMTJWOC4yNU0xMiAxMkwxMiAxNS43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AddRhombusIcon: ProIcon;
export { AddRhombusIcon }
export { AddRhombusIcon as addRhombus }

/**
 * @description Add Box, Plus
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDguNVYxNS41TTguNSAxMkgxNS41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AddSquareIcon: ProIcon;
export { AddSquareIcon }
export { AddSquareIcon as addSquare }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjYzMDIgNy42NjAzVjEzLjU5OTdNNy42NjA1MiAxMC42M0gxMy41OTk5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMy42MyIgeT0iMy42MyIgd2lkdGg9IjE0IiBoZWlnaHQ9IjE0IiByeD0iMyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMC42MyA3LjYzVjE0LjYzQzIwLjYzIDE3Ljk0MzcgMTcuOTQzNyAyMC42MyAxNC42MyAyMC42M0g3LjYzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const AddSquareMultipleIcon: ProIcon;
export { AddSquareMultipleIcon }
export { AddSquareMultipleIcon as AddSquareMultipleVarIcon }
export { AddSquareMultipleIcon as addSquareMultiple }
export { AddSquareMultipleIcon as addSquareMultipleVar }

/**
 * @description Aircraft, Plane, Aviation, Jet, Boeing, Airbus, Flight, Aeroplane, Airplane Mode, Flight Mode, Fly
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjIzODEgNC41MTE5MUMxMC4yMzgxIDMuNTM4ODMgMTEuMDI2OSAyLjc1IDEyIDIuNzVDMTIuOTczMSAyLjc1IDEzLjc2MTkgMy41Mzg4MyAxMy43NjE5IDQuNTExOTFMMTMuNzYxOSA4LjkwMDE1TDIwLjQ5NDYgMTIuNDM0OEMyMC44MjM3IDEyLjYwNzYgMjEuMDI5OCAxMi45NDg2IDIxLjAyOTggMTMuMzIwMlYxMy43NTE1QzIxLjAyOTggMTQuMTI3NSAyMC42ODc4IDE0LjQxMDkgMjAuMzE4MyAxNC4zNDFMMTMuNzYxOSAxMy4xMDE5VjE3LjIwODRDMTMuNzYxOSAxNy40Mjk3IDEzLjg4MzcgMTcuNjMzIDE0LjA3ODggMTcuNzM3NEwxNS45NDA3IDE4LjczMzhDMTYuNDI4NCAxOC45OTQ4IDE2LjczMjkgMTkuNTAzMSAxNi43MzI5IDIwLjA1NjNWMjAuNTAyOUMxNi43MzI5IDIwLjg4NjUgMTYuMzc4IDIxLjE3MTUgMTYuMDAzNCAyMS4wODg4TDEyIDIwLjIwMzlMNy45OTY1OCAyMS4wODg4QzcuNjIyMDUgMjEuMTcxNSA3LjI2NzA5IDIwLjg4NjUgNy4yNjcwOSAyMC41MDI5VjIwLjA1NjNDNy4yNjcwOSAxOS41MDMxIDcuNTcxNTkgMTguOTk0OCA4LjA1OTM1IDE4LjczMzhMOS45MjExOSAxNy43Mzc0QzEwLjExNjMgMTcuNjMzIDEwLjIzODEgMTcuNDI5NyAxMC4yMzgxIDE3LjIwODRMMTAuMjM4MSAxMy4xMDE5TDMuNjgxNjYgMTQuMzQxQzMuMzEyMTcgMTQuNDEwOSAyLjk3MDI0IDE0LjEyNzUgMi45NzAyNCAxMy43NTE1VjEzLjMyMDJDMi45NzAyNCAxMi45NDg2IDMuMTc2MzUgMTIuNjA3NiAzLjUwNTQgMTIuNDM0OEwxMC4yMzgxIDguOTAwMTVWNC41MTE5MVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AirplaneIcon: ProIcon;
export { AirplaneIcon }
export { AirplaneIcon as airplane }

/**
 * @description Aircraft, Plane, Aviation, Jet, Boeing, Airbus, Flight, Aeroplane, Airplane Mode, Flight Mode, Fly, TO, Climb
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMjAuNzVIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTkuMTk5NyAxMy4yOTcyQzIwLjE1MTEgMTMuNTUyMSAyMC43MTU3IDE0LjUzIDIwLjQ2MDcgMTUuNDgxNEMyMC4yMDU4IDE2LjQzMjcgMTkuMjI3OSAxNi45OTczIDE4LjI3NjYgMTYuNzQyNEw4LjE4NTMzIDE0LjAzODVDNy43MTA1OCAxMy45MTEzIDcuMjYyOTUgMTMuNjk4NyA2Ljg2NDM2IDEzLjQxMTFMNC43MjU2OSAxMS44NjgxQzMuODk1OTcgMTEuMjY5NSAzLjQyMzQ4IDEwLjI5MzMgMy40Njg3NiA5LjI3MTJMMy41Nzk4NSA2Ljc2MzAyQzMuNTk3MDMgNi4zNzUxNSAzLjk2ODc0IDYuMTAyNzkgNC4zNDM3NSA2LjIwMzI3TDQuNzgwMzggNi4zMjAyN0M1LjMyMTI1IDYuNDY1MTkgNS43Mzg0NSA2Ljg5NjA2IDUuODY1ODYgNy40NDEzM0w2LjM1MjIyIDkuNTIyNjRDNi40MDMxOCA5Ljc0MDc1IDYuNTcwMDYgOS45MTMxIDYuNzg2NDEgOS45NzEwN0wxMC44MDE0IDExLjA0NjlMMTEuMzA3NSA0LjMxMjA3QzExLjMzNiAzLjkzMjUyIDExLjcwMjYgMy42NzI0NSAxMi4wNzAyIDMuNzcwOTZMMTIuNDkxOSAzLjg4Mzk0QzEyLjg1NTIgMy45ODEzIDEzLjEzNDYgNC4yNzIxNCAxMy4yMTczIDQuNjM5MTJMMTQuOTA5NCAxMi4xNDc2TDE5LjE5OTcgMTMuMjk3MloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AirplaneLandingIcon: ProIcon;
export { AirplaneLandingIcon }
export { AirplaneLandingIcon as airplaneLanding }

/**
 * @description Aircraft, Plane, Aviation, Jet, Boeing, Airbus, Flight, Aeroplane, Airplane Mode, Flight Mode, Fly, TO, Climb
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMjAuNzVIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTguNTc0NiA2LjI5ODYzQzE5LjQyNzYgNS44MDYxNyAyMC41MTgzIDYuMDk4NDIgMjEuMDEwOCA2Ljk1MTM5QzIxLjUwMzIgNy44MDQzNiAyMS4yMTEgOC44OTUwNSAyMC4zNTggOS4zODc1MkwxMS4zMTA1IDE0LjYxMTFDMTAuODg0OCAxNC44NTY5IDEwLjQxOCAxNS4wMjMxIDkuOTMyNzcgMTUuMTAxNkw3LjMyOTQ1IDE1LjUyMjhDNi4zMTk0NyAxNS42ODYyIDUuMjk1MSAxNS4zMyA0LjYwNDM3IDE0LjU3NTNMMi45MDkzNyAxMi43MjMyQzIuNjQ3MjUgMTIuNDM2OCAyLjcxNzUgMTEuOTgxMyAzLjA1MzczIDExLjc4NzJMMy40NDUxOSAxMS41NjEyQzMuOTMwMTMgMTEuMjgxMiA0LjUyOTggMTEuMjkwOSA1LjAwNTQ2IDExLjU4NjRMNi44MjEwOCAxMi43MTQyQzcuMDExMzQgMTIuODMyNCA3LjI1MTIxIDEyLjgzNjIgNy40NDUxOSAxMi43MjQyTDExLjA0NDkgMTAuNjQ1OUw2LjY0MDUzIDUuNTI1ODVDNi4zOTIzMiA1LjIzNzMgNi40Njc2NiA0Ljc5NDE2IDYuNzk3MjggNC42MDM4Nkw3LjE3NTMgNC4zODU2MUM3LjUwMTA4IDQuMTk3NTIgNy45MDQzIDQuMjA1NjEgOC4yMjIyNiA0LjQwNjYzTDE0LjcyOCA4LjUxOTQ4TDE4LjU3NDYgNi4yOTg2M1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AirplaneTakeoffIcon: ProIcon;
export { AirplaneTakeoffIcon }
export { AirplaneTakeoffIcon as airplaneTakeoff }

/**
 * @description Warning
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGVsbGlwc2UgY3g9IjEyIiBjeT0iMTIiIHJ4PSI5LjI1IiByeT0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8cGF0aCBkPSJNMTIuMDAwMSAxMi40Mzc1TDEyLjAwMDEgNy40Mzc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPGVsbGlwc2UgY3g9IjEuMjUiIGN5PSIxLjI1IiByeD0iMS4yNSIgcnk9IjEuMjUiIHRyYW5zZm9ybT0ibWF0cml4KDEgMCAwIC0xIDEwLjc1MDEgMTcuMDYyNSkiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const AlertCircleIcon: ProIcon;
export { AlertCircleIcon }
export { AlertCircleIcon as alertCircle }

/**
 * @description Warning
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuNzMyMjUgMjAuNUMzLjQ0MjI1IDIwLjUgMi4wMDkyNiAxOC4wMDE5IDMuMTUwNzYgMTUuOTk5N0w5LjQxODUxIDUuMDA2MjJDMTAuNTYzNSAyLjk5NzkzIDEzLjQzNjUgMi45OTc5MyAxNC41ODE1IDUuMDA2MjJMMjAuODQ5MiAxNS45OTk3QzIxLjk5MDcgMTguMDAxOSAyMC41NTc3IDIwLjUgMTguMjY3NyAyMC41SDUuNzMyMjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxwYXRoIGQ9Ik0xMiAxMy4zNzVMMTIgOSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxlbGxpcHNlIGN4PSIxLjI1IiBjeT0iMS4yNSIgcng9IjEuMjUiIHJ5PSIxLjI1IiB0cmFuc2Zvcm09Im1hdHJpeCgxIDAgMCAtMSAxMC43NTAxIDE3LjkzNzUpIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AlertTriangleIcon: ProIcon;
export { AlertTriangleIcon }
export { AlertTriangleIcon as alertTriangle }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMjEuMjVIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB3aWR0aD0iNiIgaGVpZ2h0PSIxMCIgcng9IjIiIHRyYW5zZm9ybT0ibWF0cml4KC0xIDAgMCAxIDE5Ljc1IDcuNzUpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3Qgd2lkdGg9IjYiIGhlaWdodD0iMTUiIHJ4PSIyIiB0cmFuc2Zvcm09Im1hdHJpeCgtMSAwIDAgMSAxMC4yNSAyLjc1KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AlignBottomIcon: ProIcon;
export { AlignBottomIcon }
export { AlignBottomIcon as alignBottom }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5Ljc1IDEyTDIxLjI1IDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEwLjI1IDEyTDEzLjc1IDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTJMNC4yNSAxMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHdpZHRoPSI2IiBoZWlnaHQ9IjEwIiByeD0iMiIgdHJhbnNmb3JtPSJtYXRyaXgoLTEgLTguNzQyMjhlLTA4IC04Ljc0MjI4ZS0wOCAxIDE5Ljc1IDcpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3Qgd2lkdGg9IjYiIGhlaWdodD0iMTUiIHJ4PSIyIiB0cmFuc2Zvcm09Im1hdHJpeCgtMSAtOC43NDIyOGUtMDggLTguNzQyMjhlLTA4IDEgMTAuMjUgNC41KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AlignHorizontalCentersIcon: ProIcon;
export { AlignHorizontalCentersIcon }
export { AlignHorizontalCentersIcon as alignHorizontalCenters }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMi43NUwyLjc1IDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3Qgd2lkdGg9IjYiIGhlaWdodD0iMTAiIHJ4PSIyIiB0cmFuc2Zvcm09Im1hdHJpeCg0LjM3MTE0ZS0wOCAtMSAtMSAtNC4zNzExNGUtMDggMTYuMjUgMTkuNzUpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3Qgd2lkdGg9IjYiIGhlaWdodD0iMTUiIHJ4PSIyIiB0cmFuc2Zvcm09Im1hdHJpeCg0LjM3MTE0ZS0wOCAtMSAtMSAtNC4zNzExNGUtMDggMjEuMjUgMTAuMjUpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const AlignLeftIcon: ProIcon;
export { AlignLeftIcon }
export { AlignLeftIcon as alignLeft }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjI1IDIuNzVMMjEuMjUgMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSI3Ljc1IiB5PSIxOS43NSIgd2lkdGg9IjYiIGhlaWdodD0iMTAiIHJ4PSIyIiB0cmFuc2Zvcm09InJvdGF0ZSgtOTAgNy43NSAxOS43NSkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIyLjc1IiB5PSIxMC4yNSIgd2lkdGg9IjYiIGhlaWdodD0iMTUiIHJ4PSIyIiB0cmFuc2Zvcm09InJvdGF0ZSgtOTAgMi43NSAxMC4yNSkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AlignRightIcon: ProIcon;
export { AlignRightIcon }
export { AlignRightIcon as alignRight }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMi43NUgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjE5Ljc1IiB5PSIxNi4yNSIgd2lkdGg9IjYiIGhlaWdodD0iMTAiIHJ4PSIyIiB0cmFuc2Zvcm09InJvdGF0ZSgxODAgMTkuNzUgMTYuMjUpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMTAuMjUiIHk9IjIxLjI1IiB3aWR0aD0iNiIgaGVpZ2h0PSIxNSIgcng9IjIiIHRyYW5zZm9ybT0icm90YXRlKDE4MCAxMC4yNSAyMS4yNSkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AlignTopIcon: ProIcon;
export { AlignTopIcon }
export { AlignTopIcon as alignTop }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDE5Ljc1TDEyIDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyIDEwLjI1TDEyIDEzLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyIDIuNzVMMTIgNC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjciIHk9IjE5Ljc1IiB3aWR0aD0iNiIgaGVpZ2h0PSIxMCIgcng9IjIiIHRyYW5zZm9ybT0icm90YXRlKC05MCA3IDE5Ljc1KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjQuNSIgeT0iMTAuMjUiIHdpZHRoPSI2IiBoZWlnaHQ9IjE1IiByeD0iMiIgdHJhbnNmb3JtPSJyb3RhdGUoLTkwIDQuNSAxMC4yNSkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AlignVerticalCentersIcon: ProIcon;
export { AlignVerticalCentersIcon }
export { AlignVerticalCentersIcon as alignVerticalCenters }

/**
 * @description Shopping, Delivery, Prime
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const AmazonIcon: ProIcon;
export { AmazonIcon }
export { AmazonIcon as amazon }

/**
 * @description Lock
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMTJDMi43NSAxNC40NTMzIDMuNzI0NTUgMTYuODA2IDUuNDU5MjYgMTguNTQwN0M3LjE5Mzk3IDIwLjI3NTQgOS41NDY3NSAyMS4yNSAxMiAyMS4yNUMxNC40NTMzIDIxLjI1IDE2LjgwNiAyMC4yNzU1IDE4LjU0MDcgMTguNTQwN0MyMC4yNzU0IDE2LjgwNiAyMS4yNSAxNC40NTMzIDIxLjI1IDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyIDIxLjI1VjcuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjUuMjUiIHI9IjIuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8cGF0aCBkPSJNMi43NSAxMkg2Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTE3LjI1IDEySDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const AnchorIcon: ProIcon;
export { AnchorIcon }
export { AnchorIcon as anchor }

/**
 * @description Social
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2Ljc2MzcgOS45MDY3M0MxNy40MDkgMTAuMzE0NyAxOC4wMDYgMTAuODA0OSAxOC41NDA3IDExLjM2NzZDMTkuMzk5NyAxMi4yNzE0IDIwLjA4MSAxMy4zNDQ0IDIwLjU0NTkgMTQuNTI1M0MyMC44ODkyIDE1LjM5NzUgMjEuMTA5NSAxNi4zMTYgMjEuMjAxMiAxNy4yNTE2QzIxLjI1NTEgMTcuODAxMiAyMC44MDIzIDE4LjI1IDIwLjI1IDE4LjI1TDMuNzUgMTguMjVDMy4xOTc3MiAxOC4yNSAyLjc0NDkzIDE3LjgwMTIgMi43OTg3OSAxNy4yNTE2QzIuODkwNDkgMTYuMzE2IDMuMTEwNzYgMTUuMzk3NSAzLjQ1NDExIDE0LjUyNTNDMy45MTg5NyAxMy4zNDQ0IDQuNjAwMzIgMTIuMjcxNCA1LjQ1OTI2IDExLjM2NzZDNS45OTM5OSAxMC44MDQ5IDYuNTkxMDIgMTAuMzE0NyA3LjIzNjMxIDkuOTA2NzNNMTYuNzYzNyA5LjkwNjczQzE2LjM3MjQgOS42NTkzOCAxNS45NjM0IDkuNDQyMjkgMTUuNTM5OCA5LjI1NzY2QzE0LjQxNzYgOC43Njg1MiAxMy4yMTQ3IDguNTE2NzYgMTIgOC41MTY3NkMxMC43ODUzIDguNTE2NzYgOS41ODI0NCA4Ljc2ODUyIDguNDYwMTggOS4yNTc2NkM4LjAzNjU3IDkuNDQyMjkgNy42Mjc1NiA5LjY1OTM4IDcuMjM2MzEgOS45MDY3M00xNi43NjM3IDkuOTA2NzNMMTguNDkgNi43NU03LjIzNjMxIDkuOTA2NzNMNS41MSA2Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iOC43NSIgY3k9IjE0LjA2MjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTUuMjUiIGN5PSIxNC4wNjI1IiByPSIxLjI1IiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const AndroidIcon: ProIcon;
export { AndroidIcon }
export { AndroidIcon as android }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuMjUgNC4yNVYxNi43NUM0LjI1IDE4LjQwNjkgNS41OTMxNSAxOS43NSA3LjI1IDE5Ljc1SDE5Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTQuMjUgMTAuMzU2MUg0LjY0Mzk0QzkuNjE0NSAxMC4zNTYxIDEzLjY0MzkgMTQuMzg1NSAxMy42NDM5IDE5LjM1NjFWMTkuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AngleIcon: ProIcon;
export { AngleIcon }
export { AngleIcon as angle }

/**
 * @description iPhone, iPad, Mac, iOS, iPadOS, watchOS, Watch, Tablet, Phone, Tim Cook, Steve Jobs, macOS, Cupertino
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xMC4xMDIzIDcuNzc5MjhDOS43MjgwOSA3LjY2NDM5IDkuMzI4MDMgNy42MTg1MyA4LjkxNjUzIDcuNjE4NTNDNi45OTg5NCA3LjYxODUzIDQuNzUgOS4zMTQ0OCA0Ljc1IDEyLjk3NzhDNC43NSAxNi4zMzg1IDcuMTA3OTggMjAuMTg3NSA4LjU1MTM1IDIwLjgwMDNDOC44NzkzOCAyMC45Mzk2IDkuMjgyMDMgMjEuMDI2OSA5LjYzNDkgMjAuOTkyNkMxMC4zNDIzIDIwLjkyMzcgMTAuOTgzMyAyMC41NzE2IDExLjY1ODMgMjAuMzcwNUMxMS44ODY0IDIwLjMzMzEgMTIuMTU4OCAyMC4yOTc0IDEyLjM3NjcgMjAuMjk1NkMxMi42MTYzIDIwLjI5MzcgMTIuODg2NyAyMC4zNTU3IDEzLjE1MDggMjAuNDE2MkMxMy44NjYgMjAuNTgwMiAxNC42NTYgMjEuMDY1NSAxNS40MDU4IDIwLjk5MjZDMTUuNjcyNiAyMC45NjY2IDE2LjAzOTIgMjAuODA2MiAxNi4xNTIgMjAuNzU0NEMxNi4xNzUxIDIwLjc0MzcgMTYuMTk3OSAyMC43MzQyIDE2LjIyMTUgMjAuNzI0N0MxNy4wNzI1IDIwLjM4MDUgMTguMjEgMTguODk4MiAxOC45ODA5IDE3LjAyMTNDMTkuMTQzNSAxNi42MjU1IDE4LjkyODggMTYuMTg4MiAxOC41NzczIDE1Ljk0NDFDMTcuNTc4MSAxNS4yNSAxNi45MTQ0IDE0LjAxMDMgMTYuOTE0NCAxMi43NDk1QzE2LjkxNDQgMTEuNzgwMSAxNy4yMjY3IDEwLjg5NDkgMTcuODIwOSAxMC4yMjU5QzE3LjgyNzYgMTAuMjE4NCAxNy44MzQgMTAuMjExIDE3Ljg0MDUgMTAuMjAzM0MxNy44OTAzIDEwLjE0MzggMTguMTI1OSA5Ljg2NDI0IDE4LjI5MTIgOS43MDMzNFY5LjcwMzM0QzE4LjU0NjIgOS40NTUxMSAxOC42MTc1IDkuMDU4MDggMTguMzczIDguNzk5NDhDMTcuNTY1MyA3Ljk0NTA3IDE2LjU0MDYgNy41MjI0IDE1LjYwOTMgNy41MjI0QzE1LjIzNTcgNy41MjI0IDE0Ljg4MjggNy41NjM5MyAxNC41NTYyIDcuNjYyODZDMTQuNTM4MyA3LjY2ODI4IDE0LjUyMDggNy42NzMxOCAxNC41MDI3IDcuNjc3NkMxNC4zNjQ4IDcuNzExMjEgMTMuNzI0NSA3Ljg3MDM2IDEzLjI4MDYgOC4wMzMwOUMxMy4wMjM2IDguMTA0MjcgMTIuNjQ2IDguMTk5OSAxMi40NzE1IDguMjQzN0MxMi40MDg1IDguMjU5NTIgMTIuMzQzOCA4LjI2NzkgMTIuMjc4OSA4LjI2NTgzQzExLjU0NDEgOC4yNDI0MyAxMC44MDg5IDcuOTYzMTYgMTAuMTAyMyA3Ljc3OTI4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuODYwOSA1LjE3ODA3QzEzLjEyNjUgNi4wNTY0NCAxMS44ODU0IDYuMjI0NjkgMTEuODg1NCA2LjIyNDY5QzExLjg4NTQgNi4yMjQ2OSAxMS44MzUgNC45Njg4MSAxMi41Njk0IDQuMDkwNDRDMTMuMzAzOCAzLjIxMjA2IDE0LjU0NDggMy4wNDM4MiAxNC41NDQ4IDMuMDQzODJDMTQuNTQ0OCAzLjA0MzgyIDE0LjU5NTMgNC4yOTk2OSAxMy44NjA5IDUuMTc4MDdaIiBmaWxsPSIjZmZmZmZmIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const AppleIcon: ProIcon;
export { AppleIcon }
export { AppleIcon as apple }

/**
 * @description Uninstall, Delete App
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjYuNSIgaGVpZ2h0PSI2LjUiIHJ4PSIyIiB0cmFuc2Zvcm09Im1hdHJpeCgxIDAgMCAtMSAzLjc1IDIwLjI1KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMC4yNSAyMC4yNUwxNyAxN00xNyAxN0wxMy43NSAxMy43NU0xNyAxN0wxMy43NSAyMC4yNU0xNyAxN0wyMC4yNSAxMy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHdpZHRoPSI2LjUiIGhlaWdodD0iNi41IiByeD0iMiIgdHJhbnNmb3JtPSJtYXRyaXgoMSAwIDAgLTEgMy43NSAxMC4yNSkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB3aWR0aD0iNi41IiBoZWlnaHQ9IjYuNSIgcng9IjIiIHRyYW5zZm9ybT0ibWF0cml4KDEgMCAwIC0xIDEzLjc1IDEwLjI1KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AppRemoveIcon: ProIcon;
export { AppRemoveIcon }
export { AppRemoveIcon as appRemove }

/**
 * @description Add App, Install
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjYuNSIgaGVpZ2h0PSI2LjUiIHJ4PSIyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE3IDMuNzVWN00xNyA3VjEwLjI1TTE3IDdIMTMuNzVNMTcgN0gyMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjMuNzUiIHk9IjEzLjc1IiB3aWR0aD0iNi41IiBoZWlnaHQ9IjYuNSIgcng9IjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIxMy43NSIgeT0iMTMuNzUiIHdpZHRoPSI2LjUiIGhlaWdodD0iNi41IiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AppsAddIcon: ProIcon;
export { AppsAddIcon }
export { AppsAddIcon as appsAdd }

/**
 * @description Applications, Software, Plugins, Extensions
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjYuNSIgaGVpZ2h0PSI2LjUiIHJ4PSIyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjU4NTggMy44MTgwMkMxNi4zNjY4IDMuMDM2OTcgMTcuNjMzMiAzLjAzNjk3IDE4LjQxNDIgMy44MTgwMkwyMC4xODIgNS41ODU3OUMyMC45NjMgNi4zNjY4NCAyMC45NjMgNy42MzMxNyAyMC4xODIgOC40MTQyMUwxOC40MTQyIDEwLjE4MkMxNy42MzMyIDEwLjk2MyAxNi4zNjY4IDEwLjk2MyAxNS41ODU4IDEwLjE4MkwxMy44MTggOC40MTQyMUMxMy4wMzcgNy42MzMxNiAxMy4wMzcgNi4zNjY4MyAxMy44MTggNS41ODU3OUwxNS41ODU4IDMuODE4MDJaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMy43NSIgeT0iMTMuNzUiIHdpZHRoPSI2LjUiIGhlaWdodD0iNi41IiByeD0iMS41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMTMuNzUiIHk9IjEzLjc1IiB3aWR0aD0iNi41IiBoZWlnaHQ9IjYuNSIgcng9IjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AppsIcon: ProIcon;
export { AppsIcon }
export { AppsIcon as apps }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjI1IDQuNUwyMS4yNSA0LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIyLjc1IiB5PSIyLjc1IiB3aWR0aD0iMy41IiBoZWlnaHQ9IjMuNSIgcng9IjEuMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMC4yNSAxMkwyMS4yNSAxMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjIuNzUiIHk9IjEwLjI1IiB3aWR0aD0iMy41IiBoZWlnaHQ9IjMuNSIgcng9IjEuMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMC4yNSAxOS41TDIxLjI1IDE5LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIyLjc1IiB5PSIxNy43NSIgd2lkdGg9IjMuNSIgaGVpZ2h0PSIzLjUiIHJ4PSIxLjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AppsListIcon: ProIcon;
export { AppsListIcon }
export { AppsListIcon as appsList }

/**
 * @description Apple, Mac App Store, Apple App Store, iOS, iPadOs, macOS
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjkwMzkgMTMuNzk0SDEyLjkyODJMMTEuOTE2MSAxMi4wMzk0TDEwLjkwMzkgMTMuNzk0WiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNOC44NDI4NSAxNy4zNjY4TDcuMjYyNDIgMjAuMTA2NUM2Ljc2OTUyIDIwLjk2MDkgNS42Nzc4NyAyMS4yNTM3IDQuODI0MTQgMjAuNzYwNEMzLjk3MDQyIDIwLjI2NzEgMy42Nzc5MSAxOS4xNzQ1IDQuMTcwODEgMTguMzIwMUw0LjcyMDcxIDE3LjM2NjhNOC44NDI4NSAxNy4zNjY4SDQuNzIwNzFNOC44NDI4NSAxNy4zNjY4TDE0Ljk4OTMgMTcuMzY2OE00LjcyMDcxIDE3LjM2NjhINC4yNTQ2N0MzLjI2ODg3IDE3LjM2NjggMi40Njk3MyAxNi41NjcgMi40Njk3MyAxNS41ODA0QzIuNDY5NzMgMTQuNTkzOCAzLjI2ODg3IDEzLjc5NCA0LjI1NDY3IDEzLjc5NEg2Ljc4MTc4TDkuODU1MDEgOC40NjY1M0w4LjgyNDM4IDYuNjc5OTRDOC4zMzE0OCA1LjgyNTUgOC42MjM5OSA0LjczMjk0IDkuNDc3NzEgNC4yMzk2M0MxMC4zMzE0IDMuNzQ2MzMgMTEuNDIzMyA0LjAzOTA4IDExLjkxNjIgNC44OTM1MUMxMi40MDkxIDQuMDM5MDggMTMuNTAwNyAzLjc0NjMzIDE0LjM1NDQgNC4yMzk2M0MxNS4yMDgyIDQuNzMyOTQgMTUuNTAwNyA1LjgyNTUgMTUuMDA3OCA2LjY3OTk0TDEzLjk3NzIgOC40NjY0MU0xMi45MjgyIDEzLjc5NEgxMC45MDM5TDExLjkxNjEgMTIuMDM5NE0xMi45MjgyIDEzLjc5NEwxNC45ODkzIDE3LjM2NjhNMTIuOTI4MiAxMy43OTRMMTEuOTE2MSAxMi4wMzk0TTE0Ljk4OTMgMTcuMzY2OEwxNi41Njk3IDIwLjEwNjVDMTcuMDYyNiAyMC45NjA5IDE4LjE1NDMgMjEuMjUzNyAxOS4wMDggMjAuNzYwNEMxOS44NjE3IDIwLjI2NzEgMjAuMTU0MiAxOS4xNzQ1IDE5LjY2MTQgMTguMzIwMUwxOS4xMTE1IDE3LjM2NjhIMTkuNzQ1NEMyMC43MzEyIDE3LjM2NjggMjEuNTMwMyAxNi41NjcgMjEuNTMwMyAxNS41ODA0QzIxLjUzMDMgMTQuNTkzOCAyMC43MzEyIDEzLjc5NCAxOS43NDU0IDEzLjc5NEgxNy4wNTA0TDEzLjk3NzIgOC40NjY0MU0xMy45NzcyIDguNDY2NDFMMTEuOTE2MSAxMi4wMzk0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const AppStoreIcon: ProIcon;
export { AppStoreIcon }
export { AppStoreIcon as appStore }

/**
 * @description UPDATE
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjI1IDEyLjI1SDEyLjI1TTMuNzUgOC4yNUgyMC4yNU0yMC4yNSAxMC4yNVY4LjU1QzIwLjI1IDYuODY5ODQgMjAuMjUgNi4wMjk3NiAxOS45MjMgNS4zODgwM0MxOS42MzU0IDQuODIzNTQgMTkuMTc2NSA0LjM2NDYgMTguNjEyIDQuMDc2OThDMTcuOTcwMiAzLjc1IDE3LjEzMDIgMy43NSAxNS40NSAzLjc1SDguNTVDNi44Njk4NCAzLjc1IDYuMDI5NzYgMy43NSA1LjM4ODAzIDQuMDc2OThDNC44MjM1NCA0LjM2NDYgNC4zNjQ2IDQuODIzNTQgNC4wNzY5OCA1LjM4ODAzQzMuNzUgNi4wMjk3NiAzLjc1IDYuODY5ODQgMy43NSA4LjU1VjE1LjQ1QzMuNzUgMTcuMTMwMiAzLjc1IDE3Ljk3MDIgNC4wNzY5OCAxOC42MTJDNC4zNjQ2IDE5LjE3NjUgNC44MjM1NCAxOS42MzU0IDUuMzg4MDMgMTkuOTIzQzYuMDI5NzYgMjAuMjUgNi44Njk4NCAyMC4yNSA4LjU1IDIwLjI1SDEwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNy41IDIzQzIwLjUzNzYgMjMgMjMgMjAuNTM3NiAyMyAxNy41QzIzIDE0LjQ2MjQgMjAuNTM3NiAxMiAxNy41IDEyQzE0LjQ2MjQgMTIgMTIgMTQuNDYyNCAxMiAxNy41QzEyIDIwLjUzNzYgMTQuNDYyNCAyMyAxNy41IDIzWk0xNy41IDE0LjAwNjZDMTcuNzc2MSAxNC4wMDY2IDE4IDE0LjIzMDQgMTggMTQuNTA2NlYxNy4wMDAxSDIwLjQ5MzRDMjAuNzY5NiAxNy4wMDAxIDIwLjk5MzQgMTcuMjIzOSAyMC45OTM0IDE3LjUwMDFDMjAuOTkzNCAxNy43NzYyIDIwLjc2OTYgMTguMDAwMSAyMC40OTM0IDE4LjAwMDFIMThWMjAuNDkzNEMxOCAyMC43Njk2IDE3Ljc3NjEgMjAuOTkzNCAxNy41IDIwLjk5MzRDMTcuMjIzOSAyMC45OTM0IDE3IDIwLjc2OTYgMTcgMjAuNDkzNFYxOC4wMDAxSDE0LjUwNjZDMTQuMjMwNCAxOC4wMDAxIDE0LjAwNjYgMTcuNzc2MiAxNC4wMDY2IDE3LjUwMDFDMTQuMDA2NiAxNy4yMjM5IDE0LjIzMDQgMTcuMDAwMSAxNC41MDY2IDE3LjAwMDFIMTdWMTQuNTA2NkMxNyAxNC4yMzA0IDE3LjIyMzkgMTQuMDA2NiAxNy41IDE0LjAwNjZaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArchiveAdd2Icon: ProIcon;
export { ArchiveAdd2Icon }
export { ArchiveAdd2Icon as archiveAdd2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjI1IDEyLjVIMTMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy43NSA3Ljc1QzMuNzUgNS41NDA4NiA1LjU0MDg2IDMuNzUgNy43NSAzLjc1SDE2LjI1QzE4LjQ1OTEgMy43NSAyMC4yNSA1LjU0MDg2IDIwLjI1IDcuNzVWMTYuMjVDMjAuMjUgMTguNDU5MSAxOC40NTkxIDIwLjI1IDE2LjI1IDIwLjI1SDcuNzVDNS41NDA4NiAyMC4yNSAzLjc1IDE4LjQ1OTEgMy43NSAxNi4yNVY3Ljc1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0zLjc1IDguNzVIMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ArchiveIcon: ProIcon;
export { ArchiveIcon }
export { ArchiveIcon as archive }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjI1IDQuNzVIMTguNzVDMTEuMDE4IDQuNzUgNC43NSAxMS4wMTggNC43NSAxOC43NVYxOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArcIcon: ProIcon;
export { ArcIcon }
export { ArcIcon as arc }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjcxODkgMTQuMzg1M0MxOS4yMjQ5IDE2LjIyODkgMTguMTA2OSAxNy44NDQyIDE2LjU1NTQgMTguOTU2QzE1LjAwNCAyMC4wNjc4IDEzLjExNSAyMC42MDcyIDExLjIxMDQgMjAuNDgyM0M5LjMwNTgzIDIwLjM1NzUgNy41MDM0NCAxOS41NzYxIDYuMTEwMzYgMTguMjcxNEM0LjcxNzI4IDE2Ljk2NjYgMy44MTk3MSAxNS4yMTkyIDMuNTcwNTggMTMuMzI2OEMzLjMyMTQ1IDExLjQzNDUgMy43MzYxNyA5LjUxNDMgNC43NDQwOCA3Ljg5MzQ0QzUuNzUyIDYuMjcyNTggNy4yOTA3NCA1LjA1MTM1IDkuMDk4MTMgNC40Mzc4M0MxMC45MDU1IDMuODI0MyAxMi44Njk3IDMuODU2NDQgMTQuNjU2MSA0LjUyODc4QzE2LjQ0MjQgNS4yMDExMSAxNy45NDA0IDYuNDcyMDMgMTguODk0NyA4LjEyNUwxOS4zMTUzIDkuMDMyNTNNMTkuODk0OCA0LjM3NVY4LjEyNUMxOS44OTQ4IDguNTI3MDYgMTkuNjU3NSA4Ljg3MzcgMTkuMzE1MyA5LjAzMjUzTTE1LjE0NDggOS4xMjVIMTguODk0OEMxOS4wNDUgOS4xMjUgMTkuMTg3NSA5LjA5MTg4IDE5LjMxNTMgOS4wMzI1MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowClockwiseIcon: ProIcon;
export { ArrowClockwiseIcon }
export { ArrowClockwiseIcon as arrowClockwise }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuMjgxMTEgMTQuMzg1M0M0Ljc3NTEyIDE2LjIyODkgNS44OTMxIDE3Ljg0NDIgNy40NDQ1NiAxOC45NTZDOC45OTYwMyAyMC4wNjc4IDEwLjg4NSAyMC42MDcyIDEyLjc4OTYgMjAuNDgyM0MxNC42OTQyIDIwLjM1NzUgMTYuNDk2NiAxOS41NzYxIDE3Ljg4OTYgMTguMjcxNEMxOS4yODI3IDE2Ljk2NjYgMjAuMTgwMyAxNS4yMTkyIDIwLjQyOTQgMTMuMzI2OEMyMC42Nzg2IDExLjQzNDUgMjAuMjYzOCA5LjUxNDMgMTkuMjU1OSA3Ljg5MzQ0QzE4LjI0OCA2LjI3MjU4IDE2LjcwOTMgNS4wNTEzNSAxNC45MDE5IDQuNDM3ODNDMTMuMDk0NSAzLjgyNDMgMTEuMTMwMyAzLjg1NjQ0IDkuMzQzOTQgNC41Mjg3OEM3LjU1NzU5IDUuMjAxMTEgNi4wNTk2MyA2LjQ3MjAzIDUuMTA1MjkgOC4xMjVMNC42MjgyMyA5LjAwNDEyTTQuMTA1MjIgNC4zNzVWOC4xMjVDNC4xMDUyMiA4LjUwNDU2IDQuMzE2NjkgOC44MzQ3MyA0LjYyODIzIDkuMDA0MTJNOC44NTUyMiA5LjEyNUg1LjEwNTIyQzQuOTMyNSA5LjEyNSA0Ljc3IDkuMDgxMjEgNC42MjgyMyA5LjAwNDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowCounterclockwiseIcon: ProIcon;
export { ArrowCounterclockwiseIcon }
export { ArrowCounterclockwiseIcon as arrowCounterclockwise }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDRWMTkuNVYxOS44Nzg2TTUuMjUgMTMuNzVMMTAuOTM5MyAxOS40MzkzQzExLjIzMjIgMTkuNzMyMiAxMS42MTYxIDE5Ljg3ODYgMTIgMTkuODc4Nk0xOC43NSAxMy43NUwxMy4wNjA3IDE5LjQzOTNDMTIuNzY3OCAxOS43MzIyIDEyLjM4MzkgMTkuODc4NiAxMiAxOS44Nzg2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowDownIcon: ProIcon;
export { ArrowDownIcon }
export { ArrowDownIcon as arrowDown }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjA3MzUgMy4yNVYxNS40MTQ3VjE1LjcyNzVNNi4xOTExOSAxMC40NjY0TDExLjAxMjkgMTUuMjg4MUMxMS4zMDU4IDE1LjU4MSAxMS42ODk3IDE1LjcyNzUgMTIuMDczNSAxNS43Mjc1TTE3Ljk1NTkgMTAuNDY2NEwxMy4xMzQyIDE1LjI4ODFDMTIuODQxMyAxNS41ODEgMTIuNDU3NCAxNS43Mjc1IDEyLjA3MzUgMTUuNzI3NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMC43NSAxNi41MTQ3VjE3LjQ1QzIwLjc1IDE5LjI3MjUgMTkuMjcyNSAyMC43NSAxNy40NSAyMC43NUg2LjU1QzQuNzI3NDYgMjAuNzUgMy4yNSAxOS4yNzI1IDMuMjUgMTcuNDVWMTYuNTE0NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowDownloadIcon: ProIcon;
export { ArrowDownloadIcon }
export { ArrowDownloadIcon as arrowDownload }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5Ljc1IDUuNjIzMzRWOS41MjAwMkMxOS43NSAxMS43MjkyIDE3Ljk1OTEgMTMuNTIgMTUuNzUgMTMuNTJINC4yNUgzLjg3MTMyTTguMTA2NjQgMTguMzc2N0w0LjMxMDY2IDE0LjU4MDdDNC4wMTc3NyAxNC4yODc4IDMuODcxMzIgMTMuOTAzOSAzLjg3MTMyIDEzLjUyTTguMTA2NjQgOC42NjMzOEw0LjMxMDY2IDEyLjQ1OTRDNC4wMTc3NyAxMi43NTIzIDMuODcxMzIgMTMuMTM2MSAzLjg3MTMyIDEzLjUyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowEnterIcon: ProIcon;
export { ArrowEnterIcon }
export { ArrowEnterIcon as arrowEnter }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1Ljc5OCAxMkwzLjI1MDAxIDEySDIuODcxMzRNOC4wMjgxNCA2LjIyMTkxTDMuMzEwNjggMTAuOTM5NEMzLjAxNzc4IDExLjIzMjMgMi44NzEzNCAxMS42MTYxIDIuODcxMzQgMTJNOC4wMjgxNCAxNy43NzgxTDMuMzEwNjggMTMuMDYwN0MzLjAxNzc4IDEyLjc2NzggMi44NzEzNCAxMi4zODM5IDIuODcxMzQgMTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuNzUgNC4wOTUxNEwyMC43NSAxOS45MDQ5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowExportIcon: ProIcon;
export { ArrowExportIcon }
export { ArrowExportIcon as arrowExport }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuMjUgMTguMjE4NkM0LjI1IDE1Ljg2NzQgNC4yNSAxNC42OTE4IDQuNjMzMjkgMTMuNzY0MkM1LjE0NjY4IDEyLjUyMTcgNi4xMzM2NCAxMS41MzQ3IDcuMzc2MTQgMTEuMDIxM0M4LjMwMzc3IDEwLjYzOCA5LjQ3OTM4IDEwLjYzOCAxMS44MzA2IDEwLjYzOEgxOS43NUgyMC4xMjg3TTE1Ljg5MzQgNS43ODEzOUwxOS42ODkzIDkuNTc3MzdDMTkuOTgyMiA5Ljg3MDI2IDIwLjEyODcgMTAuMjU0MSAyMC4xMjg3IDEwLjYzOE0xNS44OTM0IDE1LjQ5NDdMMTkuNjg5MyAxMS42OTg3QzE5Ljk4MjIgMTEuNDA1OCAyMC4xMjg3IDExLjAyMTkgMjAuMTI4NyAxMC42MzgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ArrowFowardIcon: ProIcon;
export { ArrowFowardIcon }
export { ArrowFowardIcon as arrowFoward }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuMjUgMTJMMTQuNzk4IDEySDE1LjE3NjdNMTAuMDE5OSA2LjIyMTkxTDE0LjczNzQgMTAuOTM5NEMxNS4wMzAyIDExLjIzMjMgMTUuMTc2NyAxMS42MTYxIDE1LjE3NjcgMTJNMTAuMDE5OSAxNy43NzgxTDE0LjczNzQgMTMuMDYwN0MxNS4wMzAyIDEyLjc2NzggMTUuMTc2NyAxMi4zODM5IDE1LjE3NjcgMTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuNzUgNC4wOTUxNEwyMC43NSAxOS45MDQ5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowImportIcon: ProIcon;
export { ArrowImportIcon }
export { ArrowImportIcon as arrowImport }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwIDEySDQuNDk5OTlINC4xMjEzMU0xMC4yNSAxOC43NUw0LjU2MDY1IDEzLjA2MDdDNC4yNjc3NSAxMi43Njc4IDQuMTIxMyAxMi4zODM5IDQuMTIxMzEgMTJNMTAuMjUgNS4yNUw0LjU2MDY1IDEwLjkzOTNDNC4yNjc3NiAxMS4yMzIyIDQuMTIxMzEgMTEuNjE2MSA0LjEyMTMxIDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowLeftIcon: ProIcon;
export { ArrowLeftIcon }
export { ArrowLeftIcon as arrowLeft }

/**
 * @description Left Right, Bidirectional, Horizontal, Width, Size, Wide
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjI1IDE3TDIwLjE4OTQgMTMuMDYwN0MyMC40ODIzIDEyLjc2NzggMjAuNjI4NyAxMi4zODM5IDIwLjYyODcgMTJNMTYuMjUgN0wyMC4xODk0IDEwLjkzOTNDMjAuNDgyMyAxMS4yMzIyIDIwLjYyODcgMTEuNjE2MSAyMC42Mjg3IDEyTTcuNzUwMDIgMTdMMy44MTA2OCAxMy4wNjA3QzMuNTE3NzggMTIuNzY3OCAzLjM3MTM0IDEyLjM4MzkgMy4zNzEzNCAxMk03Ljc1MDAyIDdMMy44MTA2OCAxMC45MzkzQzMuNTE3NzggMTEuMjMyMiAzLjM3MTM0IDExLjYxNjEgMy4zNzEzNCAxMk0zLjM3MTM0IDEySDMuNzUwMDJIMjAuMjVIMjAuNjI4NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowLeftRightIcon: ProIcon;
export { ArrowLeftRightIcon }
export { ArrowLeftRightIcon as arrowLeftRight }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzQ5OTcgMTIuNzVWMTguNzVDMy43NDk5NyAxOS4xNjQyIDMuOTE3ODYgMTkuNTM5MiA0LjE4OTMxIDE5LjgxMDdNMTEuMjUgMjAuMjVINS4yNDk5N0M0LjgzNTc2IDIwLjI1IDQuNDYwNzYgMjAuMDgyMSA0LjE4OTMxIDE5LjgxMDdNMjAuMjUgMTEuMjVWNS4yNUMyMC4yNSA0LjgzNTc5IDIwLjA4MjEgNC40NjA3OSAxOS44MTA2IDQuMTg5MzRNMTIuNzUgMy43NUgxOC43NUMxOS4xNjQyIDMuNzUgMTkuNTM5MiAzLjkxNzg5IDE5LjgxMDYgNC4xODkzNE00LjE4OTMxIDE5LjgxMDdMNC43NDk5NyAxOS4yNUwxOS4yNSA0Ljc1TDE5LjgxMDYgNC4xODkzNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowMaximizeIcon: ProIcon;
export { ArrowMaximizeIcon }
export { ArrowMaximizeIcon as arrowMaximize }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMjEuMjVMOS4yNSAxNC43NUw5LjgxMDY2IDE0LjE4OTNNMTAuMjUgMjEuMjVWMTUuMjVDMTAuMjUgMTQuODM1OCAxMC4wODIxIDE0LjQ2MDggOS44MTA2NiAxNC4xODkzTTIuNzUgMTMuNzVIOC43NUM5LjE2NDIxIDEzLjc1IDkuNTM5MjEgMTMuOTE3OSA5LjgxMDY2IDE0LjE4OTMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuNzUgMi43NVY4Ljc1QzEzLjc1IDkuMTY0MjEgMTMuOTE3OSA5LjUzOTIxIDE0LjE4OTMgOS44MTA2Nk0yMS4yNSAxMC4yNUgxNS4yNUMxNC44MzU4IDEwLjI1IDE0LjQ2MDggMTAuMDgyMSAxNC4xODkzIDkuODEwNjZNMjEuMjUgMi43NUwxNC43NSA5LjI1TDE0LjE4OTMgOS44MTA2NiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowMinimizeIcon: ProIcon;
export { ArrowMinimizeIcon }
export { ArrowMinimizeIcon as arrowMinimize }

/**
 * @description Arrow 4-Way, Move
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDkuMDA0NjRWMi44MDA2NFYyLjc1TTkgNS4zMjQyOUwxMS4yNzMzIDMuMDUxMDJDMTEuNDc0IDIuODUwMzMgMTEuNzM3IDIuNzQ5OTkgMTIgMi43NU0xNSA1LjMyNDI5TDEyLjcyNjcgMy4wNTEwMkMxMi41MjYxIDIuODUwMzUgMTIuMjYzIDIuNzUwMDEgMTIgMi43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC45OTU0IDEyTDIxLjE5OTQgMTJMMjEuMjUgMTJNMTguNjc1NyA5TDIwLjk0OSAxMS4yNzMzQzIxLjE0OTcgMTEuNDc0IDIxLjI1IDExLjczNyAyMS4yNSAxMk0xOC42NzU3IDE1TDIwLjk0OSAxMi43MjY3QzIxLjE0OTcgMTIuNTI2MSAyMS4yNSAxMi4yNjMgMjEuMjUgMTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgMTQuOTk1NFYyMS4xOTk0VjIxLjI1TTkgMTguNjc1N0wxMS4yNzMzIDIwLjk0OUMxMS40NzQgMjEuMTQ5NyAxMS43MzcgMjEuMjUgMTIgMjEuMjVNMTUgMTguNjc1N0wxMi43MjY3IDIwLjk0OUMxMi41MjYxIDIxLjE0OTcgMTIuMjYzIDIxLjI1IDEyIDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkuMDA0NjQgMTJMMi44MDA2NCAxMkwyLjc1IDEyTTUuMzI0MjkgOUwzLjA1MTAyIDExLjI3MzNDMi44NTAzMyAxMS40NzQgMi43NDk5OSAxMS43MzcgMi43NSAxMk01LjMyNDI5IDE1TDMuMDUxMDIgMTIuNzI2N0MyLjg1MDM1IDEyLjUyNjEgMi43NTAwMSAxMi4yNjMgMi43NSAxMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowMoveIcon: ProIcon;
export { ArrowMoveIcon }
export { ArrowMoveIcon as arrowMove }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0Ljc1IDEyTDE4LjA0MjkgOC43MDcxMUMxOC4yMzgyIDguNTExODQgMTguMzM1OCA4LjI1NTkyIDE4LjMzNTggOE0xNC43NSA0TDE4LjA0MjkgNy4yOTI4OUMxOC4yMzgyIDcuNDg4MTYgMTguMzM1OCA3Ljc0NDA4IDE4LjMzNTggOE0xNi43NSAxOS41SDEwLjVDNy4zMjQzNiAxOS41IDQuNzUgMTYuOTI1NiA0Ljc1IDEzLjc1QzQuNzUgMTAuNTc0NCA3LjMyNDM2IDggMTAuNSA4SDE4SDE4LjMzNTgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ArrowRedo2Icon: ProIcon;
export { ArrowRedo2Icon }
export { ArrowRedo2Icon as arrowRedo2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjAyOTcgMjEuMjVMNS43Njk4IDEyLjk5MDFDMy40MjcyNCAxMC42NDc1IDMuNDI3MjQgNi44NDk0OCA1Ljc2OTggNC41MDY5MkM4LjExMjM2IDIuMTY0MzYgMTEuOTEwNCAyLjE2NDM2IDE0LjI1MyA0LjUwNjkyTDE4Ljk4NzIgOS4yNDExNkwxOS42MDk0IDkuODYzMzhNMTIuNDEwMSAxMC4zNjgxSDE4LjQ4NzJDMTguOTMzNyAxMC4zNjgxIDE5LjMzNDYgMTAuMTczIDE5LjYwOTQgOS44NjMzOE0xOS45ODcyIDIuNzkxMDJWOC44NjgwN0MxOS45ODcyIDkuMjQ5OTkgMTkuODQ0NSA5LjU5ODU3IDE5LjYwOTQgOS44NjMzOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowRedoIcon: ProIcon;
export { ArrowRedoIcon }
export { ArrowRedoIcon as arrowRedo }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5Ljc1IDE4LjIxODZDMTkuNzUgMTUuODY3NCAxOS43NSAxNC42OTE4IDE5LjM2NjcgMTMuNzY0MkMxOC44NTMzIDEyLjUyMTcgMTcuODY2NCAxMS41MzQ3IDE2LjYyMzkgMTEuMDIxM0MxNS42OTYyIDEwLjYzOCAxNC41MjA2IDEwLjYzOCAxMi4xNjk0IDEwLjYzOEg0LjI1MDAySDMuODcxMzRNOC4xMDY2NiA1Ljc4MTM5TDQuMzEwNjggOS41NzczN0M0LjAxNzc4IDkuODcwMjYgMy44NzEzNCAxMC4yNTQxIDMuODcxMzQgMTAuNjM4TTguMTA2NjYgMTUuNDk0N0w0LjMxMDY4IDExLjY5ODdDNC4wMTc3OCAxMS40MDU4IDMuODcxMzQgMTEuMDIxOSAzLjg3MTM0IDEwLjYzOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowReplyIcon: ProIcon;
export { ArrowReplyIcon }
export { ArrowReplyIcon as arrowReply }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQgMTJIMTkuNUgxOS44Nzg3TTEzLjc1IDE4Ljc1TDE5LjQzOTMgMTMuMDYwN0MxOS43MzIyIDEyLjc2NzggMTkuODc4NyAxMi4zODM5IDE5Ljg3ODcgMTJNMTMuNzUgNS4yNUwxOS40MzkzIDEwLjkzOTNDMTkuNzMyMiAxMS4yMzIyIDE5Ljg3ODcgMTEuNjE2MSAxOS44Nzg3IDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowRightIcon: ProIcon;
export { ArrowRightIcon }
export { ArrowRightIcon as arrowRight }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMTJDMy43NSAxMC41NTE4IDQuMTMxMiA5LjEyOTE2IDQuODU1MjkgNy44NzVDNS41NzkzOCA2LjYyMDg0IDYuNjIwODQgNS41NzkzOCA3Ljg3NSA0Ljg1NTI5QzkuMTI5MTYgNC4xMzEyIDEwLjU1MTggMy43NSAxMiAzLjc1QzEzLjQ0ODIgMy43NSAxNC44NzA4IDQuMTMxMiAxNi4xMjUgNC44NTUyOUMxNy4zNzkyIDUuNTc5MzggMTguNDIwNiA2LjYyMDg0IDE5LjE0NDcgNy44NzVDMTkuODY4OCA5LjEyOTE2IDIwLjI1IDEwLjU1MTggMjAuMjUgMTJDMjAuMjUgMTMuNDQ4MiAxOS44Njg4IDE0Ljg3MDggMTkuMTQ0NyAxNi4xMjVDMTguNDIwNiAxNy4zNzkyIDE3LjM3OTIgMTguNDIwNiAxNi4xMjUgMTkuMTQ0N0wxNC45MjYxIDE5LjU2NjNNMTQuODc1IDE2LjI1VjE5LjI1QzE0Ljg3NSAxOS4zNjA1IDE0Ljg5MjkgMTkuNDY2OSAxNC45MjYxIDE5LjU2NjNNMTguODc1IDIwLjI1SDE1Ljg3NUMxNS40MzMzIDIwLjI1IDE1LjA1ODQgMTkuOTYzNiAxNC45MjYxIDE5LjU2NjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuNSAxMS43NUMxNC41IDEyLjk5MjYgMTMuNDkyNiAxNCAxMi4yNSAxNEMxMS4wMDc0IDE0IDEwIDEyLjk5MjYgMTAgMTEuNzVDMTAgMTAuNTA3NCAxMS4wMDc0IDkuNSAxMi4yNSA5LjVDMTMuNDkyNiA5LjUgMTQuNSAxMC41MDc0IDE0LjUgMTEuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowRotateClockwiseIcon: ProIcon;
export { ArrowRotateClockwiseIcon }
export { ArrowRotateClockwiseIcon as arrowRotateClockwise }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjI1IDEyQzIwLjI1IDEwLjU1MTggMTkuODY4OCA5LjEyOTE2IDE5LjE0NDcgNy44NzVDMTguNDIwNiA2LjYyMDg0IDE3LjM3OTIgNS41NzkzOCAxNi4xMjUgNC44NTUyOUMxNC44NzA4IDQuMTMxMiAxMy40NDgyIDMuNzUgMTIgMy43NUMxMC41NTE4IDMuNzUgOS4xMjkxNiA0LjEzMTIgNy44NzUgNC44NTUyOUM2LjYyMDg0IDUuNTc5MzggNS41NzkzOCA2LjYyMDg0IDQuODU1MjkgNy44NzVDNC4xMzEyIDkuMTI5MTYgMy43NSAxMC41NTE4IDMuNzUgMTJDMy43NSAxMy40NDgyIDQuMTMxMiAxNC44NzA4IDQuODU1MjkgMTYuMTI1QzUuNTc5MzggMTcuMzc5MiA2LjYyMDg0IDE4LjQyMDYgNy44NzUgMTkuMTQ0N0w5LjA0Mjc5IDE5LjY0NzdNOS4xMjUgMTYuMjVWMTkuMjVDOS4xMjUgMTkuMzkxMyA5LjA5NTY4IDE5LjUyNTggOS4wNDI3OSAxOS42NDc3TTUuMTI1IDIwLjI1SDguMTI1QzguNTM1OTUgMjAuMjUgOC44ODkwMSAyMC4wMDIxIDkuMDQyNzkgMTkuNjQ3NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC41IDExLjc1QzE0LjUgMTIuOTkyNiAxMy40OTI2IDE0IDEyLjI1IDE0QzExLjAwNzQgMTQgMTAgMTIuOTkyNiAxMCAxMS43NUMxMCAxMC41MDc0IDExLjAwNzQgOS41IDEyLjI1IDkuNUMxMy40OTI2IDkuNSAxNC41IDEwLjUwNzQgMTQuNSAxMS43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowRotateCounterclockwiseIcon: ProIcon;
export { ArrowRotateCounterclockwiseIcon }
export { ArrowRotateCounterclockwiseIcon as arrowRotateCounterclockwise }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDkuODY3MTlMOC4xODU2NiA2LjA1Mjg1QzcuODkyNzcgNS43NTk5NiA3LjUwODg4IDUuNjEzNTEgNy4xMjUgNS42MTM1MU0yLjI1IDkuODY3MTlMNi4wNjQzNCA2LjA1Mjg1QzYuMzU3MjMgNS43NTk5NiA2Ljc0MTEyIDUuNjEzNTEgNy4xMjUgNS42MTM1MU03LjEyNSAxOS4wMDc4VjUuOTkyMTlWNS42MTM1MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNi44NzUgNS40OTAwMVYxOC41MDU2VjE4Ljg4NDNNMjEuNzUgMTQuNjMwNkwxNy45MzU3IDE4LjQ0NUMxNy42NDI4IDE4LjczNzkgMTcuMjU4OSAxOC44ODQzIDE2Ljg3NSAxOC44ODQzTTEyIDE0LjYzMDZMMTUuODE0MyAxOC40NDVDMTYuMTA3MiAxOC43Mzc5IDE2LjQ5MTEgMTguODg0MyAxNi44NzUgMTguODg0MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowSortIcon: ProIcon;
export { ArrowSortIcon }
export { ArrowSortIcon as arrowSort }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNjE4MyAxMi4yNDg5TDUuODAzOTYgMTYuMDYzM0M1LjUxMTA3IDE2LjM1NjEgNS4zNjQ2MiAxNi43NCA1LjM2NDYyIDE3LjEyMzlNOS42MTgzIDIxLjk5ODlMNS44MDM5NiAxOC4xODQ2QzUuNTExMDcgMTcuODkxNyA1LjM2NDYyIDE3LjUwNzggNS4zNjQ2MiAxNy4xMjM5TTE4Ljc1ODkgMTcuMTIzOUw1Ljc0MzMgMTcuMTIzOUg1LjM2NDYyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTUuMjQxMDkgNy4zNzM5MkwxOC4yNTY3IDcuMzczOTJIMTguNjM1NE0xNC4zODE3IDIuNDk4OTJMMTguMTk2MSA2LjMxMzI2QzE4LjQ4ODkgNi42MDYxNSAxOC42MzU0IDYuOTkwMDMgMTguNjM1NCA3LjM3MzkyTTE0LjM4MTcgMTIuMjQ4OUwxOC4xOTYxIDguNDM0NThDMTguNDg4OSA4LjE0MTY4IDE4LjYzNTQgNy43NTc4IDE4LjYzNTQgNy4zNzM5MiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowSwapIcon: ProIcon;
export { ArrowSwapIcon }
export { ArrowSwapIcon as arrowSwap }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuOTE1MjYgMTguNTMxNUM2LjQyMjQzIDE3LjY2OTYgNS4yNTU3MiAxNi4zMzkyIDQuNTk2MDYgMTQuNzQ2N0MzLjkzNjQxIDEzLjE1NDEgMy44MjA2OCAxMS4zODg0IDQuMjY2ODIgOS43MjMzOEM0LjcxMjk2IDguMDU4MzUgNS42OTYwNSA2LjU4NzA2IDcuMDYzNiA1LjUzNzdDOC40MzExNSA0LjQ4ODM0IDEwLjEwNjcgMy45MTk1NiAxMS44MzA1IDMuOTE5NTZIMTIuODczOU0xMS4xMTg3IDEuNzVMMTIuNTgxIDMuMjEyMzhDMTIuNzc2MyAzLjQwNzY2IDEyLjg3MzkgMy42NjM2MSAxMi44NzM5IDMuOTE5NTZNMTEuMTE4NyA2LjA4ODk4TDEyLjU4MSA0LjYyNjZDMTIuNzc2MyA0LjQzMTM1IDEyLjg3MzkgNC4xNzU0NiAxMi44NzM5IDMuOTE5NTYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuMDg0NyA1LjIxODYzQzE3LjU3NzYgNi4wODA1MSAxOC43NDQzIDcuNDEwODkgMTkuNDAzOSA5LjAwMzQ0QzIwLjA2MzYgMTAuNTk2IDIwLjE3OTMgMTIuMzYxNyAxOS43MzMyIDE0LjAyNjdDMTkuMjg3IDE1LjY5MTggMTguMzA0IDE3LjE2MyAxNi45MzY0IDE4LjIxMjRDMTUuNTY4OCAxOS4yNjE4IDEzLjg5MzMgMTkuODMwNiAxMi4xNjk1IDE5LjgzMDZIMTEuMTI2MU0xMi44ODEzIDIyTDExLjQxOSAyMC41Mzc2QzExLjIyMzcgMjAuMzQyNCAxMS4xMjYxIDIwLjA4NjUgMTEuMTI2MSAxOS44MzA2TTEyLjg4MTMgMTcuNjYxTDExLjQxOSAxOS4xMjM0QzExLjIyMzcgMTkuMzE4NyAxMS4xMjYxIDE5LjU3NDYgMTEuMTI2MSAxOS44MzA2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowSync2Icon: ProIcon;
export { ArrowSync2Icon }
export { ArrowSync2Icon as arrowSync2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNTQ4MTUgOS43MzUzNEMzLjk5NjA2IDguMDYzNzIgNC45Mjk2IDYuNTYyNDYgNi4yMzA3MiA1LjQyMTQxQzcuNTMxODUgNC4yODAzNSA5LjE0MjExIDMuNTUwNzUgMTAuODU3OSAzLjMyNDg2QzEyLjU3MzcgMy4wOTg5OCAxNC4zMTc5IDMuMzg2OTUgMTUuODcgNC4xNTIzN0MxNy40MjIxIDQuOTE3NzkgMTguNzEyNCA2LjEyNjI3IDE5LjU3NzcgNy42MjUwMUwxOS45MTI4IDguMzgzODhNMjAuNzUgMy4yNTAwMVY3LjM5NzA3QzIwLjc1IDcuODkzOTEgMjAuMzg3NyA4LjMwNjEyIDE5LjkxMjggOC4zODM4OE0xNS42MDI5IDguMzk3MDdIMTkuNzVDMTkuODA1NCA4LjM5NzA3IDE5Ljg1OTggOC4zOTI1NSAxOS45MTI4IDguMzgzODgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy4yNSAyMC43NVYxNi42MDI5QzMuMjUgMTYuMDUwNiAzLjY5NzcyIDE1LjYwMjkgNC4yNSAxNS42MDI5TTQuMjUgMTUuNjAyOUg4LjM5NzA2TTQuMjUgMTUuNjAyOUw0LjQyMjI4IDE2LjM3NUM1LjI4NzU3IDE3Ljg3MzcgNi41Nzc4NiAxOS4wODIyIDguMTI5OTggMTkuODQ3NkM5LjY4MjA5IDIwLjYxMyAxMS40MjYzIDIwLjkwMSAxMy4xNDIxIDIwLjY3NTFDMTQuODU3OSAyMC40NDkyIDE2LjQ2ODIgMTkuNzE5NiAxNy43NjkzIDE4LjU3ODZDMTkuMDcwNCAxNy40Mzc1IDIwLjAwMzkgMTUuOTM2MyAyMC40NTE5IDE0LjI2NDYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ArrowSyncIcon: ProIcon;
export { ArrowSyncIcon }
export { ArrowSyncIcon as arrowSync }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuMjUgMTYuNzVMOC4wNDI4OSAxMS45NTcxQzguNDMzNDIgMTEuNTY2NiA5LjA2NjU4IDExLjU2NjYgOS40NTcxMSAxMS45NTcxTDEyLjA0MjkgMTQuNTQyOUMxMi40MzM0IDE0LjkzMzQgMTMuMDY2NiAxNC45MzM0IDEzLjQ1NzEgMTQuNTQyOUwxOS43NSA4LjI1TDIwLjMxMDcgNy42ODkzNE0xNC43NSA3LjI1SDE5LjI1QzE5LjY2NDIgNy4yNSAyMC4wMzkyIDcuNDE3ODkgMjAuMzEwNyA3LjY4OTM0TTIwLjc1IDEzLjI1VjguNzVDMjAuNzUgOC4zMzU3OSAyMC41ODIxIDcuOTYwNzkgMjAuMzEwNyA3LjY4OTM0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ArrowTrendingIcon: ProIcon;
export { ArrowTrendingIcon }
export { ArrowTrendingIcon as arrowTrending }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMjQ5OTcgMTJMNS45NTcwOCA4LjcwNzExQzUuNzYxODIgOC41MTE4NCA1LjY2NDE4IDguMjU1OTIgNS42NjQxOCA4TTkuMjQ5OTcgNEw1Ljk1NzA4IDcuMjkyODlDNS43NjE4MiA3LjQ4ODE2IDUuNjY0MTggNy43NDQwOCA1LjY2NDE4IDhNNy4yNDk5NyAxOS41SDEzLjVDMTYuNjc1NiAxOS41IDE5LjI1IDE2LjkyNTYgMTkuMjUgMTMuNzVDMTkuMjUgMTAuNTc0NCAxNi42NzU2IDggMTMuNSA4SDUuOTk5OTdINS42NjQxOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowUndo2Icon: ProIcon;
export { ArrowUndo2Icon }
export { ArrowUndo2Icon as arrowUndo2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuOTcwMzYgMjEuMjVMMTguMjMwMyAxMi45OTAxQzIwLjU3MjggMTAuNjQ3NiAyMC41NzI4IDYuODQ5NTEgMTguMjMwMyA0LjUwNjk1QzE1Ljg4NzcgMi4xNjQzOSAxMi4wODk3IDIuMTY0MzkgOS43NDcxMSA0LjUwNjk1TDUuMDEyODggOS4yNDExOUw0LjM5MDY1IDkuODYzNDJNMTEuNTg5OSAxMC4zNjgxSDUuNTEyODhDNS4wNjYzNyAxMC4zNjgxIDQuNjY1NDMgMTAuMTczIDQuMzkwNjUgOS44NjM0Mk00LjAxMjg4IDIuNzkxMDVWOC44NjgxQzQuMDEyODggOS4yNTAwMiA0LjE1NTYxIDkuNTk4NiA0LjM5MDY1IDkuODYzNDIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ArrowUndoIcon: ProIcon;
export { ArrowUndoIcon }
export { ArrowUndoIcon as arrowUndo }

/**
 * @description Up-Down, Bidirectional, Vertical, Height, Size
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcgMTYuMjVMMTAuOTM5MyAyMC4xODkzQzExLjIzMjIgMjAuNDgyMiAxMS42MTYxIDIwLjYyODcgMTIgMjAuNjI4N00xNyAxNi4yNUwxMy4wNjA3IDIwLjE4OTNDMTIuNzY3OCAyMC40ODIyIDEyLjM4MzkgMjAuNjI4NyAxMiAyMC42Mjg3TTcgNy43NUwxMC45MzkzIDMuODEwNjZDMTEuMjMyMiAzLjUxNzc3IDExLjYxNjEgMy4zNzEzMiAxMiAzLjM3MTMyTTE3IDcuNzVMMTMuMDYwNyAzLjgxMDY2QzEyLjc2NzggMy41MTc3NyAxMi4zODM5IDMuMzcxMzIgMTIgMy4zNzEzMk0xMiAzLjM3MTMyVjMuNzVMMTIgMjAuMjVWMjAuNjI4NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowUpDownIcon: ProIcon;
export { ArrowUpDownIcon }
export { ArrowUpDownIcon as arrowUpDown }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIwVjQuNTAwMDNWNC4xMjEzMk01LjI1IDEwLjI1TDEwLjkzOTMgNC41NjA2NkMxMS4yMzIyIDQuMjY3NzcgMTEuNjE2MSA0LjEyMTMyIDEyIDQuMTIxMzJNMTguNzUgMTAuMjVMMTMuMDYwNyA0LjU2MDY2QzEyLjc2NzggNC4yNjc3NyAxMi4zODM5IDQuMTIxMzIgMTIgNC4xMjEzMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowUpIcon: ProIcon;
export { ArrowUpIcon }
export { ArrowUpIcon as arrowUp }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDE2LjM0ODhMMTIgNC4xODQxVjMuODcxMzRNNi4xMTc2OCA5LjEzMjM3TDEwLjkzOTQgNC4zMTA2OEMxMS4yMzIzIDQuMDE3NzggMTEuNjE2MSAzLjg3MTM0IDEyIDMuODcxMzRNMTcuODgyNCA5LjEzMjM3TDEzLjA2MDcgNC4zMTA2OEMxMi43Njc4IDQuMDE3NzggMTIuMzgzOSAzLjg3MTM0IDEyIDMuODcxMzQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuNzUgMTYuNTE0N0wyMC43NSAxNy40NUMyMC43NSAxOS4yNzI1IDE5LjI3MjUgMjAuNzUgMTcuNDUgMjAuNzVMNi41NSAyMC43NUM0LjcyNzQ2IDIwLjc1IDMuMjUgMTkuMjcyNSAzLjI1IDE3LjQ1TDMuMjUgMTYuNTE0NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ArrowUploadIcon: ProIcon;
export { ArrowUploadIcon }
export { ArrowUploadIcon as arrowUpload }

/**
 * @description Clip, Paper Clip, Paperclip
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuODYxMTEgMTMuNjI0N0wxMi4yMDI5IDQuMjgyOTRDMTQuMjQ3MSAyLjIzODY5IDE3LjU2MTUgMi4yMzg2OSAxOS42MDU3IDQuMjgyOTVDMjEuNjUgNi4zMjcyIDIxLjY1IDkuNjQxNTggMTkuNjA1NyAxMS42ODU4TDEwLjg4MDkgMjAuNDEwN0M5Ljc2MTQzIDIxLjUzMDEgNy45NDY0MSAyMS41MzAxIDYuODI2OTQgMjAuNDEwN0M1LjcwNzQ3IDE5LjI5MTIgNS43MDc0NyAxNy40NzYyIDYuODI2OTQgMTYuMzU2N0wxNS4xOTkzIDcuOTg0MzkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const AttatchIcon: ProIcon;
export { AttatchIcon }
export { AttatchIcon as attatch }

/**
 * @description House, Home Samsung
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0zIDE0Ljk1VjEzLjI3SDMuNjMzNDZDMy44MDExIDEzLjQzMyAzLjk2MzkxIDEzLjYwMDYgNC4xMTkxMiAxMy43MzI0QzQuNDI2MjYgMTMuOTkzMSA0LjgxNTMgMTQuMjcyNyA1LjMyMjk3IDE0LjQzNzdDNS42ODUwOCAxNC41NTUzIDYuMDYxNTYgMTQuNjEyNSA2LjQzNzY0IDE0LjYwOTJDNi43OTMxNSAxNC42MDYxIDcuMTQ4MzEgMTQuNTQ4OSA3LjQ5MDYyIDE0LjQzNzdDNy45OTgzIDE0LjI3MjcgOC4zODczNCAxMy45OTMxIDguNjk0NDggMTMuNzMyNEM4Ljk3MzU0IDEzLjQ5NTUgOS4yNzcyIDEzLjE5MTggOS41ODkzMyAxMi44Nzk2TDEwLjc3NDQgMTEuNjk0NUM5LjQ1MTkyIDE0LjgxMzkgMTIuODcyNiAxNy44OTI1IDE1Ljg1ODQgMTYuMTY4NkMxNy41Njc2IDE1LjE4MTggMTguMTUzMyAxMi45OTYyIDE3LjE2NjQgMTEuMjg2OUMxNy4xMzA3IDExLjIyNSAxNy4wOTEyIDExLjE2NTQgMTcuMDQ4MSAxMS4xMDgzTDE1LjMwNCA4Ljc5NTRDMTQuOTU0NSA4LjMzMjA0IDE0LjM5ODEgOC4wNzIwNSAxMy44MTg1IDguMTAxM0MxMy43MjQyIDguMTA2MDYgMTMuNjMxMiA4LjExODM5IDEzLjU0MDMgOC4xMzc4NEMxMy41MjQgNy42OTcyMiAxMy4zNDE5IDcuMjc4MDIgMTMuMDI4OSA2Ljk2NTExTDEyLjI5IDYuMjQ4NjdWNC43NUgxNi43QzE4LjM4MDIgNC43NSAxOS4yMjAyIDQuNzUgMTkuODYyIDUuMDc2OThDMjAuNDI2NSA1LjM2NDYgMjAuODg1NCA1LjgyMzU0IDIxLjE3MyA2LjM4ODAzQzIxLjUgNy4wMjk3NiAyMS41IDcuODY5ODQgMjEuNSA5LjU1VjE0Ljk1QzIxLjUgMTYuNjMwMiAyMS41IDE3LjQ3MDIgMjEuMTczIDE4LjExMkMyMC44ODU0IDE4LjY3NjUgMjAuNDI2NSAxOS4xMzU0IDE5Ljg2MiAxOS40MjNDMTkuMjIwMiAxOS43NSAxOC4zODAyIDE5Ljc1IDE2LjcgMTkuNzVINy44QzYuMTE5ODQgMTkuNzUgNS4yNzk3NiAxOS43NSA0LjYzODAzIDE5LjQyM0M0LjA3MzU0IDE5LjEzNTQgMy42MTQ2IDE4LjY3NjUgMy4zMjY5OCAxOC4xMTJDMyAxNy40NzAyIDMgMTYuNjMwMiAzIDE0Ljk1WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BackgroundColorAccentIcon: ProIcon;
export { BackgroundColorAccentIcon }
export { BackgroundColorAccentIcon as backgroundColorAccent }

/**
 * @description House, Home Samsung
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEzLjA0IDQuNzVIMTYuN0MxOC4zODAyIDQuNzUgMTkuMjIwMiA0Ljc1IDE5Ljg2MiA1LjA3Njk4QzIwLjQyNjUgNS4zNjQ2IDIwLjg4NTQgNS44MjM1NCAyMS4xNzMgNi4zODgwM0MyMS41IDcuMDI5NzYgMjEuNSA3Ljg2OTg0IDIxLjUgOS41NVYxNC45NUMyMS41IDE2LjYzMDIgMjEuNSAxNy40NzAyIDIxLjE3MyAxOC4xMTJDMjAuODg1NCAxOC42NzY1IDIwLjQyNjUgMTkuMTM1NCAxOS44NjIgMTkuNDIzQzE5LjIyMDIgMTkuNzUgMTguMzgwMiAxOS43NSAxNi43IDE5Ljc1SDcuOEM2LjExOTg0IDE5Ljc1IDUuMjc5NzYgMTkuNzUgNC42MzgwMyAxOS40MjNDNC4wNzM1NCAxOS4xMzU0IDMuNjE0NiAxOC42NzY1IDMuMzI2OTggMTguMTEyQzMgMTcuNDcwMiAzIDE2LjYzMDIgMyAxNC45NVYxNC4wMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02LjQwNjggMi44MTc4NEwxMS43OTE1IDguMjAyNTVNNi40MDY4IDIuODE3ODRMMy4wMTAyOSA2LjIxNDM1QzIuMzE0MzUgNi45MTAyOSAxLjk2NjM4IDcuMjU4MjUgMS44MzYwMSA3LjY1OTVDMS43Nzg2NyA3LjgzNTk4IDEuNzUgOC4wMTkyNyAxLjc1IDguMjAyNTVNNi40MDY4IDIuODE3ODRMNS41ODg5NCAyTTExLjc5MTUgOC4yMDI1NUw4LjM5NSAxMS41OTkxQzcuNjk5MDYgMTIuMjk1IDcuMzUxMSAxMi42NDMgNi45NDk4NSAxMi43NzMzQzYuNTk2OSAxMi44ODggNi4yMTY3IDEyLjg4OCA1Ljg2Mzc1IDEyLjc3MzNDNS40NjI1IDEyLjY0MyA1LjExNDUzIDEyLjI5NSA0LjQxODYgMTEuNTk5MUwzLjAxMDI5IDEwLjE5MDhDMi4zMTQzNSA5LjQ5NDgyIDEuOTY2MzggOS4xNDY4NSAxLjgzNjAxIDguNzQ1NkMxLjc3ODY3IDguNTY5MTIgMS43NSA4LjM4NTg0IDEuNzUgOC4yMDI1NU0xMS43OTE1IDguMjAyNTVIMi42MjVIMS43NU0xMi40MjE1IDEyLjI5NzNMMTMuOTA2NyA5Ljg0OTA4TDE1LjY1MDkgMTIuMTYyQzE2LjE1NDUgMTMuMDM0MiAxNS44NTU2IDE0LjE0OTUgMTQuOTgzNCAxNC42NTMxQzEzLjQzNjYgMTUuNTQ2MSAxMS42NjEgMTMuOTEzNSAxMi40MjE1IDEyLjI5NzNaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BackgroundColorIcon: ProIcon;
export { BackgroundColorIcon }
export { BackgroundColorIcon as backgroundColor }

/**
 * @description Delete
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuNzEwNiA2LjA4NDM1QzcuMzczMTcgNS4zNjY1NiA4LjMwNTU3IDQuOTU4MzMgOS4yODI0MSA0Ljk1ODMzSDE3LjI1QzE5LjE4MyA0Ljk1ODMzIDIwLjc1IDYuNTI1MzMgMjAuNzUgOC40NTgzM1YxNS41NDE3QzIwLjc1IDE3LjQ3NDcgMTkuMTgzIDE5LjA0MTcgMTcuMjUgMTkuMDQxN0g5LjI4MjQxQzguMzA1NTcgMTkuMDQxNyA3LjM3MzE3IDE4LjYzMzQgNi43MTA2IDE3LjkxNTZMMy40NDEzNyAxNC4zNzRDMi4yMDM3OCAxMy4wMzMzIDIuMjAzNzggMTAuOTY2NyAzLjQ0MTM3IDkuNjI2MDFMNi43MTA2IDYuMDg0MzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEwLjgyMDggOS4zNjQ4NUwxNi4wOTExIDE0LjYzNTFNMTYuMDkxMSA5LjM2NDg1TDEwLjgyMDggMTQuNjM1MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BackspaceIcon: ProIcon;
export { BackspaceIcon }
export { BackspaceIcon as backspace }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDMuNzVIOC43NUM1Ljk4ODU4IDMuNzUgMy43NSA1Ljk4ODU4IDMuNzUgOC43NVYxNS4yNUMzLjc1IDE4LjAxMTQgNS45ODg1OCAyMC4yNSA4Ljc1IDIwLjI1SDE1LjI1QzE4LjAxMTQgMjAuMjUgMjAuMjUgMTguMDExNCAyMC4yNSAxNS4yNVYxMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjE4LjI1IiBjeT0iNS43NSIgcj0iMyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BadgeIcon: ProIcon;
export { BadgeIcon }
export { BadgeIcon as badge }

/**
 * @description Stats, Statistics, Data, Graph, Chart
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMjFIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSI0IiB5PSI3LjUiIHdpZHRoPSI2IiBoZWlnaHQ9IjEwIiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjE0IiB5PSIyLjUiIHdpZHRoPSI2IiBoZWlnaHQ9IjE1IiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BarGraphIcon: ProIcon;
export { BarGraphIcon }
export { BarGraphIcon as barGraph }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNiIgd2lkdGg9IjE2IiBoZWlnaHQ9IjEyIiByeD0iMy4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjUuMjUiIHk9IjguNSIgd2lkdGg9IjExIiBoZWlnaHQ9IjciIHJ4PSIxLjUiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTIxLjI1IDEwTDIxLjI1IDE0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BatteryFullIcon: ProIcon;
export { BatteryFullIcon }
export { BatteryFullIcon as batteryFull }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNiIgd2lkdGg9IjE2IiBoZWlnaHQ9IjEyIiByeD0iMy4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjUuMjUiIHk9IjguNSIgd2lkdGg9IjciIGhlaWdodD0iNyIgcng9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMjEuMjUgMTBMMjEuMjUgMTQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BatteryIcon: ProIcon;
export { BatteryIcon }
export { BatteryIcon as battery }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3LjEzNDYgNC4wMjY1M0MxOS4xMDQgNS4xNjM1OSAyMC41MDM4IDcuMTAxMTUgMjEuMDI1OSA5LjQxMjk2QzIxLjMyNiAxMC43NDIgMjEuMzIyIDEyLjEzMjEgMjEuMDMwNCAxMy40NzlDMjAuNjY4NyAxNS4xNDk0IDE4LjcxODcgMTUuNjYxIDE3LjIzODYgMTQuODA2NUw3Ljc0Njg2IDkuMzI2NDVDNi4yNjY3NSA4LjQ3MTkxIDUuNzM0ODEgNi41MjcyNyA3LjAwMDU5IDUuMzc4OUM4LjAyMTIzIDQuNDUyOTQgOS4yMjMxIDMuNzU0MzcgMTAuNTI0MSAzLjM0OTc5QzEyLjc4NzMgMi42NDYwMyAxNS4xNjUxIDIuODg5NDYgMTcuMTM0NiA0LjAyNjUzWk0xNy4xMzQ2IDQuMDI2NTNDMTUuNzY3NSAzLjIzNzI2IDEyLjU4MTEgNi4xOTcwMyAxMC4wMTc0IDEwLjYzNzRNMTcuMTM0NiA0LjAyNjUzQzE4LjUwMTYgNC44MTU4IDE3LjUzMTYgOS4wNTUyMyAxNC45NjggMTMuNDk1Nk0xMi40OTI4IDEyLjA2NjVMOC44ODI0MyAxOC4zMTk4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjkwODkgMjEuMDQ1MUMxNS4wNDQ4IDIwLjE4MTEgMTQuMDE5MSAxOS40OTU3IDEyLjg5MDIgMTkuMDI4MUMxMS43NjEzIDE4LjU2MDUgMTAuNTUxNCAxOC4zMTk4IDkuMzI5NDQgMTguMzE5OEM4LjEwNzUzIDE4LjMxOTggNi44OTc1OSAxOC41NjA1IDUuNzY4NjkgMTkuMDI4MUM0LjYzOTc5IDE5LjQ5NTcgMy42MTQwNSAyMC4xODExIDIuNzUwMDMgMjEuMDQ1MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BeachIcon: ProIcon;
export { BeachIcon }
export { BeachIcon as beach }

/**
 * @description Flask, Test, Lab, Experiment
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNDU2MjQgMy43NVY4Ljg0MDFDOS40NTYyNCA5LjQ2NDQ1IDkuMjYxNTIgMTAuMDczMyA4Ljg5OTE4IDEwLjU4MTdMNy4xNjI4NCAxMy4wMTg0TTkuNDU2MjQgMy43NUg3LjgwNjI0TTkuNDU2MjQgMy43NUgxNC41NDM4TTE0LjU0MzggMy43NVY4Ljg0MDFDMTQuNTQzOCA5LjQ2NDQ1IDE0LjczODUgMTAuMDczMyAxNS4xMDA4IDEwLjU4MTdMMTYuODM3MiAxMy4wMTg0TTE0LjU0MzggMy43NUgxNi4xOTM4TTcuMTYyODQgMTMuMDE4NEw0Ljc4NTA3IDE2LjM1NTFDMy45NDk2NiAxNy41Mjc1IDQuMjkyNTggMTkuMTYzMiA1LjUyODQ5IDE5LjkwMTRDNS45MTA1MyAyMC4xMjk1IDYuMzQ3MjEgMjAuMjUgNi43OTIyIDIwLjI1SDE3LjIwNzhDMTcuNjUyOCAyMC4yNSAxOC4wODk1IDIwLjEyOTUgMTguNDcxNSAxOS45MDE0QzE5LjcwNzQgMTkuMTYzMiAyMC4wNTAzIDE3LjUyNzUgMTkuMjE0OSAxNi4zNTUxTDE2LjgzNzIgMTMuMDE4NE03LjE2Mjg0IDEzLjAxODRIMTYuODM3MiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BeakerIcon: ProIcon;
export { BeakerIcon }
export { BeakerIcon as beaker }

/**
 * @description New Notification, Alert, Unread
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjQ3NjYgOS43NVYxMy4zODkyQzE4LjQ3NjYgMTMuOTUyMSAxOC42MzQ5IDE0LjUwMzYgMTguOTMzNSAxNC45ODA4TDIwLjAyMjEgMTYuNzIwMUMyMC40Mzg5IDE3LjM4NjEgMTkuOTYwMSAxOC4yNTA2IDE5LjE3NDQgMTguMjUwNkg0LjgyNTU1QzQuMDM5ODQgMTguMjUwNiAzLjU2MTA0IDE3LjM4NjEgMy45Nzc4OCAxNi43MjAxTDUuMDY2NDQgMTQuOTgwOEM1LjM2NTA2IDE0LjUwMzYgNS41MjM0MyAxMy45NTIxIDUuNTIzNDMgMTMuMzg5MlY5LjIyNzE3QzUuNTIzNDMgNS42NTAyNyA4LjQyMzA4IDIuNzUwNjEgMTIgMi43NTA2MUMxMi44OTM4IDIuNzUwNjEgMTMuNzQ1NCAyLjkzMTY5IDE0LjUyIDMuMjU5MTciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTAgMjEuMjQ5NEgxNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxjaXJjbGUgY3g9IjE4LjUiIGN5PSI1LjUiIHI9IjIuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.11.0
 */
declare const BellDotIcon: ProIcon;
export { BellDotIcon }
export { BellDotIcon as bellDot }

/**
 * @description Notification, Alert
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjkzMzYgMTQuOTgwOEMxOC42MzQ5IDE0LjUwMzYgMTguNDc2NiAxMy45NTIxIDE4LjQ3NjYgMTMuMzg5MlY5LjIyNzE3QzE4LjQ3NjYgNS42NTAyNyAxNS41NzY5IDIuNzUwNjEgMTIgMi43NTA2MUM4LjQyMzExIDIuNzUwNjEgNS41MjM0NiA1LjY1MDI3IDUuNTIzNDYgOS4yMjcxN1YxMy4zODkyQzUuNTIzNDYgMTMuOTUyMSA1LjM2NTA5IDE0LjUwMzYgNS4wNjY0NyAxNC45ODA4TDMuOTc3OTEgMTYuNzIwMUMzLjU2MTA3IDE3LjM4NjEgNC4wMzk4NyAxOC4yNTA2IDQuODI1NTggMTguMjUwNkgxOS4xNzQ1QzE5Ljk2MDIgMTguMjUwNiAyMC40MzkgMTcuMzg2MSAyMC4wMjIxIDE2LjcyMDFMMTguOTMzNiAxNC45ODA4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMCAyMS4yNDk0SDE0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BellIcon: ProIcon;
export { BellIcon }
export { BellIcon as bell }

/**
 * @description Notification, Alert, Do Not Disturb
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwIDIxLjI0OTRIMTQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTcuMTg3NiAxOC4yNTA3SDQuODI1N0M0LjAzOTk4IDE4LjI1MDcgMy41NjExOSAxNy4zODYyIDMuOTc4MDMgMTYuNzIwMkw1LjA2NjU4IDE0Ljk4MDlDNS4zNjUyMSAxNC41MDM4IDUuNTIzNTcgMTMuOTUyMiA1LjUyMzU3IDEzLjM4OTNWOS4yMjcyOUM1LjUyMzU3IDguNDM5MTQgNS42NjQzNSA3LjY4Mzg4IDUuOTIyMTQgNi45ODUyNk03LjYxODUgNC40NTc4NUM3LjYzODYyIDQuNDM5MzYgNy42NTg4NSA0LjQyMSA3LjY3OTE5IDQuNDAyNzZDOC44MjU0IDMuMzc1NSAxMC4zMzk4IDIuNzUwNzMgMTIuMDAwMSAyLjc1MDczQzE1LjU3NyAyLjc1MDczIDE4LjQ3NjcgNS42NTAzOSAxOC40NzY3IDkuMjI3M1YxMy4zODkzQzE4LjQ3NjcgMTMuOTUyMiAxOC42MzUxIDE0LjUwMzggMTguOTMzNyAxNC45ODA5TDIwLjAyMjIgMTYuNzIwMkMyMC4wNjY5IDE2Ljc5MTYgMjAuMTAxMyAxNi44NjUzIDIwLjEyNjIgMTYuOTQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuNzE4NSAyMS43ODE2TDE3LjE4NzYgMTguMjUwN0w1LjkyMjE0IDYuOTg1MjhMMi4yMTg0OCAzLjI4MTYyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const BellOffIcon: ProIcon;
export { BellOffIcon }
export { BellOffIcon as bellOff }

/**
 * @description BT, Wireless
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuMjUgNy41TDExLjcwNDUgMTJNMTEuNzA0NSAxMkwxNi45NTA0IDE1Ljk4MjNDMTcuMjkzIDE2LjI0MjQgMTcuMjkzIDE2Ljc1NzYgMTYuOTUwNCAxNy4wMTc3TDEyLjc0NzYgMjAuMjA4MkMxMi4zMTk2IDIwLjUzMzEgMTEuNzA0NSAyMC4yMjc5IDExLjcwNDUgMTkuNjkwNVY0LjMwOTUxQzExLjcwNDUgMy43NzIxNCAxMi4zMTk1IDMuNDY2ODcgMTIuNzQ3NiAzLjc5MTc5TDE2Ljk1MDQgNi45ODIyOEMxNy4yOTMgNy4yNDIzOSAxNy4yOTMgNy43NTc2MSAxNi45NTA0IDguMDE3NzJMMTEuNzA0NSAxMlpNMTEuNzA0NSAxMkw2LjI1IDE2LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BluetoothIcon: ProIcon;
export { BluetoothIcon }
export { BluetoothIcon as bluetooth }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3Ljc1IDRINi4yNUM0LjMxNyA0IDIuNzUgNS41NjcgMi43NSA3LjVWMTYuNUMyLjc1IDE4LjQzMyA0LjMxNyAyMCA2LjI1IDIwSDE3Ljc1QzE5LjY4MyAyMCAyMS4yNSAxOC40MzMgMjEuMjUgMTYuNVY3LjVDMjEuMjUgNS41NjcgMTkuNjgzIDQgMTcuNzUgNFoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTcuMDk5OCA2Ljk1MDA3SDYuOTAwMkM2LjIzNzQ1IDYuOTUwMDcgNS43MDAyIDcuNDg3MzMgNS43MDAyIDguMTUwMDdWOC42MzM0MkM1LjcwMDIgOS4yOTYxNiA2LjIzNzQ1IDkuODMzNDIgNi45MDAxOSA5LjgzMzQySDE3LjA5OThDMTcuNzYyNSA5LjgzMzQyIDE4LjI5OTggOS4yOTYxNiAxOC4yOTk4IDguNjMzNDJWOC4xNTAwN0MxOC4yOTk4IDcuNDg3MzMgMTcuNzYyNSA2Ljk1MDA3IDE3LjA5OTggNi45NTAwN1oiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTE3LjA5OTggMTIuNTg5MkgxNC4xOTk4QzEzLjUzNyAxMi41ODkyIDEyLjk5OTggMTMuMTI2NSAxMi45OTk4IDEzLjc4OTJWMTUuODVDMTIuOTk5OCAxNi41MTI3IDEzLjUzNyAxNy4wNSAxNC4xOTk4IDE3LjA1SDE3LjA5OThDMTcuNzYyNSAxNy4wNSAxOC4yOTk4IDE2LjUxMjcgMTguMjk5OCAxNS44NVYxMy43ODkyQzE4LjI5OTggMTMuMTI2NSAxNy43NjI1IDEyLjU4OTIgMTcuMDk5OCAxMi41ODkyWiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNOS4wMDAyIDEyLjU4OTJINi45MDAyQzYuMjM3NDUgMTIuNTg5MiA1LjcwMDIgMTMuMTI2NSA1LjcwMDIgMTMuNzg5MlYxNS44NUM1LjcwMDIgMTYuNTEyNyA2LjIzNzQ1IDE3LjA1IDYuOTAwMiAxNy4wNUg5LjAwMDJDOS42NjI5NCAxNy4wNSAxMC4yMDAyIDE2LjUxMjcgMTAuMjAwMiAxNS44NVYxMy43ODkyQzEwLjIwMDIgMTMuMTI2NSA5LjY2Mjk0IDEyLjU4OTIgOS4wMDAyIDEyLjU4OTJaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BoardIcon: ProIcon;
export { BoardIcon }
export { BoardIcon as board }

/**
 * @description Lightning, Strike, Flash, Zap
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5Ljg5NjMgMTEuNDU3QzIwLjUzNiAxMS40NTcgMjAuODIgMTIuMjYxMyAyMC4zMjIyIDEyLjY2M0w5Ljg3MTQyIDIxLjA5NjhDOS4zNjczMSAyMS41MDM2IDguNjM0MjkgMjEuMDM5NyA4Ljc4NjE3IDIwLjQxTDEwLjQwMTIgMTMuNzEzNUg0LjEwMzcxQzMuNDgyNzcgMTMuNzEzNSAzLjE4ODMgMTIuOTQ4MyAzLjY0OTAzIDEyLjUzMkwxNC4yNzkyIDIuOTI3NjJDMTQuNzY3OSAyLjQ4NjEzIDE1LjUzNTYgMi45Mjk5MSAxNS4zOTY5IDMuNTczNjhMMTMuNjk4NyAxMS40NTdIMTkuODk2M1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.10.0
 */
declare const BoltIcon: ProIcon;
export { BoltIcon }
export { BoltIcon as bolt }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNDk5OTcgNC43NDg1NEM0LjQ5OTk3IDMuNjQzOTcgNS4zOTU0IDIuNzQ4NTQgNi40OTk5NyAyLjc0ODU0SDE3LjVDMTguNjA0NiAyLjc0ODU0IDE5LjUgMy42NDM5NyAxOS41IDQuNzQ4NTRWMTcuNzQ4NUg0LjQ5OTk3VjQuNzQ4NTRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTQuNDk5OTcgMTcuNzQ4NVYxOS4yNTE2QzQuNDk5OTcgMjAuMzU2MSA1LjM5NTQgMjEuMjUxNiA2LjQ5OTk3IDIxLjI1MTZIMTkuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjgiIHk9IjYuMjUiIHdpZHRoPSI4IiBoZWlnaHQ9IjMiIHJ4PSIwLjYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const Book2Icon: ProIcon;
export { Book2Icon }
export { Book2Icon as book2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const BookAdd2Icon: ProIcon;
export { BookAdd2Icon }
export { BookAdd2Icon as bookAdd2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNy41IDIzQzIwLjUzNzYgMjMgMjMgMjAuNTM3NiAyMyAxNy41QzIzIDE0LjQ2MjQgMjAuNTM3NiAxMiAxNy41IDEyQzE0LjQ2MjQgMTIgMTIgMTQuNDYyNCAxMiAxNy41QzEyIDIwLjUzNzYgMTQuNDYyNCAyMyAxNy41IDIzWk0xNy41IDE0LjAwNjZDMTcuNzc2MSAxNC4wMDY2IDE4IDE0LjIzMDQgMTggMTQuNTA2NlYxNy4wMDAxSDIwLjQ5MzRDMjAuNzY5NiAxNy4wMDAxIDIwLjk5MzQgMTcuMjIzOSAyMC45OTM0IDE3LjUwMDFDMjAuOTkzNCAxNy43NzYyIDIwLjc2OTYgMTguMDAwMSAyMC40OTM0IDE4LjAwMDFIMThWMjAuNDkzNEMxOCAyMC43Njk2IDE3Ljc3NjEgMjAuOTkzNCAxNy41IDIwLjk5MzRDMTcuMjIzOSAyMC45OTM0IDE3IDIwLjc2OTYgMTcgMjAuNDkzNFYxOC4wMDAxSDE0LjUwNjZDMTQuMjMwNCAxOC4wMDAxIDE0LjAwNjYgMTcuNzc2MiAxNC4wMDY2IDE3LjUwMDFDMTQuMDA2NiAxNy4yMjM5IDE0LjIzMDQgMTcuMDAwMSAxNC41MDY2IDE3LjAwMDFIMTdWMTQuNTA2NkMxNyAxNC4yMzA0IDE3LjIyMzkgMTQuMDA2NiAxNy41IDE0LjAwNjZaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik00LjQ5OTk3IDE5LjEyNUM0LjQ5OTk3IDIwLjUwNTcgNS42MTkyNiAyMS42MjUgNi45OTk5NyAyMS42MjVIMTEuNjFNNC40OTk5NyAxOS4xMjVDNC40OTk5NyAxNy43NDQzIDUuNjE5MjYgMTYuNjI1IDYuOTk5OTcgMTYuNjI1SDEwLjMyTTQuNDk5OTcgMTkuMTI1VjYuMTI1QzQuNDk5OTcgNC40NjgxNSA1Ljg0MzEyIDMuMTI1IDcuNDk5OTcgMy4xMjVIMTguNUMxOS4wNTIzIDMuMTI1IDE5LjUgMy41NzI3MiAxOS41IDQuMTI1VjEwLjYyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BookAddIcon: ProIcon;
export { BookAddIcon }
export { BookAddIcon as bookAdd }

/**
 * @description Reading
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNDk5OTcgMTYuNjI1VjYuMTI1QzQuNDk5OTcgNC40NjgxNSA1Ljg0MzEyIDMuMTI1IDcuNDk5OTcgMy4xMjVIMTguNUMxOS4wNTIzIDMuMTI1IDE5LjUgMy41NzI3MiAxOS41IDQuMTI1VjE2LjYyNUg3LjM3NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik00LjQ5OTk3IDE2LjYyVjE5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE4LjUgMjEuNjI1SDYuOTk5OTdDNS42MTkyNiAyMS42MjUgNC40OTk5NyAyMC41MDU3IDQuNDk5OTcgMTkuMTI1QzQuNDk5OTcgMTcuNzQ0MyA1LjYxOTI2IDE2LjYyNSA2Ljk5OTk3IDE2LjYyNUgxOS41VjIwLjYyNUMxOS41IDIxLjE3NzMgMTkuMDUyMyAyMS42MjUgMTguNSAyMS42MjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BookIcon: ProIcon;
export { BookIcon }
export { BookIcon as book }

/**
 * @description Manual, Infobook, Tutorial
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNDk5OTcgNC43NDg1NEM0LjQ5OTk3IDMuNjQzOTcgNS4zOTU0IDIuNzQ4NTQgNi40OTk5NyAyLjc0ODU0SDE3LjVDMTguNjA0NiAyLjc0ODU0IDE5LjUgMy42NDM5NyAxOS41IDQuNzQ4NTRWMTcuNzQ4NUg0LjQ5OTk3VjQuNzQ4NTRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyLjAwMDIgMTAuMDcwNEwxMi4wMDAyIDE0Ljg2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPGVsbGlwc2UgY3g9IjEyLjAwMDEiIGN5PSI2LjgzNzQxIiByeD0iMS4xOTc0IiByeT0iMS4xOTc0IiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik00LjQ5OTk3IDE3Ljc0ODVWMTkuMjUxNkM0LjQ5OTk3IDIwLjM1NjEgNS4zOTU0IDIxLjI1MTYgNi40OTk5NyAyMS4yNTE2SDE5LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BookInfo2Icon: ProIcon;
export { BookInfo2Icon }
export { BookInfo2Icon as bookInfo2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNDk5OTcgMTYuNjI1VjYuMTI1QzQuNDk5OTcgNC40NjgxNSA1Ljg0MzEyIDMuMTI1IDcuNDk5OTcgMy4xMjVIMTguNUMxOS4wNTIzIDMuMTI1IDE5LjUgMy41NzI3MiAxOS41IDQuMTI1VjE2LjYyNUg3LjM3NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik00LjQ5OTk3IDE2LjYyVjE5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE4LjUgMjEuNjI1SDYuOTk5OTdDNS42MTkyNiAyMS42MjUgNC40OTk5NyAyMC41MDU3IDQuNDk5OTcgMTkuMTI1QzQuNDk5OTcgMTcuNzQ0MyA1LjYxOTI2IDE2LjYyNSA2Ljk5OTk3IDE2LjYyNUgxOS41VjIwLjYyNUMxOS41IDIxLjE3NzMgMTkuMDUyMyAyMS42MjUgMTguNSAyMS42MjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyLjAwMDEgOS44MjU0NEwxMi4wMDAxIDEzLjYxNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxlbGxpcHNlIGN4PSIxMiIgY3k9IjYuNTkyNDIiIHJ4PSIxLjE5NzQiIHJ5PSIxLjE5NzQiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BookInfoIcon: ProIcon;
export { BookInfoIcon }
export { BookInfoIcon as bookInfo }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNy41IDEyQzIwLjUzNzYgMTIgMjMgOS41Mzc1NyAyMyA2LjVDMjMgMy40NjI0MyAyMC41Mzc2IDEgMTcuNSAxQzE1LjY3ODIgMSAxNC4wNjM0IDEuODg1NzEgMTMuMDYyNSAzLjI1QzEyLjM5NDUgNC4xNjA1MSAxMiA1LjI4NDE5IDEyIDYuNUMxMiA5LjUzNzU3IDE0LjQ2MjQgMTIgMTcuNSAxMlpNMTcuNSAzLjAwNjU5QzE3Ljc3NjEgMy4wMDY1OSAxOCAzLjIzMDQ1IDE4IDMuNTA2NTlWNi4wMDAwNkgyMC40OTM0QzIwLjc2OTYgNi4wMDAwNiAyMC45OTM0IDYuMjIzOTIgMjAuOTkzNCA2LjUwMDA2QzIwLjk5MzQgNi43NzYyIDIwLjc2OTYgNy4wMDAwNiAyMC40OTM0IDcuMDAwMDZIMThWOS40OTM0M0MxOCA5Ljc2OTU4IDE3Ljc3NjEgOS45OTM0MyAxNy41IDkuOTkzNDNDMTcuMjIzOSA5Ljk5MzQzIDE3IDkuNzY5NTggMTcgOS40OTM0M1Y3LjAwMDA2SDE0LjUwNjZDMTQuMjMwNCA3LjAwMDA2IDE0LjAwNjYgNi43NzYyIDE0LjAwNjYgNi41MDAwNkMxNC4wMDY2IDYuMjIzOTIgMTQuMjMwNCA2LjAwMDA2IDE0LjUwNjYgNi4wMDAwNkgxN1YzLjUwNjU5QzE3IDMuMjMwNDUgMTcuMjIzOSAzLjAwNjU5IDE3LjUgMy4wMDY1OVoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTE5LjI1IDEzLjVWMjAuMTEyOEMxOS4yNSAyMC42MTExIDE4LjY5NiAyMC45MTYgMTguMjY2NiAyMC42NTM5TDEyLjU2NDggMTcuMTczN0MxMi4yMTg3IDE2Ljk2MjQgMTEuNzgxMyAxNi45NjI0IDExLjQzNTEgMTcuMTczN0w1LjczMzM1IDIwLjY1MzlDNS4zMDQwMiAyMC45MTYgNC43NSAyMC42MTExIDQuNzUgMjAuMTEyOFY2LjI1QzQuNzUgNC41OTMxNSA2LjA5MzE1IDMuMjUgNy43NSAzLjI1SDExLjA2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const BookmarkAddIcon: ProIcon;
export { BookmarkAddIcon }
export { BookmarkAddIcon as bookmarkAdd }

/**
 * @description Favorite
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNzUgMjAuMTEyOEM0Ljc1IDIwLjYxMTEgNS4zMDQwMiAyMC45MTYgNS43MzMzNSAyMC42NTM5TDExLjQzNTEgMTcuMTczN0MxMS43ODEzIDE2Ljk2MjQgMTIuMjE4NyAxNi45NjI0IDEyLjU2NDggMTcuMTczN0wxOC4yNjY2IDIwLjY1MzlDMTguNjk2IDIwLjkxNiAxOS4yNSAyMC42MTExIDE5LjI1IDIwLjExMjhWNi4yNUMxOS4yNSA0LjU5MzE1IDE3LjkwNjkgMy4yNSAxNi4yNSAzLjI1SDcuNzVDNi4wOTMxNSAzLjI1IDQuNzUgNC41OTMxNSA0Ljc1IDYuMjVWMjAuMTEyOFoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const BookmarkIcon: ProIcon;
export { BookmarkIcon }
export { BookmarkIcon as bookmark }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMjAuNjUzNkMzLjc1IDIxLjEyMzYgNC4yNjU4MSAyMS40MTExIDQuNjY1NTQgMjEuMTYzOUw5Ljk3NDEgMTcuODgxNkMxMC4yOTY0IDE3LjY4MjQgMTAuNzAzNiAxNy42ODI0IDExLjAyNTkgMTcuODgxNkwxNi4zMzQ1IDIxLjE2MzlDMTYuNzM0MiAyMS40MTExIDE3LjI1IDIxLjEyMzUgMTcuMjUgMjAuNjUzNlY4Ljc1QzE3LjI1IDcuMDkzMTUgMTUuOTA2OSA1Ljc1IDE0LjI1IDUuNzVINi43NUM1LjA5MzE1IDUuNzUgMy43NSA3LjA5MzE0IDMuNzUgOC43NVYyMC42NTM2WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuMjUgMTcuNjVWOC43NUMyMC4yNSA1LjQzNjI5IDE3LjU2MzcgMi43NSAxNC4yNSAyLjc1SDcuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const BookmarkMultipleIcon: ProIcon;
export { BookmarkMultipleIcon }
export { BookmarkMultipleIcon as BookmarkMultipleVarIcon }
export { BookmarkMultipleIcon as bookmarkMultiple }
export { BookmarkMultipleIcon as bookmarkMultipleVar }

/**
 * @description Reading
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNy4yMDk5NkMyLjc1IDYuMTA1MzkgMy42NDU0MyA1LjIwOTk2IDQuNzUgNS4yMDk5Nkg4LjVDMTAuNDMzIDUuMjA5OTYgMTIgNi43NzY5NiAxMiA4LjcwOTk2VjE2LjA3OFYxOS41OTQ5TDEwLjk4NTIgMTguODczNUMxMC4zMDgyIDE4LjM5MjIgOS40OTgxNCAxOC4xMzM2IDguNjY3NDggMTguMTMzNkg0Ljc1QzMuNjQ1NDMgMTguMTMzNiAyLjc1IDE3LjIzODEgMi43NSAxNi4xMzM2VjcuMjA5OTZaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIxLjI1IDcuMjA5OTZDMjEuMjUgNi4xMDUzOSAyMC4zNTQ2IDUuMjA5OTYgMTkuMjUgNS4yMDk5NkgxNS41QzEzLjU2NyA1LjIwOTk2IDEyIDYuNzc2OTYgMTIgOC43MDk5NlYxNi4wNzhWMTkuNTk0OUwxMy4wMTQ4IDE4Ljg3MzVDMTMuNjkxOCAxOC4zOTIyIDE0LjUwMTkgMTguMTMzNiAxNS4zMzI1IDE4LjEzMzZIMTkuMjVDMjAuMzU0NiAxOC4xMzM2IDIxLjI1IDE3LjIzODEgMjEuMjUgMTYuMTMzNlY3LjIwOTk2WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BookOpenIcon: ProIcon;
export { BookOpenIcon }
export { BookOpenIcon as bookOpen }

/**
 * @description Not to be confused with 'Microsoft'
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIwLjI1SDE2LjI1QzE4LjQ1OTEgMjAuMjUgMjAuMjUgMTguNDU5MSAyMC4yNSAxNi4yNVYxMk0xMiAyMC4yNUg3Ljc1QzUuNTQwODYgMjAuMjUgMy43NSAxOC40NTkxIDMuNzUgMTYuMjVWMTJNMTIgMjAuMjVWMy43NU0xMiAzLjc1SDcuNzVDNS41NDA4NiAzLjc1IDMuNzUgNS41NDA4NiAzLjc1IDcuNzVWMTJNMTIgMy43NUgxNi4yNUMxOC40NTkxIDMuNzUgMjAuMjUgNS41NDA4NiAyMC4yNSA3Ljc1VjEyTTMuNzUgMTJIMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BorderAllIcon: ProIcon;
export { BorderAllIcon }
export { BorderAllIcon as borderAll }

/**
 * @description Grab, Hand, Drop, Grabber, Draging
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjA3MjcgMTcuNTMyNkwxMi4wNzI3IDE0LjUyOTJWMTMuNjY5Mk0xNC42MTcgMTAuNzMyMkMxNC42MTcgMTAuMDMzMiAxNC4wNDc0IDkuNDY2NTQgMTMuMzQ0OCA5LjQ2NjU0QzEyLjY0MjIgOS40NjY1NCAxMi4wNzI3IDEwLjAzMzIgMTIuMDcyNyAxMC43MzIyTDEyLjA3MjcgMTMuNjY5Mk0xNC42MTcgMTMuMjI1MkwxNC42MTcgOS4wMTU2NUMxNC42MTcgOC4zMTY2NSAxNS4xODY2IDcuNzUgMTUuODg5MiA3Ljc1QzE2LjU5MTcgNy43NSAxNy4xNjEzIDguMzE2NjUgMTcuMTYxMyA5LjAxNTY1TDE3LjE2MTMgMTAuNzMyMk0xNy4xNjEzIDEwLjczMjJMMTcuMTYxMyAxMy4yMjUyTTE3LjE2MTMgMTAuNzMyMkMxNy4xNjEzIDEwLjAzMzIgMTcuNzMwOSA5LjQ2MTk1IDE4LjQzMzUgOS40NjE5NUMxOS4xMzYxIDkuNDYxOTUgMTkuNzA1NiAxMC4wMzMyIDE5LjcwNTYgMTAuNzMyMkwxOS43MDU2IDEyLjQ0ODdNMTkuNzA1NiAxMi40NDg3VjEzLjIyNTJNMTkuNzA1NiAxMi40NDg3QzE5LjcwNTYgMTEuNzQ5NyAyMC4yNzUyIDExLjE4MzEgMjAuOTc3OCAxMS4xODMxQzIxLjY4MDQgMTEuMTgzMSAyMi4yNSAxMS43NDk3IDIyLjI1IDEyLjQ0ODdMMjIuMjUgMTcuMTAwNEMyMi4yNSAxOS45NDQ0IDE5Ljk0NDQgMjIuMjUgMTcuMTAwNCAyMi4yNUgxNC43ODk0QzEzLjMzMzQgMjIuMjUgMTEuOTM1NyAyMS42Nzc4IDEwLjg5NzcgMjAuNjU2OUM5Ljc1NjkzIDE5LjUzNDkgOS4xNTU5MyAxNy45NzUxIDkuMjQ4ODkgMTYuMzc3N0w5LjI2MDU3IDE2LjE3N0M5LjMxODMyIDE1LjE4NDcgOS45ODI1IDE0LjMzMSAxMC45MzAyIDE0LjAzMDlMMTIuMDcyNyAxMy42NjkyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTYuNzUgMTguMjVDNS4wOTMxNSAxOC4yNSAzLjc1IDE2LjkwNjkgMy43NSAxNS4yNVY2Ljc1QzMuNzUgNS4wOTMxNSA1LjA5MzE1IDMuNzUgNi43NSAzLjc1SDE1LjI1QzE2LjczNjUgMy43NSAxNy45NzA1IDQuODMxMTQgMTguMjA4NSA2LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BoxDragIcon: ProIcon;
export { BoxDragIcon }
export { BoxDragIcon as boxDrag }

/**
 * @description Package, Amazon, Delivery
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNjg2NTIgOS42ODc0NEwxMC4zNDYzIDExLjExMzRDMTAuODYyNyAxMS4zOTAyIDExLjQzMTQgMTEuNTI4NyAxMiAxMS41Mjg3TTcuNjg2NTIgOS42ODc0NEwzLjg4NDAzIDcuNjQ4ODhNNy42ODY1MiA5LjY4NzQ0TDE2LjE4MzMgNS4xMzIyM0wxNi4zMTExIDUuMDYxMThNMy44ODQwMyA3LjY0ODg4QzMuNTU1NjUgOC4xODc5MiAzLjM3MzA1IDguODE1NDEgMy4zNzMwNSA5LjQ2OThWMTQuNTMwMUMzLjM3MzA1IDE1LjgyIDQuMDgyNTEgMTcuMDA1MyA1LjIxOTMyIDE3LjYxNDdMMTAuMzQ2MyAyMC4zNjM0QzEwLjg2MjcgMjAuNjQwMiAxMS40MzE0IDIwLjc3ODcgMTIgMjAuNzc4N00zLjg4NDAzIDcuNjQ4ODhDNC4yMDI5MSA3LjEyNTQzIDQuNjU5MjUgNi42ODUzOSA1LjIxOTMyIDYuMzg1MTNMMTAuMzQ2MyAzLjYzNjUyQzExLjM3OTIgMy4wODI3NSAxMi42MjA4IDMuMDgyNzUgMTMuNjUzNyAzLjYzNjUyTDE2LjMxMTEgNS4wNjExOE0xMiAxMS41Mjg3QzEyLjU2ODYgMTEuNTI4NyAxMy4xMzcyIDExLjM5MDIgMTMuNjUzNyAxMS4xMTM0TDIwLjExNiA3LjY0ODg4TTEyIDExLjUyODdWMTEuOTk5OVYyMC43Nzg3TTEyIDIwLjc3ODdDMTIuNTY4NiAyMC43Nzg3IDEzLjEzNzIgMjAuNjQwMiAxMy42NTM3IDIwLjM2MzRMMTguNzgwNyAxNy42MTQ3QzE5LjkxNzUgMTcuMDA1MyAyMC42MjY5IDE1LjgyIDIwLjYyNjkgMTQuNTMwMVY5LjQ2OThDMjAuNjI2OSA4LjgxNTQxIDIwLjQ0NDMgOC4xODc5MiAyMC4xMTYgNy42NDg4OE0yMC4xMTYgNy42NDg4OEMxOS43OTcxIDcuMTI1NDMgMTkuMzQwNyA2LjY4NTM5IDE4Ljc4MDcgNi4zODUxM0wxNi4zMTExIDUuMDYxMTgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BoxIcon: ProIcon;
export { BoxIcon }
export { BoxIcon as box }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy43NSAzLjc1TDcuNzUgMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuMjUgMjAuMjVMMTYuMjUgMy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0zLjc1IDcuNzVIMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuMjUgMTYuMjVIMy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BoxMarginsIcon: ProIcon;
export { BoxMarginsIcon }
export { BoxMarginsIcon as boxMargins }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTggMjAuMjVDNi44OTU0MyAyMC4yNSA2IDE5LjM1NDYgNiAxOC4yNVYxNS45MDY5QzYgMTQuODQ2IDUuNTc4NTcgMTMuODI4NiA0LjgyODQzIDEzLjA3ODRMMy43NSAxMkw0LjgyODQzIDEwLjkyMTZDNS41Nzg1NyAxMC4xNzE0IDYgOS4xNTQwMSA2IDguMDkzMTVWNS43NUM2IDQuNjQ1NDMgNi44OTU0MyAzLjc1IDggMy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNiAyMC4yNUMxNy4xMDQ2IDIwLjI1IDE4IDE5LjM1NDYgMTggMTguMjVWMTUuOTA2OUMxOCAxNC44NDYgMTguNDIxNCAxMy44Mjg2IDE5LjE3MTYgMTMuMDc4NEwyMC4yNSAxMkwxOS4xNzE2IDEwLjkyMTZDMTguNDIxNCAxMC4xNzE0IDE4IDkuMTU0MDEgMTggOC4wOTMxNVY1Ljc1QzE4IDQuNjQ1NDMgMTcuMTA0NiAzLjc1IDE2IDMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BracesIcon: ProIcon;
export { BracesIcon }
export { BracesIcon as braces }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcgMjAuMjVDNS44OTU0MyAyMC4yNSA1IDE5LjM1NDYgNSAxOC4yNVYxNS45MDY5QzUgMTQuODQ2IDQuNTc4NTcgMTMuODI4NiAzLjgyODQzIDEzLjA3ODRMMi43NSAxMkwzLjgyODQzIDEwLjkyMTZDNC41Nzg1NyAxMC4xNzE0IDUgOS4xNTQwMSA1IDguMDkzMTVWNS43NUM1IDQuNjQ1NDMgNS44OTU0MyAzLjc1IDcgMy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNyAyMC4yNUMxOC4xMDQ2IDIwLjI1IDE5IDE5LjM1NDYgMTkgMTguMjVWMTUuOTA2OUMxOSAxNC44NDYgMTkuNDIxNCAxMy44Mjg2IDIwLjE3MTYgMTMuMDc4NEwyMS4yNSAxMkwyMC4xNzE2IDEwLjkyMTZDMTkuNDIxNCAxMC4xNzE0IDE5IDkuMTU0MDEgMTkgOC4wOTMxNVY1Ljc1QzE5IDQuNjQ1NDMgMTguMTA0NiAzLjc1IDE3IDMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOSA4LjE0Mjg1TDE1IDE1Ljg1NzFNMTUgOC4xNDI4NUw5IDE1Ljg1NzEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BracesVariableIcon: ProIcon;
export { BracesVariableIcon }
export { BracesVariableIcon as bracesVariable }

/**
 * @description Code
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguNzUgMy43NUg2Ljc1QzUuNjQ1NDMgMy43NSA0Ljc1IDQuNjQ1NDMgNC43NSA1Ljc1VjE4LjI1QzQuNzUgMTkuMzU0NiA1LjY0NTQzIDIwLjI1IDYuNzUgMjAuMjVIOC43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS4yNSAzLjc1SDE3LjI1QzE4LjM1NDYgMy43NSAxOS4yNSA0LjY0NTQzIDE5LjI1IDUuNzVWMTguMjVDMTkuMjUgMTkuMzU0NiAxOC4zNTQ2IDIwLjI1IDE3LjI1IDIwLjI1SDE1LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const BracketsIcon: ProIcon;
export { BracketsIcon }
export { BracketsIcon as brackets }

/**
 * @description Git
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMjUgNS41QzguMjUgNy4wMTg3OCA3LjAxODc4IDguMjUgNS41IDguMjVDMy45ODEyMiA4LjI1IDIuNzUgNy4wMTg3OCAyLjc1IDUuNUMyLjc1IDMuOTgxMjIgMy45ODEyMiAyLjc1IDUuNSAyLjc1QzcuMDE4NzggMi43NSA4LjI1IDMuOTgxMjIgOC4yNSA1LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIxLjI1IDE4LjVDMjEuMjUgMjAuMDE4OCAyMC4wMTg4IDIxLjI1IDE4LjUgMjEuMjVDMTYuOTgxMiAyMS4yNSAxNS43NSAyMC4wMTg4IDE1Ljc1IDE4LjVDMTUuNzUgMTYuOTgxMiAxNi45ODEyIDE1Ljc1IDE4LjUgMTUuNzVDMjAuMDE4OCAxNS43NSAyMS4yNSAxNi45ODEyIDIxLjI1IDE4LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTUuNSA4LjI1VjE1LjVDNS41IDE3LjE1NjkgNi44NDMxNSAxOC41IDguNSAxOC41SDEyLjI1SDEyLjgzNThNMTAuNzUgMTZMMTIuNTQyOSAxNy43OTI5QzEyLjczODIgMTcuOTg4MiAxMi44MzU4IDE4LjI0NDEgMTIuODM1OCAxOC41TTEwLjc1IDIxTDEyLjU0MjkgMTkuMjA3MUMxMi43MzgyIDE5LjAxMTggMTIuODM1OCAxOC43NTU5IDEyLjgzNTggMTguNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xOC41IDE1Ljc1TDE4LjUgOC41QzE4LjUgNi44NDMxNSAxNy4xNTY5IDUuNSAxNS41IDUuNUwxMS43NSA1LjVIMTEuMTY0Mk0xMy4yNSA4TDExLjQ1NzEgNi4yMDcxMUMxMS4yNjE4IDYuMDExODQgMTEuMTY0MiA1Ljc1NTkyIDExLjE2NDIgNS41TTEzLjI1IDNMMTEuNDU3MSA0Ljc5Mjg5QzExLjI2MTggNC45ODgxNiAxMS4xNjQyIDUuMjQ0MDggMTEuMTY0MiA1LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const BranchCompareIcon: ProIcon;
export { BranchCompareIcon }
export { BranchCompareIcon as branchCompare }

/**
 * @description Git
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuNSA4LjI1QzguMDE4NzggOC4yNSA5LjI1IDcuMDE4NzggOS4yNSA1LjVDOS4yNSAzLjk4MTIyIDguMDE4NzggMi43NSA2LjUgMi43NUM0Ljk4MTIyIDIuNzUgMy43NSAzLjk4MTIyIDMuNzUgNS41QzMuNzUgNy4wMTg3OCA0Ljk4MTIyIDguMjUgNi41IDguMjVaTTYuNSA4LjI1VjEwQzYuNSAxMS4xMDQ2IDcuMzk1NDMgMTIgOC41IDEySDExLjVNMTcuNSA4LjI1QzE5LjAxODggOC4yNSAyMC4yNSA3LjAxODc4IDIwLjI1IDUuNUMyMC4yNSAzLjk4MTIyIDE5LjAxODggMi43NSAxNy41IDIuNzVDMTUuOTgxMiAyLjc1IDE0Ljc1IDMuOTgxMjIgMTQuNzUgNS41QzE0Ljc1IDcuMDE4NzggMTUuOTgxMiA4LjI1IDE3LjUgOC4yNVpNMTcuNSA4LjI1VjEwQzE3LjUgMTEuMTA0NiAxNi42MDQ2IDEyIDE1LjUgMTJIMTEuNU0xMS41IDEyVjE1Ljc1TTExLjUgMTUuNzVDOS45ODEyMiAxNS43NSA4Ljc1IDE2Ljk4MTIgOC43NSAxOC41QzguNzUgMjAuMDE4OCA5Ljk4MTIyIDIxLjI1IDExLjUgMjEuMjVDMTMuMDE4OCAyMS4yNSAxNC4yNSAyMC4wMTg4IDE0LjI1IDE4LjVDMTQuMjUgMTYuOTgxMiAxMy4wMTg4IDE1Ljc1IDExLjUgMTUuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BranchFork2Icon: ProIcon;
export { BranchFork2Icon }
export { BranchFork2Icon as branchFork2 }

/**
 * @description Git
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcgOC4yNUM4LjUxODc4IDguMjUgOS43NSA3LjAxODc4IDkuNzUgNS41QzkuNzUgMy45ODEyMiA4LjUxODc4IDIuNzUgNyAyLjc1QzUuNDgxMjIgMi43NSA0LjI1IDMuOTgxMjIgNC4yNSA1LjVDNC4yNSA3LjAxODc4IDUuNDgxMjIgOC4yNSA3IDguMjVaTTcgOC4yNVYxMk03IDE1Ljc1QzUuNDgxMjIgMTUuNzUgNC4yNSAxNi45ODEyIDQuMjUgMTguNUM0LjI1IDIwLjAxODggNS40ODEyMiAyMS4yNSA3IDIxLjI1QzguNTE4NzggMjEuMjUgOS43NSAyMC4wMTg4IDkuNzUgMTguNUM5Ljc1IDE2Ljk4MTIgOC41MTg3OCAxNS43NSA3IDE1Ljc1Wk03IDE1Ljc1VjEyTTE3IDguMjVDMTguNTE4OCA4LjI1IDE5Ljc1IDcuMDE4NzggMTkuNzUgNS41QzE5Ljc1IDMuOTgxMjIgMTguNTE4OCAyLjc1IDE3IDIuNzVDMTUuNDgxMiAyLjc1IDE0LjI1IDMuOTgxMjIgMTQuMjUgNS41QzE0LjI1IDcuMDE4NzggMTUuNDgxMiA4LjI1IDE3IDguMjVaTTE3IDguMjVWOUMxNyAxMC42NTY5IDE1LjY1NjkgMTIgMTQgMTJINyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BranchForkIcon: ProIcon;
export { BranchForkIcon }
export { BranchForkIcon as branchFork }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcgOC4yNUM4LjUxODc4IDguMjUgOS43NSA3LjAxODc4IDkuNzUgNS41QzkuNzUgMy45ODEyMiA4LjUxODc4IDIuNzUgNyAyLjc1QzUuNDgxMjIgMi43NSA0LjI1IDMuOTgxMjIgNC4yNSA1LjVDNC4yNSA3LjAxODc4IDUuNDgxMjIgOC4yNSA3IDguMjVaTTcgOC4yNVYxNS43NU03IDguMjVWOC4yNUM3IDExLjE0OTUgOS4zNTA1MSAxMy41IDEyLjI1IDEzLjVIMTQuMjVNNyAxNS43NUM1LjQ4MTIyIDE1Ljc1IDQuMjUgMTYuOTgxMiA0LjI1IDE4LjVDNC4yNSAyMC4wMTg4IDUuNDgxMjIgMjEuMjUgNyAyMS4yNUM4LjUxODc4IDIxLjI1IDkuNzUgMjAuMDE4OCA5Ljc1IDE4LjVDOS43NSAxNi45ODEyIDguNTE4NzggMTUuNzUgNyAxNS43NVpNMTQuMjUgMTMuNUMxNC4yNSAxNS4wMTg4IDE1LjQ4MTIgMTYuMjUgMTcgMTYuMjVDMTguNTE4OCAxNi4yNSAxOS43NSAxNS4wMTg4IDE5Ljc1IDEzLjVDMTkuNzUgMTEuOTgxMiAxOC41MTg4IDEwLjc1IDE3IDEwLjc1QzE1LjQ4MTIgMTAuNzUgMTQuMjUgMTEuOTgxMiAxNC4yNSAxMy41WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const BranchIcon: ProIcon;
export { BranchIcon }
export { BranchIcon as branch }

/**
 * @description Git
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMjUgNS41QzguMjUgNy4wMTg3OCA3LjAxODc4IDguMjUgNS41IDguMjVDMy45ODEyMiA4LjI1IDIuNzUgNy4wMTg3OCAyLjc1IDUuNUMyLjc1IDMuOTgxMjIgMy45ODEyMiAyLjc1IDUuNSAyLjc1QzcuMDE4NzggMi43NSA4LjI1IDMuOTgxMjIgOC4yNSA1LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIxLjI1IDE4LjVDMjEuMjUgMjAuMDE4OCAyMC4wMTg4IDIxLjI1IDE4LjUgMjEuMjVDMTYuOTgxMiAyMS4yNSAxNS43NSAyMC4wMTg4IDE1Ljc1IDE4LjVDMTUuNzUgMTYuOTgxMiAxNi45ODEyIDE1Ljc1IDE4LjUgMTUuNzVDMjAuMDE4OCAxNS43NSAyMS4yNSAxNi45ODEyIDIxLjI1IDE4LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTguMjUgMTguNUM4LjI1IDIwLjAxODggNy4wMTg3OCAyMS4yNSA1LjUgMjEuMjVDMy45ODEyMiAyMS4yNSAyLjc1IDIwLjAxODggMi43NSAxOC41QzIuNzUgMTYuOTgxMiAzLjk4MTIyIDE1Ljc1IDUuNSAxNS43NUM3LjAxODc4IDE1Ljc1IDguMjUgMTYuOTgxMiA4LjI1IDE4LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTUuNSA4LjI1VjE1Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE4LjUgMTUuNzVMMTguNSA4LjVDMTguNSA2Ljg0MzE1IDE3LjE1NjkgNS41IDE1LjUgNS41TDExLjc1IDUuNUgxMS4xNjQyTTEzLjI1IDhMMTEuNDU3MSA2LjIwNzExQzExLjI2MTggNi4wMTE4NCAxMS4xNjQyIDUuNzU1OTIgMTEuMTY0MiA1LjVNMTMuMjUgM0wxMS40NTcxIDQuNzkyODlDMTEuMjYxOCA0Ljk4ODE2IDExLjE2NDIgNS4yNDQwOCAxMS4xNjQyIDUuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.10.0
 */
declare const BranchPullRequestIcon: ProIcon;
export { BranchPullRequestIcon }
export { BranchPullRequestIcon as branchPullRequest }

/**
 * @description Suitcase, Work
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMTAuNUMzLjc1IDkuMTE5MjkgNC44NjkyOSA4IDYuMjUgOEgxNy43NUMxOS4xMzA3IDggMjAuMjUgOS4xMTkyOSAyMC4yNSAxMC41VjEzLjUyNDRWMTcuNUMyMC4yNSAxOC44ODA3IDE5LjEzMDcgMjAgMTcuNzUgMjBINi4yNUM0Ljg2OTI5IDIwIDMuNzUgMTguODgwNyAzLjc1IDE3LjVWMTMuNTI0NFYxMC41WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04LjYwMzAzIDUuNUM4LjYwMzAzIDQuNjcxNTcgOS4yNzQ2IDQgMTAuMTAzIDRIMTMuODk3MUMxNC43MjU2IDQgMTUuMzk3MSA0LjY3MTU3IDE1LjM5NzEgNS41VjhIOC42MDMwM1Y1LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const Briefcase2Icon: ProIcon;
export { Briefcase2Icon }
export { Briefcase2Icon as briefcase2 }

/**
 * @description Suitcase
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgOS44OTM5MkMzLjc1IDguNTEzMjEgNC44NjkyOSA3LjM5MzkyIDYuMjUgNy4zOTM5MkgxNy43NUMxOS4xMzA3IDcuMzkzOTIgMjAuMjUgOC41MTMyMSAyMC4yNSA5Ljg5MzkyVjEzLjE5NzNWMTcuNUMyMC4yNSAxOC44ODA3IDE5LjEzMDcgMjAgMTcuNzUgMjBINi4yNUM0Ljg2OTI5IDIwIDMuNzUgMTguODgwNyAzLjc1IDE3LjVWMTMuMTk3M1Y5Ljg5MzkyWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNy43NSA3LjM5MzkySDYuMjVDNC44NjkyOSA3LjM5MzkyIDMuNzUgOC41MTMyMSAzLjc1IDkuODkzOTJWMTAuMTk3M0MzLjc1IDExLjg1NDIgNS4wOTMxNSAxMy4xOTczIDYuNzUgMTMuMTk3M0gxNy4yNUMxOC45MDY5IDEzLjE5NzMgMjAuMjUgMTEuODU0MiAyMC4yNSAxMC4xOTczVjkuODkzOTJDMjAuMjUgOC41MTMyMSAxOS4xMzA3IDcuMzkzOTIgMTcuNzUgNy4zOTM5MloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC42MDI5MSA1LjVDOC42MDI5MSA0LjY3MTU3IDkuMjc0NDggNCAxMC4xMDI5IDRIMTMuODk3QzE0LjcyNTQgNCAxNS4zOTcgNC42NzE1NyAxNS4zOTcgNS41VjcuMzkzOTRIOC42MDI5MVY1LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BriefcaseIcon: ProIcon;
export { BriefcaseIcon }
export { BriefcaseIcon as briefcase }

/**
 * @description Weather Sunny
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iNC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8cGF0aCBkPSJNMTIgMi43NUwxMiA0LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTUuNDU5MjYgNS40NTkyM0w2LjUxOTkyIDYuNTE5ODkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgMTkuNzVMMTIgMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTcuNDgwMSAxNy40OEwxOC41NDA3IDE4LjU0MDYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAxMkw0LjI1IDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTUuNDU5MjYgMTguNTQwOEw2LjUxOTkyIDE3LjQ4MDEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTkuNzUgMTJMMjEuMjUgMTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTcuNDgwMSA2LjUyMDAyTDE4LjU0MDcgNS40NTkzNiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const BrightnessIcon: ProIcon;
export { BrightnessIcon }
export { BrightnessIcon as brightness }

/**
 * @description Sweep, Clean
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEzLjQ0MzcgMTcuNjI1N0wxNC4xNTA4IDE2LjkxODZDMTYuMTAzNCAxNC45NjYgMTYuMTAzNCAxMS44MDAxIDE0LjE1MDggOS44NDc1Mk0xMy40NDM3IDE3LjYyNTdMNi4zNzI2NSAxMC41NTQ2TTEzLjQ0MzcgMTcuNjI1N0wxMC42MTUzIDIxLjg2ODNMMi4xMyAxMy4zODMxTDYuMzcyNjUgMTAuNTU0Nk02LjM3MjY1IDEwLjU1NDZMNy4wNzk3NSA5Ljg0NzUyQzkuMDMyMzcgNy44OTQ5IDEyLjE5ODIgNy44OTQ5IDE0LjE1MDggOS44NDc1Mk0xNC4xNTA4IDkuODQ3NTJMMjAuODY4MyAzLjEzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const BroomIcon: ProIcon;
export { BroomIcon }
export { BroomIcon as broom }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const BugIcon: ProIcon;
export { BugIcon }
export { BugIcon as bug }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0Ljc1IDVDMTQuNzUgNC4xNzE1NyAxNC4wNzg0IDMuNSAxMy4yNSAzLjVIOS4yODg0NkM4LjczNjE4IDMuNSA4LjI4ODQ2IDMuOTQ3NzIgOC4yODg0NiA0LjVWNS41SDQuNzVDMy42NDU0MyA1LjUgMi43NSA2LjM5NTQzIDIuNzUgNy41VjE4LjVDMi43NSAxOS42MDQ2IDMuNjQ1NDMgMjAuNSA0Ljc1IDIwLjVIMTQuNzVWNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuNzUgOC41SDE5LjI1QzIwLjM1NDYgOC41IDIxLjI1IDkuMzk1NDMgMjEuMjUgMTAuNVYxOC41QzIxLjI1IDE5LjYwNDYgMjAuMzU0NiAyMC41IDE5LjI1IDIwLjVIMTQuNzVWOC41WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC43NSAxMi41SDE3LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE0Ljc1IDE2LjVIMTcuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSI2Ljc1IiBjeT0iOS41IiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjYuNzUiIGN5PSIxMyIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSI2Ljc1IiBjeT0iMTYuNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMC43NSIgY3k9IjkuNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMC43NSIgY3k9IjEzIiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEwLjc1IiBjeT0iMTYuNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const BuildingMultipleIcon: ProIcon;
export { BuildingMultipleIcon }
export { BuildingMultipleIcon as buildingMultiple }

/**
 * @description UI
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNi41IiB3aWR0aD0iMTguNSIgaGVpZ2h0PSIxMSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNyAxMkgxNyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ButtonIcon: ProIcon;
export { ButtonIcon }
export { ButtonIcon as button }

/**
 * @description Birthday, Party
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuMjUgMTMuMjVDNC4yNSAxMS44NjkzIDUuMzY5MjkgMTAuNzUgNi43NSAxMC43NUgxNy4yNUMxOC42MzA3IDEwLjc1IDE5Ljc1IDExLjg2OTMgMTkuNzUgMTMuMjVWMTZWMjEuMjVIMTJINC4yNVYxNlYxMy4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNC4yNSAxNC44N0w2LjQ5ODYyIDE2LjMyMDdDNy40ODg3OCAxNi45NTk1IDguNzYxMjIgMTYuOTU5NSA5Ljc1MTM4IDE2LjMyMDdMMTAuMzczNiAxNS45MTkzQzExLjM2MzggMTUuMjgwNSAxMi42MzYyIDE1LjI4MDUgMTMuNjI2NCAxNS45MTkzTDE0LjI0ODYgMTYuMzIwN0MxNS4yMzg4IDE2Ljk1OTUgMTYuNTExMiAxNi45NTk1IDE3LjUwMTQgMTYuMzIwN0wxOS43NSAxNC44NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMS4yNSAyMS4yNDVIMi43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMiAyLjc1TDEzLjQxNDIgNC4xNjQyMUMxNC4xOTUzIDQuOTQ1MjYgMTQuMTk1MyA2LjIxMTU5IDEzLjQxNDIgNi45OTI2NEMxMy4wMjM3IDcuMzgzMTYgMTIuNTExOCA3LjU3ODQzIDEyIDcuNTc4NDNDMTEuNDg4MiA3LjU3ODQzIDEwLjk3NjMgNy4zODMxNiAxMC41ODU4IDYuOTkyNjRDOS44MDQ3NCA2LjIxMTU5IDkuODA0NzQgNC45NDUyNiAxMC41ODU4IDQuMTY0MjFMMTIgMi43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgNy41ODAwMlYxMC43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CakeIcon: ProIcon;
export { CakeIcon }
export { CakeIcon as cake }

/**
 * @description Solve, Math
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNC43NSIgeT0iMi43NSIgd2lkdGg9IjE0LjUiIGhlaWdodD0iMTguNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSI4LjI1IiB5PSI2LjI1IiB3aWR0aD0iNy41IiBoZWlnaHQ9IjMuNzUiIHJ4PSIxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iOC41IiBjeT0iMTMuNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjEzLjUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTUuNSIgY3k9IjEzLjUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iOC41IiBjeT0iMTcuNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjE3LjUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTUuNSIgY3k9IjE3LjUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CalculatorIcon: ProIcon;
export { CalculatorIcon }
export { CalculatorIcon as calculator }

/**
 * @description Date
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3LjI1IDQuNzVINi43NDk5N0M0LjgxNjk3IDQuNzUgMy4yNDk5NyA2LjMxNyAzLjI0OTk3IDguMjVWMTcuNzVDMy4yNDk5NyAxOS42ODMgNC44MTY5NyAyMS4yNSA2Ljc0OTk3IDIxLjI1SDE3LjI1QzE5LjE4MyAyMS4yNSAyMC43NSAxOS42ODMgMjAuNzUgMTcuNzVWOC4yNUMyMC43NSA2LjMxNyAxOS4xODMgNC43NSAxNy4yNSA0Ljc1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0zLjI0OTk3IDkuMjVIMjAuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy4zNjEwNSA0Ljc1TDcuMzYxMDUgMi43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNi42MTExIDQuNzVMMTYuNjExMSAyLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CalendarIcon: ProIcon;
export { CalendarIcon }
export { CalendarIcon as calendar }

/**
 * @description Sketch
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjE1OTkgMi43NVYzLjc5ODUxQzE5LjE1OTkgNC45ODU1NSAxOS4xNTk5IDUuNTc5MDcgMTguOTI4OSA2LjAzMjQ2QzE4LjcyNTcgNi40MzEyNyAxOC40MDE0IDYuNzU1NTIgMTguMDAyNiA2Ljk1ODcyQzE3LjU0OTIgNy4xODk3NCAxNi45NTU3IDcuMTg5NzQgMTUuNzY4NyA3LjE4OTc0SDE1LjM0NjNNNC44NDAwOSAyLjc1VjMuNzk4NTFDNC44NDAwOSA0Ljk4NTU1IDQuODQwMDkgNS41NzkwNyA1LjA3MTEgNi4wMzI0NkM1LjI3NDMxIDYuNDMxMjcgNS41OTg1NSA2Ljc1NTUyIDUuOTk3MzYgNi45NTg3MkM2LjQ1MDc1IDcuMTg5NzQgNy4wNDQyNyA3LjE4OTc0IDguMjMxMzEgNy4xODk3NEg4LjY1MzY4TTguNjUzNjggNy4xODk3NEw2LjMxODcgMTEuNDcwNUM1Ljk1MTc0IDEyLjE0MzMgNS43NjgyNiAxMi40Nzk3IDUuNzA5NDkgMTIuODMyM0M1LjY1NzUyIDEzLjE0NDEgNS42NzU5NiAxMy40NjM2IDUuNzYzNDYgMTMuNzY3NEM1Ljg2MjQyIDE0LjExMSA2LjA4MzM5IDE0LjQyNCA2LjUyNTMyIDE1LjA1MDFMOS4yMjk0NiAxOC44ODA5QzEwLjE2MjUgMjAuMjAyNyAxMC42MjkgMjAuODYzNSAxMS4yMDkgMjEuMDk2OUMxMS43MTY2IDIxLjMwMSAxMi4yODM0IDIxLjMwMSAxMi43OTEgMjEuMDk2OUMxMy4zNzEgMjAuODYzNSAxMy44Mzc1IDIwLjIwMjcgMTQuNzcwNSAxOC44ODA5TDE3LjQ3NDYgMTUuMDUwMUMxNy45MTY2IDE0LjQyNCAxOC4xMzc1IDE0LjExMSAxOC4yMzY1IDEzLjc2NzRDMTguMzI0IDEzLjQ2MzYgMTguMzQyNCAxMy4xNDQxIDE4LjI5MDUgMTIuODMyM0MxOC4yMzE3IDEyLjQ3OTcgMTguMDQ4MiAxMi4xNDMzIDE3LjY4MTMgMTEuNDcwNUwxNS4zNDYzIDcuMTg5NzRNOC42NTM2OCA3LjE4OTc0SDE1LjM0NjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgMTMuMzI0NlYyMC44NDY5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iMTEuOTk5OSIgY3k9IjEzLjMyNDYiIHI9IjEuNjczMTUiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CalligraphyPenIcon: ProIcon;
export { CalligraphyPenIcon }
export { CalligraphyPenIcon as calligraphyPen }

/**
 * @description Photo, Picture, Photography, Shot, Shoot
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjg1NjkgMy4xODg5NkgxMS4xNDMxQzEwLjQ2MTcgMy4xODg5NiAxMC4xMjEgMy4xODg5NiA5LjgxMTc3IDMuMjgyODhDOS41MzggMy4zNjYwMiA5LjI4MzMgMy41MDIzMyA5LjA2MjI1IDMuNjg0MDFDOC44MTI1NyAzLjg4OTIzIDguNjIzNTggNC4xNzI3MSA4LjI0NTYyIDQuNzM5NjZMNy4xMDI5NCA2LjQ1MzY3QzUuNTc5MjcgNi40NTM2NyA0LjgxNzQzIDYuNDUzNjcgNC4yMzU0NyA2Ljc1MDJDMy43MjM1NiA3LjAxMTAzIDMuMzA3MzYgNy40MjcyMyAzLjA0NjUzIDcuOTM5MTRDMi43NSA4LjUyMTEgMi43NSA5LjI4Mjk0IDIuNzUgMTAuODA2NlYxNi40NTgyQzIuNzUgMTcuOTgxOSAyLjc1IDE4Ljc0MzcgMy4wNDY1MyAxOS4zMjU3QzMuMzA3MzYgMTkuODM3NiAzLjcyMzU2IDIwLjI1MzggNC4yMzU0NyAyMC41MTQ2QzQuODE3NDMgMjAuODExMiA1LjU3OTI3IDIwLjgxMTIgNy4xMDI5NCAyMC44MTEySDE2Ljg5NzFDMTguNDIwNyAyMC44MTEyIDE5LjE4MjYgMjAuODExMiAxOS43NjQ1IDIwLjUxNDZDMjAuMjc2NCAyMC4yNTM4IDIwLjY5MjYgMTkuODM3NiAyMC45NTM1IDE5LjMyNTdDMjEuMjUgMTguNzQzNyAyMS4yNSAxNy45ODE5IDIxLjI1IDE2LjQ1ODJWMTAuODA2NkMyMS4yNSA5LjI4Mjk0IDIxLjI1IDguNTIxMSAyMC45NTM1IDcuOTM5MTRDMjAuNjkyNiA3LjQyNzIzIDIwLjI3NjQgNy4wMTEwMyAxOS43NjQ1IDYuNzUwMkMxOS4xODI2IDYuNDUzNjcgMTguNDIwNyA2LjQ1MzY3IDE2Ljg5NzEgNi40NTM2N0wxNS43NTQ0IDQuNzM5NjZDMTUuMzc2NCA0LjE3MjcxIDE1LjE4NzQgMy44ODkyMyAxNC45Mzc3IDMuNjg0MDFDMTQuNzE2NyAzLjUwMjMzIDE0LjQ2MiAzLjM2NjAyIDE0LjE4ODIgMy4yODI4OEMxMy44NzkgMy4xODg5NiAxMy41MzgzIDMuMTg4OTYgMTIuODU2OSAzLjE4ODk2WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS43NzQ4IDEzLjIxMjNDMTUuNzc0OCAxNS4yOTcxIDE0LjA4NDggMTYuOTg3MSAxMiAxNi45ODcxQzkuOTE1MjIgMTYuOTg3MSA4LjIyNTE3IDE1LjI5NzEgOC4yMjUxNyAxMy4yMTIzQzguMjI1MTcgMTEuMTI3NSA5LjkxNTIyIDkuNDM3NSAxMiA5LjQzNzVDMTQuMDg0OCA5LjQzNzUgMTUuNzc0OCAxMS4xMjc1IDE1Ljc3NDggMTMuMjEyM1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const CameraIcon: ProIcon;
export { CameraIcon }
export { CameraIcon as camera }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGVsbGlwc2UgY3g9IjEyIiBjeT0iMTIiIHJ4PSI5LjI1IiByeT0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8cGF0aCBkPSJNOC44NzUgOC44NzVMMTUuMTI1IDE1LjEyNU0xNS4xMjUgOC44NzVMOC44NzUgMTUuMTI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CancelCircleIcon: ProIcon;
export { CancelCircleIcon }
export { CancelCircleIcon as cancelCircle }

/**
 * @description Dismiss, X, Close, Abort, Delete
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuOTk5OTQgMTlMMTEuOTk5OSAxMk0xMS45OTk5IDEyTDE5IDVNMTEuOTk5OSAxMkw0Ljk5OTk0IDVNMTEuOTk5OSAxMkwxOSAxOSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CancelIcon: ProIcon;
export { CancelIcon }
export { CancelIcon as CloseIcon }
export { CancelIcon as DismissIcon }
export { CancelIcon as XIcon }
export { CancelIcon as cancel }
export { CancelIcon as close }
export { CancelIcon as dismiss }
export { CancelIcon as x }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMjUgMy43NUM1Ljc2NDcyIDMuNzUgMy43NSA1Ljc2NDcyIDMuNzUgOC4yNVYxNS43NUMzLjc1IDE4LjIzNTMgNS43NjQ3MiAyMC4yNSA4LjI1IDIwLjI1SDE1Ljc1QzE4LjIzNTMgMjAuMjUgMjAuMjUgMTguMjM1MyAyMC4yNSAxNS43NVY4LjI1QzIwLjI1IDUuNzY0NzIgMTguMjM1MyAzLjc1IDE1Ljc1IDMuNzVIOC4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiLz4KPHBhdGggZD0iTTguNjU1NCA4LjY1NTRMMTUuMzQ0NiAxNS4zNDQ2TTE1LjM0NDYgOC42NTU0TDguNjU1NCAxNS4zNDQ2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CancelSquareIcon: ProIcon;
export { CancelSquareIcon }
export { CancelSquareIcon as cancelSquare }

/**
 * @description Skeleton, Emoji, Bones, Head, Spooky, Poison, Pirate, Kill, Blood, Death, Die
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMDE5NzEgNy41Mjk1TDcuNTI5NTUgOS4wMTk2NkM1LjQ3MjA2IDExLjA3NzEgNS40NzIwNiAxNC40MTMgNy41Mjk1NSAxNi40NzA1QzguMTQyMzMgMTcuMDgzMiA4Ljg2ODUyIDE3LjUxMzUgOS42NDA1NSAxNy43NjEzQzkuNzI4MzkgMTcuNzg5NSA5LjgxNjgxIDE3LjgxNTMgOS45MDU3MyAxNy44Mzg4QzExLjI3NDQgMTguMTk5OSAxMi43NiAxOC4wMDE0IDE0IDE3LjI0MzRNOS4wMTk3MSA3LjUyOTVDOS4yMTU3OCA3LjMzMzQyIDkuNDIzNDcgNy4xNTYwMyA5LjY0MDU1IDYuOTk3MzNNOS4wMTk3MSA3LjUyOTVMOS42NDA1NSA2Ljk5NzMzTTkuNjQwNTUgNi45OTczM0M5Ljc1Nzc1IDYuOTExNjUgOS44Nzc2OSA2LjgzMTQxIDEwIDYuNzU2NjNNMTAgMTcuODYyN1Y2Ljc1NjYzTTEwIDYuNzU2NjNDMTEuMjk4NyA1Ljk2MjY2IDEyLjg2NjggNS43ODI1MiAxNC4yODc3IDYuMjE2MThDMTUuMDg2NSA2LjQ1OTk3IDE1LjgzODggNi44OTc3NSAxNi40NzA1IDcuNTI5NUMxOC41MjggOS41ODY5OCAxOC41MjggMTIuOTIyOCAxNi40NzA1IDE0Ljk4MDNMMTQuOTgwMyAxNi40NzA1QzE0Ljc2MjcgMTYuNjg4MSAxNC41MzA5IDE2Ljg4MjYgMTQuMjg3NyAxNy4wNTQyQzE0LjE5MzQgMTcuMTIwNyAxNC4wOTc1IDE3LjE4MzggMTQgMTcuMjQzNE0xNCA2LjEzNzIzVjE3LjI0MzQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuNDcwNSA3LjUyOTUxQzE1LjIzNiA2LjI5NTAyIDE1LjIzNiA0LjI5MzUyIDE2LjQ3MDUgMy4wNTkwM0MxNi44Nzk0IDIuNjUwMSAxNy41NDcxIDIuNjQ1NDYgMTcuOTU2IDMuMDU0MzlMMjAuOTQ1NiA2LjA0Mzk5QzIxLjM1NDUgNi40NTI5MiAyMS4zNDk5IDcuMTIwNTggMjAuOTQxIDcuNTI5NTFDMTkuNzA2NSA4Ljc2NCAxNy43MDUgOC43NjQgMTYuNDcwNSA3LjUyOTUxWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03LjUyOTUxIDE2LjQ3MDVDNi4yOTUwMiAxNS4yMzYgNC4yOTM1MiAxNS4yMzYgMy4wNTkwMyAxNi40NzA1QzIuNjUwMSAxNi44Nzk0IDIuNjQ1NDYgMTcuNTQ3MSAzLjA1NDM5IDE3Ljk1Nkw2LjA0Mzk5IDIwLjk0NTZDNi40NTI5MiAyMS4zNTQ1IDcuMTIwNTggMjEuMzQ5OSA3LjUyOTUxIDIwLjk0MUM4Ljc2NCAxOS43MDY1IDguNzY0IDE3LjcwNSA3LjUyOTUxIDE2LjQ3MDVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.10.0
 */
declare const CandyIcon: ProIcon;
export { CandyIcon }
export { CandyIcon as candy }

/**
 * @description Shopping, Trolley, Amazon, Shopping Cart
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iOS41NDkwMiIgY3k9IjE5LjA0ODgiIHI9IjEuNzAxMTgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSIxNi45NjAxIiBjeT0iMTkuMDQ4OCIgcj0iMS43MDExOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik01LjYwNjQ0IDUuNTU0NTlMNy42MTYyNiAxMS45MTlDNy45MjUwMyAxMi44OTY4IDguMDc5NDEgMTMuMzg1NyA4LjM3NTMzIDEzLjc0NzdDOC42MzY2MSAxNC4wNjcyIDguOTc0ODUgMTQuMzE1MSA5LjM1ODI3IDE0LjQ2OEM5Ljc5MjU1IDE0LjY0MTIgMTAuMzA1MiAxNC42NDEyIDExLjMzMDYgMTQuNjQxMkgxNS4xODYxQzE2LjIxMTUgMTQuNjQxMiAxNi43MjQxIDE0LjY0MTIgMTcuMTU4NCAxNC40NjhDMTcuNTQxOCAxNC4zMTUxIDE3Ljg4MDEgMTQuMDY3MiAxOC4xNDEzIDEzLjc0NzdDMTguNDM3MyAxMy4zODU3IDE4LjU5MTcgMTIuODk2OCAxOC45MDA0IDExLjkxOTFMMTkuMzA5OCAxMC42MjI3QzE5LjM5NzEgMTAuMzQ2MSAxOS40Nzc1IDEwLjA5MTcgMTkuNTUgOS44NTY5MkwxOS44ODE0IDguODA3NDJDMjAuMzkwMiA3LjE5NjEyIDE5LjE4NzIgNS41NTQ1OSAxNy40OTc0IDUuNTU0NTlINS42MDY0NFpNNS42MDY0NCA1LjU1NDU5TDUuNTk0OTcgNS41MTgyN0M1LjUyNjY3IDUuMzAxOTYgNS40OTI1MSA1LjE5MzgxIDUuNDU0ODMgNS4wOTgzOUM1LjA0MTcxIDQuMDUyMTkgNC4wNjQ2MyAzLjMzNjEgMi45NDI1OSAzLjI1NzJDMi44NDAyNSAzLjI1IDIuNzI2ODMgMy4yNSAyLjUgMy4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CartIcon: ProIcon;
export { CartIcon }
export { CartIcon as cart }

export declare const categories: string[];

/**
 * @description Stats, Statistics, Data, Graph, Chart
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjI1IDIwLjI1TDIwLjI1IDMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy43NSAyMC4yNUwzLjc1IDMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB3aWR0aD0iNiIgaGVpZ2h0PSIxMyIgcng9IjIiIHRyYW5zZm9ybT0ibWF0cml4KC0xIC04Ljc0MjI4ZS0wOCAtOC43NDIyOGUtMDggMSAxNSA1LjUpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CenterHorizontalIcon: ProIcon;
export { CenterHorizontalIcon }
export { CenterHorizontalIcon as centerHorizontal }

/**
 * @description Stats, Statistics, Data, Graph, Chart
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMjAuMjVMMjAuMjUgMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy43NSAzLjc1TDIwLjI1IDMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB3aWR0aD0iNiIgaGVpZ2h0PSIxMyIgcng9IjIiIHRyYW5zZm9ybT0ibWF0cml4KDEuMzExMzRlLTA3IC0xIC0xIC0xLjMxMTM0ZS0wNyAxOC41IDE1KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CenterVerticalIcon: ProIcon;
export { CenterVerticalIcon }
export { CenterVerticalIcon as centerVertical }

/**
 * @description $, Money, Coin, Dollar, ¢
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjA4NDYgMy44NzVWNi4yOTIwNk0xMi4wODQ2IDIwLjM3NVYxNy45NTc5TTE2LjQ2NjkgMTYuMjUzNEMxNS42NTA0IDE3LjA2OTkgMTQuNjEgMTcuNjI2IDEzLjQ3NzUgMTcuODUxM0MxMy4wMTY3IDE3Ljk0MjkgMTIuNTQ5MSAxNy45NzgyIDEyLjA4NDYgMTcuOTU3OU0xNi40NjY5IDcuOTk2NThDMTUuNjUwNCA3LjE4MDA2IDE0LjYxIDYuNjI0IDEzLjQ3NzUgNi4zOTg3MkMxMy4wMTY3IDYuMzA3MDcgMTIuNTQ5MSA2LjI3MTg0IDEyLjA4NDYgNi4yOTIwNk0xMi4wODQ2IDE3Ljk1NzlDMTEuNDA3NCAxNy45Mjg1IDEwLjczNyAxNy43ODExIDEwLjEwNDIgMTcuNTE5QzkuMDM3MzQgMTcuMDc3MSA4LjEyNTUgMTYuMzI4OCA3LjQ4Mzk2IDE1LjM2ODdDNi44NDI0MiAxNC40MDg1IDYuNSAxMy4yNzk3IDYuNSAxMi4xMjVDNi41IDEwLjk3MDMgNi44NDI0MiA5Ljg0MTQ2IDcuNDgzOTYgOC44ODEzM0M4LjEyNTUgNy45MjEyIDkuMDM3MzQgNy4xNzI4NiAxMC4xMDQyIDYuNzMwOTdDMTAuNzM3IDYuNDY4ODUgMTEuNDA3NCA2LjMyMTUzIDEyLjA4NDYgNi4yOTIwNiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CentIcon: ProIcon;
export { CentIcon }
export { CentIcon as cent }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIxLjI1QzE3LjEwODYgMjEuMjUgMjEuMjUgMTcuMTA4NiAyMS4yNSAxMkMyMS4yNSA2Ljg5MTM3IDE3LjEwODYgMi43NSAxMiAyLjc1QzYuODkxMzcgMi43NSAyLjc1IDYuODkxMzcgMi43NSAxMkMyLjc1IDEzLjQ2MTggMy4wODkwOCAxNC44NDQ0IDMuNjkyODcgMTYuMDczNEMzLjgwMDU0IDE2LjI5MjYgMy44MzY2MSAxNi41NDE0IDMuNzgxNyAxNi43NzkzTDIuOTY1ODcgMjAuMzE0NkMyLjg2NjE2IDIwLjc0NjYgMy4yNTMzNyAyMS4xMzM4IDMuNjg1NDIgMjEuMDM0MUw3LjIyMDcgMjAuMjE4M0M3LjQ1ODY0IDIwLjE2MzQgNy43MDc0NSAyMC4xOTk1IDcuOTI2NjIgMjAuMzA3MUM5LjE1NTY0IDIwLjkxMDkgMTAuNTM4MiAyMS4yNSAxMiAyMS4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy45Njk2NCA5Ljg4NTcxSDE2LjAzMDQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy45Njk2NCAxNC4xMTQzSDEzLjcxNzkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ChatIcon: ProIcon;
export { ChatIcon }
export { ChatIcon as chat }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuNTExOCA5LjEwNjY5TDEwLjcyNTMgMTQuODkzMkw3LjQ4ODM5IDExLjY2MTMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.11.0
 */
declare const CheckboxCheckedIcon: ProIcon;
export { CheckboxCheckedIcon }
export { CheckboxCheckedIcon as CheckmarkCheckedIcon }
export { CheckboxCheckedIcon as checkboxChecked }
export { CheckboxCheckedIcon as checkmarkChecked }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iMi43NSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTguNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy4xMTI1IDYuMjVDNi42MzYxNSA2LjI1IDYuMjUgNi42MzYxNSA2LjI1IDcuMTEyNVYxNi44ODc1QzYuMjUgMTcuMzYzOCA2LjYzNjE1IDE3Ljc1IDcuMTEyNSAxNy43NUgxNi44ODc1QzE3LjM2MzggMTcuNzUgMTcuNzUgMTcuMzYzOCAxNy43NSAxNi44ODc1VjcuMTEyNUMxNy43NSA2LjYzNjE1IDE3LjM2MzggNi4yNSAxNi44ODc1IDYuMjVINy4xMTI1WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.11.0
 * @updated v4.11.0
 */
declare const CheckboxIndeterminate2Icon: ProIcon;
export { CheckboxIndeterminate2Icon }
export { CheckboxIndeterminate2Icon as CheckboxIntermediate2Icon }
export { CheckboxIndeterminate2Icon as checkboxIndeterminate2 }
export { CheckboxIndeterminate2Icon as checkboxIntermediate2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuMTg5NSAxMkg3LjgxMDU4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const CheckboxIndeterminateIcon: ProIcon;
export { CheckboxIndeterminateIcon }
export { CheckboxIndeterminateIcon as CheckmarkIntermediateIcon }
export { CheckboxIndeterminateIcon as checkboxIndeterminate }
export { CheckboxIndeterminateIcon as checkmarkIntermediate }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const CheckboxUncheckedIcon: ProIcon;
export { CheckboxUncheckedIcon }
export { CheckboxUncheckedIcon as checkboxUnchecked }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNi4zNzUxIDkuMTk0NDZMMTAuNzYzOSAxNC44MDU2TDcuNjI1MDYgMTEuNjcxNyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CheckmarkCircleIcon: ProIcon;
export { CheckmarkCircleIcon }
export { CheckmarkCircleIcon as checkmarkCircle }

/**
 * @description Done, Check, Completed
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5Ljc1IDcuMDE3ODZMMTAuNDkyOCAxNi4yNzVDMTAuMTAyMyAxNi42NjU2IDkuNDY5MTMgMTYuNjY1NiA5LjA3ODYxIDE2LjI3NUw0LjI1IDExLjQ0NjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const CheckmarkIcon: ProIcon;
export { CheckmarkIcon }
export { CheckmarkIcon as checkmark }

/**
 * @description Verified, Twitter Blue, Trusted, Safe, Legitimate, Real, X Premium
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMDcyMDUgNC4wNjg2OEM3LjUzNTAzIDIuOTgyOTYgOC43ODEyIDIuNDY2NzggOS44NzYyOSAyLjkwNzEyTDExLjE5MDggMy40MzU3MUMxMS43MTAxIDMuNjQ0NSAxMi4yODk5IDMuNjQ0NSAxMi44MDkyIDMuNDM1NzFMMTQuMTIzNyAyLjkwNzEyQzE1LjIxODggMi40NjY3OCAxNi40NjUgMi45ODI5NiAxNi45MjggNC4wNjg2N0wxNy40ODM3IDUuMzcxOTdDMTcuNzAzMiA1Ljg4Njc2IDE4LjExMzIgNi4yOTY3NyAxOC42MjggNi41MTYyOUwxOS45MzEzIDcuMDcyMDVDMjEuMDE3IDcuNTM1MDMgMjEuNTMzMiA4Ljc4MTIgMjEuMDkyOSA5Ljg3NjI5TDIwLjU2NDMgMTEuMTkwOEMyMC4zNTU1IDExLjcxMDEgMjAuMzU1NSAxMi4yODk5IDIwLjU2NDMgMTIuODA5MkwyMS4wOTI5IDE0LjEyMzdDMjEuNTMzMiAxNS4yMTg4IDIxLjAxNyAxNi40NjUgMTkuOTMxMyAxNi45MjhMMTguNjI4IDE3LjQ4MzdDMTguMTEzMiAxNy43MDMyIDE3LjcwMzIgMTguMTEzMiAxNy40ODM3IDE4LjYyOEwxNi45MjggMTkuOTMxM0MxNi40NjUgMjEuMDE3IDE1LjIxODggMjEuNTMzMiAxNC4xMjM3IDIxLjA5MjlMMTIuODA5MiAyMC41NjQzQzEyLjI4OTkgMjAuMzU1NSAxMS43MTAxIDIwLjM1NTUgMTEuMTkwOCAyMC41NjQzTDkuODc2MjkgMjEuMDkyOUM4Ljc4MTIgMjEuNTMzMiA3LjUzNTAzIDIxLjAxNyA3LjA3MjA1IDE5LjkzMTNMNi41MTYyOSAxOC42MjhDNi4yOTY3NyAxOC4xMTMyIDUuODg2NzYgMTcuNzAzMiA1LjM3MTk3IDE3LjQ4MzdMNC4wNjg2OCAxNi45MjhDMi45ODI5NiAxNi40NjUgMi40NjY3OCAxNS4yMTg4IDIuOTA3MTIgMTQuMTIzN0wzLjQzNTcxIDEyLjgwOTJDMy42NDQ1IDEyLjI4OTkgMy42NDQ1IDExLjcxMDEgMy40MzU3MSAxMS4xOTA4TDIuOTA3MTIgOS44NzYyOUMyLjQ2Njc4IDguNzgxMiAyLjk4Mjk2IDcuNTM1MDMgNC4wNjg2NyA3LjA3MjA1TDUuMzcxOTcgNi41MTYyOUM1Ljg4Njc2IDYuMjk2NzcgNi4yOTY3NyA1Ljg4Njc2IDYuNTE2MjkgNS4zNzE5N0w3LjA3MjA1IDQuMDY4NjhaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1Ljg5ODUgOS41TDEwLjg5ODUgMTQuNUw4LjEwMTU0IDExLjcwNzQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const CheckmarkStarburstIcon: ProIcon;
export { CheckmarkStarburstIcon }
export { CheckmarkStarburstIcon as checkmarkStarburst }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNzUgOS43NUwxMC45MzkzIDE1LjkzOTNDMTEuNTI1MSAxNi41MjUxIDEyLjQ3NDkgMTYuNTI1MSAxMy4wNjA3IDE1LjkzOTNMMTkuMjUgOS43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ChevronDownIcon: ProIcon;
export { ChevronDownIcon }
export { ChevronDownIcon as chevronDown }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjI1IDQuNzVMOC4wNjA2NiAxMC45MzkzQzcuNDc0ODcgMTEuNTI1MSA3LjQ3NDg3IDEyLjQ3NDkgOC4wNjA2NiAxMy4wNjA3TDE0LjI1IDE5LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ChevronLeftIcon: ProIcon;
export { ChevronLeftIcon }
export { ChevronLeftIcon as chevronLeft }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNzUgNC43NUwxNS45MzkzIDEwLjkzOTNDMTYuNTI1MSAxMS41MjUxIDE2LjUyNTEgMTIuNDc0OSAxNS45MzkzIDEzLjA2MDdMOS43NSAxOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ChevronRightIcon: ProIcon;
export { ChevronRightIcon }
export { ChevronRightIcon as chevronRight }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNzUgMTQuMjVMMTAuOTM5MyA4LjA2MDY2QzExLjUyNTEgNy40NzQ4NyAxMi40NzQ5IDcuNDc0ODcgMTMuMDYwNyA4LjA2MDY2TDE5LjI1IDE0LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ChevronUpIcon: ProIcon;
export { ChevronUpIcon }
export { ChevronUpIcon as chevronUp }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgOS4yNUMyLjc1IDcuMzE3IDQuMzE3IDUuNzUgNi4yNSA1Ljc1SDE0Ljc1QzE2LjY4MyA1Ljc1IDE4LjI1IDcuMzE3IDE4LjI1IDkuMjVWMTcuNzVDMTguMjUgMTkuNjgzIDE2LjY4MyAyMS4yNSAxNC43NSAyMS4yNUg2LjI1QzQuMzE3IDIxLjI1IDIuNzUgMTkuNjgzIDIuNzUgMTcuNzVWOS4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNi43NSAyLjc1SDE0LjI1SDE0Ljc1QzE4LjMzOTkgMi43NSAyMS4yNSA1LjY2MDE1IDIxLjI1IDkuMjVWOS43NVYxNy4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const ChromeRestoreIcon: ProIcon;
export { ChromeRestoreIcon }
export { ChromeRestoreIcon as ChromeRestoreVarIcon }
export { ChromeRestoreIcon as chromeRestore }
export { ChromeRestoreIcon as chromeRestoreVar }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CircleIcon: ProIcon;
export { CircleIcon }
export { CircleIcon as circle }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iMy4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CircleSmallIcon: ProIcon;
export { CircleSmallIcon }
export { CircleSmallIcon as circleSmall }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMi43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTguNSIgcng9IjMuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8cGF0aCBkPSJNOC4yNSAyLjc1SDE1Ljc1VjUuMjVDMTUuNzUgNi4zNTQ1NyAxNC44NTQ2IDcuMjUgMTMuNzUgNy4yNUgxMC4yNUM5LjE0NTQzIDcuMjUgOC4yNSA2LjM1NDU3IDguMjUgNS4yNVYyLjc1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.9.0
 */
declare const ClipboardIcon: ProIcon;
export { ClipboardIcon }
export { ClipboardIcon as clipboard }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNzUgMjEuMjVINi43NUM0LjgxNyAyMS4yNSAzLjI1IDE5LjY4MyAzLjI1IDE3Ljc1VjYuMjVDMy4yNSA0LjMxNyA0LjgxNyAyLjc1IDYuNzUgMi43NUgxNi4yNUMxOC4xODMgMi43NSAxOS43NSA0LjMxNyAxOS43NSA2LjI1VjguMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy43NSAyLjc1SDE1LjI1VjUuMjVDMTUuMjUgNi4zNTQ1NyAxNC4zNTQ2IDcuMjUgMTMuMjUgNy4yNUg5Ljc1QzguNjQ1NDMgNy4yNSA3Ljc1IDYuMzU0NTcgNy43NSA1LjI1VjIuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxwYXRoIGQ9Ik0xMi4yNSAxMy4yNUMxMi4yNSAxMS44NjkzIDEzLjM2OTMgMTAuNzUgMTQuNzUgMTAuNzVIMTguMjVDMTkuNjMwNyAxMC43NSAyMC43NSAxMS44NjkzIDIwLjc1IDEzLjI1VjE4Ljc1QzIwLjc1IDIwLjEzMDcgMTkuNjMwNyAyMS4yNSAxOC4yNSAyMS4yNUgxNC43NUMxMy4zNjkzIDIxLjI1IDEyLjI1IDIwLjEzMDcgMTIuMjUgMTguNzVWMTMuMjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.9.0
 */
declare const ClipboardPasteIcon: ProIcon;
export { ClipboardPasteIcon }
export { ClipboardPasteIcon as clipboardPaste }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjI1IDIxLjI1SDE3LjI1QzE5LjE4MyAyMS4yNSAyMC43NSAxOS42ODMgMjAuNzUgMTcuNzVWNi4yNUMyMC43NSA0LjMxNyAxOS4xODMgMi43NSAxNy4yNSAyLjc1SDcuNzVDNS44MTcgMi43NSA0LjI1IDQuMzE3IDQuMjUgNi4yNVYxMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik04Ljc1IDIuNzVIMTYuMjVWNS4yNUMxNi4yNSA2LjM1NDU3IDE1LjM1NDYgNy4yNSAxNC4yNSA3LjI1SDEwLjc1QzkuNjQ1NDMgNy4yNSA4Ljc1IDYuMzU0NTcgOC43NSA1LjI1VjIuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxwYXRoIGQ9Ik05LjE3MDIxIDE5LjY3MDJDMTAuNzUzMyAxOC4wODcxIDEwLjc1MzMgMTUuNTIwNCA5LjE3MDIxIDEzLjkzNzNDNy41ODcxMSAxMi4zNTQyIDUuMDIwNDEgMTIuMzU0MiAzLjQzNzMyIDEzLjkzNzNDMS44NTQyMyAxNS41MjA0IDEuODU0MjMgMTguMDg3MSAzLjQzNzMyIDE5LjY3MDJDNS4wMjA0MSAyMS4yNTMzIDcuNTg3MTEgMjEuMjUzMyA5LjE3MDIxIDE5LjY3MDJaTTkuMTcwMjEgMTkuNjcwMkwxMS43NSAyMi4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 * @updated v4.9.0
 */
declare const ClipboardSearchIcon: ProIcon;
export { ClipboardSearchIcon }
export { ClipboardSearchIcon as clipboardSearch }

/**
 * @description Analog, Time
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjI1IDEyQzIxLjI1IDE3LjEwODYgMTcuMTA4NiAyMS4yNSAxMiAyMS4yNUM2Ljg5MTM3IDIxLjI1IDIuNzUgMTcuMTA4NiAyLjc1IDEyQzIuNzUgNi44OTEzNyA2Ljg5MTM3IDIuNzUgMTIgMi43NUMxNy4xMDg2IDIuNzUgMjEuMjUgNi44OTEzNyAyMS4yNSAxMloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTEuMjUgNi43NVYxMi43NUgxNS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ClockIcon: ProIcon;
export { ClockIcon }
export { ClockIcon as clock }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC43NSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTQuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTAuNSAxNC4zODE2QzEwLjA4MTkgMTQuNjIyOSA5LjYwNzczIDE0Ljc1IDkuMTI1IDE0Ljc1QzguNjQyMjcgMTQuNzUgOC4xNjgwNSAxNC42MjI5IDcuNzUgMTQuMzgxNkM3LjMzMTk1IDE0LjE0MDIgNi45ODQ3OSAxMy43OTMxIDYuNzQzNDMgMTMuMzc1QzYuNTAyMDcgMTIuOTU2OSA2LjM3NSAxMi40ODI3IDYuMzc1IDEyQzYuMzc1IDExLjUxNzMgNi41MDIwNyAxMS4wNDMxIDYuNzQzNDMgMTAuNjI1QzYuOTg0NzkgMTAuMjA2OSA3LjMzMTk1IDkuODU5NzkgNy43NSA5LjYxODQzQzguMTY4MDUgOS4zNzcwNyA4LjY0MjI3IDkuMjUgOS4xMjUgOS4yNUM5LjYwNzczIDkuMjUgMTAuMDgxOSA5LjM3NzA3IDEwLjUgOS42MTg0MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNy42MjUgMTQuMzgxNkMxNy4yMDY5IDE0LjYyMjkgMTYuNzMyNyAxNC43NSAxNi4yNSAxNC43NUMxNS43NjczIDE0Ljc1IDE1LjI5MzEgMTQuNjIyOSAxNC44NzUgMTQuMzgxNkMxNC40NTY5IDE0LjE0MDIgMTQuMTA5OCAxMy43OTMxIDEzLjg2ODQgMTMuMzc1QzEzLjYyNzEgMTIuOTU2OSAxMy41IDEyLjQ4MjcgMTMuNSAxMkMxMy41IDExLjUxNzMgMTMuNjI3MSAxMS4wNDMxIDEzLjg2ODQgMTAuNjI1QzE0LjEwOTggMTAuMjA2OSAxNC40NTY5IDkuODU5NzkgMTQuODc1IDkuNjE4NDNDMTUuMjkzMSA5LjM3NzA3IDE1Ljc2NzMgOS4yNSAxNi4yNSA5LjI1QzE2LjczMjcgOS4yNSAxNy4yMDY5IDkuMzc3MDcgMTcuNjI1IDkuNjE4NDMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ClosedCaptionsIcon: ProIcon;
export { ClosedCaptionsIcon }
export { ClosedCaptionsIcon as closedCaptions }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTk2NTMgMTguNDk1NUw3LjIzNDE1IDE3Ljc0NjVDNy4yMTAyNiAxNy43NDUzIDcuMTg2MzMgMTcuNzQ1MiA3LjE2MjQzIDE3Ljc0NjNMNy4xOTY1MyAxOC40OTU1Wk03LjQzMTIgOS42NjU4NUw4LjE1ODk1IDkuODQ3MTlMNy40MzEyIDkuNjY1ODVaTTE4Ljc2NSAxMS42NDk0TDE4Ljk4MjEgMTAuOTMxNkwxOC43NjUgMTEuNjQ5NFpNMjIgMTVDMjIgMTMuMDgwMyAyMC43Mjc4IDExLjQ1OTcgMTguOTgyMSAxMC45MzE2TDE4LjU0NzggMTIuMzY3M0MxOS42NzgzIDEyLjcwOTMgMjAuNSAxMy43NTk3IDIwLjUgMTVIMjJaTTE3Ljc1IDE5LjI1QzIwLjA5NzIgMTkuMjUgMjIgMTcuMzQ3MiAyMiAxNUgyMC41QzIwLjUgMTYuNTE4OCAxOS4yNjg4IDE3Ljc1IDE3Ljc1IDE3Ljc1VjE5LjI1Wk03LjM3NSAxOS4yNUgxNy43NVYxNy43NUg3LjM3NVYxOS4yNVpNNy4xNTg5MiAxOS4yNDQ2QzcuMjMwNTUgMTkuMjQ4MiA3LjMwMjYgMTkuMjUgNy4zNzUgMTkuMjVWMTcuNzVDNy4zMjc3IDE3Ljc1IDcuMjgwNzQgMTcuNzQ4OCA3LjIzNDE1IDE3Ljc0NjVMNy4xNTg5MiAxOS4yNDQ2Wk03LjE2MjQzIDE3Ljc0NjNDNy4xMDg2NSAxNy43NDg4IDcuMDU0NSAxNy43NSA3IDE3Ljc1VjE5LjI1QzcuMDc3MjUgMTkuMjUgNy4xNTQxNCAxOS4yNDgyIDcuMjMwNjQgMTkuMjQ0OEw3LjE2MjQzIDE3Ljc0NjNaTTcgMTcuNzVDNS4wNjcgMTcuNzUgMy41IDE2LjE4MyAzLjUgMTQuMjVIMkMyIDE3LjAxMTQgNC4yMzg1OCAxOS4yNSA3IDE5LjI1VjE3Ljc1Wk0zLjUgMTQuMjVDMy41IDEyLjMxNyA1LjA2NyAxMC43NSA3IDEwLjc1VjkuMjVDNC4yMzg1OCA5LjI1IDIgMTEuNDg4NiAyIDE0LjI1SDMuNVpNMTIuNzY4MyA0Ljc1QzkuODM4MzIgNC43NSA3LjM4MDk3IDYuNzY1NDIgNi43MDM0NSA5LjQ4NDUyTDguMTU4OTUgOS44NDcxOUM4LjY3MzkgNy43ODA1MSAxMC41NDMzIDYuMjUgMTIuNzY4MyA2LjI1VjQuNzVaTTE5LjAxODMgMTFDMTkuMDE4MyA3LjU0ODIyIDE2LjIyMDEgNC43NSAxMi43NjgzIDQuNzVWNi4yNUMxNS4zOTE2IDYuMjUgMTcuNTE4MyA4LjM3NjY1IDE3LjUxODMgMTFIMTkuMDE4M1pNNyAxMC43NUM3LjUzOTQgMTAuNzUgOC4wMjUwMyAxMC4zODQ2IDguMTU4OTUgOS44NDcxOUw2LjcwMzQ1IDkuNDg0NTJDNi43Mzk1NCA5LjMzOTY2IDYuODY1MTkgOS4yNSA3IDkuMjVWMTAuNzVaTTE3LjUxODMgMTFDMTcuNTE4MyAxMS42NTQ5IDE3Ljk2OTUgMTIuMTkyNCAxOC41NDc4IDEyLjM2NzNMMTguOTgyMSAxMC45MzE2QzE4Ljk5MSAxMC45MzQzIDE4Ljk5NzEgMTAuOTM4OCAxOS4wMDIyIDEwLjk0NTNDMTkuMDA4IDEwLjk1MjggMTkuMDE4MyAxMC45NzE0IDE5LjAxODMgMTFIMTcuNTE4M1oiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const CloudIcon: ProIcon;
export { CloudIcon }
export { CloudIcon as cloud }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguNzUgNi41TDMuMjUgMTJMOC43NSAxNy41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjI1IDYuNUwyMC43NSAxMkwxNS4yNSAxNy41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CodeIcon: ProIcon;
export { CodeIcon }
export { CodeIcon as code }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNSAxMC42ODI0QzMuNSA5LjgwNjkyIDQuMjA5NjkgOS4wOTcyMyA1LjA4NTE0IDkuMDk3MjNIMTYuNTIwMUMxNy4zOTU2IDkuMDk3MjMgMTguMTA1MyA5LjgwNjkyIDE4LjEwNTMgMTAuNjgyNFYxMy45NDc0QzE4LjEwNTMgMTcuOTgwNSAxNC44MzU4IDIxLjI1IDEwLjgwMjYgMjEuMjVWMjEuMjVDNi43Njk1IDIxLjI1IDMuNSAxNy45ODA1IDMuNSAxMy45NDc0VjEwLjY4MjRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE4LjEwNTIgMTAuNTU1NUgxOS41Njk0QzIwLjkxMTggMTAuNTU1NSAyMiAxMS42NDM3IDIyIDEyLjk4NjFWMTIuOTg2MUMyMiAxNC4zMjg1IDIwLjkxMTggMTUuNDE2NyAxOS41Njk0IDE1LjQxNjdIMTguMTA1MiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02LjQyMTAyIDMuNzVMNi40MjEwMiA2LjE4MDU2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEwLjgwMjYgMy43NUwxMC44MDI2IDYuMTgwNTYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuMTg0MiAzLjc1TDE1LjE4NDIgNi4xODA1NiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CoffeeHotIcon: ProIcon;
export { CoffeeHotIcon }
export { CoffeeHotIcon as coffeeHot }

/**
 * @description House, Home Samsung
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMS4yNSIgY3k9IjEuMjUiIHI9IjEuMjUiIHRyYW5zZm9ybT0ibWF0cml4KC0xIDAgMCAxIDE2LjY1MzkgNi4wMzM1NykiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMS4yNSIgY3k9IjEuMjUiIHI9IjEuMjUiIHRyYW5zZm9ybT0ibWF0cml4KC0xIDAgMCAxIDEyLjE1NjIgNS4yMjEwNykiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMS4yNSIgY3k9IjEuMjUiIHI9IjEuMjUiIHRyYW5zZm9ybT0ibWF0cml4KC0xIDAgMCAxIDguNjUzOSA3LjkzOTgyKSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxLjI1IiBjeT0iMS4yNSIgcj0iMS4yNSIgdHJhbnNmb3JtPSJtYXRyaXgoLTEgMCAwIDEgNy42ODUxNSAxMi4xNTYyKSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxLjI1IiBjeT0iMS4yNSIgcj0iMS4yNSIgdHJhbnNmb3JtPSJtYXRyaXgoLTEgMCAwIDEgOS45MDM5IDE1Ljk0NzgpIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0yMS4yNSAxMkMyMS4yNSA2Ljg5MTM3IDE3LjEwODYgMi43NSAxMiAyLjc1QzYuODkxMzcgMi43NSAyLjc1IDYuODkxMzcgMi43NSAxMkMyLjc1IDE3LjEwODYgNi44OTEzNyAyMS4yNSAxMiAyMS4yNUMxMy4zMTc4IDIxLjI1IDE0LjIyNDMgMTkuOTcgMTQuMzI5IDE4LjY1NjRMMTQuNDQ2NCAxNy4xODM1QzE0LjU2MzcgMTUuNzEyOCAxNS43MzI5IDE0LjU0NTYgMTcuMjAzOCAxNC40MzA5TDE4Ljg1NSAxNC4zMDIyQzIwLjEzNDMgMTQuMjAyNSAyMS4yNSAxMy4yODMzIDIxLjI1IDEyWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ColorPaletteIcon: ProIcon;
export { ColorPaletteIcon }
export { ColorPaletteIcon as colorPalette }

/**
 * @description Message, Important
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTgzNDEgMTYuOTU4NEg3LjkzMzQxQzcuOTMzNDEgMTYuNTQ0MiA3LjU5NzYyIDE2LjIwODQgNy4xODM0MSAxNi4yMDg0VjE2Ljk1ODRaTTguMDIyMDEgMjEuMTE4Mkw4LjUyOTkxIDIxLjY3SDguNTI5OTFMOC4wMjIwMSAyMS4xMTgyWk0xMi41NDE3IDE2Ljk1ODRWMTYuMjA4NEMxMi4zNTM1IDE2LjIwODQgMTIuMTcyMyAxNi4yNzkxIDEyLjAzMzggMTYuNDA2NkwxMi41NDE3IDE2Ljk1ODRaTTMuODM5MzEgNi43NDk3QzMuODM5MzEgNC45NTQ3NyA1LjI5NDM4IDMuNDk5NjkgNy4wODkzMSAzLjQ5OTY5VjEuOTk5NjlDNC40NjU5NiAxLjk5OTY5IDIuMzM5MzEgNC4xMjYzNCAyLjMzOTMxIDYuNzQ5N0gzLjgzOTMxWk0zLjgzOTMxIDEyLjk1ODRWNi43NDk3SDIuMzM5MzFWMTIuOTU4NEgzLjgzOTMxWk03LjA4OTMxIDE2LjIwODRDNS4yOTQzOCAxNi4yMDg0IDMuODM5MzEgMTQuNzUzMyAzLjgzOTMxIDEyLjk1ODRIMi4zMzkzMUMyLjMzOTMxIDE1LjU4MTggNC40NjU5NiAxNy43MDg0IDcuMDg5MzEgMTcuNzA4NFYxNi4yMDg0Wk03LjE2MTA4IDE2LjIwODRINy4wODkzMVYxNy43MDg0SDcuMTYxMDhWMTYuMjA4NFpNNy4xODM0MSAxNi4yMDg0SDcuMTYxMDhWMTcuNzA4NEg3LjE4MzQxVjE2LjIwODRaTTcuOTMzNDEgMjAuNzUwM1YxNi45NTg0SDYuNDMzNDFWMjAuNzUwM0g3LjkzMzQxWk03LjUxNDExIDIwLjU2NjNDNy42NzQzNCAyMC40MTg5IDcuOTMzNDEgMjAuNTMyNSA3LjkzMzQxIDIwLjc1MDNINi40MzM0MUM2LjQzMzQxIDIxLjgzOTEgNy43Mjg3NiAyMi40MDc0IDguNTI5OTEgMjEuNjdMNy41MTQxMSAyMC41NjYzWk0xMi4wMzM4IDE2LjQwNjZMNy41MTQxMSAyMC41NjYzTDguNTI5OTEgMjEuNjdMMTMuMDQ5NiAxNy41MTAzTDEyLjAzMzggMTYuNDA2NlpNMTYuOTEwNyAxNi4yMDg0SDEyLjU0MTdWMTcuNzA4NEgxNi45MTA3VjE2LjIwODRaTTIwLjE2MDcgMTIuOTU4NEMyMC4xNjA3IDE0Ljc1MzMgMTguNzA1NiAxNi4yMDg0IDE2LjkxMDcgMTYuMjA4NFYxNy43MDg0QzE5LjUzNCAxNy43MDg0IDIxLjY2MDcgMTUuNTgxOCAyMS42NjA3IDEyLjk1ODRIMjAuMTYwN1pNMjAuMTYwNyA2Ljc0OTY5VjEyLjk1ODRIMjEuNjYwN1Y2Ljc0OTY5SDIwLjE2MDdaTTE2LjkxMDcgMy40OTk2OUMxOC43MDU2IDMuNDk5NjkgMjAuMTYwNyA0Ljk1NDc3IDIwLjE2MDcgNi43NDk2OUgyMS42NjA3QzIxLjY2MDcgNC4xMjYzNCAxOS41MzQgMS45OTk2OSAxNi45MTA3IDEuOTk5NjlWMy40OTk2OVpNNy4wODkzMSAzLjQ5OTY5SDE2LjkxMDdWMS45OTk2OUg3LjA4OTMxVjMuNDk5NjlaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0xMiA2LjI1TDEyIDEwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMy4yNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.11.0
 */
declare const CommentExclamationIcon: ProIcon;
export { CommentExclamationIcon }
export { CommentExclamationIcon as commentExclamation }

/**
 * @description Message
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTgzNDEgMTYuOTU4NEg3LjkzMzQxQzcuOTMzNDEgMTYuNTQ0MiA3LjU5NzYyIDE2LjIwODQgNy4xODM0MSAxNi4yMDg0VjE2Ljk1ODRaTTguMDIyMDEgMjEuMTE4Mkw4LjUyOTkxIDIxLjY3SDguNTI5OTFMOC4wMjIwMSAyMS4xMTgyWk0xMi41NDE3IDE2Ljk1ODRWMTYuMjA4NEMxMi4zNTM1IDE2LjIwODQgMTIuMTcyMyAxNi4yNzkxIDEyLjAzMzggMTYuNDA2NkwxMi41NDE3IDE2Ljk1ODRaTTMuODM5MzEgNi43NDk3QzMuODM5MzEgNC45NTQ3NyA1LjI5NDM4IDMuNDk5NjkgNy4wODkzMSAzLjQ5OTY5VjEuOTk5NjlDNC40NjU5NiAxLjk5OTY5IDIuMzM5MzEgNC4xMjYzNCAyLjMzOTMxIDYuNzQ5N0gzLjgzOTMxWk0zLjgzOTMxIDEyLjk1ODRWNi43NDk3SDIuMzM5MzFWMTIuOTU4NEgzLjgzOTMxWk03LjA4OTMxIDE2LjIwODRDNS4yOTQzOCAxNi4yMDg0IDMuODM5MzEgMTQuNzUzMyAzLjgzOTMxIDEyLjk1ODRIMi4zMzkzMUMyLjMzOTMxIDE1LjU4MTggNC40NjU5NiAxNy43MDg0IDcuMDg5MzEgMTcuNzA4NFYxNi4yMDg0Wk03LjE2MTA4IDE2LjIwODRINy4wODkzMVYxNy43MDg0SDcuMTYxMDhWMTYuMjA4NFpNNy4xODM0MSAxNi4yMDg0SDcuMTYxMDhWMTcuNzA4NEg3LjE4MzQxVjE2LjIwODRaTTcuOTMzNDEgMjAuNzUwM1YxNi45NTg0SDYuNDMzNDFWMjAuNzUwM0g3LjkzMzQxWk03LjUxNDExIDIwLjU2NjNDNy42NzQzNCAyMC40MTg5IDcuOTMzNDEgMjAuNTMyNSA3LjkzMzQxIDIwLjc1MDNINi40MzM0MUM2LjQzMzQxIDIxLjgzOTEgNy43Mjg3NiAyMi40MDc0IDguNTI5OTEgMjEuNjdMNy41MTQxMSAyMC41NjYzWk0xMi4wMzM4IDE2LjQwNjZMNy41MTQxMSAyMC41NjYzTDguNTI5OTEgMjEuNjdMMTMuMDQ5NiAxNy41MTAzTDEyLjAzMzggMTYuNDA2NlpNMTYuOTEwNyAxNi4yMDg0SDEyLjU0MTdWMTcuNzA4NEgxNi45MTA3VjE2LjIwODRaTTIwLjE2MDcgMTIuOTU4NEMyMC4xNjA3IDE0Ljc1MzMgMTguNzA1NiAxNi4yMDg0IDE2LjkxMDcgMTYuMjA4NFYxNy43MDg0QzE5LjUzNCAxNy43MDg0IDIxLjY2MDcgMTUuNTgxOCAyMS42NjA3IDEyLjk1ODRIMjAuMTYwN1pNMjAuMTYwNyA2Ljc0OTY5VjEyLjk1ODRIMjEuNjYwN1Y2Ljc0OTY5SDIwLjE2MDdaTTE2LjkxMDcgMy40OTk2OUMxOC43MDU2IDMuNDk5NjkgMjAuMTYwNyA0Ljk1NDc3IDIwLjE2MDcgNi43NDk2OUgyMS42NjA3QzIxLjY2MDcgNC4xMjYzNCAxOS41MzQgMS45OTk2OSAxNi45MTA3IDEuOTk5NjlWMy40OTk2OVpNNy4wODkzMSAzLjQ5OTY5SDE2LjkxMDdWMS45OTk2OUg3LjA4OTMxVjMuNDk5NjlaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const CommentIcon: ProIcon;
export { CommentIcon }
export { CommentIcon as comment }

/**
 * @description Message, Conversation
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const CommentMultipleIcon: ProIcon;
export { CommentMultipleIcon }
export { CommentMultipleIcon as CommentMultipleVarIcon }
export { CommentMultipleIcon as commentMultiple }
export { CommentMultipleIcon as commentMultipleVar }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4Ljc1IDguNzVDMjAuMTMwNyA4Ljc1IDIxLjI1IDkuODY5MjkgMjEuMjUgMTEuMjVWMTcuNzVDMjEuMjUgMTkuMTMwNyAyMC4xMzA3IDIwLjI1IDE4Ljc1IDIwLjI1SDUuMjVDMy44NjkyOSAyMC4yNSAyLjc1IDE5LjEzMDcgMi43NSAxNy43NVYxMS4yNUMyLjc1IDkuODY5MjkgMy44NjkyOSA4Ljc1IDUuMjUgOC43NUgxOC43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuMjUgMTYuMjVMMTYuMjUgMTguNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuMjUgMTAuNzVMMTYuMjUgMTMuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC4yNSAzLjc1TDEwLjc1IDMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuNzUgMy43NUwxNC4yNSAzLjc1QzE1LjM1NDYgMy43NSAxNi4yNSA0LjY0NTQzIDE2LjI1IDUuNzVWNi4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik01LjI1IDMuNzVINC43NUMzLjY0NTQzIDMuNzUgMi43NSA0LjY0NTQzIDIuNzUgNS43NVY2LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CompareSizeIcon: ProIcon;
export { CompareSizeIcon }
export { CompareSizeIcon as compareSize }

/**
 * @description Direction, Explore, Safari
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMC4xOTQ5IDEwLjE5NDlDMTAuMzQxOSAxMC4wNDc5IDEwLjUwMDkgOS45MTI3NSAxMC42NzAyIDkuNzkwOTVDMTEuMDUyNCA5LjUxNjE0IDExLjUwNDkgOS4zMzUxMSAxMi40MTAxIDguOTczMDZMMTQuNzY2NyA4LjAzMDQxQzE1LjM5ODUgNy43Nzc2NyAxNS43MTQ1IDcuNjUxMzEgMTUuOTE0OCA3LjcxNzQ4QzE2LjA4ODcgNy43NzQ5MyAxNi4yMjUyIDcuOTExMzcgMTYuMjgyNiA4LjA4NTI5QzE2LjM0ODggOC4yODU2MyAxNi4yMjI0IDguNjAxNTQgMTUuOTY5NyA5LjIzMzM4TDE1LjAyNyAxMS41OUMxNC42NjUgMTIuNDk1MSAxNC40ODM5IDEyLjk0NzcgMTQuMjA5MSAxMy4zMjk5QzE0LjA4NzMgMTMuNDk5MiAxMy45NTIyIDEzLjY1ODIgMTMuODA1MSAxMy44MDUyTTEwLjE5NDkgMTAuMTk0OUMxMC4wNDc4IDEwLjM0MiA5LjkxMjY5IDEwLjUwMDkgOS43OTA4OSAxMC42NzAzQzkuNTE2MDggMTEuMDUyNCA5LjMzNTA1IDExLjUwNSA4Ljk3MyAxMi40MTAxTDguMDMwMzUgMTQuNzY2OEM3Ljc3NzYxIDE1LjM5ODYgNy42NTEyNSAxNS43MTQ1IDcuNzE3NDIgMTUuOTE0OUM3Ljc3NDg3IDE2LjA4ODggNy45MTEzIDE2LjIyNTIgOC4wODUyMyAxNi4yODI3QzguMjg1NTcgMTYuMzQ4OCA4LjYwMTQ4IDE2LjIyMjUgOS4yMzMzMiAxNS45Njk3TDExLjU5IDE1LjAyNzFDMTIuNDk1MSAxNC42NjUgMTIuOTQ3NiAxNC40ODQgMTMuMzI5OCAxNC4yMDkyQzEzLjQ5OTIgMTQuMDg3NCAxMy42NTgxIDEzLjk1MjIgMTMuODA1MSAxMy44MDUyTTEwLjE5NDkgMTAuMTk0OUwxMy44MDUxIDEzLjgwNTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const CompassIcon: ProIcon;
export { CompassIcon }
export { CompassIcon as compass }

/**
 * @description Symbol, Figma, Sketch, Icon, Asset
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNy45OTAzMSIgeT0iMTcuODYwNCIgd2lkdGg9IjUuNjcwNTUiIGhlaWdodD0iNS42NzA1NSIgcng9IjEuNSIgdHJhbnNmb3JtPSJyb3RhdGUoLTQ1IDcuOTkwMzEgMTcuODYwNCkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIxMy44NTA2IiB5PSIxMiIgd2lkdGg9IjUuNjcwNTUiIGhlaWdodD0iNS42NzA1NSIgcng9IjEuNSIgdHJhbnNmb3JtPSJyb3RhdGUoLTQ1IDEzLjg1MDYgMTIpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMi4xMyIgeT0iMTIiIHdpZHRoPSI1LjY3MDU1IiBoZWlnaHQ9IjUuNjcwNTUiIHJ4PSIxLjUiIHRyYW5zZm9ybT0icm90YXRlKC00NSAyLjEzIDEyKSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjcuOTkwMzEiIHk9IjYuMTM5NjUiIHdpZHRoPSI1LjY3MDU1IiBoZWlnaHQ9IjUuNjcwNTUiIHJ4PSIxLjUiIHRyYW5zZm9ybT0icm90YXRlKC00NSA3Ljk5MDMxIDYuMTM5NjUpIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ComponentIcon: ProIcon;
export { ComponentIcon }
export { ComponentIcon as component }

/**
 * @description Mail, Write
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjM3MSA0LjI1SDguMjVDNS40ODg1OCA0LjI1IDMuMjUgNi40ODg1OCAzLjI1IDkuMjVWMTUuNzVDMy4yNSAxOC41MTE0IDUuNDg4NTggMjAuNzUgOC4yNSAyMC43NUgxNC43NUMxNy41MTE0IDIwLjc1IDE5Ljc1IDE4LjUxMTQgMTkuNzUgMTUuNzVWMTMuNjI5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyLjI5ODYgMTQuNzVDMTIuNzkyNSAxNC43NSAxMy4yNjYxIDE0LjU1MzggMTMuNjE1NCAxNC4yMDQ2TDIwLjIwNDYgNy42MTUzNkMyMC45MzE4IDYuODg4MTIgMjAuOTMxOCA1LjcwOTAzIDIwLjIwNDYgNC45ODE3OUwxOS4wMTgyIDMuNzk1NDNDMTguMjkxIDMuMDY4MTkgMTcuMTExOSAzLjA2ODE5IDE2LjM4NDYgMy43OTU0M0w5Ljc5NTQzIDEwLjM4NDZDOS40NDYyIDEwLjczMzkgOS4yNSAxMS4yMDc1IDkuMjUgMTEuNzAxNFYxNC43NUgxMi4yOTg2WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ComposeIcon: ProIcon;
export { ComposeIcon }
export { ComposeIcon as compose }

/**
 * @description All-in-one, AIO, Desktop, PC
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iMi43NSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTUuMDMxMiIgcng9IjMuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik05LjEwOTM4IDE3Ljc4MTJWMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuODkwNiAxNy43ODEyVjIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTYuNTA3ODEgMjEuMjVIMTcuNDkyMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ComputerIcon: ProIcon;
export { ComputerIcon }
export { ComputerIcon as computer }

/**
 * @description iMac, All-in-one, AIO, Desktop, Apple, Mac
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNi4yNUMyLjc1IDQuMzE3IDQuMzE3IDIuNzUgNi4yNSAyLjc1SDE3Ljc1QzE5LjY4MyAyLjc1IDIxLjI1IDQuMzE3IDIxLjI1IDYuMjVWMTQuMjgxM0MyMS4yNSAxNi4yMTQyIDE5LjY4MyAxNy43ODEyIDE3Ljc1IDE3Ljc4MTJINi4yNUM0LjMxNyAxNy43ODEyIDIuNzUgMTYuMjE0MiAyLjc1IDE0LjI4MTNWNi4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAxNEgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik05LjEwOTM4IDE3Ljc4MTJWMTkuMjVDOS4xMDkzOCAyMC4zNTQ2IDguMjEzOTUgMjEuMjUgNy4xMDkzOCAyMS4yNUg2LjUxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE0Ljg5MDYgMTcuNzgxMlYxOS4yNUMxNC44OTA2IDIwLjM1NDYgMTUuNzg2MSAyMS4yNSAxNi44OTA2IDIxLjI1SDE3LjQ5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTYuNTA3ODEgMjEuMjVIMTcuNDkyMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ComputerMacIcon: ProIcon;
export { ComputerMacIcon }
export { ComputerMacIcon as computerMac }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIwLjI1SDE2LjI1QzE4LjQ1OTEgMjAuMjUgMjAuMjUgMTguNDU5MSAyMC4yNSAxNi4yNVYxMy43NU0xMiAyMC4yNUg3Ljc1QzUuNTQwODYgMjAuMjUgMy43NSAxOC40NTkxIDMuNzUgMTYuMjVWMTJNMTIgMjAuMjVWMTVDMTIgMTMuMzQzMSAxMC42NTY5IDEyIDkgMTJIMy43NU0zLjc1IDEyVjcuNzVDMy43NSA1LjU0MDg2IDUuNTQwODYgMy43NSA3Ljc1IDMuNzVIMTAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuMjUgMTAuMjVIMTQuNzVDMTQuNDczOSAxMC4yNSAxNC4yMjM5IDEwLjEzODEgMTQuMDQyOSA5Ljk1NzExTTEzLjc1IDMuNzVWOS4yNUMxMy43NSA5LjUyNjE0IDEzLjg2MTkgOS43NzYxNCAxNC4wNDI5IDkuOTU3MTFNMjAuMjUgMy43NUwxNC43NSA5LjI1TDE0LjA0MjkgOS45NTcxMSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ContractDownIcon: ProIcon;
export { ContractDownIcon }
export { ContractDownIcon as contractDown }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3LjA3NiAxMC41MzUyQzE4LjE0OTkgMTEuNjA5MiAxOS44OTExIDExLjYwOTIgMjAuOTY1MSAxMC41MzUyVjEwLjUzNTJDMjEuMDkyOSAxMC40MDc0IDIxLjMyNzcgMTAuNDU4NyAyMS4zNTkgMTAuNjM2N0MyMS44NjUgMTMuNTA4MSAyMS4wMDg5IDE2LjU3MjYgMTguNzkwNyAxOC43OTA3QzE1LjE3ODQgMjIuNDAzMSA5LjMyMTYxIDIyLjQwMzEgNS43MDkyNiAxOC43OTA3QzIuMDk2OTEgMTUuMTc4NCAyLjA5NjkxIDkuMzIxNjEgNS43MDkyNiA1LjcwOTI2QzcuOTI3NDIgMy40OTExIDEwLjk5MTkgMi42MzUgMTMuODYzMyAzLjE0MDk2QzE0LjA0MTIgMy4xNzIzMiAxNC4wOTI1IDMuNDA3MSAxMy45NjQ3IDMuNTM0OVYzLjUzNDlDMTIuODkwOCA0LjYwODg0IDEyLjg5MDggNi4zNTAwNSAxMy45NjQ3IDcuNDIzOTlDMTQuNjAwOCA4LjA2MDA4IDE1LjQ3MSA4LjMxOTQyIDE2LjI5OCA4LjIwMTk5QzE2LjE4MDYgOS4wMjg5NyAxNi40Mzk5IDkuODk5MTUgMTcuMDc2IDEwLjUzNTJaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iOC41IiBjeT0iMTUuNSIgcj0iMS4yNSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSI3LjUiIGN5PSI5LjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTIuNSIgY3k9IjEyLjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTUuNSIgY3k9IjE2LjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CookiesIcon: ProIcon;
export { CookiesIcon }
export { CookiesIcon as cookies }

/**
 * @description Clipboard
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2Ljc1IDUuNzVDMTYuNzUgNC4wOTMxNSAxNS40MDY5IDIuNzUgMTMuNzUgMi43NUg3LjI1QzUuNTkzMTUgMi43NSA0LjI1IDQuMDkzMTUgNC4yNSA1Ljc1VjE1LjI1QzQuMjUgMTYuOTA2OSA1LjU5MzE1IDE4LjI1IDcuMjUgMTguMjVIMTMuNzVDMTUuNDA2OSAxOC4yNSAxNi43NSAxNi45MDY5IDE2Ljc1IDE1LjI1VjUuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE5Ljc1IDYuNzVWMTUuMjVDMTkuNzUgMTguNTYzNyAxNy4wNjM3IDIxLjI1IDEzLjc1IDIxLjI1SDguMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const CopyIcon: ProIcon;
export { CopyIcon }
export { CopyIcon as CopyVarIcon }
export { CopyIcon as copy }
export { CopyIcon as copyVar }

/**
 * @description Legal, Rights, License
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik05LjE3MTU3IDE0LjgyODRDOS43MzA5OCAxNS4zODc4IDEwLjQ0MzcgMTUuNzY4OCAxMS4yMTk2IDE1LjkyMzFDMTEuOTk1NiAxNi4wNzc1IDEyLjc5OTggMTUuOTk4MyAxMy41MzA3IDE1LjY5NTVDMTQuMjYxNiAxNS4zOTI4IDE0Ljg4NjQgMTQuODgwMSAxNS4zMjU5IDE0LjIyMjNDMTUuNzY1NCAxMy41NjQ1IDE2IDEyLjc5MTEgMTYgMTJDMTYgMTEuMjA4OSAxNS43NjU0IDEwLjQzNTUgMTUuMzI1OSA5Ljc3NzcyQzE0Ljg4NjQgOS4xMTk5MiAxNC4yNjE2IDguNjA3MjMgMTMuNTMwNyA4LjMwNDQ4QzEyLjc5OTggOC4wMDE3MyAxMS45OTU2IDcuOTIyNTIgMTEuMjE5NiA4LjA3Njg2QzEwLjQ0MzcgOC4yMzEyIDkuNzMwOTggOC42MTIxNiA5LjE3MTU3IDkuMTcxNTciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.11.0
 */
declare const CopyleftIcon: ProIcon;
export { CopyleftIcon }
export { CopyleftIcon as copyleft }

/**
 * @description Legal, Rights, License, Protection
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC44Mjg0IDE0LjgyODRDMTQuMjY5IDE1LjM4NzggMTMuNTU2MyAxNS43Njg4IDEyLjc4MDQgMTUuOTIzMUMxMi4wMDQ0IDE2LjA3NzUgMTEuMjAwMiAxNS45OTgzIDEwLjQ2OTMgMTUuNjk1NUM5LjczODM2IDE1LjM5MjggOS4xMTM2NSAxNC44ODAxIDguNjc0MTIgMTQuMjIyM0M4LjIzNDYgMTMuNTY0NSA4IDEyLjc5MTEgOCAxMkM4IDExLjIwODkgOC4yMzQ2IDEwLjQzNTUgOC42NzQxMiA5Ljc3NzcyQzkuMTEzNjUgOS4xMTk5MiA5LjczODM2IDguNjA3MjMgMTAuNDY5MyA4LjMwNDQ4QzExLjIwMDIgOC4wMDE3MyAxMi4wMDQ0IDcuOTIyNTIgMTIuNzgwNCA4LjA3Njg2QzEzLjU1NjMgOC4yMzEyIDE0LjI2OSA4LjYxMjE2IDE0LjgyODQgOS4xNzE1NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const CopyrightIcon: ProIcon;
export { CopyrightIcon }
export { CopyrightIcon as copyright }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjI1IDQuNzVIMTEuNzVDNy44ODQwMSA0Ljc1IDQuNzUgNy44ODQwMSA0Ljc1IDExLjc1VjE5LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CornerRadiusIcon: ProIcon;
export { CornerRadiusIcon }
export { CornerRadiusIcon as cornerRadius }

/**
 * @description Debit Card, Payment
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTQiIHJ4PSIzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgOS41SDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxwYXRoIGQ9Ik0xNC43NSAxNC4yNUgxNy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CreditCardIcon: ProIcon;
export { CreditCardIcon }
export { CreditCardIcon as creditCard }

/**
 * @description Edit, Photo, Image, Picture
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjI1IDE3LjY1MjhIOS4zNDcyMkM3LjY5MDM3IDE3LjY1MjggNi4zNDcyMiAxNi4zMDk2IDYuMzQ3MjIgMTQuNjUyOFYyLjc1TTIuNzUgNi4zNDcyMkg2LjM0NzIyTTE3LjY1MjggMTcuNjUyOFYyMS4yNU04LjkxNjY3IDYuMzQ3MjJIMTQuNjUyOEMxNi4zMDk2IDYuMzQ3MjIgMTcuNjUyOCA3LjY5MDM3IDE3LjY1MjggOS4zNDcyMlYxNS4wODMzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CropIcon: ProIcon;
export { CropIcon }
export { CropIcon as crop }

/**
 * @description CSS3, Stylesheet, Programming, Web
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjc1NDEgNC43OTIwOEwxNy45MTMyIDE5LjEwMjVDMTcuODAwOSAxOS42Njg0IDE3LjM3MzkgMjAuMTE5NyAxNi44MTUxIDIwLjI2MzNMMTIuMzczMiAyMS40MDQyQzEyLjEyODQgMjEuNDY3IDExLjg3MTYgMjEuNDY3IDExLjYyNjggMjEuNDA0Mkw3LjE4NDkzIDIwLjI2MzNDNi42MjYxMSAyMC4xMTk3IDYuMTk5MTUgMTkuNjY4NCA2LjA4NjggMTkuMTAyNUwzLjI0NTkgNC43OTIwOEMzLjA2MTc1IDMuODY0NDggMy43NzE0OSAzIDQuNzE3MTkgM0gxMkgxOS4yODI4QzIwLjIyODUgMyAyMC45MzgzIDMuODY0NDggMjAuNzU0MSA0Ljc5MjA4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03Ljc2OTU5IDYuODgwOThIMTcuMjk5OUw4LjY2OTUyIDEyLjQ1OEgxNC44OTQ2QzE1LjUyOTQgMTIuNDU4IDE2LjAwMzYgMTMuMDQxOSAxNS44NzMzIDEzLjY2MzNMMTUuMzEwNSAxNi4zNDU3QzE1LjIzODMgMTYuNjkwMSAxNC45OTAzIDE2Ljk3MTIgMTQuNjU3NSAxNy4wODU5TDEyLjM3NTEgMTcuODcyMUMxMi4xNjA5IDE3Ljk0NTkgMTEuOTI4IDE3Ljk0NDggMTEuNzE0NiAxNy44Njg5TDguOTkwOTMgMTYuOTAxMSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const CssIcon: ProIcon;
export { CssIcon }
export { CssIcon as css }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjM5NDEgMjAuNzMzNkMxMS42MzczIDIxLjcxODkgMTAuMDYyMyAyMS4yMDUxIDEwLjAzMjIgMTkuOTYzTDkuNzkzMDIgMTAuMTAyNUM5Ljc2NzczIDkuMDYwMDIgMTAuOTA2MSA4LjQwMjc2IDExLjc5NjMgOC45NDU5TDIwLjIxNjIgMTQuMDgzM0MyMS4yNzY4IDE0LjczMDQgMjAuOTM0MyAxNi4zNTEzIDE5LjcwMjYgMTYuNTE0MUwxNS43MTU5IDE3LjA0MDlDMTUuMzcgMTcuMDg2NiAxNS4wNTYzIDE3LjI2NzcgMTQuODQzNyAxNy41NDQ1TDEyLjM5NDEgMjAuNzMzNloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTMuNzk2NzUgOC43NTA4NUw2LjI5Njc0IDguNzUwODUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTAuMDQ2OCA1LjI0NzU2TDEwLjA0NjggMi43NDc1NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02LjgxNDUxIDUuNzY1MjZMNS4wNDY3NiAzLjk5NzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuMjc4NyA1Ljc2NTI2TDE1LjA0NjUgMy45OTc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CursorClickIcon: ProIcon;
export { CursorClickIcon }
export { CursorClickIcon as cursorClick }

/**
 * @description Grab, Hand, Drop, Grabber
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMzE0OTYgMTEuMDU0N0w3LjMxNDk4IDE1LjIzMTNNMTAuNTYxMSA4LjYzODE5VjYuNTU0ODdDMTAuNTYxMSA1LjY2MzA0IDkuODM0NDMgNC45NDAwNyA4LjkzODAyIDQuOTQwMDdDOC4wNDE2MSA0Ljk0MDA3IDcuMzE0OTIgNS42NjMwNCA3LjMxNDkyIDYuNTU0ODdMNy4zMTQ5MiAxMC4zMDIxTTEwLjU2MTEgOS43MzU2NEwxMC41NjExIDQuMzY0OEMxMC41NjExIDMuNDcyOTcgMTEuMjg3OCAyLjc1IDEyLjE4NDIgMi43NUMxMy4wODA2IDIuNzUgMTMuODA3MyAzLjQ3Mjk3IDEzLjgwNzMgNC4zNjQ4TDEzLjgwNzMgOS43MzEzMk0xMy44MDc0IDkuNzM1NjNMMTMuODA3MyA2LjU1NDg3QzEzLjgwNzMgNS42NjMwNCAxNC41MzQgNC45MzQyMiAxNS40MzA0IDQuOTM0MjJDMTYuMzI2OSA0LjkzNDIyIDE3LjA1MzUgNS42NjMwNCAxNy4wNTM1IDYuNTU0ODdMMTcuMDUzNSA4Ljc0NDk0TTE3LjA1MzUgOC43NDQ5NFY5LjczNTYzTTE3LjA1MzUgOC43NDQ5NEMxNy4wNTM1IDcuODUzMTEgMTcuNzgwMiA3LjEzMDE0IDE4LjY3NjYgNy4xMzAxNEMxOS41NzMxIDcuMTMwMTQgMjAuMjk5NyA3Ljg1MzExIDIwLjI5OTcgOC43NDQ5NEwyMC4yOTk4IDE0LjY3OThDMjAuMjk5OCAxOC4zMDg0IDE3LjM1ODIgMjEuMjUgMTMuNzI5NiAyMS4yNUgxMC43ODFDOC45MjM0MyAyMS4yNSA3LjE0MDIxIDIwLjUyIDUuODE1ODMgMTkuMjE3NEM0LjM2MDM2IDE3Ljc4NTkgMy41OTM1NyAxNS43OTU4IDMuNzEyMTcgMTMuNzU3OEwzLjcyNzA3IDEzLjUwMThDMy44MDA3NSAxMi4yMzU3IDQuNjQ4MTYgMTEuMTQ2NCA1Ljg1NzI1IDEwLjc2MzZMNy4zMTQ5MiAxMC4zMDIxTTcuMzE0OTIgMTAuMzAyMVYxMS4zOTkzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CursorDragIcon: ProIcon;
export { CursorDragIcon }
export { CursorDragIcon as cursorDrag }

/**
 * @description Cursor, Mouse, Pointer
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMDg0MzUgMjAuMjc1OEM3LjAyNDggMjEuNjU1MyA0LjgxOTgyIDIwLjkzNTkgNC43Nzc2NCAxOS4xOTdMNC40NDI3OCA1LjM5MjMzQzQuNDA3MzggMy45MzI4MyA2LjAwMTE2IDMuMDEyNjYgNy4yNDc0MiAzLjc3MzA3TDE5LjAzNTIgMTAuOTY1NEMyMC41MiAxMS44NzE0IDIwLjA0MDUgMTQuMTQwNiAxOC4zMTYxIDE0LjM2ODVMMTIuNzM0OSAxNS4xMDYxQzEyLjI1MDUgMTUuMTcwMSAxMS44MTEzIDE1LjQyMzYgMTEuNTEzNyAxNS44MTExTDguMDg0MzUgMjAuMjc1OFoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const CursorIcon: ProIcon;
export { CursorIcon }
export { CursorIcon as cursor }

/**
 * @description Scissors
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguNjUxMjkgMTQuNDI5M0M2Ljk1NDc3IDEzLjI0MTQgNC42MTY0OCAxMy42NTM3IDMuNDI4NTYgMTUuMzUwMkMyLjI0MDY1IDE3LjA0NjcgMi42NTI5NSAxOS4zODUgNC4zNDk0NyAyMC41NzI5QzYuMDQ1OTkgMjEuNzYwOCA4LjM4NDI5IDIxLjM0ODUgOS41NzIyIDE5LjY1MkMxMC43NjAxIDE3Ljk1NTUgMTAuMzQ3OCAxNS42MTcyIDguNjUxMjkgMTQuNDI5M1pNOC42NTEyOSAxNC40MjkzTDEyLjAwMDEgOS45ODM2Nk0xNy40NTAxIDIuNzQ4NThMMTMuNjMxNiA3LjgxNzcyTTE1LjM0ODggMTQuNDI5M0MxNy4wNDUzIDEzLjI0MTQgMTkuMzgzNiAxMy42NTM3IDIwLjU3MTYgMTUuMzUwMkMyMS43NTk1IDE3LjA0NjcgMjEuMzQ3MiAxOS4zODUgMTkuNjUwNyAyMC41NzI5QzE3Ljk1NDEgMjEuNzYwOCAxNS42MTU4IDIxLjM0ODUgMTQuNDI3OSAxOS42NTJDMTMuMjQgMTcuOTU1NSAxMy42NTIzIDE1LjYxNzIgMTUuMzQ4OCAxNC40MjkzWk0xNS4zNDg4IDE0LjQyOTNMMTIuMDAwMSA5Ljk4MzY2TTYuNTUwMDYgMi43NDg1OEwxMi4wMDAxIDkuOTgzNjYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const CutIcon: ProIcon;
export { CutIcon }
export { CutIcon as cut }

/**
 * @description Appearance
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMTJDMi43NSAxNy4xMDg2IDYuODkxMzcgMjEuMjUgMTIgMjEuMjVWMi43NUM2Ljg5MTM3IDIuNzUgMi43NSA2Ljg5MTM3IDIuNzUgMTJaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0xMiAyMS4yNUMxNy4xMDg2IDIxLjI1IDIxLjI1IDE3LjEwODYgMjEuMjUgMTJDMjEuMjUgNi44OTEzNyAxNy4xMDg2IDIuNzUgMTIgMi43NU0xMiAyMS4yNUM2Ljg5MTM3IDIxLjI1IDIuNzUgMTcuMTA4NiAyLjc1IDEyQzIuNzUgNi44OTEzNyA2Ljg5MTM3IDIuNzUgMTIgMi43NU0xMiAyMS4yNVYyLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const DarkThemeIcon: ProIcon;
export { DarkThemeIcon }
export { DarkThemeIcon as darkTheme }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjI1IDYuMjVDMTkuMjUgOC4xODMgMTYuMDA0MSA5Ljc1IDEyIDkuNzVDNy45OTU5NCA5Ljc1IDQuNzUgOC4xODMgNC43NSA2LjI1TTE5LjI1IDYuMjVDMTkuMjUgNC4zMTcgMTYuMDA0MSAyLjc1IDEyIDIuNzVDNy45OTU5NCAyLjc1IDQuNzUgNC4zMTcgNC43NSA2LjI1TTE5LjI1IDYuMjVWOS43OE00Ljc1IDYuMjVWMTJNNC43NSAxMlYxNy43NUM0Ljc1IDE5LjUwNTggNy40MjgxNyAyMC45NTk3IDEwLjkyIDIxLjIxMTRNNC43NSAxMkM0Ljc1IDEzLjU3NjkgNi45MTAyMyAxNC45MTAzIDkuODggMTUuMzQ4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNy41IDIzQzIwLjUzNzYgMjMgMjMgMjAuNTM3NiAyMyAxNy41QzIzIDE1LjA3NDIgMjEuNDI5NiAxMy4wMTUzIDE5LjI1IDEyLjI4NDNDMTguNzAwMyAxMi4wOTk5IDE4LjExMTggMTIgMTcuNSAxMkMxNS4xNjk4IDEyIDEzLjE3OCAxMy40NDkxIDEyLjM3NjggMTUuNDk1NEMxMi4xMzM1IDE2LjExNjUgMTIgMTYuNzkyNyAxMiAxNy41QzEyIDE4LjkxNjcgMTIuNTM1NiAyMC4yMDgzIDEzLjQxNTQgMjEuMTgzM0MxNC40MjIgMjIuMjk4OSAxNS44NzkxIDIzIDE3LjUgMjNaTTE3LjUgMTQuMDA2NkMxNy43NzYyIDE0LjAwNjYgMTggMTQuMjMwNCAxOCAxNC41MDY2VjE3LjAwMDFIMjAuNDkzNEMyMC43Njk2IDE3LjAwMDEgMjAuOTkzNCAxNy4yMjM5IDIwLjk5MzQgMTcuNTAwMUMyMC45OTM0IDE3Ljc3NjIgMjAuNzY5NiAxOC4wMDAxIDIwLjQ5MzQgMTguMDAwMUgxOFYyMC40OTM0QzE4IDIwLjc2OTYgMTcuNzc2MiAyMC45OTM0IDE3LjUgMjAuOTkzNEMxNy4yMjM5IDIwLjk5MzQgMTcgMjAuNzY5NiAxNyAyMC40OTM0VjE4LjAwMDFIMTQuNTA2NkMxNC4yMzA0IDE4LjAwMDEgMTQuMDA2NiAxNy43NzYyIDE0LjAwNjYgMTcuNTAwMUMxNC4wMDY2IDE3LjIyMzkgMTQuMjMwNCAxNy4wMDAxIDE0LjUwNjYgMTcuMDAwMUgxN1YxNC41MDY2QzE3IDE0LjIzMDQgMTcuMjIzOSAxNC4wMDY2IDE3LjUgMTQuMDA2NloiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const DatabaseAddIcon: ProIcon;
export { DatabaseAddIcon }
export { DatabaseAddIcon as databaseAdd }

/**
 * @description SQL, MongoDB
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjI1IDYuMjVDMTkuMjUgOC4xODMgMTYuMDA0MSA5Ljc1IDEyIDkuNzVDNy45OTU5NCA5Ljc1IDQuNzUgOC4xODMgNC43NSA2LjI1TTE5LjI1IDYuMjVDMTkuMjUgNC4zMTcgMTYuMDA0MSAyLjc1IDEyIDIuNzVDNy45OTU5NCAyLjc1IDQuNzUgNC4zMTcgNC43NSA2LjI1TTE5LjI1IDYuMjVWMTJNNC43NSA2LjI1VjEyTTQuNzUgMTJWMTcuNzVDNC43NSAxOS42ODMgNy45OTU5NCAyMS4yNSAxMiAyMS4yNUMxNi4wMDQxIDIxLjI1IDE5LjI1IDE5LjY4MyAxOS4yNSAxNy43NVYxMk00Ljc1IDEyQzQuNzUgMTMuOTMzIDcuOTk1OTQgMTUuNSAxMiAxNS41QzE2LjAwNDEgMTUuNSAxOS4yNSAxMy45MzMgMTkuMjUgMTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const DatabaseIcon: ProIcon;
export { DatabaseIcon }
export { DatabaseIcon as database }

/**
 * @description Trash, Remove
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNjg2NTIgNi4yMTMwNUw2LjgwMDY4IDE4Ljk3NjNDNy4wMDA1NCAyMC4xODI5IDguMDQ0MDMgMjEuMDY3NyA5LjI2NzA3IDIxLjA2NzdIMTIuNjE1MU0xOS4zMTM0IDYuMjEzMDVMMTcuMTk5MiAxOC45NzYzQzE2Ljk5OTQgMjAuMTgyOSAxNS45NTU5IDIxLjA2NzcgMTQuNzMyOCAyMS4wNjc3SDExLjM4NDgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTAuMDIyNCAxMS4xMTYxTDEwLjAyMjQgMTYuMTY0OCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMy45Nzc2IDExLjExNjFMMTMuOTc3NiAxNi4xNjQ4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgNi4yMTMwN0gyMS4yNU0xNC43NzczIDYuMjEzMDdWNC40MzIyOEMxNC43NzczIDMuNjAzODUgMTQuMTA1NyAyLjkzMjI4IDEzLjI3NzMgMi45MzIyOEgxMC43MjI3QzkuODk0MyAyLjkzMjI4IDkuMjIyNzIgMy42MDM4NSA5LjIyMjcyIDQuNDMyMjhWNi4yMTMwN0gxNC43NzczWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const DeleteIcon: ProIcon;
export { DeleteIcon }
export { DeleteIcon as delete }

/**
 * @description Premium, Pro
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNjg5MTcgOS45MTQ4TDE2LjMxMDkgOS45MTQ4TTcuNjg5MTcgOS45MTQ4SDIuNzVNNy42ODkxNyA5LjkxNDhMMTEuMzQwMyAxOS45NjYyTTcuNjg5MTcgOS45MTQ4TDEwLjA4OTQgNS45ODE2NkwxMC42NDA2IDQuOTY5OTdNMTYuMzEwOSA5LjkxNDhMMjEuMjUgOS45MTQ4TTE2LjMxMDkgOS45MTQ4TDEyLjY1OTggMTkuOTY2MU0xNi4zMTA5IDkuOTE0OEwxMy45MTA3IDUuOTgxNjZMMTMuMzQzOCA0Ljk2OTk3TTIuNzUgOS45MTQ4QzIuNzUgMTAuMzM0NSAyLjgyODcxIDEwLjc1NDIgMi45ODYxNCAxMS4xNTEzQzMuMTk4MTUgMTEuNjg2MSAzLjYyNzY3IDEyLjE3ODggNC40ODY3MiAxMy4xNjQyTDcuOTUzMTYgMTcuMTQwNEM5LjM0OTg0IDE4Ljc0MjUgMTAuMDQ4MiAxOS41NDM1IDEwLjg3NjIgMTkuODM3OUMxMS4wMjg0IDE5Ljg5MTkgMTEuMTgzNSAxOS45MzQ3IDExLjM0MDMgMTkuOTY2Mk0yLjc1IDkuOTE0OEMyLjc1IDkuNDk1MTIgMi44Mjg3MSA5LjA3NTQzIDIuOTg2MTQgOC42NzgyOUMzLjE5ODE1IDguMTQzNDUgMy42Mjc2NyA3LjY1MDc2IDQuNDg2NzIgNi42NjUzOEM0Ljk1MjU2IDYuMTMxMDQgNS4xODU0OCA1Ljg2Mzg3IDUuNDU2MTMgNS42NTc0NEM1Ljg1NzQ4IDUuMzUxMzIgNi4zMjI3MyA1LjEzOTcgNi44MTcyMSA1LjAzODMzQzcuMTUwNjcgNC45Njk5NyA3LjUwNTExIDQuOTY5OTcgOC4yMTQgNC45Njk5N0gxMC42NDA2TTIxLjI1IDkuOTE0OEMyMS4yNSAxMC4zMzQ1IDIxLjE3MTMgMTAuNzU0MiAyMS4wMTM5IDExLjE1MTNDMjAuODAxOSAxMS42ODYxIDIwLjM3MjMgMTIuMTc4OCAxOS41MTMzIDEzLjE2NDJMMTYuMDQ2OCAxNy4xNDA0QzE0LjY1MDIgMTguNzQyNSAxMy45NTE4IDE5LjU0MzUgMTMuMTIzOCAxOS44Mzc5QzEyLjk3MTcgMTkuODkxOSAxMi44MTY2IDE5LjkzNDcgMTIuNjU5OCAxOS45NjYxTTIxLjI1IDkuOTE0OEMyMS4yNSA5LjQ5NTEyIDIxLjE3MTMgOS4wNzU0MyAyMS4wMTM5IDguNjc4MjlDMjAuODAxOSA4LjE0MzQ1IDIwLjM3MjMgNy42NTA3NiAxOS41MTMzIDYuNjY1MzhDMTkuMDQ3NCA2LjEzMTA0IDE4LjgxNDUgNS44NjM4NyAxOC41NDM5IDUuNjU3NDRDMTguMTQyNSA1LjM1MTMyIDE3LjY3NzMgNS4xMzk3IDE3LjE4MjggNS4wMzgzM0MxNi44NDkzIDQuOTY5OTcgMTYuNDk0OSA0Ljk2OTk3IDE1Ljc4NiA0Ljk2OTk3SDEzLjM0MzhNMTIuNjU5OCAxOS45NjYxQzEyLjIyNDMgMjAuMDUzNSAxMS43NzU4IDIwLjA1MzUgMTEuMzQwMyAxOS45NjYyTTEzLjM0MzggNC45Njk5N0gxMC42NDA2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const DiamondIcon: ProIcon;
export { DiamondIcon }
export { DiamondIcon as diamond }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNTA2NjUgMTQuMDA2N0MyLjM5ODQxIDEyLjg5ODQgMi4zOTg0MSAxMS4xMDE2IDMuNTA2NjUgOS45OTMzNUw5Ljk5MzM1IDMuNTA2NjVDMTEuMTAxNiAyLjM5ODQxIDEyLjg5ODQgMi4zOTg0MSAxNC4wMDY3IDMuNTA2NjVMMjAuNDkzMyA5Ljk5MzM1QzIxLjYwMTYgMTEuMTAxNiAyMS42MDE2IDEyLjg5ODQgMjAuNDkzMyAxNC4wMDY3TDE0LjAwNjcgMjAuNDkzM0MxMi44OTg0IDIxLjYwMTYgMTEuMTAxNiAyMS42MDE2IDkuOTkzMzUgMjAuNDkzM0wzLjUwNjY1IDE0LjAwNjdaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE0LjQ1OTEgOS4wMjAwMkwxNS44NTQgMTAuNDE0OUMxNi4wNDkzIDEwLjYxMDIgMTYuMTQ2OSAxMC44NjYxIDE2LjE0NjkgMTEuMTIyMU0xNC40NTkxIDEzLjIyNDFMMTUuODU0IDExLjgyOTFDMTYuMDQ5MiAxMS42MzM5IDE2LjE0NjkgMTEuMzc4IDE2LjE0NjkgMTEuMTIyMU04LjY4NzUgMTUuMTUzM1YxMi42MjIxQzguNjg3NSAxMS43OTM2IDkuMzU5MDcgMTEuMTIyMSAxMC4xODc1IDExLjEyMjFIMTUuNTEwMUgxNi4xNDY5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const DirectionsIcon: ProIcon;
export { DirectionsIcon }
export { DirectionsIcon as directions }

/**
 * @description Docs
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNC41MDAwMSIgeT0iMi43NSIgd2lkdGg9IjE1IiBoZWlnaHQ9IjE4LjUiIHJ4PSIzLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC41MDAwMSA2Ljc1NDY0SDE1LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC41MDAwMSAxMC43NTQ2SDE1LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC41MDAwMSAxNC43NTQ2SDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const DocumentIcon: ProIcon;
export { DocumentIcon }
export { DocumentIcon as document }

/**
 * @description $, Money, Cash, Bill, Currency
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjA5ODggOS43MjMxNEMxNS4wOTg4IDkuNzIzMTQgMTQuNzIyNCA3LjkzOTk1IDEyLjA5OCA3Ljc0NTg1TTkuMTQxMzEgMTQuODU0M0M5LjE0MTMxIDE0Ljg1NDMgOS45MDIxNyAxNi42NTQgMTIuMDk4IDE2Ljc2NThNMTIuMDk4IDZWNy43NDU4NU0xMi4wOTggMTguNVYxNi43NjU4TTEyLjA5OCA3Ljc0NTg1QzExLjk0NjkgNy43MzQ2NyAxMS43ODg0IDcuNzI4NzcgMTEuNjIyMSA3LjcyODc3QzEwLjQ4MTUgNy43Mjg3NyA5IDguNjc4MzEgOSAxMC4wMDQzQzkgMTEuMzMwMyAxMC4wNzM1IDExLjg1MDEgMTEuOTY0OSAxMi4xNzI2QzEzLjg1NjMgMTIuNDk1IDE1LjE5NTkgMTMuMjA3NyAxNS4xOTU5IDE0LjY3QzE1LjE5NTkgMTYuMTMyMyAxMy42Mjg3IDE2Ljc3MTIgMTIuMzEzNiAxNi43NzEyQzEyLjI0MDIgMTYuNzcxMiAxMi4xNjg0IDE2Ljc2OTQgMTIuMDk4IDE2Ljc2NTgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSIxMi4yNSIgY3k9IjEyLjI1IiByPSI5LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const DollarCircleIcon: ProIcon;
export { DollarCircleIcon }
export { DollarCircleIcon as dollarCircle }

/**
 * @description $, Money, Cash, Bill, Currency
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjQ0MTMgOC4yNjAyNUMxNi40NDEzIDguMjYwMjUgMTUuODg0MSA1LjYyMTEyIDEyIDUuMzMzODVNNy42MjQxMyAxNS44NTQ0QzcuNjI0MTMgMTUuODU0NCA4Ljc1MDIgMTguNTE3OSAxMiAxOC42ODM0TTEyIDIuNzVWNS4zMzM4NU0xMiAyMS4yNVYxOC42ODM0TTEyIDUuMzMzODVDMTEuNzc2NCA1LjMxNzMyIDExLjU0MTggNS4zMDg1NyAxMS4yOTU3IDUuMzA4NTdDOS42MDc1NyA1LjMwODU3IDcuNDE0OTkgNi43MTM5IDcuNDE0OTkgOC42NzYzNEM3LjQxNDk5IDEwLjYzODggOS4wMDM4MyAxMS40MDgxIDExLjgwMyAxMS44ODU0QzE0LjYwMjMgMTIuMzYyNyAxNi41ODUgMTMuNDE3NCAxNi41ODUgMTUuNTgxNkMxNi41ODUgMTcuNzQ1NyAxNC4yNjU0IDE4LjY5MTQgMTIuMzE5MSAxOC42OTE0QzEyLjIxMDUgMTguNjkxNCAxMi4xMDQyIDE4LjY4ODcgMTIgMTguNjgzNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const DollarIcon: ProIcon;
export { DollarIcon }
export { DollarIcon as dollar }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGVsbGlwc2UgY3g9IjEyIiBjeT0iMTIiIHJ4PSI5LjI1IiByeT0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8cGF0aCBkPSJNNy41IDEySDE2LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const DoNotDisturbIcon: ProIcon;
export { DoNotDisturbIcon }
export { DoNotDisturbIcon as doNotDisturb }

/**
 * @description Closed
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuMjUgNi4yNUM1LjI1IDQuODY5MjkgNi4zNjkyOSAzLjc1IDcuNzUgMy43NUgxNi4yNUMxNy42MzA3IDMuNzUgMTguNzUgNC44NjkyOSAxOC43NSA2LjI1VjIxLjI1SDUuMjVWNi4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAyMS4yNUgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjE1LjI1IiBjeT0iMTIuNSIgcj0iMS41IiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.10.0
 */
declare const DoorIcon: ProIcon;
export { DoorIcon }
export { DoorIcon as door }

/**
 * @description Configure, Spanner, Options, Mechanism, Mechanic
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjE1NzQgMjAuNTE3SDE2Ljc1QzE4LjEzMDcgMjAuNTE3IDE5LjI1IDE5LjM5NzcgMTkuMjUgMTguMDE3VjUuNzVDMTkuMjUgNC4zNjkyOSAxOC4xMzA3IDMuMjUgMTYuNzUgMy4yNUg3LjI1QzYuNjk5MDYgMy4yNSA2LjE4OTc0IDMuNDI4MjIgNS43NzY1NSAzLjczMDE1TTQuNzU2MjMgMTcuNDcyMUM0Ljc1NjIzIDE4LjA1MzIgNS4wOTE4IDE4LjU4MiA1LjYxNzU0IDE4LjgyOTRMMTEuNTEyNyAyMS42MDM2QzEyLjUwNzUgMjIuMDcxNyAxMy42NTE0IDIxLjM0NTggMTMuNjUxNCAyMC4yNDYzVjE0LjMxNzFWOC4zODc4NkMxMy42NTE0IDcuODA2ODEgMTMuMzE1OCA3LjI3ODAzIDEyLjc5MDEgNy4wMzA2M0w1Ljc3NjU1IDMuNzMwMTVNNS43NzY1NSAzLjczMDE1QzUuMTU0MjUgNC4xODQ4OCA0Ljc1IDQuOTIwMjMgNC43NSA1Ljc1VjkuMzk4MTFWMTcuNDcyMSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxlbGxpcHNlIGN4PSIxMC4yNSIgY3k9IjEyLjc1IiByeD0iMS4yNSIgcnk9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.10.0
 */
declare const DoorOpenIcon: ProIcon;
export { DoorOpenIcon }
export { DoorOpenIcon as doorOpen }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuNzE4NzUgMTYuMjVMNy42MzgzOSAxMS44NDY0TTcuNjM4MzkgMTEuODQ2NEgxNC41NDkxTTcuNjM4MzkgMTEuODQ2NEwxMC41Nzk4IDUuMDk4NzhDMTAuNzgyNSA0LjYzMzc0IDExLjQwNSA0LjYzMzc0IDExLjYwNzcgNS4wOTg3OEwxNC41NDkxIDExLjg0NjRNMTQuNTQ5MSAxMS44NDY0TDE0Ljg4NjQgMTIuNjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuNjc5NyAyMC45MzU5QzE2LjE0MTEgMjAuODMwNSAxNi41NjM1IDIwLjU5NzEgMTYuODk4NCAyMC4yNjI2TDIyLjM1MzIgMTQuODEyOUMyMy4zNDAyIDEzLjgyNjggMjMuMzQwNyAxMi4yMjcxIDIyLjM1NDIgMTEuMjQwNEMyMS4zNjc5IDEwLjI1MzkgMTkuNzY4NiAxMC4yNTM4IDE4Ljc4MjIgMTEuMjQwMkwxMy4zMzAyIDE2LjY5MjJDMTIuOTk0NyAxNy4wMjc3IDEyLjc2MDggMTcuNDUxMiAxMi42NTU1IDE3LjkxMzhMMTIuMTE5NiAyMC4yNjg0QzExLjk1NDkgMjAuOTkxOCAxMi42MDI2IDIxLjYzODkgMTMuMzI1OSAyMS40NzM3TDE1LjY3OTcgMjAuOTM1OVoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTMuNzUgMTkuNjg3NEw0LjMxNzk4IDE5LjkyMTNDNC45NTYwNSAyMC4xODQgNS42ODIyNSAyMC4wOTYyIDYuMjc0MzggMTkuNzQxOUM2Ljk2MzExIDE5LjMyOTcgNy45MjI2MiAxOC44MjU1IDguNzU3NDkgMTguNjQwMkM5LjMzOTk2IDE4LjUxMDkgMTAuMDAwNCAxOC44Mzk3IDkuODQ4MTEgMTkuNDE2NkM5LjY3ODYzIDIwLjA1ODcgOS4xNTg4NSAyMC44MTM1IDkuNjU2MjcgMjEuMTYyQzEwLjQwNjMgMjEuNjg3NCAxNC42ODc1IDIwLjM0MzcgMTQuNjg3NSAyMC4zNDM3IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const DrawTextIcon: ProIcon;
export { DrawTextIcon }
export { DrawTextIcon as drawText }

/**
 * @description Water, Fill, Transparency, Transparent, Droplet
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIxQzEwLjE5NTggMjEgOC43NTQzNSAyMC40MzQxIDcuNjAzNDEgMTkuNTUzNkMyLjM4MDE4IDE1LjU1NzMgNS44MzE1NSA4LjA5MDA3IDEwLjgwMDggMy41MjI0QzExLjQ4MTcgMi44OTY1OCAxMi41MTgzIDIuODk2NTggMTMuMTk5MiAzLjUyMjRDMTguMTY4NCA4LjA5MDA3IDIxLjYxOTggMTUuNTU3MyAxNi4zOTY2IDE5LjU1MzZDMTUuMjQ1NiAyMC40MzQxIDEzLjgwNDIgMjEgMTIgMjFaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const DropIcon: ProIcon;
export { DropIcon }
export { DropIcon as drop }

/**
 * @description Sad, Dislike, Not Helpful
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjkiIGN5PSI5LjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTUiIGN5PSI5LjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTE1LjQ2NDEgMTUuODEyNUMxNS4xMTMgMTUuMjA0NCAxNC42MDgxIDE0LjY5OTUgMTQgMTQuMzQ4NEMxMy4zOTE5IDEzLjk5NzMgMTIuNzAyMiAxMy44MTI1IDEyIDEzLjgxMjVDMTEuMjk3OSAxMy44MTI1IDEwLjYwODEgMTMuOTk3MyAxMCAxNC4zNDg0QzkuMzkxOTMgMTQuNjk5NSA4Ljg4Njk4IDE1LjIwNDQgOC41MzU5IDE1LjgxMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const EmojiFrownIcon: ProIcon;
export { EmojiFrownIcon }
export { EmojiFrownIcon as emojiFrown }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjkiIGN5PSI5IiByPSIxLjI1IiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjE1IiBjeT0iOSIgcj0iMS4yNSIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTYuNSAxMi43NUMxNi43NzYxIDEyLjc1IDE3LjAwMjYgMTIuOTc0NCAxNi45NzUgMTMuMjQ5MkMxNi45MjYzIDEzLjczNDUgMTYuODA2OCAxNC4yMTExIDE2LjYxOTQgMTQuNjYzNEMxNi4zNjgxIDE1LjI3IDE1Ljk5OTggMTUuODIxMiAxNS41MzU1IDE2LjI4NTVDMTUuMDcxMiAxNi43NDk4IDE0LjUyIDE3LjExODEgMTMuOTEzNCAxNy4zNjk0QzEzLjMwNjggMTcuNjIwNyAxMi42NTY2IDE3Ljc1IDEyIDE3Ljc1QzExLjM0MzQgMTcuNzUgMTAuNjkzMiAxNy42MjA3IDEwLjA4NjYgMTcuMzY5NEM5LjQ3OTk1IDE3LjExODEgOC45Mjg3NiAxNi43NDk4IDguNDY0NDcgMTYuMjg1NUM4LjAwMDE3IDE1LjgyMTIgNy42MzE4OCAxNS4yNyA3LjM4MDYgMTQuNjYzNEM3LjE5MzI0IDE0LjIxMTEgNy4wNzM2OCAxMy43MzQ1IDcuMDI0OTggMTMuMjQ5MkM2Ljk5NzQxIDEyLjk3NDQgNy4yMjM4NiAxMi43NSA3LjUgMTIuNzVMMTYuNSAxMi43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const EmojiGrinIcon: ProIcon;
export { EmojiGrinIcon }
export { EmojiGrinIcon as emojiGrin }

/**
 * @description Smile, Happy, Smiley, Like, Helpful
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjkiIGN5PSI5LjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTUiIGN5PSI5LjUiIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTE1LjQ2NDEgMTQuMjVDMTUuMTEzIDE0Ljg1ODEgMTQuNjA4MSAxNS4zNjMgMTQgMTUuNzE0MUMxMy4zOTE5IDE2LjA2NTIgMTIuNzAyMSAxNi4yNSAxMiAxNi4yNUMxMS4yOTc5IDE2LjI1IDEwLjYwODEgMTYuMDY1MiAxMCAxNS43MTQxQzkuMzkxOTIgMTUuMzYzIDguODg2OTcgMTQuODU4MSA4LjUzNTkgMTQuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const EmojiIcon: ProIcon;
export { EmojiIcon }
export { EmojiIcon as emoji }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNi41IDEyLjc1QzE2Ljc3NjEgMTIuNzUgMTcuMDAyNiAxMi45NzQ0IDE2Ljk3NSAxMy4yNDkyQzE2LjkyNjMgMTMuNzM0NSAxNi44MDY4IDE0LjIxMTEgMTYuNjE5NCAxNC42NjM0QzE2LjM2ODEgMTUuMjcgMTUuOTk5OCAxNS44MjEyIDE1LjUzNTUgMTYuMjg1NUMxNS4wNzEyIDE2Ljc0OTggMTQuNTIgMTcuMTE4MSAxMy45MTM0IDE3LjM2OTRDMTMuMzA2OCAxNy42MjA3IDEyLjY1NjYgMTcuNzUgMTIgMTcuNzVDMTEuMzQzNCAxNy43NSAxMC42OTMyIDE3LjYyMDcgMTAuMDg2NiAxNy4zNjk0QzkuNDc5OTUgMTcuMTE4MSA4LjkyODc2IDE2Ljc0OTggOC40NjQ0NyAxNi4yODU1QzguMDAwMTcgMTUuODIxMiA3LjYzMTg4IDE1LjI3IDcuMzgwNiAxNC42NjM0QzcuMTkzMjQgMTQuMjExMSA3LjA3MzY4IDEzLjczNDUgNy4wMjQ5OCAxMy4yNDkyQzYuOTk3NDEgMTIuOTc0NCA3LjIyMzg2IDEyLjc1IDcuNSAxMi43NUwxNi41IDEyLjc1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03LjI2NDM1IDkuMDgxODFDNy4zNjY3MyA4LjY5OTczIDcuNTkyMzIgOC4zNjIxMiA3LjkwNjEzIDguMTIxMzJDOC4yMTk5NSA3Ljg4MDUyIDguNjA0NDUgNy43NSA5IDcuNzVDOS4zOTU1NSA3Ljc1IDkuNzgwMDUgNy44ODA1MiAxMC4wOTM5IDguMTIxMzJDMTAuNDA3NyA4LjM2MjEyIDEwLjYzMzMgOC42OTk3MyAxMC43MzU2IDkuMDgxODEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuMjY0NCA5LjA4MTgxQzEzLjM2NjcgOC42OTk3MyAxMy41OTIzIDguMzYyMTIgMTMuOTA2MSA4LjEyMTMyQzE0LjIxOTkgNy44ODA1MiAxNC42MDQ0IDcuNzUgMTUgNy43NUMxNS4zOTU2IDcuNzUgMTUuNzgwMSA3Ljg4MDUyIDE2LjA5MzkgOC4xMjEzMkMxNi40MDc3IDguMzYyMTIgMTYuNjMzMyA4LjY5OTczIDE2LjczNTYgOS4wODE4MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const EmojiLaughterIcon: ProIcon;
export { EmojiLaughterIcon }
export { EmojiLaughterIcon as emojiLaughter }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNzg3OTIgMjAuNDk5OUgxOC44MDc3TTkuNzg3OTIgMjAuNDk5OUMxMC42ODY4IDIwLjUwNiAxMS41ODc2IDIwLjE2NjIgMTIuMjczNSAxOS40ODAzTDEzLjU2MzUgMTguMTkwM005Ljc4NzkyIDIwLjQ5OTlDOC45MDQ4OSAyMC40OTM5IDguMDIzNyAyMC4xNTQgNy4zNDk5NiAxOS40ODAzTDQuMDE5NyAxNi4xNUMyLjY2MDEgMTQuNzkwNCAyLjY2MDEgMTIuNTg2MSA0LjAxOTcgMTEuMjI2NUw1LjMwOTcyIDkuOTM2NDlNNS4zMDk3MiA5LjkzNjQ5TDEwLjcyNjUgNC41MTk3QzEyLjA4NjEgMy4xNjAxIDE0LjI5MDQgMy4xNjAxIDE1LjY1IDQuNTE5N0wxOC45ODAzIDcuODQ5OTZDMjAuMzM5OSA5LjIwOTU1IDIwLjMzOTkgMTEuNDEzOSAxOC45ODAzIDEyLjc3MzVMMTMuNTYzNSAxOC4xOTAzTTUuMzA5NzIgOS45MzY0OUw1LjY3NzI3IDEwLjMwNEwxMy4yNjE5IDE3Ljg4ODdMMTMuNTYzNSAxOC4xOTAzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const EraserIcon: ProIcon;
export { EraserIcon }
export { EraserIcon as eraser }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIwLjI1SDE2LjI1QzE4LjQ1OTEgMjAuMjUgMjAuMjUgMTguNDU5MSAyMC4yNSAxNi4yNVYxMy43NU0xMiAyMC4yNUg3Ljc1QzUuNTQwODYgMjAuMjUgMy43NSAxOC40NTkxIDMuNzUgMTYuMjVWMTJNMTIgMjAuMjVWMTVDMTIgMTMuMzQzMSAxMC42NTY5IDEyIDkgMTJIMy43NU0zLjc1IDEyVjcuNzVDMy43NSA1LjU0MDg2IDUuNTQwODYgMy43NSA3Ljc1IDMuNzVIMTAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuNzUgMy43NUgxOS4yNUMxOS41MjYxIDMuNzUgMTkuNzc2MSAzLjg2MTkzIDE5Ljk1NzEgNC4wNDI4OU0yMC4yNSAxMC4yNVY0Ljc1QzIwLjI1IDQuNDczODYgMjAuMTM4MSA0LjIyMzg2IDE5Ljk1NzEgNC4wNDI4OU0xMy43NSAxMC4yNUwxOS4yNSA0Ljc1TDE5Ljk1NzEgNC4wNDI4OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ExpandIcon: ProIcon;
export { ExpandIcon }
export { ExpandIcon as expand }

/**
 * @description Puzzle
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const ExtensionIcon: ProIcon;
export { ExtensionIcon }
export { ExtensionIcon as extension }

/**
 * @description Eyedropper 2
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuOTQxMDcgMTkuOTY4NEwxNC4wNDk2IDEzLjg1OTlINi4yMzQ4Nkw0LjAzMjcyIDE2LjA2MkMzLjgyNzc5IDE2LjI2NjkgMy43MjUzMyAxNi4zNjk0IDMuNjQ1NTcgMTYuNDg2OEMzLjU3NDc5IDE2LjU5MSAzLjUxNzQxIDE2LjcwMzcgMy40NzQ4IDE2LjgyMjJDMy40MjY3OCAxNi45NTU4IDMuNDA0MjEgMTcuMDk4OSAzLjM1OTA3IDE3LjM4NTJMMy4yNjMyMSAxNy45OTMxQzMuMDg5NyAxOS4wOTM0IDMuMDAyOTQgMTkuNjQzNiAzLjE3NTc3IDIwLjA0M0MzLjMyNzA4IDIwLjM5MjcgMy42MDU4IDIwLjY3MTcgMy45NTUzNCAyMC44MjMzQzQuMzU0NTggMjAuOTk2NiA0LjkwNDgzIDIwLjkxMDQgNi4wMDUzMSAyMC43MzhMNi42MTU0MiAyMC42NDI1QzYuOTAyMjIgMjAuNTk3NSA3LjA0NTYzIDIwLjU3NTEgNy4xNzk0NiAyMC41MjcxQzcuMjk4MjIgMjAuNDg0NSA3LjQxMTE0IDIwLjQyNzEgNy41MTU1MyAyMC4zNTYyQzcuNjMzMTYgMjAuMjc2MyA3LjczNTggMjAuMTczNyA3Ljk0MTA3IDE5Ljk2ODRaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const EyedropperColorAccentIcon: ProIcon;
export { EyedropperColorAccentIcon }
export { EyedropperColorAccentIcon as eyedropperColorAccent }

/**
 * @description Eyedropper 2
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjA0NzEgNy44MTg3M0wyMC45MTk1IDkuNjkxMTlNMTkuMDQ3MSA3LjgxODczTDE2LjE4MzMgNC45NTQ5N00xOS4wNDcxIDcuODE4NzNMMjAuNTQyOSA2LjMyMjk0QzIwLjkzMzQgNS45MzI0MiAyMC45MzM0IDUuMjk5MjYgMjAuNTQyOSA0LjkwODczTDE5LjA5MzMgMy40NTkxOEMxOC43MDI4IDMuMDY4NjYgMTguMDY5NiAzLjA2ODY2IDE3LjY3OTEgMy40NTkxOEwxNi4xODMzIDQuOTU0OTdNMTQuMzEwOSAzLjA4MjUxTDE2LjE4MzMgNC45NTQ5NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02LjIzNDg3IDEzLjg1OThMNC4wMzI3MyAxNi4wNjJDMy44Mjc4MSAxNi4yNjY5IDMuNzI1MzUgMTYuMzY5MyAzLjY0NTU5IDE2LjQ4NjhDMy41NzQ4IDE2LjU5MDkgMy41MTc0MyAxNi43MDM2IDMuNDc0ODIgMTYuODIyMkMzLjQyNjggMTYuOTU1OCAzLjQwNDIzIDE3LjA5ODkgMy4zNTkwOCAxNy4zODUyTDMuMjYzMjIgMTcuOTkzQzMuMDg5NzEgMTkuMDkzMyAzLjAwMjk1IDE5LjY0MzUgMy4xNzU3OCAyMC4wNDI5QzMuMzI3MDkgMjAuMzkyNiAzLjYwNTgxIDIwLjY3MTYgMy45NTUzNSAyMC44MjMzQzQuMzU0NiAyMC45OTY1IDQuOTA0ODQgMjAuOTEwMyA2LjAwNTMzIDIwLjczOEw2LjYxNTQzIDIwLjY0MjRDNi45MDIyNCAyMC41OTc1IDcuMDQ1NjQgMjAuNTc1IDcuMTc5NDcgMjAuNTI3QzcuMjk4MjQgMjAuNDg0NCA3LjQxMTE1IDIwLjQyNyA3LjUxNTU0IDIwLjM1NjFDNy42MzMxNyAyMC4yNzYzIDcuNzM1ODEgMjAuMTczNiA3Ljk0MTA5IDE5Ljk2ODRMMTUuNjU5MSAxMi4yNTAzQzE2LjI1MzEgMTEuNjU2MyAxNi41NTAyIDExLjM1OTMgMTYuNjYxNCAxMS4wMTY4QzE2Ljc1OTMgMTAuNzE1NSAxNi43NTkzIDEwLjM5MSAxNi42NjE0IDEwLjA4OThDMTYuNTUwMiA5Ljc0NzI2IDE2LjI1MzEgOS40NTAyNSAxNS42NTkxIDguODU2MjJMMTUuMTQ1OCA4LjM0Mjk1QzE0LjU1MTggNy43NDg5MiAxNC4yNTQ4IDcuNDUxOTEgMTMuOTEyMyA3LjM0MDYzQzEzLjYxMSA3LjI0Mjc0IDEzLjI4NjUgNy4yNDI3NCAxMi45ODUzIDcuMzQwNjNDMTIuNjQyOCA3LjQ1MTkxIDEyLjM0NTggNy43NDg5MiAxMS43NTE3IDguMzQyOTVMNi4yMzQ4NyAxMy44NTk4Wk02LjIzNDg3IDEzLjg1OThIMTQuMDQ5NiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const EyedropperColorIcon: ProIcon;
export { EyedropperColorIcon }
export { EyedropperColorIcon as eyedropperColor }

/**
 * @description Color
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjA0NzEgNy44MTg3M0wyMC45MTk1IDkuNjkxMTlNMTkuMDQ3MSA3LjgxODczTDE2LjE4MzMgNC45NTQ5N00xOS4wNDcxIDcuODE4NzNMMjAuNTQyOSA2LjMyMjk0QzIwLjkzMzQgNS45MzI0MiAyMC45MzM0IDUuMjk5MjYgMjAuNTQyOSA0LjkwODczTDE5LjA5MzMgMy40NTkxOEMxOC43MDI4IDMuMDY4NjYgMTguMDY5NiAzLjA2ODY2IDE3LjY3OTEgMy40NTkxOEwxNi4xODMzIDQuOTU0OTdNMTQuMzEwOSAzLjA4MjUxTDE2LjE4MzMgNC45NTQ5NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMi4zODgyIDcuNzA2NTNDMTIuOTc0IDcuMTIwNzUgMTMuOTIzNyA3LjEyMDc1IDE0LjUwOTUgNy43MDY1M0wxNi4yOTU2IDkuNDkyNkMxNi44ODE0IDEwLjA3ODQgMTYuODgxNCAxMS4wMjgxIDE2LjI5NTYgMTEuNjEzOUw3LjczMzc2IDIwLjE3NTdDNy41MDkxNSAyMC40MDAzIDcuMjE5MDQgMjAuNTQ3OCA2LjkwNTIyIDIwLjU5N0w0Ljc4NDYxIDIwLjkyOTJDMy43NzkzMSAyMS4wODY2IDIuOTEyMjkgMjAuMjE4NyAzLjA3MDggMTkuMjEzNkwzLjQwNDc0IDE3LjA5NkMzLjQ1NDEzIDE2Ljc4MjcgMy42MDE1MyAxNi40OTMyIDMuODI1NzcgMTYuMjY4OUwxMi4zODgyIDcuNzA2NTNaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const EyedropperIcon: ProIcon;
export { EyedropperIcon }
export { EyedropperIcon as eyedropper }

/**
 * @description Look
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuMTgyMjcgMTIuODA4M0M0LjIzMzM4IDE0LjYxMjUgNy4xOTUyIDE4LjgxIDEyIDE4LjgxQzE2LjgxMzQgMTguODEgMTkuNzcwOSAxNC42MTExIDIwLjgxOTMgMTIuODA3NUMyMS4xMTE5IDEyLjMwNDEgMjEuMTExNyAxMS42OTYgMjAuODE4OSAxMS4xOTI3QzE5Ljc2OTUgOS4zODkyMyAxNi44MDk3IDUuMTkgMTIgNS4xOUM3LjE5MTQ4IDUuMTkgNC4yMzE5NCA5LjM4NzE3IDMuMTgxODYgMTEuMTkxNEMyLjg4ODU3IDExLjY5NTMgMi44ODg3NSAxMi4zMDQ1IDMuMTgyMjcgMTIuODA4M1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyIDE0LjYyNUMxMy40NDk3IDE0LjYyNSAxNC42MjUgMTMuNDQ5NyAxNC42MjUgMTJDMTQuNjI1IDEwLjU1MDMgMTMuNDQ5NyA5LjM3NSAxMiA5LjM3NUMxMC41NTAzIDkuMzc1IDkuMzc1IDEwLjU1MDMgOS4zNzUgMTJDOS4zNzUgMTMuNDQ5NyAxMC41NTAzIDE0LjYyNSAxMiAxNC42MjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const EyeIcon: ProIcon;
export { EyeIcon }
export { EyeIcon as eye }

/**
 * @description Invisible, Hidden
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuMjgxNTUgMjEuNzgxNkw3LjU1OTU2IDE3LjUwMzZNMjEuNzgxNSAzLjI4MTU4TDE3LjY3MyA3LjM5MDE3TTE0LjMxMDMgMTAuNzUyOEMxNC4wNjcyIDEwLjMwMzMgMTMuNjk2NyA5LjkzMjggMTMuMjQ3MiA5LjY4OTY0QzEyLjg3NjIgOS40ODg5NCAxMi40NTE0IDkuMzc0OTkgMTIgOS4zNzQ5OUMxMC41NTAyIDkuMzc0OTkgOS4zNzQ5OCAxMC41NTAyIDkuMzc0OTggMTJDOS4zNzQ5OCAxMi40NTE0IDkuNDg4OTMgMTIuODc2MiA5LjY4OTYzIDEzLjI0NzJDOS45MzI3OSAxMy42OTY3IDEwLjMwMzMgMTQuMDY3MiAxMC43NTI4IDE0LjMxMDRNMTQuMzEwMyAxMC43NTI4TDEwLjc1MjggMTQuMzEwNE0xNC4zMTAzIDEwLjc1MjhMMTcuNjczIDcuMzkwMTdNMTAuNzUyOCAxNC4zMTA0TDcuNTU5NTYgMTcuNTAzNk0xNy42NzMgNy4zOTAxN0MxNy4yOTI1IDcuMDcxMzQgMTYuODgxOSA2Ljc2ODY4IDE2LjQ0MTMgNi40OTU1OEMxNS4xOTg1IDUuNzI1MjIgMTMuNzE3MSA1LjE4OTk5IDEyIDUuMTg5OTlDNy4wNDM4MyA1LjE4OTk5IDQuMDUxOTQgOS42NDg4NCAzLjA5MDUyIDExLjM1MDZDMi45ODAzMSAxMS41NDU3IDIuOTI1MiAxMS42NDMzIDIuODkzNDQgMTEuNzk1NkMyLjg2OTk1IDExLjkwODIgMi44NyAxMi4wOTE2IDIuODkzNTQgMTIuMjA0M0MyLjkyNTM3IDEyLjM1NjUgMi45ODA1NCAxMi40NTQxIDMuMDkwODcgMTIuNjQ5MkMzLjYwMTUyIDEzLjU1MjEgNC42ODQyNyAxNS4yMzEzIDYuMzI4MDIgMTYuNjA4OEM2LjcwODUyIDE2LjkyNzcgNy4xMTkwOCAxNy4yMzA0IDcuNTU5NTYgMTcuNTAzNk0xOS43NCA5LjU3OTJDMjAuMjY4MiAxMC4yNzI3IDIwLjY1ODYgMTAuOTA2NiAyMC45MSAxMS4zNTE2QzIxLjAyIDExLjU0NjQgMjEuMDc1IDExLjY0MzggMjEuMTA2OCAxMS43OTU5QzIxLjEzMDMgMTEuOTA4NCAyMS4xMzAzIDEyLjA5MTcgMjEuMTA2OSAxMi4yMDQyQzIxLjA3NTIgMTIuMzU2MyAyMS4wMjAyIDEyLjQ1MzcgMjAuOTEwMyAxMi42NDg1QzE5Ljk1MDUgMTQuMzQ5NyAxNi45NjA5IDE4LjgxIDEyIDE4LjgxQzExLjUyNCAxOC44MSAxMS4wNjYxIDE4Ljc2ODggMTAuNjI2NCAxOC42OTI4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const EyeOffIcon: ProIcon;
export { EyeOffIcon }
export { EyeOffIcon as eyeOff }

/**
 * @description Meta, Social Media, Mark Zuckerburg, Messenger
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjQ3NzUgMjEuMTI1M0MxMC45NzI4IDIxLjIwNzMgMTEuNDgxNCAyMS4yNSAxMiAyMS4yNUMxMi41MTU5IDIxLjI1IDEzLjAyMTkgMjEuMjA3OCAxMy41MTQ4IDIxLjEyNjZNMTAuNDc3NSAyMS4xMjUzQzYuMDkzMjcgMjAuMzk5MyAyLjc1IDE2LjU5MDEgMi43NSAxMkMyLjc1IDYuODkxMzcgNi44OTEzNyAyLjc1IDEyIDIuNzVDMTcuMTA4NiAyLjc1IDIxLjI1IDYuODkxMzcgMjEuMjUgMTJDMjEuMjUgMTYuNTkyOCAxNy45MDI4IDIwLjQwMzcgMTMuNTE0OCAyMS4xMjY2TTEwLjQ3NzUgMjEuMTI1M1YxNi4xMkg4LjU4QzguMjQ4NjIgMTYuMTIgNy45OCAxNS44NTE0IDcuOTggMTUuNTJWMTMuNjgyMkM3Ljk4IDEzLjM1MDggOC4yNDg2MiAxMy4wODIyIDguNTggMTMuMDgyMkgxMC40Nzc1VjkuOTUwNUMxMC40Nzc1IDguMjkzNjUgMTEuODIwNyA2Ljk1MDUgMTMuNDc3NSA2Ljk1MDVIMTUuMjg2N0MxNS44Mzg5IDYuOTUwNSAxNi4yODY3IDcuMzk4MjIgMTYuMjg2NyA3Ljk1MDVWOC45OTAwMkMxNi4yODY3IDkuNTQyMzEgMTUuODM4OSA5Ljk5MDAyIDE1LjI4NjcgOS45OTAwMkgxNC41MTQ4QzEzLjk2MjUgOS45OTAwMiAxMy41MTQ4IDEwLjQzNzcgMTMuNTE0OCAxMC45OVYxMy4wODIySDE1LjgxMjJDMTYuMTgyOCAxMy4wODIyIDE2LjQ2NDggMTMuNDE0OCAxNi40MDQxIDEzLjc4MDRMMTYuMTU0NyAxNS4yODM3QzE2LjA3NDYgMTUuNzY2MiAxNS42NTczIDE2LjEyIDE1LjE2ODEgMTYuMTJIMTMuNTE0OFYyMS4xMjY2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const FacebookIcon: ProIcon;
export { FacebookIcon }
export { FacebookIcon as facebook }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuOTk1NTIgMTguMzIyOUM0Ljk3NjAyIDE5LjEwNzEgMy41IDE4LjM4MDMgMy41IDE3LjA5NDFWNi45MDU5MkMzLjUgNS42MTk2OCA0Ljk3NjAyIDQuODkyODkgNS45OTU1MiA1LjY3NzEyTDEyLjIyMDQgMTAuODY4N0MxMi45MjY1IDExLjQ1NzYgMTIuOTI2NSAxMi41NDI0IDEyLjIyMDQgMTMuMTMxM0w1Ljk5NTUyIDE4LjMyMjlaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS4yNDU1IDE4LjMyMjlDMTQuMjI2IDE5LjEwNzEgMTIuNzUgMTguMzgwMyAxMi43NSAxNy4wOTQxVjYuOTA1OTJDMTIuNzUgNS42MTk2OCAxNC4yMjYgNC44OTI4OSAxNS4yNDU1IDUuNjc3MTJMMjEuNDcwNCAxMC44Njg3QzIyLjE3NjUgMTEuNDU3NiAyMi4xNzY1IDEyLjU0MjQgMjEuNDcwNCAxMy4xMzEzTDE1LjI0NTUgMTguMzIyOVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const FastFowardIcon: ProIcon;
export { FastFowardIcon }
export { FastFowardIcon as fastFoward }

/**
 * @description Design, Dylan Field, Sketch, Icons, Prototype, Prototyping, Adobe
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuODMzMzQgNS44MzMzM0M1LjgzMzM0IDQuMTMwNDUgNy4yMTM4IDIuNzUgOC45MTY2OCAyLjc1SDEyVjguOTE2NjdIOC45MTY2OEM3LjIxMzggOC45MTY2NyA1LjgzMzM0IDcuNTM2MjEgNS44MzMzNCA1LjgzMzMzVjUuODMzMzNaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE4LjE2NjcgNS44MzMzM0MxOC4xNjY3IDQuMTMwNDUgMTYuNzg2MiAyLjc1IDE1LjA4MzMgMi43NUgxMlY4LjkxNjY3SDE1LjA4MzNDMTYuNzg2MiA4LjkxNjY3IDE4LjE2NjcgNy41MzYyMSAxOC4xNjY3IDUuODMzMzNWNS44MzMzM1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB3aWR0aD0iNi4xNjY2NyIgaGVpZ2h0PSI2LjE2NjY3IiByeD0iMy4wODMzMyIgdHJhbnNmb3JtPSJtYXRyaXgoLTEgMCAwIDEgMTguMTY2NyA4LjkxNjY5KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik01LjgzMzM0IDEyQzUuODMzMzQgMTAuMjk3MSA3LjIxMzggOC45MTY2OSA4LjkxNjY4IDguOTE2NjlIMTJWMTUuMDgzNEg4LjkxNjY4QzcuMjEzOCAxNS4wODM0IDUuODMzMzQgMTMuNzAyOSA1LjgzMzM0IDEyVjEyWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik01LjgzMzM0IDE4LjE2NjZDNS44MzMzNCAxNi40NjM4IDcuMjEzOCAxNS4wODMzIDguOTE2NjggMTUuMDgzM0gxMlYxOC4xNjY2QzEyIDE5Ljg2OTUgMTAuNjE5NiAyMS4yNSA4LjkxNjY4IDIxLjI1VjIxLjI1QzcuMjEzOCAyMS4yNSA1LjgzMzM0IDE5Ljg2OTUgNS44MzMzNCAxOC4xNjY2VjE4LjE2NjZaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const FigmaIcon: ProIcon;
export { FigmaIcon }
export { FigmaIcon as figma }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik02LjUgMjNDOS41Mzc1NyAyMyAxMiAyMC41Mzc2IDEyIDE3LjVDMTIgMTQuNDYyNCA5LjUzNzU3IDEyIDYuNSAxMkMzLjQ2MjQzIDEyIDEgMTQuNDYyNCAxIDE3LjVDMSAyMC41Mzc2IDMuNDYyNDMgMjMgNi41IDIzWk02LjUgMTQuMDA2NkM2Ljc3NjE0IDE0LjAwNjYgNyAxNC4yMzA0IDcgMTQuNTA2NlYxNy4wMDAxSDkuNDkzNDJDOS43Njk1NiAxNy4wMDAxIDkuOTkzNDIgMTcuMjIzOSA5Ljk5MzQyIDE3LjUwMDFDOS45OTM0MiAxNy43NzYyIDkuNzY5NTYgMTguMDAwMSA5LjQ5MzQyIDE4LjAwMDFIN1YyMC40OTM0QzcgMjAuNzY5NiA2Ljc3NjE0IDIwLjk5MzQgNi41IDIwLjk5MzRDNi4yMjM4NiAyMC45OTM0IDYgMjAuNzY5NiA2IDIwLjQ5MzRWMTguMDAwMUgzLjUwNjU4QzMuMjMwNDQgMTguMDAwMSAzLjAwNjU4IDE3Ljc3NjIgMy4wMDY1OCAxNy41MDAxQzMuMDA2NTggMTcuMjIzOSAzLjIzMDQ0IDE3LjAwMDEgMy41MDY1OCAxNy4wMDAxSDZWMTQuNTA2NkM2IDE0LjIzMDQgNi4yMjM4NiAxNC4wMDY2IDYuNSAxNC4wMDY2WiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNNC4yOTE2NyAxMC4yNVY2LjI1QzQuMjkxNjcgNC4zMTcgNS44NTg2NyAyLjc1IDcuNzkxNjcgMi43NUgxMC4yNEMxMC43NDQyIDIuNzUgMTEuMjM3MSAyLjg1ODc4IDExLjY4NzUgMy4wNjMzM00xMy43NSAyMS4yNUgxNi4yMDgzQzE4LjE0MTMgMjEuMjUgMTkuNzA4MyAxOS42ODMgMTkuNzA4MyAxNy43NVYxMi4yMTk1QzE5LjcwODMgMTEuNzE0OCAxOS41OTkzIDExLjIyMTMgMTkuMzk0MyAxMC43NzA2TTExLjY4NzUgMy4wNjMzM0MxMi4wNjY0IDMuMjM1NDUgMTIuNDE1MiAzLjQ3NTM4IDEyLjcxNTIgMy43NzUzOEwxOC42ODM1IDkuNzQ0OTJDMTguOTgyOCAxMC4wNDQzIDE5LjIyMjMgMTAuMzkyNCAxOS4zOTQzIDEwLjc3MDZNMTEuNjg3NSAzLjA2MzMzVjQuMTA5OTlWOC43NzA1NkMxMS42ODc1IDkuODc1MTMgMTIuNTgyOSAxMC43NzA2IDEzLjY4NzUgMTAuNzcwNkgxOC4zNUgxOS4zOTQzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const FileAddIcon: ProIcon;
export { FileAddIcon }
export { FileAddIcon as fileAdd }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTExLjY4NzUgMy4wNjMzM0MxMi4wNjY0IDMuMjM1NDUgMTIuNDE1MiAzLjQ3NTM4IDEyLjcxNTIgMy43NzUzOEwxOC42ODM1IDkuNzQ0OTJDMTguOTgyOCAxMC4wNDQzIDE5LjIyMjMgMTAuMzkyNCAxOS4zOTQzIDEwLjc3MDZNMTEuNjg3NSAzLjA2MzMzQzExLjIzNzEgMi44NTg3OCAxMC43NDQyIDIuNzUgMTAuMjQgMi43NUg3Ljc5MTY3QzUuODU4NjcgMi43NSA0LjI5MTY3IDQuMzE3IDQuMjkxNjcgNi4yNVYxNy43NUM0LjI5MTY3IDE5LjY4MyA1Ljg1ODY4IDIxLjI1IDcuNzkxNjcgMjEuMjVIMTYuMjA4M0MxOC4xNDEzIDIxLjI1IDE5LjcwODMgMTkuNjgzIDE5LjcwODMgMTcuNzVWMTIuMjE5NUMxOS43MDgzIDExLjcxNDggMTkuNTk5MyAxMS4yMjEzIDE5LjM5NDMgMTAuNzcwNk0xMS42ODc1IDMuMDYzMzNWNC4xMDk5OVY4Ljc3MDU2QzExLjY4NzUgOS44NzUxMyAxMi41ODI5IDEwLjc3MDYgMTMuNjg3NSAxMC43NzA2SDE4LjM1SDE5LjM5NDMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const FileIcon: ProIcon;
export { FileIcon }
export { FileIcon as file }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const FileSyncIcon: ProIcon;
export { FileSyncIcon }
export { FileSyncIcon as fileSync }

/**
 * @description Funnel
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMTQ1MTIgMTcuNzAzOFYxMy43Mjc5QzkuMTQ1MTIgMTMuMzQ2OSA5LjE0NTEyIDEzLjE1NjQgOS4xMDA3IDEyLjk3OEM5LjA2MTMyIDEyLjgxOTggOC45OTY0MiAxMi42NjkxIDguOTA4NTYgMTIuNTMxOEM4LjgwOTQ0IDEyLjM3NjkgOC42NzEwNSAxMi4yNDYgOC4zOTQyNyAxMS45ODQyTDMuNTc3ODEgNy40Mjg3OEMyLjc5NDc1IDYuNjg4MTUgMi41Mzg3NiA1LjU0Njc5IDIuOTMwNTEgNC41NDI2N0MzLjMyNzAyIDMuNTI2MzEgNC4zMDYzMiAyLjg1NzE4IDUuMzk3MyAyLjg1NzE4SDE4LjU4NjlDMTkuNjg0NCAyLjg1NzE4IDIwLjY2OTUgMy41MzAyOSAyMS4wNjg0IDQuNTUyNzFDMjEuNDU4NiA1LjU1Mjc4IDIxLjIxMDMgNi42ODkzMyAyMC40Mzg2IDcuNDM1NThMMTUuNjc0IDEyLjA0MzJDMTUuNDA0MiAxMi4zMDQxIDE1LjI2OTIgMTIuNDM0NiAxNS4xNzI3IDEyLjU4ODFDMTUuMDg3MSAxMi43MjQyIDE1LjAyMzkgMTIuODczMiAxNC45ODU2IDEzLjAyOTNDMTQuOTQyNCAxMy4yMDU0IDE0Ljk0MjQgMTMuMzkzMSAxNC45NDI0IDEzLjc2ODVWMTcuNzAzOEMxNC45NDI0IDE4LjI0NTkgMTQuOTQyNCAxOC41MTcgMTQuODc5OCAxOC43NjEzQzE0Ljc3NzMgMTkuMTYxNSAxNC41NTMzIDE5LjUyMDEgMTQuMjM4OCAxOS43ODc4QzE0LjA0NjggMTkuOTUxMyAxMy44MDMyIDIwLjA3MDMgMTMuMzE2IDIwLjMwODJDMTIuMTc2NiAyMC44NjQ4IDExLjYwNyAyMS4xNDMxIDExLjE0NCAyMS4xNDI4QzEwLjM4MDYgMjEuMTQyNCA5LjY4NDAzIDIwLjcwNzUgOS4zNDg1NyAyMC4wMjE3QzkuMTQ1MTIgMTkuNjA1OCA5LjE0NTEyIDE4Ljk3MTggOS4xNDUxMiAxNy43MDM4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const Filter2Icon: ProIcon;
export { Filter2Icon }
export { Filter2Icon as filter2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3LjUyIDEwLjI1TDIwLjQzODYgNy40MzU1OEMyMS4yMTAzIDYuNjg5MzMgMjEuNDU4NiA1LjU1Mjc4IDIxLjA2ODQgNC41NTI3MUMyMC42Njk1IDMuNTMwMjkgMTkuNjg0NCAyLjg1NzE4IDE4LjU4NjkgMi44NTcxOEg1LjM5NzNDNC4zMDYzMiAyLjg1NzE4IDMuMzI3MDIgMy41MjYzMSAyLjkzMDUxIDQuNTQyNjdDMi41Mzg3NiA1LjU0Njc5IDIuNzk0NzUgNi42ODgxNSAzLjU3NzgxIDcuNDI4NzhMOC4zOTQyNyAxMS45ODQyQzguNjcxMDUgMTIuMjQ2IDguODA5NDQgMTIuMzc2OSA4LjkwODU2IDEyLjUzMThDOC45OTY0MiAxMi42NjkxIDkuMDYxMzIgMTIuODE5OCA5LjEwMDcgMTIuOTc4QzkuMTQ1MTIgMTMuMTU2NCA5LjE0NTEyIDEzLjM0NjkgOS4xNDUxMiAxMy43Mjc5VjE3LjcwMzhDOS4xNDUxMiAxOC45NzE4IDkuMTQ1MTIgMTkuNjA1OCA5LjM0ODU3IDIwLjAyMTdDOS41NDQ5NiAyMC40MjMyIDkuODY1MTIgMjAuNzM4NyAxMC4yNSAyMC45MzE0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNy41IDIzQzIwLjUzNzYgMjMgMjMgMjAuNTM3NiAyMyAxNy41QzIzIDE0LjQ2MjQgMjAuNTM3NiAxMiAxNy41IDEyQzE0LjQ2MjQgMTIgMTIgMTQuNDYyNCAxMiAxNy41QzEyIDIwLjUzNzYgMTQuNDYyNCAyMyAxNy41IDIzWk0xNS4xNDc4IDE1LjE0NzhDMTUuMzQzMSAxNC45NTI1IDE1LjY1OTcgMTQuOTUyNSAxNS44NTQ5IDE1LjE0NzhMMTcuNSAxNi43OTI5TDE5LjE0NTEgMTUuMTQ3OUMxOS4zNDAzIDE0Ljk1MjYgMTkuNjU2OSAxNC45NTI2IDE5Ljg1MjIgMTUuMTQ3OUMyMC4wNDc0IDE1LjM0MzEgMjAuMDQ3NCAxNS42NTk3IDE5Ljg1MjIgMTUuODU1TDE4LjIwNzEgMTcuNUwxOS44NTIyIDE5LjE0NTFDMjAuMDQ3NCAxOS4zNDAzIDIwLjA0NzQgMTkuNjU2OSAxOS44NTIyIDE5Ljg1MjJDMTkuNjU2OSAyMC4wNDc0IDE5LjM0MDMgMjAuMDQ3NCAxOS4xNDUxIDE5Ljg1MjJMMTcuNSAxOC4yMDcxTDE1Ljg1NDkgMTkuODUyMkMxNS42NTk3IDIwLjA0NzUgMTUuMzQzMSAyMC4wNDc1IDE1LjE0NzggMTkuODUyMkMxNC45NTI2IDE5LjY1NyAxNC45NTI2IDE5LjM0MDQgMTUuMTQ3OCAxOS4xNDUxTDE2Ljc5MjkgMTcuNUwxNS4xNDc4IDE1Ljg1NDlDMTQuOTUyNiAxNS42NTk2IDE0Ljk1MjYgMTUuMzQzMSAxNS4xNDc4IDE1LjE0NzhaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const FilterCancel2Icon: ProIcon;
export { FilterCancel2Icon }
export { FilterCancel2Icon as filterCancel2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNSA3LjI1SDEwLjI1TTcuMzg0NjQgMTJIMTJNMTAuMjY5MiAxNi43NUgxMy43MzA4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNy41IDEyQzIwLjUzNzYgMTIgMjMgOS41Mzc1NyAyMyA2LjVDMjMgMy40NjI0MyAyMC41Mzc2IDEgMTcuNSAxQzE0LjQ2MjQgMSAxMiAzLjQ2MjQzIDEyIDYuNUMxMiA5LjUzNzU3IDE0LjQ2MjQgMTIgMTcuNSAxMlpNMTUuMTQ3OCA0LjE0Nzc5QzE1LjM0MzEgMy45NTI1MyAxNS42NTk3IDMuOTUyNTMgMTUuODU0OSA0LjE0Nzc5TDE3LjUgNS43OTI5MUwxOS4xNDUxIDQuMTQ3ODdDMTkuMzQwMyAzLjk1MjYxIDE5LjY1NjkgMy45NTI2MSAxOS44NTIyIDQuMTQ3ODdDMjAuMDQ3NCA0LjM0MzEzIDIwLjA0NzQgNC42NTk3MiAxOS44NTIyIDQuODU0OThMMTguMjA3MSA2LjUwMDAyTDE5Ljg1MjIgOC4xNDUwNUMyMC4wNDc0IDguMzQwMzIgMjAuMDQ3NCA4LjY1NjkgMTkuODUyMiA4Ljg1MjE2QzE5LjY1NjkgOS4wNDc0MiAxOS4zNDAzIDkuMDQ3NDIgMTkuMTQ1MSA4Ljg1MjE2TDE3LjUgNy4yMDcxMkwxNS44NTQ5IDguODUyMjRDMTUuNjU5NyA5LjA0NzUgMTUuMzQzMSA5LjA0NzUgMTUuMTQ3OCA4Ljg1MjI0QzE0Ljk1MjYgOC42NTY5OCAxNC45NTI2IDguMzQwNCAxNS4xNDc4IDguMTQ1MTRMMTYuNzkyOSA2LjUwMDAyTDE1LjE0NzggNC44NTQ5QzE0Ljk1MjYgNC42NTk2MyAxNC45NTI2IDQuMzQzMDUgMTUuMTQ3OCA0LjE0Nzc5WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const FilterCancelIcon: ProIcon;
export { FilterCancelIcon }
export { FilterCancelIcon as filterCancel }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNSA3LjI1SDE5LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy4zODQ2NCAxMkgxNi42MTU0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEwLjI2OTIgMTYuNzVIMTMuNzMwOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const FilterIcon: ProIcon;
export { FilterIcon }
export { FilterIcon as filter }

/**
 * @description Report, Checkpoint, Flagged, Font Awesome, Curved, Waving, Wave
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuMjUgMTUuMTgxOFYyMS4yNTE5TTUuMjUgMTUuMTgxOEM3LjUwNjM1IDEzLjkzNjkgMTAuMjQzNyAxMy45MzY5IDEyLjUgMTUuMTgxOEMxNC42NTI2IDE2LjM2OTUgMTcuMjQzIDE2LjQyNDEgMTkuNDM1OCAxNS4zNDU2QzE5LjYzMTkgMTUuMjQ5MiAxOS43NSAxNS4wNDYxIDE5Ljc1IDE0LjgyNzZWMy42ODE4M0MxNy40OTM3IDQuOTI2NzEgMTQuNzU2MyA0LjkyNjcxIDEyLjUgMy42ODE4M0MxMC40MTY5IDIuNTMyNTEgNy45MjM3NyAyLjQ0NDI4IDUuNzc3NyAzLjQxNzE1QzUuNDQ1OTcgMy41Njc1MiA1LjI1IDMuOTA3OTkgNS4yNSA0LjI3MjIxVjE1LjE4MThaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const Flag2Icon: ProIcon;
export { Flag2Icon }
export { Flag2Icon as flag2 }

/**
 * @description Report, Checkpoint, Flagged, Font Awesome
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuMjUgMjEuMjVWMTUuMjVNNS4yNSAxNS4yNVY1LjI1QzUuMjUgNC40MjE1NyA1LjkyMTU3IDMuNzUgNi43NSAzLjc1SDE3LjgzNjJDMTguNjQzOSAzLjc1IDE5LjExODMgNC42NTgwMyAxOC42NTcxIDUuMzIxMDZMMTUuNzUgOS41TDE4LjY1NzEgMTMuNjc4OUMxOS4xMTgzIDE0LjM0MiAxOC42NDM5IDE1LjI1IDE3LjgzNjIgMTUuMjVINS4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const FlagIcon: ProIcon;
export { FlagIcon }
export { FlagIcon as flag }

/**
 * @description Torch, Light
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuNTEyMjEgNy43MTA1N0gxNy40ODgxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTguNzU4MTggMTEuNDg5OUgxMS45OTY4SDE1LjIzNTNWMTcuMDgzOFYxOS42QzE1LjIzNTMgMjAuNjQ5MyAxNC4zODQ3IDIxLjUgMTMuMzM1MyAyMS41SDEwLjY1ODJDOS42MDg4NCAyMS41IDguNzU4MTggMjAuNjQ5MyA4Ljc1ODE4IDE5LjZWMTEuNDg5OVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNS44MDU1NiA3Ljk4OTk3TDguNzU3OTUgMTEuNDg5OUgxNS4yMzUxTDE4LjE5MzcgNy45OTAxOUMxOC4zNDYzIDcuODA5NjggMTguNDMgNy41ODA5NiAxOC40MyA3LjM0NDU5TDE4LjQzIDQuODQ5OTlDMTguNDMgMy44MjgyNyAxNy42MDE3IDMgMTYuNTggM0g3LjQxOTg3QzYuMzk4MTIgMyA1LjU2OTg0IDMuODI4MyA1LjU2OTg3IDQuODUwMDRMNS41Njk5MyA3LjM0NTIxQzUuNTY5OTMgNy41ODEyIDUuNjUzNCA3LjgwOTU5IDUuODA1NTYgNy45ODk5N1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTEuOTk2NyAxNS4wMjg3TDExLjk5NjcgMTYuNzk1MiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const FlashlightIcon: ProIcon;
export { FlashlightIcon }
export { FlashlightIcon as flashlight }

/**
 * @description Folding Phone, Z Fold, Dual Screen
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDUuMjVMMTguNzc3MyAzLjYwMTQ3QzIwLjAzNjUgMy4yOTUxOCAyMS4yNSA0LjI0ODkxIDIxLjI1IDUuNTQ0OFYxOC40NTUyQzIxLjI1IDE5Ljc1MTEgMjAuMDM2NSAyMC43MDQ4IDE4Ljc3NzMgMjAuMzk4NUwxMiAxOC43NVY1LjI1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik05LjUgMTkuMzU4TDQuNjA0NTMgMjAuNTQ4OEMzLjY2MDE1IDIwLjc3ODYgMi43NSAyMC4wNjMzIDIuNzUgMTkuMDkxM1Y0LjkwODU1QzIuNzUgMy45MzY2MyAzLjY2MDE1IDMuMjIxMzMgNC42MDQ1MyAzLjQ1MTA0TDkuNSA0LjY0MTgzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiIHN0cm9rZS1kYXNoYXJyYXk9IjIuNSAzIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const FoldableHorizontalHalfIcon: ProIcon;
export { FoldableHorizontalHalfIcon }
export { FoldableHorizontalHalfIcon as foldableHorizontalHalf }

/**
 * @description Folding Phone, Z Fold, Dual Screen
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDUuMjVMNS4yMjI3IDMuNjAxNDdDMy45NjM1MyAzLjI5NTE4IDIuNzUgNC4yNDg5MSAyLjc1IDUuNTQ0OFYxOC40NTUyQzIuNzUgMTkuNzUxMSAzLjk2MzUzIDIwLjcwNDggNS4yMjI3IDIwLjM5ODVMMTIgMTguNzVNMTIgNS4yNVYxOC43NU0xMiA1LjI1TDE4Ljc3NzMgMy42MDE0N0MyMC4wMzY1IDMuMjk1MTggMjEuMjUgNC4yNDg5MSAyMS4yNSA1LjU0NDhWMTguNDU1MkMyMS4yNSAxOS43NTExIDIwLjAzNjUgMjAuNzA0OCAxOC43NzczIDIwLjM5ODVMMTIgMTguNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const FoldableHorizontalIcon: ProIcon;
export { FoldableHorizontalIcon }
export { FoldableHorizontalIcon as foldableHorizontal }

/**
 * @description Folding Phone, Z Flip, Dual Screen
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3LjI1IDEyTDE4Ljg5ODUgMTguNzc3M0MxOS4yMDQ4IDIwLjAzNjUgMTguMjUxMSAyMS4yNSAxNi45NTUyIDIxLjI1TDcuMDQ0OCAyMS4yNUM1Ljc0ODkxIDIxLjI1IDQuNzk1MTggMjAuMDM2NSA1LjEwMTQ3IDE4Ljc3NzNMNi43NSAxMkwxNy4yNSAxMloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNi4xNDE4OSA5LjVMNC45NTExIDQuNjA0NTNDNC43MjEzOSAzLjY2MDE1IDUuNDM2NjkgMi43NSA2LjQwODYgMi43NUwxNy41OTE0IDIuNzVDMTguNTYzMyAyLjc1IDE5LjI3ODYgMy42NjAxNSAxOS4wNDg5IDQuNjA0NTNMMTcuODU4MSA5LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgc3Ryb2tlLWRhc2hhcnJheT0iMiAzIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const FoldableVerticalHalfIcon: ProIcon;
export { FoldableVerticalHalfIcon }
export { FoldableVerticalHalfIcon as foldableVerticalHalf }

/**
 * @description Folding Phone, Z Flip, Dual Screen
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuMzc1IDEyTDQuOTg1OTQgMTguODUyN0M0LjczNDc5IDIwLjA5MTcgNS42ODE4NyAyMS4yNSA2Ljk0NjA4IDIxLjI1SDE3LjA1MzlDMTguMzE4MSAyMS4yNSAxOS4yNjUyIDIwLjA5MTcgMTkuMDE0MSAxOC44NTI3TDE3LjYyNSAxMk02LjM3NSAxMkwxNy42MjUgMTJNNi4zNzUgMTJMNC45ODU5NCA1LjE0NzMzQzQuNzM0NzkgMy45MDgzMSA1LjY4MTg3IDIuNzUgNi45NDYwOCAyLjc1TDE3LjA1MzkgMi43NUMxOC4zMTgxIDIuNzUgMTkuMjY1MiAzLjkwODMxIDE5LjAxNDEgNS4xNDczMkwxNy42MjUgMTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const FoldableVerticalIcon: ProIcon;
export { FoldableVerticalIcon }
export { FoldableVerticalIcon as foldableVertical }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const FolderAddIcon: ProIcon;
export { FolderAddIcon }
export { FolderAddIcon as folderAdd }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgOC42MjMxMVYxNi4wMDE5QzIuNzUgMTguMjExIDQuNTQwODYgMjAuMDAxOSA2Ljc1IDIwLjAwMTlIMTcuMjVDMTkuNDU5MSAyMC4wMDE5IDIxLjI1IDE4LjIxMSAyMS4yNSAxNi4wMDE5VjEwLjMxMTRDMjEuMjUgOC4xMDE5OCAxOS40NTg2IDYuMzEwOTggMTcuMjQ5MiA2LjMxMTQ0TDEyIDYuMzEyNTRNMi43NSA4LjYyMzExVjYuOTk4MTFDMi43NSA1LjM0MTI1IDQuMDkzMTUgMy45OTgxMSA1Ljc1IDMuOTk4MTFIOC42NTAwNEM5LjMxMzA4IDMuOTk4MTEgOS45NDg5NiA0LjI2MTUgMTAuNDE3OCA0LjczMDM0TDEyIDYuMzEyNTRNMi43NSA4LjYyMzExSDguNjUzODlDOS4zMTY5MyA4LjYyMzExIDkuOTUyODIgOC4zNTk3MiAxMC40MjE3IDcuODkwODhMMTIgNi4zMTI1NCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const FolderIcon: ProIcon;
export { FolderIcon }
export { FolderIcon as folder }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuODgxNjMgMTguMDQzM0w3LjkyMzUgMTIuNDIwM0M4LjY3NTAyIDExLjM3NDggOS44ODM4OCAxMC43NTUgMTEuMTcxNSAxMC43NTVIMTkuOTI0Mk0zLjg4MTYzIDE4LjA0MzNDNC41NTI3NCAxOC44MjUxIDUuNTQ4MTkgMTkuMzIwMyA2LjY1OTI5IDE5LjMyMDNIMTUuMDAxN0MxNi4zODk1IDE5LjMyMDMgMTcuNjc4MiAxOC42MDA5IDE4LjQwNjYgMTcuNDE5NkwyMS4zMjUxIDEyLjY4NjFWMTIuNjg2MUMyMS44MjA2IDExLjgyNzggMjEuMjAxMiAxMC43NTUgMjAuMjEwMSAxMC43NTVIMTkuOTI0Mk0zLjg4MTYzIDE4LjA0MzNDMy4zMzIwNyAxNy40MDMyIDMgMTYuNTcwOSAzIDE1LjY2MVY3LjQyNDE2QzMgNS45MDg0MyA0LjIyODc0IDQuNjc5NjkgNS43NDQ0NyA0LjY3OTY5SDguMzk3NDlDOS4wMDQwNiA0LjY3OTY5IDkuNTg1NzggNC45MjA2NCAxMC4wMTQ3IDUuMzQ5NTVMMTAuOTI2MSA2LjI2MDkzQzExLjI2OTMgNi42MDQxNSAxMS43MzQ4IDYuNzk2OTIgMTIuMjIwMiA2Ljc5NjgyTDE2LjI2NDIgNi43OTU5OEMxOC4yODU0IDYuNzk1NTYgMTkuOTI0MiA4LjQzNCAxOS45MjQyIDEwLjQ1NTNWMTAuNzU1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const FolderOpenIcon: ProIcon;
export { FolderOpenIcon }
export { FolderOpenIcon as folderOpen }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgOC4zNDQ5MlY2LjI1QzMuNzUgNC44NjkyOSA0Ljg2OTI5IDMuNzUgNi4yNSAzLjc1SDguMzQ0OTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy43NSAxNS42NTUxVjE3Ljc1QzMuNzUgMTkuMTMwNyA0Ljg2OTI5IDIwLjI1IDYuMjUgMjAuMjVIOC4zNDQ5MiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMC4yNSA4LjM0NDkyVjYuMjVDMjAuMjUgNC44NjkyOSAxOS4xMzA3IDMuNzUgMTcuNzUgMy43NUgxNS42NTUxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIwLjI1IDE1LjY1NTFWMTcuNzVDMjAuMjUgMTkuMTMwNyAxOS4xMzA3IDIwLjI1IDE3Ljc1IDIwLjI1SDE1LjY1NTEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const FullScreenMaximizeIcon: ProIcon;
export { FullScreenMaximizeIcon }
export { FullScreenMaximizeIcon as fullScreenMaximize }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMzQ0OTcgMy43NTAwNVY1Ljg0NDk3QzguMzQ0OTcgNy4yMjU2OCA3LjIyNTY4IDguMzQ0OTcgNS44NDQ5NyA4LjM0NDk3SDMuNzUwMDUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC4zNDQ5NyAyMC4yNVYxOC4xNTVDOC4zNDQ5NyAxNi43NzQzIDcuMjI1NjggMTUuNjU1IDUuODQ0OTcgMTUuNjU1SDMuNzUwMDUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuNjU1IDMuNzUwMDVWNS44NDQ5N0MxNS42NTUgNy4yMjU2OCAxNi43NzQzIDguMzQ0OTcgMTguMTU1IDguMzQ0OTdIMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuNjU1IDIwLjI1VjE4LjE1NUMxNS42NTUgMTYuNzc0MyAxNi43NzQzIDE1LjY1NSAxOC4xNTUgMTUuNjU1SDIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const FullScreenMinimizeIcon: ProIcon;
export { FullScreenMinimizeIcon }
export { FullScreenMinimizeIcon as fullScreenMinimize }

/**
 * @description Controller, Xbox, PlayStation, Arcade, Gaming, Steam
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjAzMTEgMy44ODc0NUg3Ljk2ODg4QzUuMDg2NTcgMy44ODc0NSAyLjc1IDYuMjI0MDIgMi43NSA5LjEwNjMzVjE3LjM3MkMyLjc1IDE5LjQ0NjUgNS4yODMwNiAyMC40NTc1IDYuNzExNTQgMTguOTUzMUw5LjY4NzUgMTUuODE4OUgxNC4zMTI1TDE3LjE4NzQgMTkuMjc5M0MxOC41NjEgMjAuOTMyNSAyMS4yNSAxOS45NjEyIDIxLjI1IDE3LjgxMThWOS4xMDYzM0MyMS4yNSA2LjIyNDAyIDE4LjkxMzQgMy44ODc0NSAxNi4wMzExIDMuODg3NDVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTguMTM3OTQgOC4zOTAwMVYxMi4zOU02LjEzNzk0IDEwLjM5SDEwLjEzNzkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSIxNC42NjIxIiBjeT0iOS4zOTAwMSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxNi44NjIxIiBjeT0iMTEuNTkwMSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const GameIcon: ProIcon;
export { GameIcon }
export { GameIcon as game }

/**
 * Returns information about an icon from the provided key.
 * Throws an error if the provided key does not match an icon name in Friendly Form, camelCase or kebab-case. Use the method `search` instead to return icons that contain a keyword inside its name or tags.
 *
 * Note: This will import all icons and breaks tree-shaking
 * @param key The icon name in Friendly Form, camelCase or kebab-case. Throws an error if the provided key is invalid. Case-insensitive
 * @example The following keys are valid:
 * getIconInfo('Add Square')
 * getIconInfo('addSquare')
 * getIconInfo('add-square')
 */
export declare function getIconInfo(key: string): ProIcon | undefined;

/**
 * @description Present
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNSAxMi41SDEyVjIxSDdDNS42MTkyOSAyMSA0LjUgMTkuODgwNyA0LjUgMTguNVYxMi41WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDkuNUMyLjc1IDguNjcxNTcgMy40MjE1NyA4IDQuMjUgOEgxMlYxMi41SDQuMjVDMy40MjE1NyAxMi41IDIuNzUgMTEuODI4NCAyLjc1IDExVjkuNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgMTIuNUgxOS41VjE4LjVDMTkuNSAxOS44ODA3IDE4LjM4MDcgMjEgMTcgMjFIMTJWMTIuNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgOEgxOS43NUMyMC41Nzg0IDggMjEuMjUgOC42NzE1NyAyMS4yNSA5LjVWMTFDMjEuMjUgMTEuODI4NCAyMC41Nzg0IDEyLjUgMTkuNzUgMTIuNUgxMlY4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03IDUuNUM3IDQuMTE5MjkgOC4xMTkyOSAzIDkuNSAzVjNDMTAuODgwNyAzIDEyIDQuMTE5MjkgMTIgNS41VjhIOS41QzguMTE5MjkgOCA3IDYuODgwNzEgNyA1LjVWNS41WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNyA1LjVDMTcgNC4xMTkyOSAxNS44ODA3IDMgMTQuNSAzVjNDMTMuMTE5MyAzIDEyIDQuMTE5MjkgMTIgNS41VjhIMTQuNUMxNS44ODA3IDggMTcgNi44ODA3MSAxNyA1LjVWNS41WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const GiftIcon: ProIcon;
export { GiftIcon }
export { GiftIcon as gift }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1Ljc1IDEyQzE1Ljc1IDE0LjA3MTEgMTQuMDcxMSAxNS43NSAxMiAxNS43NUM5LjkyODkzIDE1Ljc1IDguMjUgMTQuMDcxMSA4LjI1IDEyQzguMjUgOS45Mjg5MyA5LjkyODkzIDguMjUgMTIgOC4yNUMxNC4wNzExIDguMjUgMTUuNzUgOS45Mjg5MyAxNS43NSAxMloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuNzUgMTJIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAxMkg4LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const GitCommitIcon: ProIcon;
export { GitCommitIcon }
export { GitCommitIcon as gitCommit }

/**
 * @description Open Source, Code, Microsoft, Git
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMDk2MDcgMjEuMjVWMTguMTA0MkM5LjA5NjA3IDE3Ljc4NzMgOS4xNDExOCAxNy40NzU2IDkuMjI3NSAxNy4xNzc1QzkuMzUzMDUgMTYuNzQ0IDkuNTY1NzcgMTYuMzM5MiA5Ljg1MzU5IDE1Ljk4ODlDNi44NDkyMiAxNS41ODkxIDQuNTczMiAxNC4xMzAxIDQuNTczMiAxMC4xOTA5QzQuNTczMiA4LjUyNTAyIDYuMDA1NjYgNi4zMDE0MyA2LjAwNTY2IDYuMzAxNDNDNS40OTIzNiA1LjE3MTkyIDUuNTA2OTUgMy4yMTY4OCA2LjA2NTQxIDIuNzVDNi4wNjU0MSAyLjc1IDguMDE2NDEgMi45MjUwOCA5LjkxMzEgNC41MDA3OUMxMS43NTE0IDQuMDA0NzMgMTMuNjc3MyAzLjk0NjM3IDE1LjU3NCA0LjUwMDc5QzE3LjQ3MDcgMi45MjUwOCAxOS40MjE3IDIuNzUgMTkuNDIxNyAyLjc1QzE5Ljk4MDEgMy4yMTY4OCAxOS45OTQ3IDUuMTcxOTIgMTkuNDgxNCA2LjMwMTQzQzE5LjQ4MTQgNi4zMDE0MyAyMC45MTM5IDguNTI1MDIgMjAuOTEzOSAxMC4xOTA5QzIwLjkxMzkgMTQuMTMwMSAxOC42Mzc5IDE1LjU4OTEgMTUuNjMzNSAxNS45ODg5QzE1LjkyMTMgMTYuMzM5MiAxNi4xMzQgMTYuNzQ0IDE2LjI1OTYgMTcuMTc3NUMxNi4zNDU5IDE3LjQ3NTYgMTYuMzkxIDE3Ljc4NzMgMTYuMzkxIDE4LjEwNDJWMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy4wODYxMiAxNi41NzA0QzMuMjQ4ODggMTcuMTIzOCAzLjU0OTE5IDE3LjYzNTcgMy45NjM4MiAxOC4wNjY0QzQuMzc4NDUgMTguNDk3MSA0Ljg5NjI5IDE4LjgzNTIgNS40NzcyOCAxOS4wNTQ0QzYuMDU4MjYgMTkuMjczNyA2LjY4NjgyIDE5LjM2ODIgNy4zMTQzMyAxOS4zMzA4QzcuOTQxODMgMTkuMjkzMyA4LjU1MTQ3IDE5LjEyNDggOS4wOTYwNyAxOC44Mzg0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const GithubIcon: ProIcon;
export { GithubIcon }
export { GithubIcon as github }

/**
 * @description Open Source
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjA2MzEgMTIuMDUyMkMyMS41Mjk4IDEzLjM1NjUgMjEuMTAyNCAxNC44MTI5IDIwLjAwNDggMTUuNjU4MUwxMy4yOTg5IDIwLjgyMjNDMTIuNTMzMyAyMS40MTE4IDExLjQ2NjcgMjEuNDExOCAxMC43MDExIDIwLjgyMjNMMy45OTUxNiAxNS42NTgxQzIuODk3NjIgMTQuODEyOSAyLjQ3MDE5IDEzLjM1NjUgMi45MzY4OSAxMi4wNTIyTDUuOTE0ODEgMy43Mjk5OEw4LjI4NDA2IDEwLjM1MTJDOC40MzU1NCAxMC43NzQ1IDguODM2NjYgMTEuMDU3IDkuMjg2MjcgMTEuMDU3SDE0LjcxMzdDMTUuMTYzMyAxMS4wNTcgMTUuNTY0NSAxMC43NzQ1IDE1LjcxNTkgMTAuMzUxMkwxOC4wODUyIDMuNzI5OThMMjEuMDYzMSAxMi4wNTIyWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const GitlabIcon: ProIcon;
export { GitlabIcon }
export { GitlabIcon as gitlab }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjI1IDEyQzIxLjI1IDkuNTQ2NzUgMjAuMjc1NCA3LjE5Mzk3IDE4LjU0MDcgNS40NTkyNkMxNi44MDYgMy43MjQ1NSAxNC40NTMzIDIuNzUgMTIgMi43NU0yMS4yNSAxMkwyLjc1IDEyTTIxLjI1IDEyQzIxLjI1IDE0LjQ1MzMgMjAuMjc1NCAxNi44MDYgMTguNTQwNyAxOC41NDA3QzE2LjgwNiAyMC4yNzU0IDE0LjQ1MzMgMjEuMjUgMTIgMjEuMjVNMTIgMi43NUM5LjU0Njc1IDIuNzUgNy4xOTM5NyAzLjcyNDU1IDUuNDU5MjYgNS40NTkyNkMzLjcyNDU1IDcuMTkzOTcgMi43NSA5LjU0Njc1IDIuNzUgMTJNMTIgMi43NUMxMS41IDIuNzUgOCA2Ljg5MTM3IDggMTJDOCAxNy4xMDg2IDExLjUgMjEuMjUgMTIgMjEuMjVNMTIgMi43NUMxMi41IDIuNzUgMTYgNi44OTEzNyAxNiAxMkMxNiAxNy4xMDg2IDEyLjUgMjEuMjUgMTIgMjEuMjVNMi43NSAxMkMyLjc1IDE0LjQ1MzMgMy43MjQ1NSAxNi44MDYgNS40NTkyNiAxOC41NDA3QzcuMTkzOTcgMjAuMjc1NSA5LjU0Njc1IDIxLjI1IDEyIDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const GlobeIcon: ProIcon;
export { GlobeIcon }
export { GlobeIcon as globe }

/**
 * @description Google Color, Pixel, Sundar Pichai, Search, Android
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMjAwOTggOS45NDY5MkM3LjY1Mjk0IDguODU1OCA4LjQ1MjMgNy45NDQzIDkuNDc1MSA3LjM1Mzc5QzEwLjQ5NzkgNi43NjMyOCAxMS42ODcgNi41MjY3NiAxMi44NTc5IDYuNjgwOTFDMTMuNzYzIDYuODAwMDcgMTQuNjE4MiA3LjE0NzUzIDE1LjM0NTUgNy42ODQ4N0MxNS43MDA5IDcuOTQ3NDEgMTYuMjA0NSA3Ljk1MzEyIDE2LjUxNjkgNy42NDA3TDE4LjEzMjYgNi4wMjQ5NkMxOC40NDUxIDUuNzEyNTQgMTguNDQ3MSA1LjIwMjk4IDE4LjEwODkgNC45MTg3MUMxNi43NjMzIDMuNzg3ODUgMTUuMTE4NSAzLjA2MDAxIDEzLjM2NSAyLjgyOTE1QzExLjM0NjEgMi41NjMzNyA5LjI5NjAzIDIuOTcxMTYgNy41MzI2IDMuOTg5MjhDNS43NjkxNiA1LjAwNzQgNC4zOTA5NSA2LjU3ODk1IDMuNjExNzEgOC40NjAxOU03LjIwMDk4IDkuOTQ2OTJDNi43NDkwMyAxMS4wMzggNi42Njk3MyAxMi4yNDc4IDYuOTc1NCAxMy4zODg2QzcuMjgxMDggMTQuNTI5NCA3Ljk1NDYzIDE1LjUzNzQgOC44OTE1OSAxNi4yNTY0TTcuMjAwOTggOS45NDY5MkwzLjYxMTcxIDguNDYwMTlNOC44OTE1OSAxNi4yNTY0QzkuODI4NTYgMTYuOTc1MyAxMC45NzY2IDE3LjM2NSAxMi4xNTc2IDE3LjM2NUMxMy4zMzg2IDE3LjM2NSAxNC40ODY2IDE2Ljk3NTMgMTUuNDIzNiAxNi4yNTY0TTguODkxNTkgMTYuMjU2NEw2LjUyNjU1IDE5LjMzODVNMTUuNDIzNiAxNi4yNTY0QzE2LjA3NTEgMTUuNzU2NSAxNi41OTkyIDE1LjExNjggMTYuOTYwOCAxNC4zOUgxMy4wNTEzQzEyLjYwOTUgMTQuMzkgMTIuMjUxMyAxNC4wMzE4IDEyLjI1MTMgMTMuNTlWMTEuM0MxMi4yNTEzIDEwLjg1ODIgMTIuNjA5NSAxMC41IDEzLjA1MTMgMTAuNUgyMC41NDM2QzIwLjg2MDUgMTAuNSAyMS4xNTQ2IDEwLjY4NjIgMjEuMjI1NSAxMC45OTUyQzIxLjUzNzkgMTIuMzU3MiAyMS4wOTk4IDE0LjI0MTQgMjEuMDY3IDE0LjM3ODhDMjEuMDY1NyAxNC4zODQzIDIxLjA2NDQgMTQuMzg5NSAyMS4wNjI5IDE0LjM5NUMyMC41MzQ5IDE2LjM1ODUgMTkuNDAxOCAxOC4xMDA3IDE3Ljc4ODYgMTkuMzM4NU0xNS40MjM2IDE2LjI1NjRMMTcuNzg4NiAxOS4zMzg1TTE3Ljc4ODYgMTkuMzM4NUMxNi4xNzMyIDIwLjU3ODEgMTQuMTkzOCAyMS4yNSAxMi4xNTc2IDIxLjI1QzEwLjEyMTQgMjEuMjUgOC4xNDIwMSAyMC41NzgxIDYuNTI2NTUgMTkuMzM4NU02LjUyNjU1IDE5LjMzODVDNC45MTEwOSAxOC4wOTg5IDMuNzQ5OCAxNi4zNjA5IDMuMjIyNzggMTQuMzk0MUMyLjY5NTc2IDEyLjQyNzIgMi44MzI0NyAxMC4zNDE0IDMuNjExNzEgOC40NjAxOSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const Google2Icon: ProIcon;
export { Google2Icon }
export { Google2Icon as google2 }

/**
 * @description Browser, Chromium, Microsoft, MS Edge
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDguMjVDOS45Mjg5MyA4LjI1IDguMjUgOS45Mjg5MyA4LjI1IDEyQzguMjUgMTIuMDUxNSA4LjI1MTA0IDEyLjEwMjcgOC4yNTMwOSAxMi4xNTM2TTEyIDguMjVDMTQuMDcxMSA4LjI1IDE1Ljc1IDkuOTI4OTMgMTUuNzUgMTJDMTUuNzUgMTIuMzU1NiAxNS43MDA1IDEyLjY5OTYgMTUuNjA4MSAxMy4wMjU1TTEyIDguMjVIMjAuNDU4M00xNS42MDgxIDEzLjAyNTVDMTUuMTYyIDE0LjU5ODEgMTMuNzE1NSAxNS43NSAxMiAxNS43NUM5Ljk4MDM4IDE1Ljc1IDguMzMzNjYgMTQuMTUzNSA4LjI1MzA5IDEyLjE1MzZNMTUuNjA4MSAxMy4wMjU1TDEyLjUyODcgMjEuMjM1MU0yMC40NTgzIDguMjVDMTkuMDE5NiA1LjAwOTggMTUuNzczNyAyLjc1IDEyIDIuNzVDOS4xMjAyNyAyLjc1IDYuNTQ3OSA0LjA2NTk0IDQuODUxNDIgNi4xMjkyOUM0Ljc2NTE5IDYuMjM0MTcgNC42ODEyMiA2LjM0MDk4IDQuNTk5NTggNi40NDk2Nk0yMC40NTgzIDguMjVDMjAuNTE0OCA4LjM3NzMgMjAuNTY4NiA4LjUwNjExIDIwLjYxOTQgOC42MzYzNkMyMS4wMjY1IDkuNjc4ODYgMjEuMjUgMTAuODEzMyAyMS4yNSAxMkMyMS4yNSAxNi45MzEyIDE3LjM5MTMgMjAuOTYxMiAxMi41Mjg3IDIxLjIzNTFNMTIuNTI4NyAyMS4yMzUxQzEyLjM1MzcgMjEuMjQ1IDEyLjE3NzQgMjEuMjUgMTIgMjEuMjVDNi44OTEzNyAyMS4yNSAyLjc1IDE3LjEwODYgMi43NSAxMkMyLjc1IDkuOTE3NDcgMy40MzgyIDcuOTk1NjkgNC41OTk1OCA2LjQ0OTY2TTguMjUzMDkgMTIuMTUzNkw0LjU5OTU4IDYuNDQ5NjYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const GoogleChromeIcon: ProIcon;
export { GoogleChromeIcon }
export { GoogleChromeIcon as googleChrome }

/**
 * @description Pixel, Sundar Pichai, Search, Android
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEzLjM2NSAyLjgyOTE1QzE1LjExODUgMy4wNjAwMSAxNi43NjMzIDMuNzg3ODUgMTguMTA4OSA0LjkxODcxQzE4LjQ0NzEgNS4yMDI5OCAxOC40NDUxIDUuNzEyNTQgMTguMTMyNiA2LjAyNDk2TDE2LjUxNjkgNy42NDA3QzE2LjIwNDUgNy45NTMxMiAxNS43MDA5IDcuOTQ3NDEgMTUuMzQ1NSA3LjY4NDg3QzE0LjYxODIgNy4xNDc1MyAxMy43NjMgNi44MDAwNyAxMi44NTc5IDYuNjgwOTFDMTEuNjg3IDYuNTI2NzYgMTAuNDk3OSA2Ljc2MzI4IDkuNDc1MSA3LjM1Mzc5QzguNDUyMyA3Ljk0NDMgNy42NTI5NCA4Ljg1NTggNy4yMDA5OCA5Ljk0NjkyQzYuNzQ5MDMgMTEuMDM4IDYuNjY5NzMgMTIuMjQ3OCA2Ljk3NTQgMTMuMzg4NkM3LjI4MTA4IDE0LjUyOTQgNy45NTQ2MyAxNS41Mzc0IDguODkxNTkgMTYuMjU2NEM5LjgyODU2IDE2Ljk3NTMgMTAuOTc2NiAxNy4zNjUgMTIuMTU3NiAxNy4zNjVDMTMuMzM4NiAxNy4zNjUgMTQuNDg2NiAxNi45NzUzIDE1LjQyMzYgMTYuMjU2NEMxNi4wNzUxIDE1Ljc1NjUgMTYuNTk5MiAxNS4xMTY4IDE2Ljk2MDggMTQuMzlIMTMuMDUxM0MxMi42MDk1IDE0LjM5IDEyLjI1MTMgMTQuMDMxOCAxMi4yNTEzIDEzLjU5VjExLjNDMTIuMjUxMyAxMC44NTgyIDEyLjYwOTUgMTAuNSAxMy4wNTEzIDEwLjVIMjAuNTQzNkMyMC44NjA1IDEwLjUgMjEuMTU0NiAxMC42ODYyIDIxLjIyNTUgMTAuOTk1MkMyMS41Mzc5IDEyLjM1NzIgMjEuMDk5OCAxNC4yNDE0IDIxLjA2NyAxNC4zNzg4QzIxLjA2NTcgMTQuMzg0MyAyMS4wNjQ0IDE0LjM4OTUgMjEuMDYyOSAxNC4zOTVDMjAuNTM0OSAxNi4zNTg1IDE5LjQwMTggMTguMTAwNyAxNy43ODg2IDE5LjMzODVDMTYuMTczMiAyMC41NzgxIDE0LjE5MzggMjEuMjUgMTIuMTU3NiAyMS4yNUMxMC4xMjE0IDIxLjI1IDguMTQyMDEgMjAuNTc4MSA2LjUyNjU1IDE5LjMzODVDNC45MTEwOSAxOC4wOTg5IDMuNzQ5OCAxNi4zNjA5IDMuMjIyNzggMTQuMzk0MUMyLjY5NTc2IDEyLjQyNzIgMi44MzI0NyAxMC4zNDE0IDMuNjExNzEgOC40NjAxOUM0LjM5MDk1IDYuNTc4OTUgNS43NjkxNiA1LjAwNzQgNy41MzI2IDMuOTg5MjhDOS4yOTYwMyAyLjk3MTE2IDExLjM0NjEgMi41NjMzNyAxMy4zNjUgMi44MjkxNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const GoogleIcon: ProIcon;
export { GoogleIcon }
export { GoogleIcon as google }

/**
 * @description App Store, Android, Google, Google Play Store
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjI4MDggMTYuMzExNUwxOS41NzA4IDE0LjQ0OTVDMjAuNTIzNiAxMy45MTAzIDIxIDEyLjk1NTIgMjEgMTJDMjEgMTEuMDQ0OCAyMC41MjM2IDEwLjA4OTcgMTkuNTcwOCA5LjU1MDQ3TDE2LjI4MDggNy42ODg1NU0xNi4yODA4IDE2LjMxMTVMOC4yMDc5MyAyMC44OEM3LjI3OTg0IDIxLjQwNTMgNi4yNDE5NCAyMS4zNDAzIDUuNDI5MTUgMjAuODhDNS4xNjkxNSAyMC43MzI4IDQuOTMyMTkgMjAuNTQ1MiA0LjcyOTIzIDIwLjMyMzRNMTYuMjgwOCAxNi4zMTE1TDQuNzI5MjQgMy42NzY1OE00LjcyOTIzIDIwLjMyMzRDNC4yODIxMyAxOS44MzUgNCAxOS4xODEzIDQgMTguNDMwNUw0IDUuNTY5NDhDNCA0LjY0NjY1IDQuNDI2MjYgMy44NzA0OCA1LjA2MTE3IDMuMzY3NjVDNS45MTAzNyAyLjY5NTExIDcuMTMyODIgMi41MTE1MiA4LjIwNzkzIDMuMTE5OTVMMTYuMjgwOCA3LjY4ODU1TTQuNzI5MjMgMjAuMzIzNEwxNi4yODA4IDcuNjg4NTUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const GooglePlayIcon: ProIcon;
export { GooglePlayIcon }
export { GooglePlayIcon as googlePlay }

/**
 * @description Stocks, Data
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNSA0VjE3LjVDMy41IDE5LjE1NjkgNC44NDMxNSAyMC41IDYuNSAyMC41SDIwIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTYuNSAxNUwxMSAxMC41TDE0LjUgMTRMMjAgOC41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const GraphIcon: ProIcon;
export { GraphIcon }
export { GraphIcon as graph }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNSIgY3k9IjUiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjUiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxOSIgY3k9IjUiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSI1IiBjeT0iMTIiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjEyIiByPSIxLjUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTkiIGN5PSIxMiIgcj0iMS41IiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjUiIGN5PSIxOSIgcj0iMS41IiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iMTkiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxOSIgY3k9IjE5IiByPSIxLjUiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const GridDotsIcon: ProIcon;
export { GridDotsIcon }
export { GridDotsIcon as gridDots }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMTMuNzUiIHdpZHRoPSI2LjUiIGhlaWdodD0iNi41IiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjEzLjc1IiB5PSIxMy43NSIgd2lkdGg9IjYuNSIgaGVpZ2h0PSI2LjUiIHJ4PSIyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjYuNSIgaGVpZ2h0PSI2LjUiIHJ4PSIyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMTMuNzUiIHk9IjMuNzUiIHdpZHRoPSI2LjUiIGhlaWdodD0iNi41IiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const GridIcon: ProIcon;
export { GridIcon }
export { GridIcon as grid }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDMuNzIzNjlDNy42OTc5OSAzLjcyMzY5IDQuMjEwNTMgNi43NzUyMyA0LjIxMDUzIDEwLjUzOTVIMTkuNzg5NUMxOS43ODk1IDYuNzc1MjMgMTYuMzAyIDMuNzIzNjkgMTIgMy43MjM2OVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIyLjc1IiB5PSIxMC41Mzk1IiB3aWR0aD0iMTguNSIgaGVpZ2h0PSI1LjM1NTI2IiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik00LjIxMDUzIDE1Ljg5NDdIMTkuNzg5NUwxOS41MTE5IDE3LjE0NEMxOS4xMDUxIDE4Ljk3NDIgMTcuNDgxOSAyMC4yNzYzIDE1LjYwNzEgMjAuMjc2M0g4LjM5Mjg5QzYuNTE4MSAyMC4yNzYzIDQuODk0ODUgMTguOTc0MiA0LjQ4ODE1IDE3LjE0NEw0LjIxMDUzIDE1Ljg5NDdaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjEzNTUgMTMuMDYxNkwxMi45NzM3IDEwLjUzOTVIMTguODE1OEwxNi42NTQgMTMuMDYxNkMxNi4yNTQ5IDEzLjUyNzIgMTUuNTM0NiAxMy41MjcyIDE1LjEzNTUgMTMuMDYxNloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const HamburgerIcon: ProIcon;
export { HamburgerIcon }
export { HamburgerIcon as hamburger }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQgMTAuMDU5VjEzLjQ4MjdDNCAxNS4zMzYgNCAxNi4yNjI3IDQuMjIxMDggMTcuMDE4N0M0Ljc0NzY0IDE4LjgxOTMgNi4xNTU2NyAyMC4yMzUgNy45NTYyOSAyMC44NjVDOC41NTY5MyAyMS4wNDA3IDkuMTUxNzkgMjEuMjI3NiAxMC4zMDAzIDIxLjM5NzNDMTAuOTY5MyAyMS40OTYxIDExLjY1MTUgMjEuNDY2MyAxMi4zMTQxIDIxLjMzMTFDMTIuNjE3IDIxLjI2OTQgMTIuODY0MyAyMS4yMTYgMTMuMDcxNiAyMS4xNzEyQzEzLjU2MjEgMjEuMDY1MyAxNC4wNTIgMjAuOTM4MSAxNC41MDI2IDIwLjcxNzRDMTUuMDA5NyAyMC40NjkgMTUuNDA0OSAyMC4yMTExIDE1Ljk3NzUgMTkuNzgzOEMxNi4zMTkgMTkuNTI5IDE2LjYzMTYgMTkuMjE4IDE3LjI1NjkgMTguNTk1OUwyMC41MDM4IDE1LjM2NTZDMjEuMTY1NCAxNC43MDc0IDIxLjE2NTQgMTMuNjQwMyAyMC41MDM4IDEyLjk4MjJDMTkuODQyMyAxMi4zMjQgMTguNzY5NyAxMi4zMjQgMTguMTA4MiAxMi45ODIyTDE1Ljg1NzkgMTUuMjIxVjEwLjA1OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMi44OTM0IDcuODUyMTRWNS45NDk2M0MxMi44OTM0IDUuMTM1MiAxMy41NTcxIDQuNDc0OTggMTQuMzc1NyA0LjQ3NDk4QzE1LjE5NDMgNC40NzQ5OCAxNS44NTc5IDUuMTM1MiAxNS44NTc5IDUuOTQ5NjNWMTAuMzczNiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik05LjkyODk2IDEwLjA1NVYzLjk0OTYzQzkuOTI4OTYgMy4xMzUyIDEwLjU5MjYgMi40NzQ5OCAxMS40MTEyIDIuNDc0OThDMTIuMjI5OCAyLjQ3NDk4IDEyLjg5MzQgMy4xMzUyIDEyLjg5MzQgMy45NDk2M1YxMC4wNTg5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTYuOTY0NDggNy4zMjAyNlYxMC4wNTg5VjQuOTU0OThDNi45NjQ0OCA0LjE0MDU1IDcuNjI4MSAzLjQ3NDk4IDguNDQ2NzEgMy40NzQ5OEM5LjI2NTMzIDMuNDc0OTggOS45Mjg5NCA0LjE0MDU1IDkuOTI4OTQgNC45NTQ5OFYxMC4wNTg5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTYuOTY0NDcgOC44NTQzNFY3Ljk0OTYzQzYuOTY0NDcgNy4xMzUyIDYuMzAwODUgNi40NzQ5OCA1LjQ4MjIzIDYuNDc0OThDNC42NjM2MiA2LjQ3NDk4IDQgNy4xMzUyIDQgNy45NDk2M1YxMC42ODgzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const HandIcon: ProIcon;
export { HandIcon }
export { HandIcon as hand }

/**
 * @description Disk, SSD, HDD, Macintosh HD
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjI1IDE2Ljc1VjE5LjI1QzIxLjI1IDIwLjM1NDYgMjAuMzU0NiAyMS4yNSAxOS4yNSAyMS4yNUg0Ljc1QzMuNjQ1NDMgMjEuMjUgMi43NSAyMC4zNTQ2IDIuNzUgMTkuMjVWMTYuNzVNMjEuMjUgMTYuNzVDMjEuMjUgMTUuNjQ1NCAyMC4zNTQ2IDE0Ljc1IDE5LjI1IDE0Ljc1SDQuNzVDMy42NDU0MyAxNC43NSAyLjc1IDE1LjY0NTQgMi43NSAxNi43NU0yMS4yNSAxNi43NVYxNS4xMTkzQzIxLjI1IDE0Ljg3NCAyMS4yMTk5IDE0LjYyOTcgMjEuMTYwNCAxNC4zOTE3TDE4LjgxODEgNS4wMjIzOUMxOC40ODQyIDMuNjg2ODkgMTcuMjg0MyAyLjc1IDE1LjkwNzcgMi43NUg4LjA5MjMzQzYuNzE1NzMgMi43NSA1LjUxNTc4IDMuNjg2ODkgNS4xODE5IDUuMDIyMzlMMi44Mzk1NyAxNC4zOTE3QzIuNzgwMDggMTQuNjI5NyAyLjc1IDE0Ljg3NCAyLjc1IDE1LjExOTNWMTYuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSIxOCIgY3k9IjE4IiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const HardDriveIcon: ProIcon;
export { HardDriveIcon }
export { HardDriveIcon as hardDrive }

/**
 * @description Hashtag, Tag, Category, Number, Count, Pound
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzc3ODMgOC4zOTQ3OEwyMS4yNTAxIDguMzk0NzgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAxNS42MDUzTDIwLjIyMjIgMTUuNjA1MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02LjI4MjQ3IDIxLjEzTDkuNDk0OTYgMi44NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC41MDQ2IDIxLjEzTDE3LjcxNzEgMi44NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const HashIcon: ProIcon;
export { HashIcon }
export { HashIcon as hash }

/**
 * @description Education, Diplomat, Student, Learning
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNjUxNzcgMTQuNzEzN1Y5Ljc4MTI1TTUuODMxODEgMTEuODUwMkw5Ljg4MDYzIDE0LjUxODVDMTEuMjE2MSAxNS4zOTg3IDEyLjk0NzUgMTUuMzk4NyAxNC4yODI5IDE0LjUxODZMMTguMzMxOCAxMS44NTAyTTUuODMxODEgMTEuODUwMkwzLjA5ODY0IDEwLjA0ODhDMi44MDUyMyA5Ljg1NTQ4IDIuNjU1MzkgOS41NDYxMiAyLjY0OTEzIDkuMjM0MjhNNS44MzE4MSAxMS44NTAyVjEyLjE2OTdWMTYuOTExQzUuODMxODEgMTcuNDA2MSA1Ljk1MDcyIDE3Ljg5NzkgNi4yNzE4MSAxOC4yNzQ3QzcuMDE5MTEgMTkuMTUxNyA4Ljc4NjE3IDIwLjY2NTEgMTIuMDgxOCAyMC42NjUxQzE1LjM3NzUgMjAuNjY1MSAxNy4xNDQ1IDE5LjE1MTcgMTcuODkxOCAxOC4yNzQ3QzE4LjIxMjkgMTcuODk3OSAxOC4zMzE4IDE3LjQwNjEgMTguMzMxOCAxNi45MTFWMTIuMTY5N1YxMS44NTAyTTE4LjMzMTggMTEuODUwMkwyMC44MTE2IDEwLjIxNTlDMjEuNTMxMSA5Ljc0MTY1IDIxLjUzMTEgOC42ODYwNiAyMC44MTE1IDguMjExODlMMTQuMjgyNiAzLjkwOTlDMTIuOTQ3MyAzLjAzMDAzIDExLjIxNjMgMy4wMzAwMyA5Ljg4MDkzIDMuOTA5OTFMMy4wOTg3MSA4LjM3ODg1QzIuNzkyNDYgOC41ODA2NSAyLjY0MjU5IDguOTA4ODEgMi42NDkxMyA5LjIzNDI4TTIuNjQ5MTMgOS4yMzQyOFY5Ljc4MTI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const HatGraduationIcon: ProIcon;
export { HatGraduationIcon }
export { HatGraduationIcon as hatGraduation }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjI1IDE3LjM2ODNWMTJDMjEuMjUgNi44OTEzNyAxNy4xMDg2IDIuNzUgMTIgMi43NVYyLjc1QzYuODkxMzcgMi43NSAyLjc1IDYuODkxMzYgMi43NSAxMlYxNy4zNjgzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTMuMzIxNEg2Ljc1QzcuNTc4NDMgMTMuMzIxNCA4LjI1IDEzLjk5MyA4LjI1IDE0LjgyMTRWMTkuMjVDOC4yNSAyMC4zNTQ2IDcuMzU0NTcgMjEuMjUgNi4yNSAyMS4yNUg0Ljc1QzMuNjQ1NDMgMjEuMjUgMi43NSAyMC4zNTQ2IDIuNzUgMTkuMjVWMTMuMzIxNFoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuNzUgMTQuODIxNEMxNS43NSAxMy45OTMgMTYuNDIxNiAxMy4zMjE0IDE3LjI1IDEzLjMyMTRIMjEuMjVWMTkuMjVDMjEuMjUgMjAuMzU0NiAyMC4zNTQ2IDIxLjI1IDE5LjI1IDIxLjI1SDE3Ljc1QzE2LjY0NTQgMjEuMjUgMTUuNzUgMjAuMzU0NiAxNS43NSAxOS4yNVYxNC44MjE0WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const HeadphonesIcon: ProIcon;
export { HeadphonesIcon }
export { HeadphonesIcon as headphones }

/**
 * @description Audio
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3Ljc1IDIxLjI0OTlIMTkuMjVDMTkuNTI2NCAyMS4yNDk5IDE5Ljc4OTggMjEuMTkzOCAyMC4wMjkzIDIxLjA5MjRMMTUuNzUgMTYuODEzMVYxOS4yNDk5QzE1Ljc1IDIwLjM1NDUgMTYuNjQ1NCAyMS4yNDk5IDE3Ljc1IDIxLjI0OTlaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0yMS4yNSAxMy4zMjEzVjExLjk5OTlDMjEuMjUgNi44OTEyNCAxNy4xMDg2IDIuNzQ5ODggMTIgMi43NDk4OEMxMC4yNDk3IDIuNzQ5ODggOC42MTI5NSAzLjIzNiA3LjIxNzQgNC4wODA2TTIxLjI1IDEzLjMyMTNIMTcuMjVDMTYuNDIxNSAxMy4zMjEzIDE1Ljc1IDEzLjk5MjkgMTUuNzUgMTQuODIxM1YxNi44MTMxTTIxLjI1IDEzLjMyMTNWMTguMDg1OE0yLjc0OTk3IDE3LjM2ODJWMTEuOTk5OUMyLjc0OTk3IDkuNzE2MTkgMy41Nzc1NCA3LjYyNTc5IDQuOTQ5MTUgNi4wMTIyM00xNS43NSAxNi44MTMxVjE5LjI0OTlDMTUuNzUgMjAuMzU0NSAxNi42NDU0IDIxLjI0OTkgMTcuNzUgMjEuMjQ5OUgxOS4yNUMxOS41MjY0IDIxLjI0OTkgMTkuNzg5OCAyMS4xOTM4IDIwLjAyOTMgMjEuMDkyNE0xNS43NSAxNi44MTMxTDIwLjAyOTMgMjEuMDkyNE0xNS43NSAxNi44MTMxTDQuOTQ5MTUgNi4wMTIyM000Ljk0OTE1IDYuMDEyMjNMMi4yMTgzOSAzLjI4MTQ4TTIwLjcxODQgMjEuNzgxNUwyMC4wMjkzIDIxLjA5MjRNMi43NDk5NiAxMy4zMjE0SDYuNzQ5OTZDNy41NzgzOSAxMy4zMjE0IDguMjQ5OTYgMTMuOTkzIDguMjQ5OTYgMTQuODIxNFYxOS4yNUM4LjI0OTk2IDIwLjM1NDUgNy4zNTQ1MyAyMS4yNSA2LjI0OTk2IDIxLjI1SDQuNzQ5OTZDMy42NDUzOSAyMS4yNSAyLjc0OTk2IDIwLjM1NDUgMi43NDk5NiAxOS4yNVYxMy4zMjE0WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const HeadphonesOffIcon: ProIcon;
export { HeadphonesOffIcon }
export { HeadphonesOffIcon as headphonesOff }

/**
 * @description Love, Like, Favorite
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuMDg3MTQgNi40Nzc0NEM1Ljg2OTk5IDQuNjk0NTkgOC43NjA1NSA0LjY5NDU5IDEwLjU0MzQgNi40Nzc0NEwxMiA3LjkzNDA0TDEzLjQ1NjYgNi40Nzc0NEMxNS4yMzk0IDQuNjk0NTkgMTguMTMgNC42OTQ1OSAxOS45MTI5IDYuNDc3NDRDMjEuNjk1NyA4LjI2MDI5IDIxLjY5NTcgMTEuMTUwOSAxOS45MTI5IDEyLjkzMzdMMTguNDU2MyAxNC4zOTAzTDE4LjQ2OTQgMTQuNDAzNEwxMi4wMTMxIDIwLjg1OTdMMTIgMjAuODQ2NkwxMS45ODY5IDIwLjg1OTdMNS41MzA2MSAxNC40MDM0TDUuNTQzNzMgMTQuMzkwM0w0LjA4NzE0IDEyLjkzMzdDMi4zMDQyOSAxMS4xNTA5IDIuMzA0MjkgOC4yNjAyOSA0LjA4NzE0IDYuNDc3NDRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const HeartIcon: ProIcon;
export { HeartIcon }
export { HeartIcon as heart }

/**
 * @description Love
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDcuOTM0MDRMMTAuNTQzNCA2LjQ3NzQ0QzguNzYwNTUgNC42OTQ1OSA1Ljg2OTk4IDQuNjk0NTkgNC4wODcxNCA2LjQ3NzQ0QzIuMzA0MjkgOC4yNjAyOSAyLjMwNDI5IDExLjE1MDkgNC4wODcxNCAxMi45MzM3TDUuNTQzNzMgMTQuMzkwM00xMiA3LjkzNDA0TDEzLjQ1NjYgNi40Nzc0NEMxNS4yMzk0IDQuNjk0NTkgMTguMTMgNC42OTQ1OSAxOS45MTI5IDYuNDc3NDRDMjEuNjk1NyA4LjI2MDI5IDIxLjY5NTcgMTEuMTUwOSAxOS45MTI5IDEyLjkzMzdMMTguNDU2MyAxNC4zOTAzTDE4LjQ2OTQgMTQuNDAzNEwxMi4wMTMxIDIwLjg1OTdMMTIgMjAuODQ2NkwxMS45ODY5IDIwLjg1OTdMNS41MzA2MSAxNC40MDM0TDUuNTQzNzMgMTQuMzkwM00xMiA3LjkzNDA0TDUuNTQzNzMgMTQuMzkwMyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const HeartStylisticIcon: ProIcon;
export { HeartStylisticIcon }
export { HeartStylisticIcon as heartStylistic }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjQyMDggMy4xNzMxNUMxMS4zOTggMi42MDg5NSAxMi42MDIgMi42MDg5NSAxMy41NzkyIDMuMTczMTVMMTguODU0NyA2LjIxODkyQzE5LjgzMTkgNi43ODMxMyAyMC40MzM5IDcuODI1ODIgMjAuNDMzOSA4Ljk1NDI0VjE1LjA0NThDMjAuNDMzOSAxNi4xNzQyIDE5LjgzMTkgMTcuMjE2OSAxOC44NTQ3IDE3Ljc4MTFMMTMuNTc5MiAyMC44MjY4QzEyLjYwMiAyMS4zOTExIDExLjM5OCAyMS4zOTExIDEwLjQyMDggMjAuODI2OEw1LjE0NTM1IDE3Ljc4MTFDNC4xNjgxMiAxNy4yMTY5IDMuNTY2MTIgMTYuMTc0MiAzLjU2NjEyIDE1LjA0NThWOC45NTQyNEMzLjU2NjEyIDcuODI1ODIgNC4xNjgxMiA2Ljc4MzEzIDUuMTQ1MzUgNi4yMTg5MkwxMC40MjA4IDMuMTczMTVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const HexagonIcon: ProIcon;
export { HexagonIcon }
export { HexagonIcon as hexagon }

/**
 * @description Marker
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjI1IDYuMjVWMi43NUgzLjc1VjYuMjVDMy43NSA4LjE4MyA1LjMxNyA5Ljc1IDcuMjUgOS43NUgxNi43NUMxOC42ODMgOS43NSAyMC4yNSA4LjE4MyAyMC4yNSA2LjI1WiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTYuMjUgMTMuNzVINy43NVYxOS40MTI2QzcuNzUgMjAuMzA5NSA4LjYzNjg2IDIwLjkzNyA5LjQ4MjY2IDIwLjYzODVMMTQuOTE1NiAxOC43MjFDMTUuNzE1MyAxOC40Mzg3IDE2LjI1IDE3LjY4MjkgMTYuMjUgMTYuODM1VjEzLjc1WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const HighlighterAccentIcon: ProIcon;
export { HighlighterAccentIcon }
export { HighlighterAccentIcon as highlighterAccent }

/**
 * @description Marker
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMi43NVY2LjI1QzMuNzUgOC4xODMgNS4zMTcgOS43NSA3LjI1IDkuNzVIMTYuNzVDMTguNjgzIDkuNzUgMjAuMjUgOC4xODMgMjAuMjUgNi4yNVYyLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTUuNzUgOS43NUgxOC4yNVYxMS41NUMxOC4yNSAxMi43NjUgMTcuMjY1IDEzLjc1IDE2LjA1IDEzLjc1SDcuOTVDNi43MzQ5NyAxMy43NSA1Ljc1IDEyLjc2NSA1Ljc1IDExLjU1VjkuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE2LjI1IDEzLjc1SDcuNzVWMTkuNDEyNkM3Ljc1IDIwLjMwOTUgOC42MzY4NiAyMC45MzcgOS40ODI2NiAyMC42Mzg1TDE0LjkxNTYgMTguNzIxQzE1LjcxNTMgMTguNDM4NyAxNi4yNSAxNy42ODI5IDE2LjI1IDE2LjgzNVYxMy43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const HighlighterIcon: ProIcon;
export { HighlighterIcon }
export { HighlighterIcon as highlighter }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTExLjI1IDcuNzVWMTIuNzVIMTQuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNC44NTUyOSA3Ljg3NUM1LjgwOTYzIDYuMjIyMDMgNy4zMDc1OSA0Ljk1MTExIDkuMDkzOTQgNC4yNzg3OEMxMC44ODAzIDMuNjA2NDQgMTIuODQ0NSAzLjU3NDMgMTQuNjUxOSA0LjE4NzgzQzE2LjQ1OTMgNC44MDEzNSAxNy45OTggNi4wMjI1OCAxOS4wMDU5IDcuNjQzNDRDMjAuMDEzOCA5LjI2NDI5IDIwLjQyODYgMTEuMTg0NSAyMC4xNzk0IDEzLjA3NjhDMTkuOTMwMyAxNC45NjkyIDE5LjAzMjcgMTYuNzE2NiAxNy42Mzk2IDE4LjAyMTRDMTYuMjQ2NiAxOS4zMjYxIDE0LjQ0NDIgMjAuMTA3NSAxMi41Mzk2IDIwLjIzMjNDMTAuNjM1IDIwLjM1NzIgOC43NDYwMyAxOS44MTc4IDcuMTk0NTYgMTguNzA2QzUuNjQzMSAxNy41OTQyIDQuNTI1MTIgMTUuOTc4OSA0LjAzMTExIDE0LjEzNTMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy44NTUyMiA4Ljg3NVY0LjEyNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0zLjg1NTIyIDguODc1TDguNjA1MjIgOC44NzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const HistoryIcon: ProIcon;
export { HistoryIcon }
export { HistoryIcon as history }

/**
 * @description House
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjcwOTcgMTguNjVWMTEuMDI4NEMyMC43MDk3IDEwLjEwNTggMjAuMjg1MiA5LjIzNDU1IDE5LjU1ODcgOC42NjU5M0wxMy4yMzI3IDMuNzE0NzdDMTIuNTA4NiAzLjE0ODA2IDExLjQ5MTQgMy4xNDgwNiAxMC43NjczIDMuNzE0NzdMNC40NDEzIDguNjY1OTNDMy43MTQ4IDkuMjM0NTUgMy4yOTAzMSAxMC4xMDU4IDMuMjkwMzEgMTEuMDI4NFYxOC42NUMzLjI5MDMxIDE5LjgwOTggNC4yMzA1MSAyMC43NSA1LjM5MDMxIDIwLjc1SDkuMzYwN1YxMi43ODQ2SDE0LjYzOTNWMjAuNzVIMTguNjA5N0MxOS43Njk1IDIwLjc1IDIwLjcwOTcgMTkuODA5OCAyMC43MDk3IDE4LjY1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const Home2Icon: ProIcon;
export { Home2Icon }
export { Home2Icon as home2 }

/**
 * @description House
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjI5MDMgMjAuNjYzSDE4LjMwNjVDMTkuNTE3OSAyMC42NjMgMjAuNSAxOS42ODA5IDIwLjUgMTguNDY5NFYxMi4wMTU0QzIwLjUgMTEuMDY0IDIwLjA4ODIgMTAuMTU5MSAxOS4zNzA3IDkuNTM0MjRMMTMuNDQwNyA0LjM2OTM5QzEyLjYxNDkgMy42NTAxNCAxMS4zODUxIDMuNjUwMTQgMTAuNTU5MyA0LjM2OTM5TDQuNjI5MyA5LjUzNDI0QzMuOTExODQgMTAuMTU5MSAzLjUgMTEuMDY0IDMuNSAxMi4wMTU0VjE4LjQ2OTRDMy41IDE5LjY4MDkgNC40ODIwOSAyMC42NjMgNS42OTM1NSAyMC42NjNIOC45ODM4N00xNS4yOTAzIDIwLjY2M1YyMC4xMTQ2VjE0LjA4MjNDMTUuMjkwMyAxMy4xNzM3IDE0LjU1MzggMTIuNDM3MiAxMy42NDUyIDEyLjQzNzJIMTAuNjI5QzkuNzIwNDMgMTIuNDM3MiA4Ljk4Mzg3IDEzLjE3MzcgOC45ODM4NyAxNC4wODIzVjIwLjExNDZWMjAuNjYzTTE1LjI5MDMgMjAuNjYzSDguOTgzODciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const HomeIcon: ProIcon;
export { HomeIcon }
export { HomeIcon as home }

/**
 * @description Time, Timer
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuMDk0NzMgMy4yOTc3NUwxOS45MDUzIDMuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNC4wOTQ3MyAyMC43NUwxOS45MDUzIDIwLjcwMjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTguNDI2MiAzLjMxMDU1SDUuNTczNzNMNS42NTMgNC43NTg2OUM1Ljc1NTAyIDYuNjIyMjkgNi41NTk1MSA4LjM3Nzk5IDcuOTA0NDEgOS42NzIwOEw5LjE0NjMzIDEwLjg2NzFDOS43OTI3NCAxMS40ODkxIDkuNzkyNzQgMTIuNTIzNyA5LjE0NjMzIDEzLjE0NTdMNy45MDQ0MSAxNC4zNDA3QzYuNTU5NTEgMTUuNjM0OCA1Ljc1NTAyIDE3LjM5MDUgNS42NTMgMTkuMjU0MUw1LjU3MzczIDIwLjcwMjJIMTguNDI2MkwxOC4zNDcxIDE5LjI1NzRDMTguMjQ1IDE3LjM5MTggMTcuNDM4OSAxNS42MzQ0IDE2LjA5MTUgMTQuMzRMMTQuODQ5MyAxMy4xNDY1QzE0LjIwMTcgMTIuNTI0NCAxNC4yMDE3IDExLjQ4ODQgMTQuODQ5MyAxMC44NjYyTDE2LjA5MTUgOS42NzI3NkMxNy40Mzg5IDguMzc4MzQgMTguMjQ1IDYuNjIwOTQgMTguMzQ3MSA0Ljc1NTMzTDE4LjQyNjIgMy4zMTA1NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const HourglassIcon: ProIcon;
export { HourglassIcon }
export { HourglassIcon as hourglass }

/**
 * @description HTML5, Markup, Programming, Web
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjc1NDEgNC43OTIwOEwxNy45MTMyIDE5LjEwMjVDMTcuODAwOSAxOS42Njg0IDE3LjM3MzkgMjAuMTE5NyAxNi44MTUxIDIwLjI2MzNMMTIuMzczMiAyMS40MDQyQzEyLjEyODQgMjEuNDY3IDExLjg3MTYgMjEuNDY3IDExLjYyNjggMjEuNDA0Mkw3LjE4NDkzIDIwLjI2MzNDNi42MjYxMSAyMC4xMTk3IDYuMTk5MTUgMTkuNjY4NCA2LjA4NjggMTkuMTAyNUwzLjI0NTkgNC43OTIwOEMzLjA2MTc1IDMuODY0NDggMy43NzE0OSAzIDQuNzE3MTkgM0gxMkgxOS4yODI4QzIwLjIyODUgMyAyMC45MzgzIDMuODY0NDggMjAuNzU0MSA0Ljc5MjA4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNy4yOTk5IDYuODgwOThIOC45NDM4OUM4LjMyODA0IDYuODgwOTggNy44NTg1NiA3LjQzMjMgNy45NTY2NiA4LjA0MDI5TDguNTMzODYgMTEuNjE3M0M4LjYxMjA1IDEyLjEwMTggOS4wMzAzIDEyLjQ1OCA5LjUyMTEgMTIuNDU4SDE0Ljg5NDZDMTUuNTI5NCAxMi40NTggMTYuMDAzNiAxMy4wNDE5IDE1Ljg3MzMgMTMuNjYzM0wxNS4zMTA1IDE2LjM0NTdDMTUuMjM4MyAxNi42OTAxIDE0Ljk5MDMgMTYuOTcxMiAxNC42NTc1IDE3LjA4NTlMMTIuMzc1MSAxNy44NzIxQzEyLjE2MDkgMTcuOTQ1OSAxMS45MjggMTcuOTQ0OCAxMS43MTQ2IDE3Ljg2ODlMOC45OTA5MyAxNi45MDExIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const HtmlIcon: ProIcon;
export { HtmlIcon }
export { HtmlIcon as html }

export declare const iconList: string[];

declare type IconNode = [string, Record<string, string>, IconNode[]];

declare namespace icons {
    export {
        AccessibilityIcon,
        AccessibilityIcon as accessibility,
        AddCircularIcon,
        AddCircularIcon as addCircular,
        AddRhombusIcon,
        AddRhombusIcon as addRhombus,
        AddSquareMultipleIcon,
        AddSquareMultipleIcon as addSquareMultiple,
        AddSquareMultipleIcon as AddSquareMultipleVarIcon,
        AddSquareMultipleIcon as addSquareMultipleVar,
        AddSquareIcon,
        AddSquareIcon as addSquare,
        AddIcon,
        AddIcon as add,
        AddIcon as PlusIcon,
        AddIcon as plus,
        AddIcon as CreateIcon,
        AddIcon as create,
        AddIcon as AdditionIcon,
        AddIcon as addition,
        AirplaneLandingIcon,
        AirplaneLandingIcon as airplaneLanding,
        AirplaneTakeoffIcon,
        AirplaneTakeoffIcon as airplaneTakeoff,
        AirplaneIcon,
        AirplaneIcon as airplane,
        AlertCircleIcon,
        AlertCircleIcon as alertCircle,
        AlertTriangleIcon,
        AlertTriangleIcon as alertTriangle,
        AlignBottomIcon,
        AlignBottomIcon as alignBottom,
        AlignHorizontalCentersIcon,
        AlignHorizontalCentersIcon as alignHorizontalCenters,
        AlignLeftIcon,
        AlignLeftIcon as alignLeft,
        AlignRightIcon,
        AlignRightIcon as alignRight,
        AlignTopIcon,
        AlignTopIcon as alignTop,
        AlignVerticalCentersIcon,
        AlignVerticalCentersIcon as alignVerticalCenters,
        AmazonIcon,
        AmazonIcon as amazon,
        AnchorIcon,
        AnchorIcon as anchor,
        AndroidIcon,
        AndroidIcon as android,
        AngleIcon,
        AngleIcon as angle,
        AppRemoveIcon,
        AppRemoveIcon as appRemove,
        AppStoreIcon,
        AppStoreIcon as appStore,
        AppleIcon,
        AppleIcon as apple,
        AppsAddIcon,
        AppsAddIcon as appsAdd,
        AppsListIcon,
        AppsListIcon as appsList,
        AppsIcon,
        AppsIcon as apps,
        ArcIcon,
        ArcIcon as arc,
        ArchiveAdd2Icon,
        ArchiveAdd2Icon as archiveAdd2,
        ArchiveIcon,
        ArchiveIcon as archive,
        ArrowClockwiseIcon,
        ArrowClockwiseIcon as arrowClockwise,
        ArrowCounterclockwiseIcon,
        ArrowCounterclockwiseIcon as arrowCounterclockwise,
        ArrowDownIcon,
        ArrowDownIcon as arrowDown,
        ArrowDownloadIcon,
        ArrowDownloadIcon as arrowDownload,
        ArrowEnterIcon,
        ArrowEnterIcon as arrowEnter,
        ArrowExportIcon,
        ArrowExportIcon as arrowExport,
        ArrowFowardIcon,
        ArrowFowardIcon as arrowFoward,
        ArrowImportIcon,
        ArrowImportIcon as arrowImport,
        ArrowLeftRightIcon,
        ArrowLeftRightIcon as arrowLeftRight,
        ArrowLeftIcon,
        ArrowLeftIcon as arrowLeft,
        ArrowMaximizeIcon,
        ArrowMaximizeIcon as arrowMaximize,
        ArrowMinimizeIcon,
        ArrowMinimizeIcon as arrowMinimize,
        ArrowMoveIcon,
        ArrowMoveIcon as arrowMove,
        ArrowRedo2Icon,
        ArrowRedo2Icon as arrowRedo2,
        ArrowRedoIcon,
        ArrowRedoIcon as arrowRedo,
        ArrowReplyIcon,
        ArrowReplyIcon as arrowReply,
        ArrowRightIcon,
        ArrowRightIcon as arrowRight,
        ArrowRotateClockwiseIcon,
        ArrowRotateClockwiseIcon as arrowRotateClockwise,
        ArrowRotateCounterclockwiseIcon,
        ArrowRotateCounterclockwiseIcon as arrowRotateCounterclockwise,
        ArrowSortIcon,
        ArrowSortIcon as arrowSort,
        ArrowSwapIcon,
        ArrowSwapIcon as arrowSwap,
        ArrowSync2Icon,
        ArrowSync2Icon as arrowSync2,
        ArrowSyncIcon,
        ArrowSyncIcon as arrowSync,
        ArrowTrendingIcon,
        ArrowTrendingIcon as arrowTrending,
        ArrowUndo2Icon,
        ArrowUndo2Icon as arrowUndo2,
        ArrowUndoIcon,
        ArrowUndoIcon as arrowUndo,
        ArrowUpDownIcon,
        ArrowUpDownIcon as arrowUpDown,
        ArrowUpIcon,
        ArrowUpIcon as arrowUp,
        ArrowUploadIcon,
        ArrowUploadIcon as arrowUpload,
        AttatchIcon,
        AttatchIcon as attatch,
        BackgroundColorAccentIcon,
        BackgroundColorAccentIcon as backgroundColorAccent,
        BackgroundColorIcon,
        BackgroundColorIcon as backgroundColor,
        BackspaceIcon,
        BackspaceIcon as backspace,
        BadgeIcon,
        BadgeIcon as badge,
        BarGraphIcon,
        BarGraphIcon as barGraph,
        BatteryFullIcon,
        BatteryFullIcon as batteryFull,
        BatteryIcon,
        BatteryIcon as battery,
        BeachIcon,
        BeachIcon as beach,
        BeakerIcon,
        BeakerIcon as beaker,
        BellDotIcon,
        BellDotIcon as bellDot,
        BellOffIcon,
        BellOffIcon as bellOff,
        BellIcon,
        BellIcon as bell,
        BluetoothIcon,
        BluetoothIcon as bluetooth,
        BoardIcon,
        BoardIcon as board,
        BoltIcon,
        BoltIcon as bolt,
        Book2Icon,
        Book2Icon as book2,
        BookAdd2Icon,
        BookAdd2Icon as bookAdd2,
        BookAddIcon,
        BookAddIcon as bookAdd,
        BookInfo2Icon,
        BookInfo2Icon as bookInfo2,
        BookInfoIcon,
        BookInfoIcon as bookInfo,
        BookOpenIcon,
        BookOpenIcon as bookOpen,
        BookIcon,
        BookIcon as book,
        BookmarkAddIcon,
        BookmarkAddIcon as bookmarkAdd,
        BookmarkMultipleIcon,
        BookmarkMultipleIcon as bookmarkMultiple,
        BookmarkMultipleIcon as BookmarkMultipleVarIcon,
        BookmarkMultipleIcon as bookmarkMultipleVar,
        BookmarkIcon,
        BookmarkIcon as bookmark,
        BorderAllIcon,
        BorderAllIcon as borderAll,
        BoxDragIcon,
        BoxDragIcon as boxDrag,
        BoxMarginsIcon,
        BoxMarginsIcon as boxMargins,
        BoxIcon,
        BoxIcon as box,
        BracesVariableIcon,
        BracesVariableIcon as bracesVariable,
        BracesIcon,
        BracesIcon as braces,
        BracketsIcon,
        BracketsIcon as brackets,
        BranchCompareIcon,
        BranchCompareIcon as branchCompare,
        BranchFork2Icon,
        BranchFork2Icon as branchFork2,
        BranchForkIcon,
        BranchForkIcon as branchFork,
        BranchPullRequestIcon,
        BranchPullRequestIcon as branchPullRequest,
        BranchIcon,
        BranchIcon as branch,
        Briefcase2Icon,
        Briefcase2Icon as briefcase2,
        BriefcaseIcon,
        BriefcaseIcon as briefcase,
        BrightnessIcon,
        BrightnessIcon as brightness,
        BroomIcon,
        BroomIcon as broom,
        BugIcon,
        BugIcon as bug,
        BuildingMultipleIcon,
        BuildingMultipleIcon as buildingMultiple,
        ButtonIcon,
        ButtonIcon as button,
        CakeIcon,
        CakeIcon as cake,
        CalculatorIcon,
        CalculatorIcon as calculator,
        CalendarIcon,
        CalendarIcon as calendar,
        CalligraphyPenIcon,
        CalligraphyPenIcon as calligraphyPen,
        CameraIcon,
        CameraIcon as camera,
        CancelCircleIcon,
        CancelCircleIcon as cancelCircle,
        CancelSquareIcon,
        CancelSquareIcon as cancelSquare,
        CancelIcon,
        CancelIcon as cancel,
        CancelIcon as XIcon,
        CancelIcon as x,
        CancelIcon as CloseIcon,
        CancelIcon as close,
        CancelIcon as DismissIcon,
        CancelIcon as dismiss,
        CandyIcon,
        CandyIcon as candy,
        CartIcon,
        CartIcon as cart,
        CentIcon,
        CentIcon as cent,
        CenterHorizontalIcon,
        CenterHorizontalIcon as centerHorizontal,
        CenterVerticalIcon,
        CenterVerticalIcon as centerVertical,
        ChatIcon,
        ChatIcon as chat,
        CheckboxCheckedIcon,
        CheckboxCheckedIcon as checkboxChecked,
        CheckboxCheckedIcon as CheckmarkCheckedIcon,
        CheckboxCheckedIcon as checkmarkChecked,
        CheckboxIndeterminate2Icon,
        CheckboxIndeterminate2Icon as checkboxIndeterminate2,
        CheckboxIndeterminate2Icon as CheckboxIntermediate2Icon,
        CheckboxIndeterminate2Icon as checkboxIntermediate2,
        CheckboxIndeterminateIcon,
        CheckboxIndeterminateIcon as checkboxIndeterminate,
        CheckboxIndeterminateIcon as CheckmarkIntermediateIcon,
        CheckboxIndeterminateIcon as checkmarkIntermediate,
        CheckboxUncheckedIcon,
        CheckboxUncheckedIcon as checkboxUnchecked,
        CheckmarkCircleIcon,
        CheckmarkCircleIcon as checkmarkCircle,
        CheckmarkStarburstIcon,
        CheckmarkStarburstIcon as checkmarkStarburst,
        CheckmarkIcon,
        CheckmarkIcon as checkmark,
        ChevronDownIcon,
        ChevronDownIcon as chevronDown,
        ChevronLeftIcon,
        ChevronLeftIcon as chevronLeft,
        ChevronRightIcon,
        ChevronRightIcon as chevronRight,
        ChevronUpIcon,
        ChevronUpIcon as chevronUp,
        ChromeRestoreIcon,
        ChromeRestoreIcon as chromeRestore,
        ChromeRestoreIcon as ChromeRestoreVarIcon,
        ChromeRestoreIcon as chromeRestoreVar,
        CircleSmallIcon,
        CircleSmallIcon as circleSmall,
        CircleIcon,
        CircleIcon as circle,
        ClipboardPasteIcon,
        ClipboardPasteIcon as clipboardPaste,
        ClipboardSearchIcon,
        ClipboardSearchIcon as clipboardSearch,
        ClipboardIcon,
        ClipboardIcon as clipboard,
        ClockIcon,
        ClockIcon as clock,
        ClosedCaptionsIcon,
        ClosedCaptionsIcon as closedCaptions,
        CloudIcon,
        CloudIcon as cloud,
        CodeIcon,
        CodeIcon as code,
        CoffeeHotIcon,
        CoffeeHotIcon as coffeeHot,
        ColorPaletteIcon,
        ColorPaletteIcon as colorPalette,
        CommentExclamationIcon,
        CommentExclamationIcon as commentExclamation,
        CommentMultipleIcon,
        CommentMultipleIcon as commentMultiple,
        CommentMultipleIcon as CommentMultipleVarIcon,
        CommentMultipleIcon as commentMultipleVar,
        CommentIcon,
        CommentIcon as comment,
        CompareSizeIcon,
        CompareSizeIcon as compareSize,
        CompassIcon,
        CompassIcon as compass,
        ComponentIcon,
        ComponentIcon as component,
        ComposeIcon,
        ComposeIcon as compose,
        ComputerMacIcon,
        ComputerMacIcon as computerMac,
        ComputerIcon,
        ComputerIcon as computer,
        ContractDownIcon,
        ContractDownIcon as contractDown,
        CookiesIcon,
        CookiesIcon as cookies,
        CopyIcon,
        CopyIcon as copy,
        CopyIcon as CopyVarIcon,
        CopyIcon as copyVar,
        CopyleftIcon,
        CopyleftIcon as copyleft,
        CopyrightIcon,
        CopyrightIcon as copyright,
        CornerRadiusIcon,
        CornerRadiusIcon as cornerRadius,
        CreditCardIcon,
        CreditCardIcon as creditCard,
        CropIcon,
        CropIcon as crop,
        CssIcon,
        CssIcon as css,
        CursorClickIcon,
        CursorClickIcon as cursorClick,
        CursorDragIcon,
        CursorDragIcon as cursorDrag,
        CursorIcon,
        CursorIcon as cursor,
        CutIcon,
        CutIcon as cut,
        DarkThemeIcon,
        DarkThemeIcon as darkTheme,
        DatabaseAddIcon,
        DatabaseAddIcon as databaseAdd,
        DatabaseIcon,
        DatabaseIcon as database,
        DeleteIcon,
        DeleteIcon as delete,
        DiamondIcon,
        DiamondIcon as diamond,
        DirectionsIcon,
        DirectionsIcon as directions,
        DoNotDisturbIcon,
        DoNotDisturbIcon as doNotDisturb,
        DocumentIcon,
        DocumentIcon as document,
        DollarCircleIcon,
        DollarCircleIcon as dollarCircle,
        DollarIcon,
        DollarIcon as dollar,
        DoorOpenIcon,
        DoorOpenIcon as doorOpen,
        DoorIcon,
        DoorIcon as door,
        DrawTextIcon,
        DrawTextIcon as drawText,
        DropIcon,
        DropIcon as drop,
        EmojiFrownIcon,
        EmojiFrownIcon as emojiFrown,
        EmojiGrinIcon,
        EmojiGrinIcon as emojiGrin,
        EmojiLaughterIcon,
        EmojiLaughterIcon as emojiLaughter,
        EmojiIcon,
        EmojiIcon as emoji,
        EraserIcon,
        EraserIcon as eraser,
        ExpandIcon,
        ExpandIcon as expand,
        ExtensionIcon,
        ExtensionIcon as extension,
        EyeOffIcon,
        EyeOffIcon as eyeOff,
        EyeIcon,
        EyeIcon as eye,
        EyedropperColorAccentIcon,
        EyedropperColorAccentIcon as eyedropperColorAccent,
        EyedropperColorIcon,
        EyedropperColorIcon as eyedropperColor,
        EyedropperIcon,
        EyedropperIcon as eyedropper,
        FacebookIcon,
        FacebookIcon as facebook,
        FastFowardIcon,
        FastFowardIcon as fastFoward,
        FigmaIcon,
        FigmaIcon as figma,
        FileAddIcon,
        FileAddIcon as fileAdd,
        FileSyncIcon,
        FileSyncIcon as fileSync,
        FileIcon,
        FileIcon as file,
        Filter2Icon,
        Filter2Icon as filter2,
        FilterCancel2Icon,
        FilterCancel2Icon as filterCancel2,
        FilterCancelIcon,
        FilterCancelIcon as filterCancel,
        FilterIcon,
        FilterIcon as filter,
        Flag2Icon,
        Flag2Icon as flag2,
        FlagIcon,
        FlagIcon as flag,
        FlashlightIcon,
        FlashlightIcon as flashlight,
        FoldableHorizontalHalfIcon,
        FoldableHorizontalHalfIcon as foldableHorizontalHalf,
        FoldableHorizontalIcon,
        FoldableHorizontalIcon as foldableHorizontal,
        FoldableVerticalHalfIcon,
        FoldableVerticalHalfIcon as foldableVerticalHalf,
        FoldableVerticalIcon,
        FoldableVerticalIcon as foldableVertical,
        FolderAddIcon,
        FolderAddIcon as folderAdd,
        FolderOpenIcon,
        FolderOpenIcon as folderOpen,
        FolderIcon,
        FolderIcon as folder,
        FullScreenMaximizeIcon,
        FullScreenMaximizeIcon as fullScreenMaximize,
        FullScreenMinimizeIcon,
        FullScreenMinimizeIcon as fullScreenMinimize,
        GameIcon,
        GameIcon as game,
        GiftIcon,
        GiftIcon as gift,
        GitCommitIcon,
        GitCommitIcon as gitCommit,
        GithubIcon,
        GithubIcon as github,
        GitlabIcon,
        GitlabIcon as gitlab,
        GlobeIcon,
        GlobeIcon as globe,
        Google2Icon,
        Google2Icon as google2,
        GoogleChromeIcon,
        GoogleChromeIcon as googleChrome,
        GooglePlayIcon,
        GooglePlayIcon as googlePlay,
        GoogleIcon,
        GoogleIcon as google,
        GraphIcon,
        GraphIcon as graph,
        GridDotsIcon,
        GridDotsIcon as gridDots,
        GridIcon,
        GridIcon as grid,
        HamburgerIcon,
        HamburgerIcon as hamburger,
        HandIcon,
        HandIcon as hand,
        HardDriveIcon,
        HardDriveIcon as hardDrive,
        HashIcon,
        HashIcon as hash,
        HatGraduationIcon,
        HatGraduationIcon as hatGraduation,
        HeadphonesOffIcon,
        HeadphonesOffIcon as headphonesOff,
        HeadphonesIcon,
        HeadphonesIcon as headphones,
        HeartStylisticIcon,
        HeartStylisticIcon as heartStylistic,
        HeartIcon,
        HeartIcon as heart,
        HexagonIcon,
        HexagonIcon as hexagon,
        HighlighterAccentIcon,
        HighlighterAccentIcon as highlighterAccent,
        HighlighterIcon,
        HighlighterIcon as highlighter,
        HistoryIcon,
        HistoryIcon as history,
        Home2Icon,
        Home2Icon as home2,
        HomeIcon,
        HomeIcon as home,
        HourglassIcon,
        HourglassIcon as hourglass,
        HtmlIcon,
        HtmlIcon as html,
        InfinityIcon,
        InfinityIcon as infinity,
        InfoIcon,
        InfoIcon as info,
        InstagramIcon,
        InstagramIcon as instagram,
        JavascriptIcon,
        JavascriptIcon as javascript,
        KeyboardCommandIcon,
        KeyboardCommandIcon as keyboardCommand,
        KeyboardShiftIcon,
        KeyboardShiftIcon as keyboardShift,
        KeyboardIcon,
        KeyboardIcon as keyboard,
        LaptopIcon,
        LaptopIcon as laptop,
        LayersIcon,
        LayersIcon as layers,
        LayoutIcon,
        LayoutIcon as layout,
        LeafThreeIcon,
        LeafThreeIcon as leafThree,
        LeafTwoIcon,
        LeafTwoIcon as leafTwo,
        LeafIcon,
        LeafIcon as leaf,
        LibraryIcon,
        LibraryIcon as library,
        LightbulbIcon,
        LightbulbIcon as lightbulb,
        LineDiagonalIcon,
        LineDiagonalIcon as lineDiagonal,
        LinkIcon,
        LinkIcon as link,
        LinuxIcon,
        LinuxIcon as linux,
        LocationIcon,
        LocationIcon as location,
        LockOpenIcon,
        LockOpenIcon as lockOpen,
        LockIcon,
        LockIcon as lock,
        MailOpenIcon,
        MailOpenIcon as mailOpen,
        MailIcon,
        MailIcon as mail,
        MapIcon,
        MapIcon as map,
        MaskIcon,
        MaskIcon as mask,
        MathIcon,
        MathIcon as math,
        MegaphoneLoudIcon,
        MegaphoneLoudIcon as megaphoneLoud,
        MegaphoneIcon,
        MegaphoneIcon as megaphone,
        MentionIcon,
        MentionIcon as mention,
        MenuIcon,
        MenuIcon as menu,
        MicrophoneOffIcon,
        MicrophoneOffIcon as microphoneOff,
        MicrophoneIcon,
        MicrophoneIcon as microphone,
        MicrosoftEdgeIcon,
        MicrosoftEdgeIcon as microsoftEdge,
        MicrosoftIcon,
        MicrosoftIcon as microsoft,
        MoonIcon,
        MoonIcon as moon,
        MoreVerticalIcon,
        MoreVerticalIcon as moreVertical,
        MoreIcon,
        MoreIcon as more,
        MotherboardIcon,
        MotherboardIcon as motherboard,
        MovieIcon,
        MovieIcon as movie,
        MuseumIcon,
        MuseumIcon as museum,
        MusicNote2Icon,
        MusicNote2Icon as musicNote2,
        MusicNoteIcon,
        MusicNoteIcon as musicNote,
        NarratorIcon,
        NarratorIcon as narrator,
        NodejsIcon,
        NodejsIcon as nodejs,
        NoteAddIcon,
        NoteAddIcon as noteAdd,
        NoteIcon,
        NoteIcon as note,
        NpmIcon,
        NpmIcon as npm,
        OctagonIcon,
        OctagonIcon as octagon,
        OpenSourceIcon,
        OpenSourceIcon as openSource,
        OpenIcon,
        OpenIcon as open,
        PageMarginsIcon,
        PageMarginsIcon as pageMargins,
        PaintBucketAccentIcon,
        PaintBucketAccentIcon as paintBucketAccent,
        PaintBucketIcon,
        PaintBucketIcon as paintBucket,
        Paintbrush2Icon,
        Paintbrush2Icon as paintbrush2,
        PaintbrushIcon,
        PaintbrushIcon as paintbrush,
        PanelLeftContractIcon,
        PanelLeftContractIcon as panelLeftContract,
        PanelLeftExpandIcon,
        PanelLeftExpandIcon as panelLeftExpand,
        PanelLeftOpenIcon,
        PanelLeftOpenIcon as panelLeftOpen,
        PanelLeftIcon,
        PanelLeftIcon as panelLeft,
        PanelRightContractIcon,
        PanelRightContractIcon as panelRightContract,
        PanelRightExpandIcon,
        PanelRightExpandIcon as panelRightExpand,
        PanelRightOpenIcon,
        PanelRightOpenIcon as panelRightOpen,
        PanelRightIcon,
        PanelRightIcon as panelRight,
        PauseIcon,
        PauseIcon as pause,
        Pdf2Icon,
        Pdf2Icon as pdf2,
        PdfIcon,
        PdfIcon as pdf,
        PencilIcon,
        PencilIcon as pencil,
        PentagonIcon,
        PentagonIcon as pentagon,
        Person2Icon,
        Person2Icon as person2,
        PersonAdd2Icon,
        PersonAdd2Icon as personAdd2,
        PersonAddIcon,
        PersonAddIcon as personAdd,
        PersonCircleIcon,
        PersonCircleIcon as personCircle,
        PersonMultipleIcon,
        PersonMultipleIcon as personMultiple,
        PersonIcon,
        PersonIcon as person,
        PhoneAcceptIcon,
        PhoneAcceptIcon as phoneAccept,
        PhoneHangUpIcon,
        PhoneHangUpIcon as phoneHangUp,
        PhoneIcon,
        PhoneIcon as phone,
        PhotoFilterIcon,
        PhotoFilterIcon as photoFilter,
        PhotoIcon,
        PhotoIcon as photo,
        PictureInPicture2Icon,
        PictureInPicture2Icon as pictureInPicture2,
        PictureInPictureEnterIcon,
        PictureInPictureEnterIcon as pictureInPictureEnter,
        PictureInPictureExitIcon,
        PictureInPictureExitIcon as pictureInPictureExit,
        PictureInPictureIcon,
        PictureInPictureIcon as pictureInPicture,
        PinOffIcon,
        PinOffIcon as pinOff,
        PinIcon,
        PinIcon as pin,
        PlayCircularIcon,
        PlayCircularIcon as playCircular,
        PlayIcon,
        PlayIcon as play,
        PrinterIcon,
        PrinterIcon as printer,
        ProhibitedIcon,
        ProhibitedIcon as prohibited,
        PythonIcon,
        PythonIcon as python,
        QrCodeIcon,
        QrCodeIcon as qrCode,
        QuestionCircleIcon,
        QuestionCircleIcon as questionCircle,
        QuestionIcon,
        QuestionIcon as question,
        QuoteIcon,
        QuoteIcon as quote,
        ReactjsIcon,
        ReactjsIcon as reactjs,
        RecordStopIcon,
        RecordStopIcon as recordStop,
        RecordIcon,
        RecordIcon as record,
        RectangleWideIcon,
        RectangleWideIcon as rectangleWide,
        RegularExpressionIcon,
        RegularExpressionIcon as regularExpression,
        ReverseIcon,
        ReverseIcon as reverse,
        RhombusIcon,
        RhombusIcon as rhombus,
        RibbonStarIcon,
        RibbonStarIcon as ribbonStar,
        RibbonIcon,
        RibbonIcon as ribbon,
        RobloxIcon,
        RobloxIcon as roblox,
        RulerDiagonalIcon,
        RulerDiagonalIcon as rulerDiagonal,
        RulerIcon,
        RulerIcon as ruler,
        SaveAsIcon,
        SaveAsIcon as saveAs,
        SaveIcon,
        SaveIcon as save,
        ScreenSizeIcon,
        ScreenSizeIcon as screenSize,
        Script2Icon,
        Script2Icon as script2,
        ScriptIcon,
        ScriptIcon as script,
        SearchCancelIcon,
        SearchCancelIcon as searchCancel,
        SearchIcon,
        SearchIcon as search,
        SectionBreakIcon,
        SectionBreakIcon as sectionBreak,
        SendIcon,
        SendIcon as send,
        ServerIcon,
        ServerIcon as server,
        SettingsIcon,
        SettingsIcon as settings,
        ShapeDifferenceIcon,
        ShapeDifferenceIcon as shapeDifference,
        ShapeIntersectIcon,
        ShapeIntersectIcon as shapeIntersect,
        ShapeSubtractIcon,
        ShapeSubtractIcon as shapeSubtract,
        ShapeUnionIcon,
        ShapeUnionIcon as shapeUnion,
        ShieldCancelIcon,
        ShieldCancelIcon as shieldCancel,
        ShieldCheckmarkIcon,
        ShieldCheckmarkIcon as shieldCheckmark,
        ShieldKeyholeIcon,
        ShieldKeyholeIcon as shieldKeyhole,
        ShieldIcon,
        ShieldIcon as shield,
        SkullIcon,
        SkullIcon as skull,
        SlashBoxIcon,
        SlashBoxIcon as slashBox,
        SoundwaveIcon,
        SoundwaveIcon as soundwave,
        SpacebarIcon,
        SpacebarIcon as spacebar,
        SparkleIcon,
        SparkleIcon as sparkle,
        SpinnerIcon,
        SpinnerIcon as spinner,
        SquareIcon,
        SquareIcon as square,
        StarIcon,
        StarIcon as star,
        StrokeThicknessIcon,
        StrokeThicknessIcon as strokeThickness,
        SubtractIcon,
        SubtractIcon as subtract,
        SvelteIcon,
        SvelteIcon as svelte,
        SymbolsIcon,
        SymbolsIcon as symbols,
        TableSimpleIcon,
        TableSimpleIcon as tableSimple,
        TableIcon,
        TableIcon as table,
        TabletIcon,
        TabletIcon as tablet,
        TagAccentIcon,
        TagAccentIcon as tagAccent,
        TagMultipleIcon,
        TagMultipleIcon as tagMultiple,
        TagMultipleIcon as TagMultipleVarIcon,
        TagMultipleIcon as tagMultipleVar,
        TagIcon,
        TagIcon as tag,
        TaskListIcon,
        TaskListIcon as taskList,
        TerminalIcon,
        TerminalIcon as terminal,
        TextAddIcon,
        TextAddIcon as textAdd,
        TextAlignCenterIcon,
        TextAlignCenterIcon as textAlignCenter,
        TextAlignJustifyIcon,
        TextAlignJustifyIcon as textAlignJustify,
        TextAlignLeftIcon,
        TextAlignLeftIcon as textAlignLeft,
        TextAlignRightIcon,
        TextAlignRightIcon as textAlignRight,
        TextBoldIcon,
        TextBoldIcon as textBold,
        TextBulletListSquareAddIcon,
        TextBulletListSquareAddIcon as textBulletListSquareAdd,
        TextBulletListSquareIcon,
        TextBulletListSquareIcon as textBulletListSquare,
        TextBulletListIcon,
        TextBulletListIcon as textBulletList,
        TextCaseLowercaseIcon,
        TextCaseLowercaseIcon as textCaseLowercase,
        TextCaseTitleIcon,
        TextCaseTitleIcon as textCaseTitle,
        TextCaseUppercaseIcon,
        TextCaseUppercaseIcon as textCaseUppercase,
        TextClearFormattingIcon,
        TextClearFormattingIcon as textClearFormatting,
        TextCollapseIcon,
        TextCollapseIcon as textCollapse,
        TextColorAccentIcon,
        TextColorAccentIcon as textColorAccent,
        TextColorIcon,
        TextColorIcon as textColor,
        TextEditStyleIcon,
        TextEditStyleIcon as textEditStyle,
        TextEffectsIcon,
        TextEffectsIcon as textEffects,
        TextExpandIcon,
        TextExpandIcon as textExpand,
        TextFontSizeIcon,
        TextFontSizeIcon as textFontSize,
        TextFontIcon,
        TextFontIcon as textFont,
        TextFootnoteIcon,
        TextFootnoteIcon as textFootnote,
        TextHighlightColorAccentIcon,
        TextHighlightColorAccentIcon as textHighlightColorAccent,
        TextHighlightColorIcon,
        TextHighlightColorIcon as textHighlightColor,
        TextIndentDecreaseIcon,
        TextIndentDecreaseIcon as textIndentDecrease,
        TextIndentIncreaseIcon,
        TextIndentIncreaseIcon as textIndentIncrease,
        TextItalicIcon,
        TextItalicIcon as textItalic,
        TextLargeIcon,
        TextLargeIcon as textLarge,
        TextLetterSpacingIcon,
        TextLetterSpacingIcon as textLetterSpacing,
        TextLineHeightIcon,
        TextLineHeightIcon as textLineHeight,
        TextLineSpacingIcon,
        TextLineSpacingIcon as textLineSpacing,
        TextNumberListIcon,
        TextNumberListIcon as textNumberList,
        TextPositionBottomIcon,
        TextPositionBottomIcon as textPositionBottom,
        TextPositionMiddleIcon,
        TextPositionMiddleIcon as textPositionMiddle,
        TextPositionTopIcon,
        TextPositionTopIcon as textPositionTop,
        TextSmallIcon,
        TextSmallIcon as textSmall,
        TextStrikethroughIcon,
        TextStrikethroughIcon as textStrikethrough,
        TextSubscriptIcon,
        TextSubscriptIcon as textSubscript,
        TextSuperscriptIcon,
        TextSuperscriptIcon as textSuperscript,
        TextTypographyIcon,
        TextTypographyIcon as textTypography,
        TextUnderlineIcon,
        TextUnderlineIcon as textUnderline,
        TextIcon,
        TextIcon as text,
        ThumbsDownIcon,
        ThumbsDownIcon as thumbsDown,
        ThumbsUpIcon,
        ThumbsUpIcon as thumbsUp,
        TiktokIcon,
        TiktokIcon as tiktok,
        TimerIcon,
        TimerIcon as timer,
        ToolboxIcon,
        ToolboxIcon as toolbox,
        TriangleIcon,
        TriangleIcon as triangle,
        TuneIcon,
        TuneIcon as tune,
        TvIcon,
        TvIcon as tv,
        TypescriptIcon,
        TypescriptIcon as typescript,
        UbuntuIcon,
        UbuntuIcon as ubuntu,
        VehicleCarIcon,
        VehicleCarIcon as vehicleCar,
        VideoClipIcon,
        VideoClipIcon as videoClip,
        VideoIcon,
        VideoIcon as video,
        VisualStudioCodeIcon,
        VisualStudioCodeIcon as visualStudioCode,
        Volume0Icon,
        Volume0Icon as volume0,
        Volume1Icon,
        Volume1Icon as volume1,
        VolumeMuteIcon,
        VolumeMuteIcon as volumeMute,
        VolumeIcon,
        VolumeIcon as volume,
        VuejsIcon,
        VuejsIcon as vuejs,
        WatchIcon,
        WatchIcon as watch,
        WeatherCloudyIcon,
        WeatherCloudyIcon as weatherCloudy,
        WebpackIcon,
        WebpackIcon as webpack,
        WiFiIcon,
        WiFiIcon as wiFi,
        WindowMultipleIcon,
        WindowMultipleIcon as windowMultiple,
        WindowMultipleIcon as WindowMultipleVarIcon,
        WindowMultipleIcon as windowMultipleVar,
        WindowIcon,
        WindowIcon as window,
        WrenchIcon,
        WrenchIcon as wrench,
        XTwitterIcon,
        XTwitterIcon as xTwitter,
        XTwitterIcon as TwitterIcon,
        XTwitterIcon as twitter,
        YoutubeShortsIcon,
        YoutubeShortsIcon as youtubeShorts,
        YoutubeIcon,
        YoutubeIcon as youtube,
        ZoomInIcon,
        ZoomInIcon as zoomIn,
        ZoomOutIcon,
        ZoomOutIcon as zoomOut
    }
}
export { icons }

/**
 * @description Number, Infinite
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuODcyMjEgOS4xNzE1N0M1LjM2ODUgNy42MDk0OCA3Ljc5NDQ1IDcuNjA5NDggOS4yOTA3NCA5LjE3MTU3TDEyIDEyTDkuMjkwNzQgMTQuODI4NEM3Ljc5NDQ1IDE2LjM5MDUgNS4zNjg1IDE2LjM5MDUgMy44NzIyMSAxNC44Mjg0QzIuMzc1OTMgMTMuMjY2MyAyLjM3NTkzIDEwLjczMzcgMy44NzIyMSA5LjE3MTU3WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAuMTI3OCA5LjE3MTU3QzE4LjYzMTUgNy42MDk0OCAxNi4yMDU1IDcuNjA5NDggMTQuNzA5MyA5LjE3MTU3TDEyIDEyTDE0LjcwOTMgMTQuODI4NEMxNi4yMDU1IDE2LjM5MDUgMTguNjMxNSAxNi4zOTA1IDIwLjEyNzggMTQuODI4NEMyMS42MjQxIDEzLjI2NjMgMjEuNjI0MSAxMC43MzM3IDIwLjEyNzggOS4xNzE1N1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const InfinityIcon: ProIcon;
export { InfinityIcon }
export { InfinityIcon as infinity }

/**
 * @description Information
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGVsbGlwc2UgY3g9IjEyIiBjeT0iMTIiIHJ4PSI5LjI1IiByeT0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8cGF0aCBkPSJNMTIuMDAwMSAxMS44MTI1TDEyLjAwMDEgMTYuODEyNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxlbGxpcHNlIGN4PSIxMi4wMDAxIiBjeT0iOC40Mzc1IiByeD0iMS4yNSIgcnk9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const InfoIcon: ProIcon;
export { InfoIcon }
export { InfoIcon as info }

/**
 * @description Social
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy41IiB5PSIzLjUiIHdpZHRoPSIxNyIgaGVpZ2h0PSIxNyIgcng9IjUuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iMTIuMDAwMSIgcj0iMy42MDYwNiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjE2Ljg5MzkiIGN5PSI3LjEwNjA1IiByPSIxLjAzMDMiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const InstagramIcon: ProIcon;
export { InstagramIcon }
export { InstagramIcon as instagram }

/**
 * @description Programming, Web, Electron, JS
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTEuNSAxMS4yNVYxNi4yNUMxMS41IDE2LjgwMjMgMTEuMDUyMyAxNy4yNSAxMC41IDE3LjI1SDkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTcuMjUgMTEuMjVIMTUuMjVDMTQuNjk3NyAxMS4yNSAxNC4yNSAxMS42OTc3IDE0LjI1IDEyLjI1VjEzLjI1QzE0LjI1IDEzLjgwMjMgMTQuNjk3NyAxNC4yNSAxNS4yNSAxNC4yNUgxNi4yNUMxNi44MDIzIDE0LjI1IDE3LjI1IDE0LjY5NzcgMTcuMjUgMTUuMjVWMTYuMjVDMTcuMjUgMTYuODAyMyAxNi44MDIzIDE3LjI1IDE2LjI1IDE3LjI1SDE0LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const JavascriptIcon: ProIcon;
export { JavascriptIcon }
export { JavascriptIcon as javascript }

/**
 * @description Mac, macOS, Meta, Super, Cmd
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNS43NTEyNUMyLjc1IDQuMDk0NCA0LjA5MzE1IDIuNzUxMjUgNS43NSAyLjc1MTI1VjIuNzUxMjVDNy40MDY4NSAyLjc1MTI1IDguNzUgNC4wOTQ0IDguNzUgNS43NTEyNVY4Ljc1MTI1SDUuNzVDNC4wOTMxNSA4Ljc1MTI1IDIuNzUgNy40MDgxMSAyLjc1IDUuNzUxMjVWNS43NTEyNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAxOC4yNDg3QzIuNzUgMTkuOTA1NiA0LjA5MzE1IDIxLjI0ODcgNS43NSAyMS4yNDg3VjIxLjI0ODdDNy40MDY4NSAyMS4yNDg3IDguNzUgMTkuOTA1NiA4Ljc1IDE4LjI0ODdWMTUuMjQ4N0g1Ljc1QzQuMDkzMTUgMTUuMjQ4NyAyLjc1IDE2LjU5MTkgMi43NSAxOC4yNDg3VjE4LjI0ODdaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIxLjI1IDUuNzUxMjVDMjEuMjUgNC4wOTQ0IDE5LjkwNjkgMi43NTEyNSAxOC4yNSAyLjc1MTI1VjIuNzUxMjVDMTYuNTkzMSAyLjc1MTI1IDE1LjI1IDQuMDk0NCAxNS4yNSA1Ljc1MTI1VjguNzUxMjVIMTguMjVDMTkuOTA2OSA4Ljc1MTI1IDIxLjI1IDcuNDA4MTEgMjEuMjUgNS43NTEyNVY1Ljc1MTI1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMS4yNSAxOC4yNDg3QzIxLjI1IDE5LjkwNTYgMTkuOTA2OSAyMS4yNDg3IDE4LjI1IDIxLjI0ODdWMjEuMjQ4N0MxNi41OTMxIDIxLjI0ODcgMTUuMjUgMTkuOTA1NiAxNS4yNSAxOC4yNDg3VjE1LjI0ODdIMTguMjVDMTkuOTA2OSAxNS4yNDg3IDIxLjI1IDE2LjU5MTkgMjEuMjUgMTguMjQ4N1YxOC4yNDg3WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04Ljc1IDguNzUxMjVIMTUuMjVWMTUuMjUxM0g4Ljc1VjguNzUxMjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const KeyboardCommandIcon: ProIcon;
export { KeyboardCommandIcon }
export { KeyboardCommandIcon as keyboardCommand }

/**
 * @description Peripheral
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNS4yNSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTMuNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOCAxNS4zOEgxNiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjcuNSIgY3k9IjguODc1IiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEwLjUiIGN5PSI4Ljg3NSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMy41IiBjeT0iOC44NzUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTYuNSIgY3k9IjguODc1IiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjcuNSIgY3k9IjExLjg3NSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMC41IiBjeT0iMTEuODc1IiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEzLjUiIGN5PSIxMS44NzUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTYuNSIgY3k9IjExLjg3NSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const KeyboardIcon: ProIcon;
export { KeyboardIcon }
export { KeyboardIcon as keyboard }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNTAzMjIgMTEuOTEyNUwxMC4xMDQ0IDMuNjYxMDdDMTEuMDc2MiAyLjQ0NjMxIDEyLjkyMzggMi40NDYzMSAxMy44OTU2IDMuNjYxMDZMMjAuNDk2NyAxMS45MTI1QzIxLjMyNiAxMi45NDkxIDIwLjU4OCAxNC40ODQ3IDE5LjI2MDUgMTQuNDg0N0gxNS4xNjYzVjE4LjIxMDNDMTUuMTY2MyAxOS4yNzQzIDE1LjE2NjMgMTkuODA2MyAxNC45NTkyIDIwLjIxMjdDMTQuNzc3MSAyMC41NzAyIDE0LjQ4NjQgMjAuODYwOCAxNC4xMjkgMjEuMDQyOUMxMy43MjI2IDIxLjI1IDEzLjE5MDYgMjEuMjUgMTIuMTI2NiAyMS4yNUgxMS44NzMzQzEwLjgwOTMgMjEuMjUgMTAuMjc3MyAyMS4yNSA5Ljg3MDg5IDIxLjA0MjlDOS41MTM0MiAyMC44NjA4IDkuMjIyNzggMjAuNTcwMiA5LjA0MDY0IDIwLjIxMjdDOC44MzM1OCAxOS44MDYzIDguODMzNTggMTkuMjc0MyA4LjgzMzU4IDE4LjIxMDNWMTQuNDg0N0g0LjczOTQ3QzMuNDExOTcgMTQuNDg0NyAyLjY3MzkzIDEyLjk0OTEgMy41MDMyMiAxMS45MTI1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const KeyboardShiftIcon: ProIcon;
export { KeyboardShiftIcon }
export { KeyboardShiftIcon as keyboardShift }

/**
 * @description Computer, PC
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuNzUgN0M0Ljc1IDUuODk1NDMgNS42NDU0MyA1IDYuNzUgNUgxNy4yNUMxOC4zNTQ2IDUgMTkuMjUgNS44OTU0MyAxOS4yNSA3VjE2SDQuNzVWN1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAxN0MyLjc1IDE2LjQ0NzcgMy4xOTc3MiAxNiAzLjc1IDE2SDIwLjI1QzIwLjgwMjMgMTYgMjEuMjUgMTYuNDQ3NyAyMS4yNSAxN1YxOEMyMS4yNSAxOS4xMDQ2IDIwLjM1NDYgMjAgMTkuMjUgMjBINC43NUMzLjY0NTQzIDIwIDIuNzUgMTkuMTA0NiAyLjc1IDE4VjE3WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const LaptopIcon: ProIcon;
export { LaptopIcon }
export { LaptopIcon as laptop }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjk5MTIgMy4wNjU1MkMxMi4zNzY5IDIuNzE1MDMgMTEuNjIzMSAyLjcxNTAzIDExLjAwODggMy4wNjU1MkwyLjc1IDcuNzc3NzhMMTEuMDA4OCAxMi40OUMxMS42MjMxIDEyLjg0MDUgMTIuMzc2OSAxMi44NDA1IDEyLjk5MTIgMTIuNDlMMjEuMjUgNy43Nzc3OEwxMi45OTEyIDMuMDY1NTJaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDEyTDEwLjAxNzcgMTYuMTQ2N0MxMS4yNDYzIDE2Ljg0NzcgMTIuNzUzNyAxNi44NDc3IDEzLjk4MjMgMTYuMTQ2N0wyMS4yNSAxMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDE2LjIyMjJMMTAuMDE3NyAyMC4zNjg5QzExLjI0NjMgMjEuMDY5OSAxMi43NTM3IDIxLjA2OTkgMTMuOTgyMyAyMC4zNjg5TDIxLjI1IDE2LjIyMjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const LayersIcon: ProIcon;
export { LayersIcon }
export { LayersIcon as layers }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgOC43NVYxNi43NUMyLjc1IDE4LjQwNjkgNC4wOTMxNSAxOS43NSA1Ljc1IDE5Ljc1SDEwTTIuNzUgOC43NUwyLjc1IDcuMjVDMi43NSA1LjU5MzE1IDQuMDkzMTUgNC4yNSA1Ljc1IDQuMjVIMTguMjVDMTkuOTA2OSA0LjI1IDIxLjI1IDUuNTkzMTUgMjEuMjUgNy4yNVY4Ljc1TTIuNzUgOC43NUgxME0yMS4yNSA4Ljc1VjE2Ljc1QzIxLjI1IDE4LjQwNjkgMTkuOTA2OSAxOS43NSAxOC4yNSAxOS43NUgxME0yMS4yNSA4Ljc1SDEwTTEwIDguNzVWMTkuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const LayoutIcon: ProIcon;
export { LayoutIcon }
export { LayoutIcon as layout }

/**
 * @description Leaf One, 1
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjUwNzggMTYuMjIzNEMxNC4wMTgyIDE4LjcxMTIgOS45ODE3NSAxOC43MTEyIDcuNDkyMTYgMTYuMjIzNEM1LjAwMjU3IDEzLjczNTcgNS4wMDI1NyA5LjcwMjIyIDcuNDkyMTYgNy4yMTQ0N0wxMC41ODYzIDQuMTIyNjRDMTEuMzY3MiAzLjM0MjI5IDEyLjYzMjcgMy4zNDIyOSAxMy40MTM3IDQuMTIyNjRMMTYuNTA3OCA3LjIxNDQ3QzE4Ljk5NzQgOS43MDIyMiAxOC45OTc0IDEzLjczNTcgMTYuNTA3OCAxNi4yMjM0WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS45OTk2IDEyLjI2NTRMMTEuOTk5NiAyMS4yOSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const LeafIcon: ProIcon;
export { LeafIcon }
export { LeafIcon as leaf }

/**
 * @description Leaf 3
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguNTI2MzcgNy40OTg2NkM4LjUyNjM3IDQuODc1MzEgMTAuNjUzIDIuNzQ4NjYgMTMuMjc2NCAyLjc0ODY2TDE1LjQ5MyAyLjc0ODY2QzE2LjM3OTggMi43NDg2NiAxNi44MjMyIDIuNzQ4NjYgMTcuMTYxOSAyLjkyMTIzQzE3LjQ1OTggMy4wNzMwMyAxNy43MDIgMy4zMTUyNSAxNy44NTM4IDMuNjEzMTdDMTguMDI2NCAzLjk1MTg3IDE4LjAyNjQgNC4zOTUyNCAxOC4wMjY0IDUuMjgxOTlMMTguMDI2NCA3LjQ5ODY2QzE4LjAyNjQgNy45MzIyNiAxNy45NjgzIDguMzUyMyAxNy44NTk0IDguNzUxNE03LjE0Mjg1IDExLjU5MTVMOS40NDM0MiAxMy44OTIxTTE1LjA2NzMgMTUuMThMOC45OTU4NSAyMS4yNTE0TTEyLjAxMTcgOS44MUMxMi45ODU4IDkuMTQyMTUgMTQuMTY0NyA4Ljc1MTQgMTUuNDM0OSA4Ljc1MTRIMTcuODU5NE0xMi4wMTE3IDkuODFDMTEuMTY0NyA4LjM5NTU0IDkuNjE3MzEgNy40NDg2NiA3Ljg0ODczIDcuNDQ4NjZINS41ODU5OUM0LjY4MDgxIDcuNDQ4NjYgNC4yMjgyMiA3LjQ0ODY2IDMuODgyNDkgNy42MjQ4MkMzLjU3ODM3IDcuNzc5NzcgMy4zMzExMSA4LjAyNzAzIDMuMTc2MTYgOC4zMzExNEMzIDguNjc2ODggMyA5LjEyOTQ3IDMgMTAuMDM0NkwzIDEyLjI5NzRDMyAxNC45NzUzIDUuMTcwODUgMTcuMTQ2MSA3Ljg0ODczIDE3LjE0NjFDOC41MDQ1NiAxNy4xNDYxIDkuMTI5OTggMTcuMDE1OSA5LjcwMDU1IDE2Ljc4TTEyLjAxMTcgOS44MUMxMS40MTE4IDEwLjIyMTMgMTAuODg5NyAxMC43Mzc3IDEwLjQ3MTggMTEuMzMyN0M5Ljk0NzE4IDEyLjA3OTUgOS41ODY5IDEyLjk1MDIgOS40NDM0MiAxMy44OTIxTTE3Ljg1OTQgOC43NTE0SDE4LjI2MzRDMTkuMzk0OCA4Ljc1MTQgMTkuOTYwNiA4Ljc1MTQgMjAuMzkyNyA4Ljk3MTZDMjAuNzcyOSA5LjE2NTMgMjEuMDgyIDkuNDc0MzYgMjEuMjc1NiA5Ljg1NDUxQzIxLjQ5NTggMTAuMjg2NyAyMS40OTU4IDEwLjg1MjQgMjEuNDk1OCAxMS45ODM5TDIxLjQ5NTggMTQuODEyM0MyMS40OTU4IDE4LjE1OTcgMTguNzgyMyAyMC44NzMyIDE1LjQzNDkgMjAuODczMkMxMi43NzYzIDIwLjg3MzIgMTAuNTE3NSAxOS4xNjE1IDkuNzAwNTUgMTYuNzhNOS40NDM0MiAxMy44OTIxQzkuMzk3NzIgMTQuMTkyMiA5LjM3NDAxIDE0LjQ5OTUgOS4zNzQwMSAxNC44MTIzQzkuMzc0MDEgMTUuNTAxMSA5LjQ4ODkgMTYuMTYzIDkuNzAwNTUgMTYuNzgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const LeafThreeIcon: ProIcon;
export { LeafThreeIcon }
export { LeafThreeIcon as leafThree }

/**
 * @description Leaf One
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMzUgOC4xTDkuMjgwMDEgMTAuMDNNMTQuNTU3MSAxMy42OTI5TDggMjAuMjVNMTIuODcyNCA3LjA4Nzk4QzEzLjUyNjQgNi44Njg3NyAxNC4yMjY0IDYuNzUgMTQuOTU0MiA2Ljc1SDE4LjAwODlDMTkuMjMwOSA2Ljc1IDE5Ljg0MTkgNi43NSAyMC4zMDg2IDYuOTg3ODJDMjAuNzE5MiA3LjE5NzAxIDIxLjA1MyA3LjUzMDggMjEuMjYyMiA3Ljk0MTM1QzIxLjUgOC40MDgxIDIxLjUgOS4wMTkwOSAyMS41IDEwLjI0MTFMMjEuNSAxMy4yOTU4QzIxLjUgMTYuOTEwOSAxOC41NjkzIDE5Ljg0MTYgMTQuOTU0MiAxOS44NDE2QzExLjU0OTkgMTkuODQxNiA4Ljc1MjQ5IDE3LjI0MjcgOC40Mzc4NiAxMy45MjA3TTEyLjg3MjQgNy4wODc5OEMxMi4xNTc5IDUuMTM5OTYgMTAuMjg2OSAzLjc1IDguMDkxMTcgMy43NUw1LjcxNTI5IDMuNzVDNC43NjQ4NSAzLjc1IDQuMjg5NjMgMy43NSAzLjkyNjYxIDMuOTM0OTdDMy42MDcyOSA0LjA5NzY3IDMuMzQ3NjcgNC4zNTcyOSAzLjE4NDk3IDQuNjc2NjFDMyA1LjAzOTYzIDMgNS41MTQ4NSAzIDYuNDY1MjlMMyA4Ljg0MTE3QzMgMTEuNjUyOSA1LjI3OTM5IDEzLjkzMjMgOC4wOTExNyAxMy45MzIzQzguMjA3NjkgMTMuOTMyMyA4LjMyMzI5IDEzLjkyODQgOC40Mzc4NiAxMy45MjA3TTEyLjg3MjQgNy4wODc5OEMxMS4zNDY2IDcuNTk5NDUgMTAuMDcxNSA4LjY1NzcxIDkuMjgwMDEgMTAuMDNNOC40Mzc4NiAxMy45MjA3QzguNDE4MzggMTMuNzE1IDguNDA4NDEgMTMuNTA2NiA4LjQwODQxIDEzLjI5NThDOC40MDg0MSAxMi4xMDY1IDguNzI1NjEgMTAuOTkxMiA5LjI4MDAxIDEwLjAzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const LeafTwoIcon: ProIcon;
export { LeafTwoIcon }
export { LeafTwoIcon as leafTwo }

/**
 * @description Book, Bookshelf
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC41MDM2NiIgd2lkdGg9IjMuOTk4MDEiIGhlaWdodD0iMTUiIHJ4PSIxLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSI5LjIwMTQyIiB5PSI0LjUwMzY2IiB3aWR0aD0iMy45OTgwMSIgaGVpZ2h0PSIxNSIgcng9IjEuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS4yNjY2IDguMzc3NTZDMTUuMTAyIDcuNzYzMDkgMTUuNDY2NSA3LjEzMTQ4IDE2LjA4MDYgNi45NjY4M0wxNy4xMTg2IDYuNjg4NThDMTcuNzMyNyA2LjUyMzkzIDE4LjM2NCA2Ljg4ODU5IDE4LjUyODYgNy41MDMwN0wyMS4yMTA0IDE3LjUxNjZDMjEuMzc0OSAxOC4xMzEgMjEuMDEwNSAxOC43NjI3IDIwLjM5NjMgMTguOTI3M0wxOS4zNTg0IDE5LjIwNTZDMTguNzQ0MiAxOS4zNzAyIDE4LjExMjkgMTkuMDA1NSAxNy45NDgzIDE4LjM5MTFMMTUuMjY2NiA4LjM3NzU2WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const LibraryIcon: ProIcon;
export { LibraryIcon }
export { LibraryIcon as library }

/**
 * @description Tip
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjAxMjYgMTcuMTA0QzE1LjEzODggMTYuMTQ2IDE1Ljc0OTEgMTUuMzM5OSAxNi40Nzc0IDE0LjcwNDhDMTcuOTEwMyAxMy40NTUzIDE4LjgxNTggMTEuNjE2MyAxOC44MTU4IDkuNTY1NzlDMTguODE1OCA1LjgwMTUzIDE1Ljc2NDMgMi43NSAxMiAyLjc1QzguMjM1NzQgMi43NSA1LjE4NDIgNS44MDE1MyA1LjE4NDIgOS41NjU3OUM1LjE4NDIgMTEuNjE2MyA2LjA4OTY5IDEzLjQ1NTMgNy41MjI2MiAxNC43MDQ4QzguMjUwOSAxNS4zMzk5IDguODYxMTkgMTYuMTQ2IDguOTg3MzUgMTcuMTA0TDkuMDcwNzUgMTcuNzM3M0w5LjMwNDM0IDE5LjUxMTFDOS40MzUzNyAyMC41MDYyIDEwLjI4MzYgMjEuMjUgMTEuMjg3MiAyMS4yNUgxMi43MTI4QzEzLjcxNjQgMjEuMjUgMTQuNTY0NiAyMC41MDYyIDE0LjY5NTYgMTkuNTExMUwxNC45MjkyIDE3LjczNzNMMTUuMDEyNiAxNy4xMDRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkuMDcwOCAxNy43MzczSDE0LjkyOTMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const LightbulbIcon: ProIcon;
export { LightbulbIcon }
export { LightbulbIcon as lightbulb }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIxLjI1IDIuNzVMMi43NSAyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const LineDiagonalIcon: ProIcon;
export { LineDiagonalIcon }
export { LineDiagonalIcon as lineDiagonal }

/**
 * @description URL, Attatchment
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNjIxNDMgNy41SDcuMjVDNC43NjQ3MiA3LjUgMi43NSA5LjUxNDcyIDIuNzUgMTJWMTJDMi43NSAxNC40ODUzIDQuNzY0NzIgMTYuNSA3LjI1IDE2LjVIOS42MjE0MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC4zNzg2IDcuNUgxNi43NUMxOS4yMzUzIDcuNSAyMS4yNSA5LjUxNDcyIDIxLjI1IDEyVjEyQzIxLjI1IDE0LjQ4NTMgMTkuMjM1MyAxNi41IDE2Ljc1IDE2LjVIMTQuMzc4NiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03LjI0Mjg2IDEySDE2Ljc1NzEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const LinkIcon: ProIcon;
export { LinkIcon }
export { LinkIcon as link }

/**
 * @description Tux, GNU/Linux, Penguin, Operating System, OS, Linus Torvalds, Open Source
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.10.0
 */
declare const LinuxIcon: ProIcon;
export { LinuxIcon }
export { LinuxIcon as linux }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuMzk5ODggNC43NTk3MUM5LjQ5Mjc0IDEuNjY2ODUgMTQuNTA3MyAxLjY2Njg1IDE3LjYwMDEgNC43NTk3MUMyMC42OTMgNy44NTI1NyAyMC42OTMgMTIuODY3MSAxNy42MDAxIDE1Ljk1OTlMMTMuNDE0MiAyMC4xNDU5QzEyLjYzMzIgMjAuOTI2OSAxMS4zNjY4IDIwLjkyNjkgMTAuNTg1OCAyMC4xNDU5TDYuMzk5ODggMTUuOTU5OUMzLjMwNzAyIDEyLjg2NzEgMy4zMDcwMiA3Ljg1MjU3IDYuMzk5ODggNC43NTk3MVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMC4zNiIgcj0iMyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const LocationIcon: ProIcon;
export { LocationIcon }
export { LocationIcon as location }

/**
 * @description Safe, Secure, Private, Privacy
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNC43NjA4NiIgeT0iOC4zODAzNyIgd2lkdGg9IjE0LjQ3ODMiIGhlaWdodD0iMTIuODY5NiIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuMjE3NCA4LjM4MDQzVjUuOTY3MzlDMTUuMjE3NCA0LjE5MDQ4IDEzLjc3NjkgMi43NSAxMiAyLjc1VjIuNzVDMTAuMjIzMSAyLjc1IDguNzgyNiA0LjE5MDQ4IDguNzgyNiA1Ljk2NzM5VjguMzgwNDMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjE0LjgxNTIiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const LockIcon: ProIcon;
export { LockIcon }
export { LockIcon as lock }

/**
 * @description Unlock, Unsafe
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNC43NjA4NiIgeT0iOC4zODAzNyIgd2lkdGg9IjE0LjQ3ODMiIGhlaWdodD0iMTIuODY5NiIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC43ODI2MSA4LjM4MDQzVjUuOTY3MzlDOC43ODI2MSA0LjE5MDQ4IDEwLjIyMzEgMi43NSAxMiAyLjc1QzEzLjI4OTYgMi43NSAxNC40MDIgMy41MDg3NiAxNC45MTUyIDQuNjA0MjEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjE0LjgxNTIiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const LockOpenIcon: ProIcon;
export { LockOpenIcon }
export { LockOpenIcon as lockOpen }

/**
 * @description Gmail, Outlook, Yahoo, Inbox, Unread, Envelope
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC4yNSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTUuNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSA4TDExLjE2NSAxMS44NjY0QzExLjY5NSAxMi4xMDk5IDEyLjMwNSAxMi4xMDk5IDEyLjgzNSAxMS44NjY0TDIxLjI1IDgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const MailIcon: ProIcon;
export { MailIcon }
export { MailIcon as mail }

/**
 * @description Gmail, Outlook, Yahoo, Inbox, Unread, Envelope Open
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjU4OTYgOC45NDg1MUwxMi44MzUgMTIuNTExNEMxMi4zMDUgMTIuNzU1IDExLjY5NSAxMi43NTUgMTEuMTY1IDEyLjUxMTRMMy40MTA0MiA4Ljk0ODUxTTE4LjI1IDIwLjI1SDUuNzVDNC4wOTMxNSAyMC4yNSAyLjc1IDE4LjkwNjkgMi43NSAxNy4yNVYxMC4wMzQ3QzIuNzUgOS4xNzA1NCAzLjE5NjI2IDguMzY3NjcgMy45MzAxNiA3LjkxMTQ2TDEwLjk0NDEgMy41NTE0M0MxMS41OTA3IDMuMTQ5NTIgMTIuNDA5MyAzLjE0OTUyIDEzLjA1NTkgMy41NTE0M0wyMC4wNjk4IDcuOTExNDZDMjAuODAzNyA4LjM2NzY3IDIxLjI1IDkuMTcwNTQgMjEuMjUgMTAuMDM0N1YxNy4yNUMyMS4yNSAxOC45MDY5IDE5LjkwNjkgMjAuMjUgMTguMjUgMjAuMjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MailOpenIcon: ProIcon;
export { MailOpenIcon }
export { MailOpenIcon as mailOpen }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguNDk1NjYgNC40Mzg4OUw0LjI0NzExIDYuOTEwNzdDMy45MzkzNCA3LjA4OTg0IDMuNzUgNy40MTkwNSAzLjc1IDcuNzc1MTJWMTguMjYxMkMzLjc1IDE5LjAzMjUgNC41ODYyMyAxOS41MTM1IDUuMjUyODkgMTkuMTI1Nkw4LjQ5NTY2IDE3LjIzODlDOC45NjE5NiAxNi45Njc2IDkuNTM4MDQgMTYuOTY3NiAxMC4wMDQzIDE3LjIzODlMMTMuOTk1NyAxOS41NjExQzE0LjQ2MiAxOS44MzI0IDE1LjAzOCAxOS44MzI0IDE1LjUwNDMgMTkuNTYxMUwxOS43NTI5IDE3LjA4OTJDMjAuMDYwNyAxNi45MTAyIDIwLjI1IDE2LjU4MDkgMjAuMjUgMTYuMjI0OVY1LjczODc2QzIwLjI1IDQuOTY3NDcgMTkuNDEzOCA0LjQ4NjU0IDE4Ljc0NzEgNC44NzQ0MUwxNS41MDQzIDYuNzYxMTFDMTUuMDM4IDcuMDMyNDEgMTQuNDYyIDcuMDMyNDEgMTMuOTk1NyA2Ljc2MTExTDEwLjAwNDMgNC40Mzg4OUM5LjUzODA0IDQuMTY3NTkgOC45NjE5NiA0LjE2NzU5IDguNDk1NjYgNC40Mzg4OVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkuMjUgNC43NVYxNi41NU0xNC43NSA3LjQ1VjE5LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const MapIcon: ProIcon;
export { MapIcon }
export { MapIcon as map }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIuMDAwMSIgY3k9IjEyIiByPSI5LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTguODQzNzUgMjAuNjk3NkM1LjI4OTIxIDE5LjQwNzQgMi43NSAxNi4wMDAyIDIuNzUgMTJDMi43NSA3Ljk5OTgyIDUuMjg5MjEgNC41OTI2OCA4Ljg0Mzc1IDMuMzAyNDlDMTIuMzk4MyA0LjU5MjY4IDE0LjkzNzUgNy45OTk4MiAxNC45Mzc1IDEyQzE0LjkzNzUgMTYuMDAwMiAxMi4zOTgzIDE5LjQwNzQgOC44NDM3NSAyMC42OTc2WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const MaskIcon: ProIcon;
export { MaskIcon }
export { MaskIcon as mask }

/**
 * @description Operations, Addition, Subtraction, Multiplication, Division
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNi4yNDc4SDkuNzVNNi4yNSAyLjc0NzhMNi4yNSA5Ljc0NzgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuMjUgNi4yNDc4SDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTMuNDUgMjAuNTUyM0w2LjI1IDE3Ljc1MjNNNi4yNSAxNy43NTIzTDkuMDUgMTQuOTUyM002LjI1IDE3Ljc1MjNMMy40NSAxNC45NTIzTTYuMjUgMTcuNzUyM0w5LjA1IDIwLjU1MjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuMjUgMTUuNjUySDIxLjI1TTE0LjI1IDE5Ljg1MkgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const MathIcon: ProIcon;
export { MathIcon }
export { MathIcon as math }

/**
 * @description Announcement
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTQxNjQgMTUuOTAwOEw0LjY0MTE5IDE1LjI3MjlDMy41Mjk0OCAxNC45OTM4IDIuNzUgMTMuOTk0NCAyLjc1IDEyLjg0ODJWMTAuNzgwNUMyLjc1IDkuNjM0MjQgMy41Mjk0OCA4LjYzNDg2IDQuNjQxMTkgOC4zNTU3MkwxOC4xNDEyIDQuOTY2MTFDMTkuNzE5NyA0LjU2OTc4IDIxLjI1IDUuNzYzMzcgMjEuMjUgNy4zOTA4NVYxNi4yMzc4QzIxLjI1IDE3Ljg2NTMgMTkuNzE5NyAxOS4wNTg5IDE4LjE0MTIgMTguNjYyNkwxMi45NTA2IDE3LjM1OTNNNy4xNDE2NCAxNS45MDA4QzcuMDQ5NjUgMTYuMTg4OCA3IDE2LjQ5NTggNyAxNi44MTQzQzcgMTguNDcxMiA4LjM0MzE1IDE5LjgxNDMgMTAgMTkuODE0M0MxMS40NzA4IDE5LjgxNDMgMTIuNjk0MyAxOC43NTYgMTIuOTUwNiAxNy4zNTkzTTcuMTQxNjQgMTUuOTAwOEwxMi45NTA2IDE3LjM1OTMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MegaphoneIcon: ProIcon;
export { MegaphoneIcon }
export { MegaphoneIcon as megaphone }

/**
 * @description Announcement
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguNzg0MjIgMTkuMjgzTDcuNTMyOTkgMjAuMDMyNkM2LjkwMDc5IDIwLjQxMTMgNi41ODQ3IDIwLjYwMDcgNi4yNjA1IDIwLjY3MDFDNS44MjE0NCAyMC43NjQxIDUuMzYzNTQgMjAuNzA3NCA0Ljk2MDU2IDIwLjUwOTJDNC42NjMwMiAyMC4zNjI5IDQuNDAyNTEgMjAuMTAyMiAzLjg4MTUxIDE5LjU4MDhDMy4zNjA1MSAxOS4wNTk1IDMuMSAxOC43OTg4IDIuOTUzNzkgMTguNTAxQzIuNzU1NzcgMTguMDk3NyAyLjY5OTE3IDE3LjYzOTUgMi43OTMwOSAxNy4yMDAxQzIuODYyNDQgMTYuODc1NyAzLjA1MTY2IDE2LjU1OTMgMy40MzAxIDE1LjkyNjdMNy43ODU2MSA4LjY0NTM4QzguNTAzNTYgNy40NDUxNiA4Ljg2MjUzIDYuODQ1MDQgOS4zNTY0OCA2LjU4MzY5QzkuNzg5NCA2LjM1NDYzIDEwLjI5MTMgNi4yOTI1NCAxMC43NjY5IDYuNDA5MkMxMS4zMDk2IDYuNTQyMzEgMTEuODAzOCA3LjAzNjg4IDEyLjc5MjIgOC4wMjYwMUwxNS40Mjc5IDEwLjY2MzZDMTYuNDE2MyAxMS42NTI4IDE2LjkxMDUgMTIuMTQ3MyAxNy4wNDM1IDEyLjY5MDRDMTcuMTYwMSAxMy4xNjY0IDE3LjA5OCAxMy42Njg2IDE2Ljg2OTEgMTQuMTAxOUMxNi42MDggMTQuNTk2MiAxNi4wMDgzIDE0Ljk1NTQgMTQuODA5IDE1LjY3MzlMMTMuNTM4NCAxNi40MzVNOC43ODQyMiAxOS4yODNDOC45MTU2MyAxOS41NTE3IDkuMDkyOTQgMTkuODAzNiA5LjMxNjEzIDIwLjAyN0MxMC40MDE3IDIxLjExMzMgMTIuMTYxNyAyMS4xMTMzIDEzLjI0NzMgMjAuMDI3QzE0LjIyNTEgMTkuMDQ4NCAxNC4zMjIyIDE3LjUyMjIgMTMuNTM4NCAxNi40MzVNOC43ODQyMiAxOS4yODNMMTMuNTM4NCAxNi40MzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiLz4KPHBhdGggZD0iTTIwLjAwNjYgNC40MDM5M0wxNy41NDIyIDYuODcwMSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMS4yNTEyIDkuODc3NDRIMTguNzYxOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC41MzY5IDMuMTU4MlY1LjY0OTQxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MegaphoneLoudIcon: ProIcon;
export { MegaphoneLoudIcon }
export { MegaphoneLoudIcon as megaphoneLoud }

/**
 * @description @, Tag, @mention, At
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjYyNSAyMC4wMTA3QzE0Ljg2MTYgMjEuMDI4OSAxMi44MTE1IDIxLjQzNjcgMTAuNzkyNiAyMS4xNzA5QzguNzczODEgMjAuOTA1MSA2Ljg5OTEgMTkuOTgwNiA1LjQ1OTI2IDE4LjU0MDdDNC4wMTk0MiAxNy4xMDA5IDMuMDk0OTIgMTUuMjI2MiAyLjgyOTEzIDEzLjIwNzRDMi41NjMzNSAxMS4xODg1IDIuOTcxMTQgOS4xMzg0NCAzLjk4OTI2IDcuMzc1QzUuMDA3MzggNS42MTE1NyA2LjU3ODkzIDQuMjMzMzUgOC40NjAxOCAzLjQ1NDEyQzEwLjM0MTQgMi42NzQ4OCAxMi40MjcyIDIuNTM4MTcgMTQuMzk0MSAzLjA2NTE5QzE2LjM2MDkgMy41OTIyMSAxOC4wOTg5IDQuNzUzNSAxOS4zMzg1IDYuMzY4OTZDMjAuNTc4MSA3Ljk4NDQyIDIxLjI1IDkuOTYzNzYgMjEuMjUgMTJWMTMuNUMyMS4yNSAxNC44ODA3IDIwLjEzMDcgMTYgMTguNzUgMTZWMTZDMTcuMzY5MyAxNiAxNi4yNSAxNC44ODA3IDE2LjI1IDEzLjVWMTJNMTYuMjUgMTJDMTYuMjUgMTQuMzQ3MiAxNC4zNDcyIDE2LjI1IDEyIDE2LjI1QzkuNjUyNzkgMTYuMjUgNy43NSAxNC4zNDcyIDcuNzUgMTJDNy43NSA5LjY1Mjc5IDkuNjUyNzkgNy43NSAxMiA3Ljc1QzE0LjM0NzIgNy43NSAxNi4yNSA5LjY1Mjc5IDE2LjI1IDEyWk0xNi4yNSAxMlY3Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MentionIcon: ProIcon;
export { MentionIcon }
export { MentionIcon as mention }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNC43NUgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDEySDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTkuMjVIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const MenuIcon: ProIcon;
export { MenuIcon }
export { MenuIcon as menu }

/**
 * @description Unmute, Speak
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguODAxMDkgNi40NDg5NEM4LjgwMTA5IDQuNjgyMjEgMTAuMjMzMyAzLjI1IDEyIDMuMjVDMTMuNzY2NyAzLjI1IDE1LjE5OSA0LjY4MjIxIDE1LjE5OSA2LjQ0ODk0VjExLjM5ODJDMTUuMTk5IDEzLjE2NSAxMy43NjY3IDE0LjU5NzIgMTIgMTQuNTk3MkMxMC4yMzMzIDE0LjU5NzIgOC44MDEwOSAxMy4xNjUgOC44MDEwOSAxMS4zOTgyVjYuNDQ4OTRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyIDE4LjE4MTJDOC4yNTYxMyAxOC4xODEyIDUuMjIxMTIgMTUuMTQ2MiA1LjIyMTEyIDExLjQwMjNNMTIgMTguMTgxMkMxNS43NDM5IDE4LjE4MTIgMTguNzc4OSAxNS4xNDYyIDE4Ljc3ODkgMTEuNDAyM00xMiAxOC4xODEyTDEyIDIwLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const MicrophoneIcon: ProIcon;
export { MicrophoneIcon }
export { MicrophoneIcon as microphone }

/**
 * @description Mute
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDE0LjU5NzJDMTMuNzY2OCAxNC41OTcyIDE1LjE5OSAxMy4xNjUgMTUuMTk5IDExLjM5ODJWOS44NjQyMkwxMC43Mjg2IDE0LjMzNDZDMTEuMTE4MyAxNC41MDM1IDExLjU0ODIgMTQuNTk3MiAxMiAxNC41OTcyWiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTIgMTguMTgxMkMxNS43NDM5IDE4LjE4MTIgMTguNzc4OSAxNS4xNDYyIDE4Ljc3ODkgMTEuNDAyM00xMiAxOC4xODEyTDEyIDIwLjc1TTEyIDE4LjE4MTJDMTAuNTUyMiAxOC4xODEyIDkuMjEwMzggMTcuNzI3MyA4LjEwOTExIDE2Ljk1NDFNNS4yMjExMiAxMS40MDIzQzUuMjIxMTIgMTIuNTAyNCA1LjQ4MzE3IDEzLjU0MTMgNS45NDgyNiAxNC40Nk0zLjI4MTU5IDIxLjc4MTZMOC4xMDkxMSAxNi45NTQxTTIxLjc4MTYgMy4yODE2TDE1LjE5OSA5Ljg2NDIyTTE1LjE5OSA5Ljg2NDIyVjExLjM5ODJDMTUuMTk5IDEzLjE2NSAxMy43NjY4IDE0LjU5NzIgMTIgMTQuNTk3MkMxMS41NDgyIDE0LjU5NzIgMTEuMTE4MyAxNC41MDM1IDEwLjcyODYgMTQuMzM0Nk0xNS4xOTkgOS44NjQyMkwxMC43Mjg2IDE0LjMzNDZNMTAuNzI4NiAxNC4zMzQ2TDguMTA5MTEgMTYuOTU0MU04Ljg0MzQzIDExLjkyQzguODE1NTggMTEuNzUwMiA4LjgwMTA5IDExLjU3NTkgOC44MDEwOSAxMS4zOTgyVjYuNDQ4OTRDOC44MDEwOSA0LjY4MjIxIDEwLjIzMzMgMy4yNSAxMiAzLjI1QzEzLjY5NjYgMy4yNSAxNS4wODQ2IDQuNTcwNjYgMTUuMTkyMyA2LjI0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const MicrophoneOffIcon: ProIcon;
export { MicrophoneOffIcon }
export { MicrophoneOffIcon as microphoneOff }

/**
 * @description Browser, Chromium, Microsoft, MS Edge
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzYwNSAxMkMyLjc2MDUgMTcuMTA4NiA2LjkwMTg2IDIxLjI1IDEyLjAxMDUgMjEuMjVDMTIuNzk2MiAyMS4yNSAxMy41NTkgMjEuMTUyIDE0LjI4NzQgMjAuOTY3N00yLjc2MDUgMTJDMi43NjA1IDYuODkxMzcgNi45MDE4NiAyLjc1IDEyLjAxMDUgMi43NUMxNS44MDYxIDIuNzUgMjAuMDA2NSA0LjUyNjUzIDIxLjAyNzcgOS41NDg0N0MyMS4yNTE0IDEwLjY0ODggMjEuMTE4MSAxMS44MDU4IDIwLjU2NDYgMTIuNzgyN0MxOS45ODM0IDEzLjgwODQgMTkuMDA2MyAxNC45NjQ3IDE3LjU1NDYgMTQuOTY0N0MxNy4wMDU2IDE1LjA1MzMgMTMuMzkwNiAxNS4xNDA2IDEzLjU3NjQgMTMuNjUyOUMxNC4wMTQzIDEzLjIzOCAxNC4yODc0IDEyLjY1MDkgMTQuMjg3NCAxMk0yLjc2MDUgMTJDMi43NjA1IDEyIDMuMjA1MTcgNy4xNTEyNSA4LjU0MTc1IDcuMTY3NDdDMTQuMTE1NyA3LjE4NDQxIDE0LjI4NzQgMTIgMTQuMjg3NCAxMk0xNC4yODc0IDEyQzE0LjI4NzQgMTAuNzQyNSAxMy4yNjggOS43MjMwOCAxMi4wMTA1IDkuNzIzMDhDMTEuMzY4MSA5LjcyMzA4IDEwLjM3MzggMTAuNDE3MSAxMC4zNzM4IDEwLjQxNzFNMTQuMjg3NCAyMC45Njc3QzE2LjUyNjYgMjAuNDAwOSAxOC40NDA0IDE5LjAxNzUgMTkuNjkzNCAxNy4xNTI5QzE5Ljg3ODIgMTYuODc4MSAxOS43NTE1IDE2LjQ1OTUgMTkuNDMzNiAxNi41NTI0QzE5LjM3MzYgMTYuNTcgMTkuMzE0NCAxNi41OTk0IDE5LjI1OTMgMTYuNjQ0OUMxNy44OTU1IDE3LjI2MjQgMTUuMDM5NiAxNy43NjUxIDEyLjU3MzggMTYuMzg3OEMxMS4wNzMyIDE1LjU0OTcgMTAuMjAwNCAxNC4yNTMxIDkuOTM1MTggMTMuMTg1OUM5LjgzNjI3IDEyLjkzMDcgOS43MzM1OCAxMi4yOTAxIDkuNzMzNTggMTJDOS43MzM1OCAxMS4zODQ5IDkuOTc3NDUgMTAuODI2OCAxMC4zNzM4IDEwLjQxNzFNMTQuMjg3NCAyMC45Njc3QzE0LjI4NzQgMjAuOTY3NyA4LjI3NDkyIDIxLjQ1NzUgNy43NDEyNyAxNS45MTM1QzcuNDQzODcgMTIuODIzOCA5LjA0NzYxIDExLjIxMTYgMTAuMzczOCAxMC40MTcxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MicrosoftEdgeIcon: ProIcon;
export { MicrosoftEdgeIcon }
export { MicrosoftEdgeIcon as microsoftEdge }

/**
 * @description Windows, Win11, Windows 11, Satya Nadella, Steve Ballmer, Bill Gates
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDMuNzVINS43NUM0LjY0NTQzIDMuNzUgMy43NSA0LjY0NTQzIDMuNzUgNS43NVYxMk0xMiAzLjc1SDE4LjI1QzE5LjM1NDYgMy43NSAyMC4yNSA0LjY0NTQzIDIwLjI1IDUuNzVWMTJNMTIgMy43NVYyMC4yNU0xMiAyMC4yNUgxOC4yNUMxOS4zNTQ2IDIwLjI1IDIwLjI1IDE5LjM1NDYgMjAuMjUgMTguMjVWMTJNMTIgMjAuMjVINS43NUM0LjY0NTQzIDIwLjI1IDMuNzUgMTkuMzU0NiAzLjc1IDE4LjI1VjEyTTMuNzUgMTJIMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const MicrosoftIcon: ProIcon;
export { MicrosoftIcon }
export { MicrosoftIcon as microsoft }

/**
 * @description Crescent, Dark, Dark Mode, Dark Theme
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTExLjU3NzcgMy41MTIzM0M5LjMxMTAzIDUuOTg2OTIgOS4zNzU4MyA5LjgzMTc1IDExLjc3MjEgMTIuMjI4QzE0LjE2ODMgMTQuNjI0MyAxOC4wMTMyIDE0LjY4OTEgMjAuNDg3OCAxMi40MjI0QzIwLjYxMzkgMTIuMzA2OSAyMC43OTM3IDEyLjI2NjggMjAuOTUzNyAxMi4zMjcyQzIxLjEzMDIgMTIuMzkzOCAyMS4yNDQ3IDEyLjU2NjcgMjEuMjI5MyAxMi43NTQ4QzIxLjA1NjYgMTQuODY0MSAyMC4xNjMzIDE2LjkyNTQgMTguNTQ5NyAxOC41MzkxQzE0LjkzNTMgMjIuMTUzNSA5LjA3NTI5IDIyLjE1MzUgNS40NjA5NSAxOC41MzkxQzEuODQ2NiAxNC45MjQ4IDEuODQ2NiA5LjA2NDc1IDUuNDYwOTUgNS40NTA0QzcuMDc0NjQgMy44MzY3MSA5LjEzNTk4IDIuOTQzNDggMTEuMjQ1MiAyLjc3MDcyQzExLjQzMzMgMi43NTUzMSAxMS42MDYzIDIuODY5ODQgMTEuNjcyOSAzLjA0NjQxQzExLjczMzMgMy4yMDY0MSAxMS42OTMyIDMuMzg2MjIgMTEuNTc3NyAzLjUxMjMzWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const MoonIcon: ProIcon;
export { MoonIcon }
export { MoonIcon as moon }

/**
 * @description Kabab
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNiIgY3k9IjEyIiByPSIxLjc1IiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iMTIiIHI9IjEuNzUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTgiIGN5PSIxMiIgcj0iMS43NSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const MoreIcon: ProIcon;
export { MoreIcon }
export { MoreIcon as more }

/**
 * @description Kabab
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxOCIgcj0iMS43NSIgdHJhbnNmb3JtPSJyb3RhdGUoLTkwIDEyIDE4KSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxMiIgY3k9IjEyIiByPSIxLjc1IiB0cmFuc2Zvcm09InJvdGF0ZSgtOTAgMTIgMTIpIiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iNiIgcj0iMS43NSIgdHJhbnNmb3JtPSJyb3RhdGUoLTkwIDEyIDYpIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const MoreVerticalIcon: ProIcon;
export { MoreVerticalIcon }
export { MoreVerticalIcon as moreVertical }

/**
 * @description Computer Board, Chip, Components, Transistor, Silicon, PC, CPU
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const MotherboardIcon: ProIcon;
export { MotherboardIcon }
export { MotherboardIcon as motherboard }

/**
 * @description Video, Film
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNy41QzIuNzUgNS44NDMxNSA0LjA5MzE1IDQuNSA1Ljc1IDQuNUgxOC4yNUMxOS45MDY5IDQuNSAyMS4yNSA1Ljg0MzE1IDIxLjI1IDcuNVYxNi41QzIxLjI1IDE4LjE1NjkgMTkuOTA2OSAxOS41IDE4LjI1IDE5LjVINS43NUM0LjA5MzE1IDE5LjUgMi43NSAxOC4xNTY5IDIuNzUgMTYuNVY3LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTcgNVYxOSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNyA1VjE5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgOS41TDcgOS41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTQuNUw3IDE0LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTcgOS41TDIxLjI1IDkuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNyAxNC41TDIxLjI1IDE0LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const MovieIcon: ProIcon;
export { MovieIcon }
export { MovieIcon as movie }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iMTguMzc1NiIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMyIgcng9IjEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTEuMDQwMiAzLjE0OTQ0TDMuMjcwMDggNy4zOTk4OUMyLjk0OTQyIDcuNTc1MyAyLjc1IDcuOTExNjkgMi43NSA4LjI3NzJWOS4yNzQzOUMyLjc1IDkuNjA1NzYgMy4wMTg2MyA5Ljg3NDM5IDMuMzUgOS44NzQzOUgyMC42NUMyMC45ODE0IDkuODc0MzkgMjEuMjUgOS42MDU3NiAyMS4yNSA5LjI3NDM5VjguMjc3MkMyMS4yNSA3LjkxMTY5IDIxLjA1MDYgNy41NzUzIDIwLjcyOTkgNy4zOTk4OUwxMi45NTk4IDMuMTQ5NDRDMTIuMzYxOCAyLjgyMjI4IDExLjYzODIgMi44MjIyOCAxMS4wNDAyIDMuMTQ5NDRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTUuMjUgOS44NzQzOUw1LjI1IDE4LjM4MzJNMTguNzUgOS44NzQzOVYxOC4zODMyTTE0LjUgOS44NzQzOVYxOC4zODMyTTkuNSA5Ljg3NDM5TDkuNSAxOC4zODMyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MuseumIcon: ProIcon;
export { MuseumIcon }
export { MuseumIcon as museum }

/**
 * @description Song, Single
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjUgMTcuMjVDMTIuNSAxOS40NTkxIDEwLjcwOTEgMjEuMjUgOC41IDIxLjI1QzYuMjkwODYgMjEuMjUgNC41IDE5LjQ1OTEgNC41IDE3LjI1QzQuNSAxNS4wNDA5IDYuMjkwODYgMTMuMjUgOC41IDEzLjI1QzEwLjcwOTEgMTMuMjUgMTIuNSAxNS4wNDA5IDEyLjUgMTcuMjVaTTEyLjUgMTcuMjVWOC4yNU0xMi41IDguMjVMMTcuMzI5MiAxMC42NjQ2QzE4LjMyNjUgMTEuMTYzMyAxOS41IDEwLjQzOCAxOS41IDkuMzIyOTVWNy4xNzcwNUMxOS41IDYuNjA4ODkgMTkuMTc5IDYuMDg5NSAxOC42NzA4IDUuODM1NDFMMTMuOTQ3MiAzLjQ3MzYxQzEzLjI4MjMgMy4xNDExNiAxMi41IDMuNjI0NjUgMTIuNSA0LjM2ODAzVjguMjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MusicNote2Icon: ProIcon;
export { MusicNote2Icon }
export { MusicNote2Icon as musicNote2 }

/**
 * @description Song, Double
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguOTYyMjQgMTcuOTY4MVY2LjY5NTk0QzguOTYyMjQgNi4wMTk1MiA5LjQxNDk3IDUuNDI2NzggMTAuMDY3NiA1LjI0ODhMMTguMjE4MiAzLjAyNTg4QzE5LjE3MjUgMi43NjU2NSAyMC4xMTI5IDMuNDgzOTcgMjAuMTEyOSA0LjQ3MzAzVjE1Ljk0MDdNOC45NjIyNCA5LjkyMTgyTDIwLjExMjkgNi44ODA3MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04Ljk2MjE5IDE3Ljk2ODFDOC45NjIxOSAxOS42NDc2IDcuNjAwNjUgMjEuMDA5MiA1LjkyMTEgMjEuMDA5MkM0LjI0MTU0IDIxLjAwOTIgMi44OCAxOS42NDc2IDIuODggMTcuOTY4MUMyLjg4IDE2LjI4ODUgNC4yNDE1NCAxNC45MjcgNS45MjExIDE0LjkyN0M3LjYwMDY1IDE0LjkyNyA4Ljk2MjE5IDE2LjI4ODUgOC45NjIxOSAxNy45NjgxWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMC4xMTI5IDE1Ljk0MDZDMjAuMTEyOSAxNy42MjAyIDE4Ljc1MTMgMTguOTgxNyAxNy4wNzE4IDE4Ljk4MTdDMTUuMzkyMiAxOC45ODE3IDE0LjAzMDcgMTcuNjIwMiAxNC4wMzA3IDE1Ljk0MDZDMTQuMDMwNyAxNC4yNjExIDE1LjM5MjIgMTIuODk5NSAxNy4wNzE4IDEyLjg5OTVDMTguNzUxMyAxMi44OTk1IDIwLjExMjkgMTQuMjYxMSAyMC4xMTI5IDE1Ljk0MDZaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const MusicNoteIcon: ProIcon;
export { MusicNoteIcon }
export { MusicNoteIcon as musicNote }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTgzNDEgMTYuOTU4NEg3LjkzMzQxQzcuOTMzNDEgMTYuNTQ0MiA3LjU5NzYyIDE2LjIwODQgNy4xODM0MSAxNi4yMDg0VjE2Ljk1ODRaTTguMDIyMDEgMjEuMTE4Mkw4LjUyOTkxIDIxLjY3SDguNTI5OTFMOC4wMjIwMSAyMS4xMTgyWk0xMi41NDE3IDE2Ljk1ODRWMTYuMjA4NEMxMi4zNTM1IDE2LjIwODQgMTIuMTcyMyAxNi4yNzkxIDEyLjAzMzggMTYuNDA2NkwxMi41NDE3IDE2Ljk1ODRaTTMuODM5MzEgNi43NDk3QzMuODM5MzEgNC45NTQ3NyA1LjI5NDM4IDMuNDk5NjkgNy4wODkzMSAzLjQ5OTY5VjEuOTk5NjlDNC40NjU5NiAxLjk5OTY5IDIuMzM5MzEgNC4xMjYzNCAyLjMzOTMxIDYuNzQ5N0gzLjgzOTMxWk0zLjgzOTMxIDEyLjk1ODRWNi43NDk3SDIuMzM5MzFWMTIuOTU4NEgzLjgzOTMxWk03LjA4OTMxIDE2LjIwODRDNS4yOTQzOCAxNi4yMDg0IDMuODM5MzEgMTQuNzUzMyAzLjgzOTMxIDEyLjk1ODRIMi4zMzkzMUMyLjMzOTMxIDE1LjU4MTggNC40NjU5NiAxNy43MDg0IDcuMDg5MzEgMTcuNzA4NFYxNi4yMDg0Wk03LjE2MTA4IDE2LjIwODRINy4wODkzMVYxNy43MDg0SDcuMTYxMDhWMTYuMjA4NFpNNy4xODM0MSAxNi4yMDg0SDcuMTYxMDhWMTcuNzA4NEg3LjE4MzQxVjE2LjIwODRaTTcuOTMzNDEgMjAuNzUwM1YxNi45NTg0SDYuNDMzNDFWMjAuNzUwM0g3LjkzMzQxWk03LjUxNDExIDIwLjU2NjNDNy42NzQzNCAyMC40MTg5IDcuOTMzNDEgMjAuNTMyNSA3LjkzMzQxIDIwLjc1MDNINi40MzM0MUM2LjQzMzQxIDIxLjgzOTEgNy43Mjg3NiAyMi40MDc0IDguNTI5OTEgMjEuNjdMNy41MTQxMSAyMC41NjYzWk0xMi4wMzM4IDE2LjQwNjZMNy41MTQxMSAyMC41NjYzTDguNTI5OTEgMjEuNjdMMTMuMDQ5NiAxNy41MTAzTDEyLjAzMzggMTYuNDA2NlpNMTYuOTEwNyAxNi4yMDg0SDEyLjU0MTdWMTcuNzA4NEgxNi45MTA3VjE2LjIwODRaTTIwLjE2MDcgMTIuOTU4NEMyMC4xNjA3IDE0Ljc1MzMgMTguNzA1NiAxNi4yMDg0IDE2LjkxMDcgMTYuMjA4NFYxNy43MDg0QzE5LjUzNCAxNy43MDg0IDIxLjY2MDcgMTUuNTgxOCAyMS42NjA3IDEyLjk1ODRIMjAuMTYwN1pNMjAuMTYwNyA2Ljc0OTY5VjEyLjk1ODRIMjEuNjYwN1Y2Ljc0OTY5SDIwLjE2MDdaTTE2LjkxMDcgMy40OTk2OUMxOC43MDU2IDMuNDk5NjkgMjAuMTYwNyA0Ljk1NDc3IDIwLjE2MDcgNi43NDk2OUgyMS42NjA3QzIxLjY2MDcgNC4xMjYzNCAxOS41MzQgMS45OTk2OSAxNi45MTA3IDEuOTk5NjlWMy40OTk2OVpNNy4wODkzMSAzLjQ5OTY5SDE2LjkxMDdWMS45OTk2OUg3LjA4OTMxVjMuNDk5NjlaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0xMiAxNFY2TTE1LjI1IDExLjc4ODRWOC4yMTE2MU04Ljc1IDExLjc4ODRWOC4yMTE2MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const NarratorIcon: ProIcon;
export { NarratorIcon }
export { NarratorIcon as narrator }

/**
 * @description Node Package Manager, JavaScript, JS, Node.js
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNzUgOC40OTk5OVYxNi40NjM4QzkuNzUgMTcuMzMgOS4yOTM3MSAxOC4wODk2IDguNjA4MzcgMTguNTE1NUM3Ljg2Mjg3IDE4Ljk3ODcgNi45MzYxIDE4LjY0NjUgNi4xNzYgMTguMjA3Nkw0Ljc0NjY0IDE3LjM4MjRDNC4xMDY0MyAxNy4wMTI4IDMuNzEyMDQgMTYuMzI5NyAzLjcxMjA0IDE1LjU5MDRWOC40MDk2MUMzLjcxMjA0IDcuNjcwMzUgNC4xMDY0MyA2Ljk4NzI1IDQuNzQ2NjQgNi42MTc2MkwxMC45NjU0IDMuMDI3MjJDMTEuNjA1NiAyLjY1NzU5IDEyLjM5NDQgMi42NTc1OSAxMy4wMzQ2IDMuMDI3MjJMMTkuMjUzMyA2LjYxNzYyQzE5Ljg5MzYgNi45ODcyNSAyMC4yODggNy42NzAzNSAyMC4yODggOC40MDk2MVYxNS41OTA0QzIwLjI4OCAxNi4zMjk3IDE5Ljg5MzYgMTcuMDEyOCAxOS4yNTMzIDE3LjM4MjRMMTMuMDM0NiAyMC45NzI4QzEyLjM5NDQgMjEuMzQyNCAxMS42MDU2IDIxLjM0MjQgMTAuOTY1NCAyMC45NzI4TDkuOTc2MjIgMjAuNDAxNyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNy4yOSA4LjVIMTQuNTRDMTMuNTczNSA4LjUgMTIuNzkgOS4yODM1IDEyLjc5IDEwLjI1VjEwLjI1QzEyLjc5IDExLjIxNjUgMTMuNTczNSAxMiAxNC41NCAxMkgxNS41NEMxNi41MDY1IDEyIDE3LjI5IDEyLjc4MzUgMTcuMjkgMTMuNzVWMTMuNzVDMTcuMjkgMTQuNzE2NSAxNi41MDY1IDE1LjUgMTUuNTQgMTUuNUgxMi43OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.10.0
 */
declare const NodejsIcon: ProIcon;
export { NodejsIcon }
export { NodejsIcon as nodejs }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik02LjUgMTJDOS41Mzc1NyAxMiAxMiA5LjUzNzU3IDEyIDYuNUMxMiAzLjQ2MjQzIDkuNTM3NTcgMSA2LjUgMUMzLjQ2MjQzIDEgMSAzLjQ2MjQzIDEgNi41QzEgOS41Mzc1NyAzLjQ2MjQzIDEyIDYuNSAxMlpNNi41IDMuMDA2NTlDNi43NzYxNCAzLjAwNjU5IDcgMy4yMzA0NSA3IDMuNTA2NTlWNi4wMDAwNkg5LjQ5MzQyQzkuNzY5NTYgNi4wMDAwNiA5Ljk5MzQyIDYuMjIzOTIgOS45OTM0MiA2LjUwMDA2QzkuOTkzNDIgNi43NzYyIDkuNzY5NTYgNy4wMDAwNiA5LjQ5MzQyIDcuMDAwMDZIN1Y5LjQ5MzQzQzcgOS43Njk1OCA2Ljc3NjE0IDkuOTkzNDMgNi41IDkuOTkzNDNDNi4yMjM4NiA5Ljk5MzQzIDYgOS43Njk1OCA2IDkuNDkzNDNWNy4wMDAwNkgzLjUwNjU4QzMuMjMwNDQgNy4wMDAwNiAzLjAwNjU4IDYuNzc2MiAzLjAwNjU4IDYuNTAwMDZDMy4wMDY1OCA2LjIyMzkyIDMuMjMwNDQgNi4wMDAwNiAzLjUwNjU4IDYuMDAwMDZINlYzLjUwNjU5QzYgMy4yMzA0NSA2LjIyMzg2IDMuMDA2NTkgNi41IDMuMDA2NTlaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0yMC41IDE0SDE4LjhDMTcuMTE5OCAxNCAxNi4yNzk4IDE0IDE1LjYzOCAxNC4zMjdDMTUuMDczNSAxNC42MTQ2IDE0LjYxNDYgMTUuMDczNSAxNC4zMjcgMTUuNjM4QzE0IDE2LjI3OTggMTQgMTcuMTE5OCAxNCAxOC44VjIwLjVNMTUuNSA4SDE0TTExLjUgMTJIMTNNMTMuNzUgNEgxNC4xQzE2LjM0MDIgNCAxNy40NjAzIDQgMTguMzE2IDQuNDM1OTdDMTkuMDY4NiA0LjgxOTQ3IDE5LjY4MDUgNS40MzEzOSAyMC4wNjQgNi4xODQwNEMyMC41IDcuMDM5NjkgMjAuNSA4LjE1OTc5IDIwLjUgMTAuNFYxMy44NDlDMjAuNSAxNC44Mjc0IDIwLjUgMTUuMzE2NiAyMC4zODk1IDE1Ljc3NjlDMjAuMjkxNSAxNi4xODUxIDIwLjEyOTkgMTYuNTc1MyAxOS45MTA2IDE2LjkzMzFDMTkuNjYzMiAxNy4zMzY4IDE5LjMxNzMgMTcuNjgyNyAxOC42MjU1IDE4LjM3NDVMMTguMzc0NSAxOC42MjU1QzE3LjY4MjcgMTkuMzE3MyAxNy4zMzY4IDE5LjY2MzIgMTYuOTMzMSAxOS45MTA2QzE2LjU3NTMgMjAuMTI5OSAxNi4xODUxIDIwLjI5MTUgMTUuNzc2OSAyMC4zODk1QzE1LjMxNjYgMjAuNSAxNC44Mjc0IDIwLjUgMTMuODQ5IDIwLjVIMTAuNEM4LjE1OTc5IDIwLjUgNy4wMzk2OSAyMC41IDYuMTg0MDQgMjAuMDY0QzUuNDMxMzkgMTkuNjgwNSA0LjgxOTQ3IDE5LjA2ODYgNC40MzU5NyAxOC4zMTZDNCAxNy40NjAzIDQgMTYuMzQwMiA0IDE0LjFWMTMuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const NoteAddIcon: ProIcon;
export { NoteAddIcon }
export { NoteAddIcon as noteAdd }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2LjUgNEg4QzUuNzkwODYgNCA0IDUuNzkwODYgNCA4VjE2LjVDNCAxOC43MDkxIDUuNzkwODYgMjAuNSA4IDIwLjVIMTQuODQzMUMxNS45MDQgMjAuNSAxNi45MjE0IDIwLjA3ODYgMTcuNjcxNiAxOS4zMjg0TDE5LjMyODQgMTcuNjcxNkMyMC4wNzg2IDE2LjkyMTQgMjAuNSAxNS45MDQgMjAuNSAxNC44NDMxVjhDMjAuNSA1Ljc5MDg2IDE4LjcwOTEgNCAxNi41IDRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIwLjUgMTRIMTdDMTUuMzQzMSAxNCAxNCAxNS4zNDMxIDE0IDE3VjIwLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOCA4SDE1LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOCAxMkgxMyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const NoteIcon: ProIcon;
export { NoteIcon }
export { NoteIcon as note }

/**
 * @description Node Package Manager, JavaScript, JS, Node.js
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgOUMxMiA4LjQ0NzcyIDEyLjQ0NzcgOCAxMyA4SDE1QzE1LjU1MjMgOCAxNiA4LjQ0NzcyIDE2IDlWMjAuMjVIMTJWOVoiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.10.0
 */
declare const NpmIcon: ProIcon;
export { NpmIcon }
export { NpmIcon as npm }

/**
 * @description Stop, Sign
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMjg5ODcgMy42Mjg2OEM3Ljg1MjQ4IDMuMDY2MDcgOC42MTU1NSAyLjc1IDkuNDExMiAyLjc1TDE0LjU4ODkgMi43NUMxNS4zODQ1IDIuNzUgMTYuMTQ3NiAzLjA2NjA3IDE2LjcxMDIgMy42Mjg2OEwyMC4zNzEzIDcuMjg5ODRDMjAuOTM0IDcuODUyNDUgMjEuMjUgOC42MTU1MiAyMS4yNSA5LjQxMTE3VjE0LjU4ODhDMjEuMjUgMTUuMzg0NSAyMC45MzQgMTYuMTQ3NSAyMC4zNzEzIDE2LjcxMDJMMTYuNzEwMiAyMC4zNzEzQzE2LjE0NzYgMjAuOTMzOSAxNS4zODQ1IDIxLjI1IDE0LjU4ODkgMjEuMjVIOS40MTEyQzguNjE1NTUgMjEuMjUgNy44NTI0OCAyMC45MzM5IDcuMjg5ODcgMjAuMzcxM0wzLjYyODcxIDE2LjcxMDJDMy4wNjYxIDE2LjE0NzUgMi43NTAwMyAxNS4zODQ1IDIuNzUwMDMgMTQuNTg4OEwyLjc1MDAzIDkuNDExMTdDMi43NTAwMyA4LjYxNTUyIDMuMDY2MSA3Ljg1MjQ1IDMuNjI4NzEgNy4yODk4NEw3LjI4OTg3IDMuNjI4NjhaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const OctagonIcon: ProIcon;
export { OctagonIcon }
export { OctagonIcon as octagon }

/**
 * @description External Link, Box Arrow Top Right
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjI1IDMuNzVINy43NUM1LjU0MDg2IDMuNzUgMy43NSA1LjU0MDg2IDMuNzUgNy43NUwzLjc1IDE2LjI1QzMuNzUgMTguNDU5MSA1LjU0MDg2IDIwLjI1IDcuNzUgMjAuMjVIMTYuMjVDMTguNDU5MSAyMC4yNSAyMC4yNSAxOC40NTkxIDIwLjI1IDE2LjI1VjEzLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEzLjc1IDMuNzVIMTkuMjVDMTkuNTI2MSAzLjc1IDE5Ljc3NjEgMy44NjE5MyAxOS45NTcxIDQuMDQyODlNMjAuMjUgMTAuMjVWNC43NUMyMC4yNSA0LjQ3Mzg2IDIwLjEzODEgNC4yMjM4NiAxOS45NTcxIDQuMDQyODlNMTIuNzUgMTEuMjVMMTkuMjUgNC43NUwxOS45NTcxIDQuMDQyODkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const OpenIcon: ProIcon;
export { OpenIcon }
export { OpenIcon as open }

/**
 * @description Open Source Initiative, OSI, Free Software, FOSS
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjE1NzIgMjAuMTM2MUMxNS4zNjg1IDIwLjY0NjQgMTUuOTU2OCAyMC44OTMzIDE2LjQ0MTMgMjAuNjI4MkMxOC4wMTIzIDE5Ljc2ODMgMTkuMzA2OCAxOC40NjY2IDIwLjE1NzggMTYuODc0NUMyMS4xNjY2IDE0Ljk4NzIgMjEuNDg5OCAxMi44MDg0IDIxLjA3MjMgMTAuNzA5NUMyMC42NTQ4IDguNjEwNiAxOS41MjI0IDYuNzIxMzggMTcuODY4MiA1LjM2Mzc1QzE2LjIxMzkgNC4wMDYxMyAxNC4xNCAzLjI2NDEgMTIgMy4yNjQxQzkuODU5OTggMy4yNjQxIDcuNzg2MTUgNC4wMDYxMyA2LjEzMTg4IDUuMzYzNzVDNC40Nzc2IDYuNzIxMzggMy4zNDUyNSA4LjYxMDYgMi45Mjc3NSAxMC43MDk1QzIuNTEwMjUgMTIuODA4NCAyLjgzMzQ0IDE0Ljk4NzIgMy44NDIyNCAxNi44NzQ1QzQuNjkzMjUgMTguNDY2NiA1Ljk4NzcyIDE5Ljc2ODMgNy41NTg3NiAyMC42MjgyQzguMDQzMjIgMjAuODkzMyA4LjYzMTUzIDIwLjY0NjQgOC44NDI4OCAyMC4xMzYxTDEwLjIwMTQgMTYuODU2M0MxMC40MTI4IDE2LjM0NjEgMTAuMTU4MSAxNS43NzAyIDkuNzIyOCAxNS40MzAzQzkuMzE4ODYgMTUuMTE0OSA4Ljk4MTkzIDE0LjcxNjcgOC43MzY5MSAxNC4yNTgzQzguMzMzMzggMTMuNTAzMyA4LjIwNDExIDEyLjYzMTggOC4zNzExMSAxMS43OTIzQzguNTM4MTEgMTAuOTUyNyA4Ljk5MTA1IDEwLjE5NyA5LjY1Mjc2IDkuNjUzOTZDMTAuMzE0NSA5LjExMDkxIDExLjE0NCA4LjgxNDEgMTIgOC44MTQxQzEyLjg1NiA4LjgxNDEgMTMuNjg1NiA5LjExMDkxIDE0LjM0NzMgOS42NTM5NkMxNS4wMDkgMTAuMTk3IDE1LjQ2MTkgMTAuOTUyNyAxNS42Mjg5IDExLjc5MjNDMTUuNzk1OSAxMi42MzE4IDE1LjY2NjYgMTMuNTAzMyAxNS4yNjMxIDE0LjI1ODNDMTUuMDE4MSAxNC43MTY3IDE0LjY4MTIgMTUuMTE0OSAxNC4yNzcyIDE1LjQzMDNDMTMuODQxOSAxNS43NzAyIDEzLjU4NzMgMTYuMzQ2MSAxMy43OTg2IDE2Ljg1NjNMMTUuMTU3MiAyMC4xMzYxWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.10.0
 */
declare const OpenSourceIcon: ProIcon;
export { OpenSourceIcon }
export { OpenSourceIcon as openSource }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNC4yNSIgeT0iMi43NSIgd2lkdGg9IjE1LjUiIGhlaWdodD0iMTguNSIgcng9IjIuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04LjI1IDIuNzVMOC4yNSAyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik00LjI1IDYuNzVIMTkuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNC4yNSAxNy4yNUgxOS43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS43NSAyLjc1TDE1Ljc1IDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PageMarginsIcon: ProIcon;
export { PageMarginsIcon }
export { PageMarginsIcon as pageMargins }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNzgwOTcgMTAuODMxOUM5LjM4NTIzIDEwLjcyNjEgOC45NjkyOSAxMC42Njk3IDguNTQwMTggMTAuNjY5N0M1Ljg5NDYzIDEwLjY2OTcgMy43NDk5OCAxMi44MTQzIDMuNzQ5OTggMTUuNDU5OVYxOS4yNTAxQzMuNzQ5OTggMTkuODAyMyA0LjE5NzcgMjAuMjUwMSA0Ljc0OTk5IDIwLjI1MDFIOC41NDAxOEMxMS4xODU3IDIwLjI1MDEgMTMuMzMwNCAxOC4xMDU0IDEzLjMzMDQgMTUuNDU5OUMxMy4zMzA0IDE1LjAzMDggMTMuMjc0IDE0LjYxNDkgMTMuMTY4MSAxNC4yMTkxTTkuNzgwOTcgMTAuODMxOUMxMS40MjkzIDExLjI3MjcgMTIuNzI3MyAxMi41NzA4IDEzLjE2ODEgMTQuMjE5MU05Ljc4MDk3IDEwLjgzMTlMMTIuOTcxMiA3LjY0MTc1TTEzLjE2ODEgMTQuMjE5MUwxNi4zNTgzIDExLjAyODlNMTIuOTcxMiA3LjY0MTc1TDE2LjE2MTMgNC40NTE1N0MxNy4wOTY3IDMuNTE2MjIgMTguNjEzMiAzLjUxNjIzIDE5LjU0ODUgNC40NTE1N0MyMC40ODM5IDUuMzg2OTEgMjAuNDgzOSA2LjkwMzQxIDE5LjU0ODUgNy44Mzg3NUwxNi4zNTgzIDExLjAyODlNMTIuOTcxMiA3LjY0MTc1TDE2LjM1ODMgMTEuMDI4OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const Paintbrush2Icon: ProIcon;
export { Paintbrush2Icon }
export { Paintbrush2Icon as paintbrush2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const PaintbrushIcon: ProIcon;
export { PaintbrushIcon }
export { PaintbrushIcon as paintbrush }

/**
 * @description House, Home Samsung
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjY3NjYgMTMuMzQ5OUwxNi43NTM2IDE2LjUxOThDMTUuNzY4OSAxOC42MTI0IDE4LjA2NzkgMjAuNzI2NCAyMC4wNzA3IDE5LjU3MDFDMjEuMjAwMSAxOC45MTggMjEuNTg3IDE3LjQ3MzkgMjAuOTM1IDE2LjM0NDZMMTguNjc2NiAxMy4zNDk5WiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTEuMzUyMiAxNC45Mjc4TDE1Ljc1IDEwLjUzTDIuNzQ4MjggMTAuNTNDMi43NDgyOCAxMC43NjczIDIuNzg1NCAxMS4wMDQ3IDIuODU5NjQgMTEuMjMzMkMzLjAyODQ1IDExLjc1MjcgMy40NzkgMTIuMjAzMyA0LjM4MDA5IDEzLjEwNDNMNi4yMDM1NyAxNC45Mjc4QzcuMTA0NjYgMTUuODI4OSA3LjU1NTIxIDE2LjI3OTUgOC4wNzQ3NSAxNi40NDgzQzguNTMxNzUgMTYuNTk2OCA5LjAyNDAzIDE2LjU5NjggOS40ODEwMiAxNi40NDgzQzEwLjAwMDYgMTYuMjc5NSAxMC40NTExIDE1LjgyODkgMTEuMzUyMiAxNC45Mjc4WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PaintBucketAccentIcon: ProIcon;
export { PaintBucketAccentIcon }
export { PaintBucketAccentIcon as paintBucketAccent }

/**
 * @description House, Home Samsung
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjY3NjYgMTMuMzQ5OUwxNi43NTM2IDE2LjUxOTlDMTUuNzY4OSAxOC42MTI1IDE4LjA2NzkgMjAuNzI2NCAyMC4wNzA3IDE5LjU3MDFDMjEuMjAwMSAxOC45MTgxIDIxLjU4NyAxNy40NzQgMjAuOTM1IDE2LjM0NDZMMTguNjc2NiAxMy4zNDk5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC43Nzc4OSAzLjU1NzlMMTUuNzUgMTAuNTNNOC43Nzc4OSAzLjU1NzlMNC4zODAwOSA3Ljk1NTY5QzMuNDc5IDguODU2NzkgMy4wMjg0NSA5LjMwNzM0IDIuODU5NjQgOS44MjY4N0MyLjc4NTQgMTAuMDU1NCAyLjc0ODI4IDEwLjI5MjcgMi43NDgyOCAxMC41M004Ljc3Nzg5IDMuNTU3OUw3LjcxODkyIDIuNDk4OTZNMTUuNzUgMTAuNTNMMTEuMzUyMiAxNC45Mjc4QzEwLjQ1MTEgMTUuODI4OSAxMC4wMDA2IDE2LjI3OTQgOS40ODEwMiAxNi40NDgzQzkuMDI0MDMgMTYuNTk2NyA4LjUzMTc1IDE2LjU5NjcgOC4wNzQ3NSAxNi40NDgzQzcuNTU1MjEgMTYuMjc5NCA3LjEwNDY3IDE1LjgyODkgNi4yMDM1NyAxNC45Mjc4TDQuMzgwMDkgMTMuMTA0M0MzLjQ3OSAxMi4yMDMyIDMuMDI4NDUgMTEuNzUyNyAyLjg1OTY0IDExLjIzMzFDMi43ODU0IDExLjAwNDYgMi43NDgyOCAxMC43NjczIDIuNzQ4MjggMTAuNTNNMTUuNzUgMTAuNTNMNS44NDM3NSAxMC41M0gyLjc0ODI4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEyLjkzNTggMjAuNTAxTDMuNzQ4MjggMjAuNTAxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PaintBucketIcon: ProIcon;
export { PaintBucketIcon }
export { PaintBucketIcon as paintBucket }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNTQ3MyAzLjc1SDcuMjVDNS4zMTcgMy43NSAzLjc1IDUuMzE3IDMuNzUgNy4yNVYxNi43NUMzLjc1IDE4LjY4MyA1LjMxNyAyMC4yNSA3LjI1IDIwLjI1SDkuNTQ3M005LjU0NzMgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIOS41NDczTTkuNTQ3MyAzLjc1VjIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE0Ljc1OTEgMTQuMjVMMTIuNTUgMTJNMTIuNTUgMTJMMTQuNzU5MSA5Ljc1TTEyLjU1IDEySDE3LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const PanelLeftContractIcon: ProIcon;
export { PanelLeftContractIcon }
export { PanelLeftContractIcon as panelLeftContract }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNTQ3MyAzLjc1SDcuMjVDNS4zMTcgMy43NSAzLjc1IDUuMzE3IDMuNzUgNy4yNVYxNi43NUMzLjc1IDE4LjY4MyA1LjMxNyAyMC4yNSA3LjI1IDIwLjI1SDkuNTQ3M005LjU0NzMgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIOS41NDczTTkuNTQ3MyAzLjc1VjIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjA0MDkgMTQuMjVMMTcuMjUgMTJNMTcuMjUgMTJMMTUuMDQwOSA5Ljc1TTE3LjI1IDEySDEyLjU1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const PanelLeftExpandIcon: ProIcon;
export { PanelLeftExpandIcon }
export { PanelLeftExpandIcon as panelLeftExpand }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNTQ3MyAzLjc1SDcuMjVDNS4zMTcgMy43NSAzLjc1IDUuMzE3IDMuNzUgNy4yNVYxNi43NUMzLjc1IDE4LjY4MyA1LjMxNyAyMC4yNSA3LjI1IDIwLjI1SDkuNTQ3M005LjU0NzMgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIOS41NDczTTkuNTQ3MyAzLjc1VjIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PanelLeftIcon: ProIcon;
export { PanelLeftIcon }
export { PanelLeftIcon as panelLeft }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2Ljc1IDMuNzVDMTguNjgzIDMuNzUgMjAuMjUgNS4zMTcgMjAuMjUgNy4yNVYxNi43NUMyMC4yNSAxOC42ODMgMTguNjgzIDIwLjI1IDE2Ljc1IDIwLjI1SDE0LjQ1MjdWMy43NUgxNi43NVoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTE0LjQ1MjcgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVINy4yNUM1LjMxNyAzLjc1IDMuNzUgNS4zMTcgMy43NSA3LjI1VjE2Ljc1QzMuNzUgMTguNjgzIDUuMzE3IDIwLjI1IDcuMjUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVWMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PanelLeftOpenIcon: ProIcon;
export { PanelLeftOpenIcon }
export { PanelLeftOpenIcon as panelLeftOpen }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjQ1MjcgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVINy4yNUM1LjMxNyAzLjc1IDMuNzUgNS4zMTcgMy43NSA3LjI1VjE2Ljc1QzMuNzUgMTguNjgzIDUuMzE3IDIwLjI1IDcuMjUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVWMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOS4yNDA5IDE0LjI1TDExLjQ1IDEyTTExLjQ1IDEyTDkuMjQwOSA5Ljc1TTExLjQ1IDEySDYuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const PanelRightContractIcon: ProIcon;
export { PanelRightContractIcon }
export { PanelRightContractIcon as panelRightContract }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjQ1MjcgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVINy4yNUM1LjMxNyAzLjc1IDMuNzUgNS4zMTcgMy43NSA3LjI1VjE2Ljc1QzMuNzUgMTguNjgzIDUuMzE3IDIwLjI1IDcuMjUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVWMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC45NTkxMiAxNC4yNUw2Ljc1MDAyIDEyTTYuNzUwMDIgMTJMOC45NTkxMiA5Ljc1TTYuNzUwMDIgMTJIMTEuNDUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const PanelRightExpandIcon: ProIcon;
export { PanelRightExpandIcon }
export { PanelRightExpandIcon as panelRightExpand }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjQ1MjcgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVINy4yNUM1LjMxNyAzLjc1IDMuNzUgNS4zMTcgMy43NSA3LjI1VjE2Ljc1QzMuNzUgMTguNjgzIDUuMzE3IDIwLjI1IDcuMjUgMjAuMjVIMTQuNDUyN00xNC40NTI3IDMuNzVWMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PanelRightIcon: ProIcon;
export { PanelRightIcon }
export { PanelRightIcon as panelRight }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMjUgMy43NUM1LjMxNyAzLjc1IDMuNzUgNS4zMTcgMy43NSA3LjI1VjE2Ljc1QzMuNzUgMTguNjgzIDUuMzE3IDIwLjI1IDcuMjUgMjAuMjVIOS41NDczVjMuNzVINy4yNVoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTkuNTQ3MyAzLjc1SDcuMjVDNS4zMTcgMy43NSAzLjc1IDUuMzE3IDMuNzUgNy4yNVYxNi43NUMzLjc1IDE4LjY4MyA1LjMxNyAyMC4yNSA3LjI1IDIwLjI1SDkuNTQ3M005LjU0NzMgMy43NUgxNi43NUMxOC42ODMgMy43NSAyMC4yNSA1LjMxNyAyMC4yNSA3LjI1VjE2Ljc1QzIwLjI1IDE4LjY4MyAxOC42ODMgMjAuMjUgMTYuNzUgMjAuMjVIOS41NDczTTkuNTQ3MyAzLjc1VjIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PanelRightOpenIcon: ProIcon;
export { PanelRightOpenIcon }
export { PanelRightOpenIcon as panelRightOpen }

/**
 * @description Stop
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNSIgeT0iMy43NDk5OSIgd2lkdGg9IjUiIGhlaWdodD0iMTYuNSIgcng9IjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMTQiIHk9IjMuNzQ5OTkiIHdpZHRoPSI1IiBoZWlnaHQ9IjE2LjUiIHJ4PSIyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const PauseIcon: ProIcon;
export { PauseIcon }
export { PauseIcon as pause }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNzkxNjkgMjEuMjVIMTYuMjA4NEMxOC4xNDE0IDIxLjI1IDE5LjcwODQgMTkuNjgzIDE5LjcwODQgMTcuNzVWMTIuMjE5NUMxOS43MDg0IDExLjI5MTQgMTkuMzM5NyAxMC40MDEzIDE4LjY4MzUgOS43NDQ5MkwxMi43MTUyIDMuNzc1MzhDMTIuMDU4OCAzLjExODg1IDExLjE2ODQgMi43NSAxMC4yNDAxIDIuNzVINy43OTE2OUM1Ljg1ODY5IDIuNzUgNC4yOTE2OSA0LjMxNyA0LjI5MTY5IDYuMjVWMTcuNzVDNC4yOTE2OSAxOS42ODMgNS44NTg2OSAyMS4yNSA3Ljc5MTY5IDIxLjI1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS42ODc1IDMuMTA5OTlWOC43NzA1NkMxMS42ODc1IDkuODc1MTMgMTIuNTgyOSAxMC43NzA2IDEzLjY4NzUgMTAuNzcwNkgxOS4zNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03LjI1IDE2LjVWMTUuNU03LjI1IDE1LjVWMTMuNUg4LjI1QzguODAyMjggMTMuNSA5LjI1IDEzLjk0NzcgOS4yNSAxNC41VjE0LjVDOS4yNSAxNS4wNTIzIDguODAyMjggMTUuNSA4LjI1IDE1LjVINy4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS4yNSAxNi41VjEzLjVIMTEuNzVDMTIuNTc4NCAxMy41IDEzLjI1IDE0LjE3MTYgMTMuMjUgMTVDMTMuMjUgMTUuODI4NCAxMi41Nzg0IDE2LjUgMTEuNzUgMTYuNUgxMS4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS4yNSAxNi41VjE1LjI1TTE2Ljc1IDEzLjVIMTUuMjVWMTUuMjVNMTUuMjUgMTUuMjVIMTYuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const Pdf2Icon: ProIcon;
export { Pdf2Icon }
export { Pdf2Icon as pdf2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTExLjc4OTQgMTAuNjcyN0wxMS43MzE1IDEwLjkzNzdDMTEuNDcxNSAxMi4xMjY1IDExLjAwNjUgMTMuMjQzNiAxMC4zNjQgMTQuMjIzNk0xMS43ODk0IDEwLjY3MjdMMTIuMjU2NCA4LjUzNzMzQzEyLjQxNzkgNy43OTkxIDExLjY5OTggNy4yMjA2MyAxMS4xNDU5IDcuNjQyNzJDMTAuODQ4OCA3Ljg2OTEyIDEwLjczOTIgOC4zMDgzNCAxMC44ODY5IDguNjc5OTFMMTEuMTMyNCA5LjI5NzM1QzExLjMyMjYgOS43NzU2IDExLjU0MjQgMTAuMjM1MSAxMS43ODk0IDEwLjY3MjdaTTExLjc4OTQgMTAuNjcyN0MxMi4zNDc4IDExLjY2MTkgMTMuMDQ1MiAxMi41MzkzIDEzLjg1MzQgMTMuMjY5NE0xMy44NTM0IDEzLjI2OTRMMTYuMTA4NCAxMi45ODNDMTYuNzM5OCAxMi45MDI4IDE3LjE5ODEgMTMuNjU0IDE2LjkxMzkgMTQuMzAzNUMxNi43MDY5IDE0Ljc3NjkgMTYuMTkzIDE0Ljk1MTkgMTUuNzkzIDE0LjY4NTJMMTQuOTQxNiAxNC4xMTc1QzE0LjU2MDMgMTMuODYzMiAxNC4xOTY5IDEzLjU3OTYgMTMuODUzNCAxMy4yNjk0Wk0xMy44NTM0IDEzLjI2OTRMMTMuNzU3NiAxMy4yODE2QzEyLjU5NDEgMTMuNDI5MyAxMS40NTM4IDEzLjc0NjQgMTAuMzY0IDE0LjIyMzZNMTAuMzY0IDE0LjIyMzZDOS45NDY2MiAxNC40MDY0IDkuNTM2NjMgMTQuNjEyNiA5LjEzNTU5IDE0Ljg0MThMNy40Mjk3OCAxNS44MTY4QzYuOTU1MjcgMTYuMDg4IDYuODUyNjUgMTYuODEwOSA3LjIyNzc4IDE3LjIzOThDNy41NTk1NCAxNy42MTkgOC4xMDczNyAxNy41NzgzIDguMzkzNDMgMTcuMTUzMkwxMC4zMDI2IDE0LjMxNkMxMC4zMjMzIDE0LjI4NTMgMTAuMzQzNyAxNC4yNTQ1IDEwLjM2NCAxNC4yMjM2WiIgc3Ryb2tlPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik03Ljc5MTY5IDIxLjI1SDE2LjIwODRDMTguMTQxNCAyMS4yNSAxOS43MDg0IDE5LjY4MyAxOS43MDg0IDE3Ljc1VjEyLjIxOTVDMTkuNzA4NCAxMS4yOTE0IDE5LjMzOTcgMTAuNDAxMyAxOC42ODM1IDkuNzQ0OTJMMTIuNzE1MiAzLjc3NTM4QzEyLjA1ODggMy4xMTg4NSAxMS4xNjg0IDIuNzUgMTAuMjQwMSAyLjc1SDcuNzkxNjlDNS44NTg2OSAyLjc1IDQuMjkxNjkgNC4zMTcgNC4yOTE2OSA2LjI1VjE3Ljc1QzQuMjkxNjkgMTkuNjgzIDUuODU4NjkgMjEuMjUgNy43OTE2OSAyMS4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PdfIcon: ProIcon;
export { PdfIcon }
export { PdfIcon as pdf }

/**
 * @description Write, Draw, Edit
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjQzOTQgNS43Nzk1OEw0LjE5ODg0IDE2LjAyMDFDMy44OTQ1NSAxNi4zMjQ0IDMuNjk2NTIgMTYuNzE4NyAzLjYzNDE2IDE3LjE0NDVMMy4wODE0MiAyMC45MTg2TDYuODU1NTIgMjAuMzY1OUM3LjI4MTMxIDIwLjMwMzUgNy42NzU2MiAyMC4xMDU1IDcuOTc5OTEgMTkuODAxMkwxOC4yMjA1IDkuNTYwNjVNMTQuNDM5NCA1Ljc3OTU4TDE2LjY2OSAzLjU1QzE3LjI5MzggMi45MjUxNiAxOC4zMDY5IDIuOTI1MTYgMTguOTMxNyAzLjU1TDIwLjQ1IDUuMDY4MzNDMjEuMDc0OSA1LjY5MzE3IDIxLjA3NDkgNi43MDYyMyAyMC40NSA3LjMzMTA3TDE4LjIyMDUgOS41NjA2NU0xNC40Mzk0IDUuNzc5NThMMTguMjIwNSA5LjU2MDY1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PencilIcon: ProIcon;
export { PencilIcon }
export { PencilIcon as pencil }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjEzMDIgMy42NTQ3N0MxMS4yNDUxIDIuODQ0NzMgMTIuNzU0OSAyLjg0NDczIDEzLjg2OTggMy42NTQ3N0wxOS45Mzg1IDguMDYzOTVDMjEuMDUzNCA4Ljg3Mzk5IDIxLjUyIDEwLjMwOTggMjEuMDk0MSAxMS42MjA1TDE4Ljc3NiAxOC43NTQ3QzE4LjM1MDIgMjAuMDY1NCAxNy4xMjg4IDIwLjk1MjggMTUuNzUwNyAyMC45NTI4SDguMjQ5MzNDNi44NzEyMSAyMC45NTI4IDUuNjQ5ODIgMjAuMDY1NCA1LjIyMzk1IDE4Ljc1NDdMMi45MDU5MSAxMS42MjA1QzIuNDgwMDUgMTAuMzA5OCAyLjk0NjU4IDguODczOTkgNC4wNjE1IDguMDYzOTVMMTAuMTMwMiAzLjY1NDc3WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const PentagonIcon: ProIcon;
export { PentagonIcon }
export { PentagonIcon as pentagon }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSI4LjE5NjExIiByPSI0LjQ0NjExIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE5LjYwNzggMjAuMjVDMTkuNjA3OCAxOC4yMzIzIDE4LjgwNjIgMTYuMjk3MiAxNy4zNzk1IDE0Ljg3MDVDMTUuOTUyOCAxMy40NDM3IDE0LjAxNzcgMTIuNjQyMiAxMiAxMi42NDIyQzkuOTgyMjkgMTIuNjQyMiA4LjA0NzIyIDEzLjQ0MzcgNi42MjA0OCAxNC44NzA1QzUuMTkzNzQgMTYuMjk3MiA0LjM5MjIxIDE4LjIzMjMgNC4zOTIyMSAyMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const Person2Icon: ProIcon;
export { Person2Icon }
export { Person2Icon as person2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjI1IDEuNzVWNy43NU0xNi4yNSA0Ljc1SDIyLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEwLjQzNTYgMTMuNTY0NEMxMi41OTM1IDEzLjU2NDQgMTQuMzQyOCAxMS44MTUxIDE0LjM0MjggOS42NTcxOUMxNC4zNDI4IDcuNDk5MzEgMTIuNTkzNSA1Ljc1IDEwLjQzNTYgNS43NUM4LjI3Nzc1IDUuNzUgNi41Mjg0NCA3LjQ5OTMxIDYuNTI4NDQgOS42NTcxOUM2LjUyODQ0IDExLjgxNTEgOC4yNzc3NSAxMy41NjQ0IDEwLjQzNTYgMTMuNTY0NFpNMTAuNDM1NiAxMy41NjQ0QzEyLjIwODggMTMuNTY0NCAxMy45MDkzIDE0LjI2ODcgMTUuMTYzMSAxNS41MjI1QzE2LjQxNjkgMTYuNzc2MyAxNy4xMjEzIDE4LjQ3NjkgMTcuMTIxMyAyMC4yNU0xMC40MzU2IDEzLjU2NDRDOC42NjI0OSAxMy41NjQ0IDYuOTYxOTggMTQuMjY4NyA1LjcwODE4IDE1LjUyMjVDNC40NTQzOCAxNi43NzYzIDMuNzUgMTguNDc2OSAzLjc1IDIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PersonAdd2Icon: ProIcon;
export { PersonAdd2Icon }
export { PersonAdd2Icon as personAdd2 }

/**
 * @description Account Add, User
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0LjEwMzcgNi44NTM3NUMxNC4xMDM3IDguODQ0MDQgMTIuNDkwMyAxMC40NTc1IDEwLjUgMTAuNDU3NUM4LjUwOTcyIDEwLjQ1NzUgNi44OTYyNyA4Ljg0NDA0IDYuODk2MjcgNi44NTM3NUM2Ljg5NjI3IDQuODYzNDUgOC41MDk3MiAzLjI1IDEwLjUgMy4yNUMxMi40OTAzIDMuMjUgMTQuMTAzNyA0Ljg2MzQ1IDE0LjEwMzcgNi44NTM3NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTAuODY5NiAyMC43NUwzLjUgMjAuNzVDMi45NDc3MSAyMC43NSAyLjUgMjAuMzAyMyAyLjUgMTkuNzVWMTguNTA0MUMyLjUgMTUuNjk3NyA2LjQ3NDAzIDEzLjUgMTAuNSAxMy41QzEwLjc1NzMgMTMuNSAxMS4wMTQ1IDEzLjUwOSAxMS4yNzA0IDEzLjUyNjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTE3LjUgMjMuMDAwMUMyMC41Mzc2IDIzLjAwMDEgMjMgMjAuNTM3NiAyMyAxNy41MDAxQzIzIDE0LjQ2MjUgMjAuNTM3NiAxMi4wMDAxIDE3LjUgMTIuMDAwMUMxNC40NjI0IDEyLjAwMDEgMTIgMTQuNDYyNSAxMiAxNy41MDAxQzEyIDIwLjUzNzYgMTQuNDYyNCAyMy4wMDAxIDE3LjUgMjMuMDAwMVpNMTcuNSAxNC4wMDY3QzE3Ljc3NjEgMTQuMDA2NyAxOCAxNC4yMzA1IDE4IDE0LjUwNjdWMTcuMDAwMUgyMC40OTM0QzIwLjc2OTYgMTcuMDAwMSAyMC45OTM0IDE3LjIyNCAyMC45OTM0IDE3LjUwMDFDMjAuOTkzNCAxNy43NzYzIDIwLjc2OTYgMTguMDAwMSAyMC40OTM0IDE4LjAwMDFIMThWMjAuNDkzNUMxOCAyMC43Njk2IDE3Ljc3NjEgMjAuOTkzNSAxNy41IDIwLjk5MzVDMTcuMjIzOSAyMC45OTM1IDE3IDIwLjc2OTYgMTcgMjAuNDkzNVYxOC4wMDAxSDE0LjUwNjZDMTQuMjMwNCAxOC4wMDAxIDE0LjAwNjYgMTcuNzc2MyAxNC4wMDY2IDE3LjUwMDFDMTQuMDA2NiAxNy4yMjQgMTQuMjMwNCAxNy4wMDAxIDE0LjUwNjYgMTcuMDAwMUgxN1YxNC41MDY3QzE3IDE0LjIzMDUgMTcuMjIzOSAxNC4wMDY3IDE3LjUgMTQuMDA2N1oiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PersonAddIcon: ProIcon;
export { PersonAddIcon }
export { PersonAddIcon as personAdd }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDEzLjgyNTVDMTMuOTM2NiAxMy44MjU1IDE1LjUwNjUgMTIuMjU1NiAxNS41MDY1IDEwLjMxOUMxNS41MDY1IDguMzgyNDEgMTMuOTM2NiA2LjgxMjUgMTIgNi44MTI1QzEwLjA2MzQgNi44MTI1IDguNDkzNTEgOC4zODI0MSA4LjQ5MzUxIDEwLjMxOUM4LjQ5MzUxIDEyLjI1NTYgMTAuMDYzNCAxMy44MjU1IDEyIDEzLjgyNTVaTTEyIDEzLjgyNTVDMTMuNTkxMyAxMy44MjU1IDE1LjExNzQgMTQuNDU3NiAxNi4yNDI2IDE1LjU4MjlDMTcuMTkwNiAxNi41MzA4IDE3Ljc4ODYgMTcuNzYzNCAxNy45NTM1IDE5LjA3OTdNMTIgMTMuODI1NUMxMC40MDg3IDEzLjgyNTUgOC44ODI1OCAxNC40NTc2IDcuNzU3MzYgMTUuNTgyOUM2LjgwOTM4IDE2LjUzMDggNi4yMTEzNyAxNy43NjM0IDYuMDQ2NTEgMTkuMDc5N002LjA0NjUxIDE5LjA3OTdDNy42NTUzNiAyMC40MzQgOS43MzIzOSAyMS4yNSAxMiAyMS4yNUMxNC4yNjc2IDIxLjI1IDE2LjM0NDYgMjAuNDM0IDE3Ljk1MzUgMTkuMDc5N002LjA0NjUxIDE5LjA3OTdDNC4wMzA4MSAxNy4zODI5IDIuNzUgMTQuODQxIDIuNzUgMTJDMi43NSA2Ljg5MTM3IDYuODkxMzcgMi43NSAxMiAyLjc1QzE3LjEwODYgMi43NSAyMS4yNSA2Ljg5MTM3IDIxLjI1IDEyQzIxLjI1IDE0Ljg0MSAxOS45NjkyIDE3LjM4MjkgMTcuOTUzNSAxOS4wNzk3IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PersonCircleIcon: ProIcon;
export { PersonCircleIcon }
export { PersonCircleIcon as personCircle }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5IDIwLjc1QzE5LjU1MjMgMjAuNzUgMjAgMjAuMzAyMyAyMCAxOS43NVYxOC41MDQxQzIwLjAwMzcgMTUuNjk3NyAxNi4wMjYgMTMuNSAxMiAxMy41QzcuOTc0MDMgMTMuNSA0IDE1LjY5NzcgNCAxOC41MDQxVjE5Ljc1QzQgMjAuMzAyMyA0LjQ0NzcxIDIwLjc1IDUgMjAuNzVMMTkgMjAuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjYwMzcgNi44NTM3NUMxNS42MDM3IDguODQ0MDQgMTMuOTkwMyAxMC40NTc1IDEyIDEwLjQ1NzVDMTAuMDA5NyAxMC40NTc1IDguMzk2MjcgOC44NDQwNCA4LjM5NjI3IDYuODUzNzVDOC4zOTYyNyA0Ljg2MzQ1IDEwLjAwOTcgMy4yNSAxMiAzLjI1QzEzLjk5MDMgMy4yNSAxNS42MDM3IDQuODYzNDUgMTUuNjAzNyA2Ljg1Mzc1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const PersonIcon: ProIcon;
export { PersonIcon }
export { PersonIcon as person }

/**
 * @description Users, User Multiple
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEzLjMyMTUgNy4yMDg1N0MxMy4zMjE1IDcuOTU3ODIgMTMuMDg0OCA4LjY1MTQyIDEyLjY4MjYgOS4yMTc3NUMxMi4wNTk1IDEwLjA5NTIgMTEuMDM5IDEwLjY2NzEgOS44ODU3NyAxMC42NjcxQzcuOTg4MjkgMTAuNjY3MSA2LjQ1MDA3IDkuMTE4NjggNi40NTAwNyA3LjIwODU3QzYuNDUwMDcgNS4yOTg0NSA3Ljk4ODI5IDMuNzUgOS44ODU3NyAzLjc1QzExLjY1NjggMy43NSAxMy4xMTQ4IDUuMDk4OTEgMTMuMzAxMyA2LjgzMTc5QzEzLjMxNDYgNi45NTU1NCAxMy4zMjE1IDcuMDgxMjUgMTMuMzIxNSA3LjIwODU3WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDE4LjEwNzJDMi43NSAxNS40Mjk2IDYuMjk0NjkgMTMuMzMyOSA5Ljg4NTcxIDEzLjMzMjlDMTEuMzE3NyAxMy4zMzI5IDEyLjc0MjkgMTMuNjY2MyAxMy45Mzg4IDE0LjIzN0MxNS43NDE3IDE1LjA5NzUgMTcuMDIzNCAxNi40OTc0IDE3LjAyMTQgMTguMTA3MlYxOS4yNUMxNy4wMjE0IDE5LjgwMjMgMTYuNTczNyAyMC4yNSAxNi4wMjE0IDIwLjI1TDMuNzUgMjAuMjVDMy4xOTc3MSAyMC4yNSAyLjc1IDE5LjgwMjMgMi43NSAxOS4yNVYxOC4xMDcyWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS4xNzE1IDMuNzVDMTYuOTQyNSAzLjc1IDE4LjQwMDYgNS4wOTg5MSAxOC41ODcxIDYuODMxNzlDMTguNjAwNCA2Ljk1NTU0IDE4LjYwNzIgNy4wODEyNSAxOC42MDcyIDcuMjA4NTdDMTguNjA3MiA3Ljk1NzgyIDE4LjM3MDUgOC42NTE0MiAxNy45NjgzIDkuMjE3NzVDMTcuMzQ1MiAxMC4wOTUyIDE2LjMyNDcgMTAuNjY3MSAxNS4xNzE1IDEwLjY2NzEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTguNjI0IDEzLjIzN0MyMC4xNTk5IDE0LjA5NzUgMjEuMjUxNyAxNi4wMDAyIDIxLjI1IDE3LjYxVjIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const PersonMultipleIcon: ProIcon;
export { PersonMultipleIcon }
export { PersonMultipleIcon as personMultiple }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMTM5MDcgMTUuNzMyNkMxMC4yOTc2IDE3Ljg5MTEgMTIuNDE3NyAxOS4wMTM2IDE0LjAzMDIgMTkuNTk3M0MxNS43OTc2IDIwLjIzNyAxNy42MzYxIDE5LjQ4MDUgMTguOTY1MiAxOC4xNTE0TDE5LjQyNCAxNy42OTI2QzIwLjAwOTggMTcuMTA2OCAyMC4wMDk4IDE2LjE1NzEgMTkuNDI0IDE1LjU3MTNMMTguMjc1IDE0LjQyMjJDMTcuNjg5MiAxMy44MzY0IDE2LjczOTUgMTMuODM2NCAxNi4xNTM3IDE0LjQyMjJMMTUuNzY3IDE0LjgwODlDMTQuOTg1OSAxNS41OSAxMy43MTk2IDE1LjU5IDEyLjkzODYgMTQuODA4OUw5LjIyNjI0IDExLjA5NjZDOC40NDUxOSAxMC4zMTU2IDguNDQ1MTkgOS4wNDkyNCA5LjIyNjI0IDguMjY4MTlMOS42MTI5NCA3Ljg4MTQ5QzEwLjE5ODcgNy4yOTU3MSAxMC4xOTg3IDYuMzQ1OTYgOS42MTI5NCA1Ljc2MDE3TDguNDYzODkgNC42MTExMkM3Ljg3ODExIDQuMDI1MzQgNi45MjgzNiA0LjAyNTM0IDYuMzQyNTcgNC42MTExMkw1Ljc3MDUgNS4xODMxOUM0LjUwODYgNi40NDUwOSAzLjc1Nzg4IDguMTczNTMgNC4zMzI5NCA5Ljg2MjkzQzQuODcwNTMgMTEuNDQyMyA1Ljk1NDYgMTMuNTQ4MSA4LjEzOTA3IDE1LjczMjZaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const PhoneAcceptIcon: ProIcon;
export { PhoneAcceptIcon }
export { PhoneAcceptIcon as phoneAccept }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjExNTYgNy45NTMxMkM5LjA2MzAxIDcuOTUzMTMgNi43NzAxMiA4LjY1ODU5IDUuMjE3MjQgOS4zODYwM0MzLjUxNTEyIDEwLjE4MzQgMi43NSAxMi4wMTg0IDIuNzUgMTMuODk4TDIuNzUgMTQuNTQ2OUMyLjc1IDE1LjM3NTMgMy40MjE1NyAxNi4wNDY5IDQuMjUgMTYuMDQ2OUw1Ljg3NSAxNi4wNDY5QzYuNzAzNDMgMTYuMDQ2OSA3LjM3NSAxNS4zNzUzIDcuMzc1IDE0LjU0NjlMNy4zNzUgMTRDNy4zNzUgMTIuODk1NCA4LjI3MDQzIDEyIDkuMzc1IDEyTDE0LjYyNSAxMkMxNS43Mjk2IDEyIDE2LjYyNSAxMi44OTU0IDE2LjYyNSAxNEwxNi42MjUgMTQuNTQ2OUMxNi42MjUgMTUuMzc1MyAxNy4yOTY2IDE2LjA0NjkgMTguMTI1IDE2LjA0NjlIMTkuNzVDMjAuNTc4NCAxNi4wNDY5IDIxLjI1IDE1LjM3NTMgMjEuMjUgMTQuNTQ2OVYxMy43Mzc4QzIxLjI1IDExLjk1MzMgMjAuNTU4NiAxMC4yMDAyIDE4Ljk1NzQgOS40MTIyNkMxNy40NjA2IDguNjc1NjQgMTUuMjA0OSA3Ljk1MzEyIDEyLjExNTYgNy45NTMxMloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PhoneHangUpIcon: ProIcon;
export { PhoneHangUpIcon }
export { PhoneHangUpIcon as phoneHangUp }

/**
 * @description iPhone, Samsung Galaxy, Mobile, Android, iOS, Smartphone
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNS43NSIgeT0iMi43NSIgd2lkdGg9IjEyLjUiIGhlaWdodD0iMTguNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTEgMTcuNzVIMTMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PhoneIcon: ProIcon;
export { PhoneIcon }
export { PhoneIcon as phone }

/**
 * @description Color Filter, Tint
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSI4LjcyOTgiIHI9IjUuOTc5OCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8Y2lyY2xlIGN4PSI4LjcyODU4IiBjeT0iMTUuMjcwMiIgcj0iNS45Nzk4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxjaXJjbGUgY3g9IjE1LjI3MTQiIGN5PSIxNS4yNzAyIiByPSI1Ljk3OTgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PhotoFilterIcon: ProIcon;
export { PhotoFilterIcon }
export { PhotoFilterIcon as photoFilter }

/**
 * @description Image, Picture
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjMzMDIgMTcuNjU2OUMyMC40NDA2IDE3LjI5MDYgMjAuNSAxNi45MDIzIDIwLjUgMTYuNVY3LjVDMjAuNSA1LjI5MDg2IDE4LjcwOTEgMy41IDE2LjUgMy41SDcuNUM1LjI5MDg2IDMuNSAzLjUgNS4yOTA4NiAzLjUgNy41VjE2LjVDMy41IDE2LjUyMzYgMy41MDAyIDE2LjU0NzIgMy41MDA2MSAxNi41NzA3TTIwLjMzMDIgMTcuNjU2OUwyMC4yNDI0IDE3LjU1MzNMMTcuNzc2NCAxNC41NzY4QzE2Ljk3OTMgMTMuNjE0OCAxNS41MDUxIDEzLjYxMDkgMTQuNzAzIDE0LjU2ODdMMTMuMzkwOCAxNi4xMzU1TDEzLjE3NzQgMTYuMzk2NE0yMC4zMzAyIDE3LjY1NjlDMTkuODQ0NyAxOS4yNjYyIDE4LjM3MjcgMjAuNDQ3OCAxNi42MTczIDIwLjQ5ODNNMTYuNjE3MyAyMC40OTgzQzE2LjU3ODMgMjAuNDk5NCAxNi41MzkyIDIwLjUgMTYuNSAyMC41SDcuNUM1LjMxNDQ4IDIwLjUgMy41MzgzNCAxOC43NDcyIDMuNTAwNjEgMTYuNTcwN00xNi42MTczIDIwLjQ5ODNMMTYuNTIzOSAyMC4zOTIyTDEzLjE3NzQgMTYuMzk2NE0zLjUwMDYxIDE2LjU3MDdMMy42Nzg0MSAxNi4zNjk5TDYuODgzNTQgMTIuNTQyOUM3LjY4MjkyIDExLjU4ODQgOS4xNTA3NSAxMS41ODg0IDkuOTUwMTMgMTIuNTQyOUwxMy4xNzc0IDE2LjM5NjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8ZWxsaXBzZSBjeD0iMTUuMDkwOSIgY3k9IjguOTA5MSIgcng9IjEuNSIgcnk9IjEuNDk5OTgiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PhotoIcon: ProIcon;
export { PhotoIcon }
export { PhotoIcon as photo }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjI1IDRINS43NUM0LjA5MzE1IDQgMi43NSA1LjM0MzE1IDIuNzUgN1YxN0MyLjc1IDE4LjY1NjkgNC4wOTMxNSAyMCA1Ljc1IDIwSDE4LjI1QzE5LjkwNjkgMjAgMjEuMjUgMTguNjU2OSAyMS4yNSAxN1Y3QzIxLjI1IDUuMzQzMTUgMTkuOTA2OSA0IDE4LjI1IDRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMTAuMjUiIHk9IjEwLjQxOTkiIHdpZHRoPSI4LjUiIGhlaWdodD0iNy4wODMzMyIgcng9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PictureInPicture2Icon: ProIcon;
export { PictureInPicture2Icon }
export { PictureInPicture2Icon as pictureInPicture2 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMjUgMTguMjVINS43NUM0LjA5MzE1IDE4LjI1IDIuNzUgMTYuOTA2OSAyLjc1IDE1LjI1VjYuNzVDMi43NSA1LjA5MzE1IDQuMDkzMTUgMy43NSA1Ljc1IDMuNzVIMTguMjVDMTkuOTA2OSAzLjc1IDIxLjI1IDUuMDkzMTUgMjEuMjUgNi43NVYxMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjExIiB5PSIxMiIgd2lkdGg9IjEyIiBoZWlnaHQ9IjEwIiByeD0iMiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNOS45OTk5OSA3LjY2Njc1VjEwLjQwMDFDOS45OTk5OSAxMC41NjU3IDkuOTMyODUgMTAuNzE1NyA5LjgyNDMgMTAuODI0M002LjY2NjY2IDExLjAwMDFIOS4zOTk5OUM5LjU2NTcgMTEuMDAwMSA5LjcxNTcyIDEwLjkzMjkgOS44MjQzIDEwLjgyNDNNNiA3TDkgMTBMOS44MjQzIDEwLjgyNDMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PictureInPictureEnterIcon: ProIcon;
export { PictureInPictureEnterIcon }
export { PictureInPictureEnterIcon as pictureInPictureEnter }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0Ljc1IDUuNzVIMTguMjVDMTkuOTA2OSA1Ljc1IDIxLjI1IDcuMDkzMTUgMjEuMjUgOC43NVYxNy4yNUMyMS4yNSAxOC45MDY5IDE5LjkwNjkgMjAuMjUgMTguMjUgMjAuMjVINS43NUM0LjA5MzE1IDIwLjI1IDIuNzUgMTguOTA2OSAyLjc1IDE3LjI1VjEzLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iMTMiIHk9IjEyIiB3aWR0aD0iMTIiIGhlaWdodD0iMTAiIHJ4PSIyIiB0cmFuc2Zvcm09InJvdGF0ZSgxODAgMTMgMTIpIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0xOCAxMy42NjY3VjE2LjQwMDFDMTggMTYuNTY1OCAxNy45MzI5IDE2LjcxNTcgMTcuODI0MyAxNi44MjQzTTE0LjY2NjcgMTcuMDAwMUgxNy40QzE3LjU2NTcgMTcuMDAwMSAxNy43MTU3IDE2LjkzMjkgMTcuODI0MyAxNi44MjQzTTE0IDEzTDE3IDE2TDE3LjgyNDMgMTYuODI0MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const PictureInPictureExitIcon: ProIcon;
export { PictureInPictureExitIcon }
export { PictureInPictureExitIcon as pictureInPictureExit }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMjUgMTguMjVINS43NUM0LjA5MzE1IDE4LjI1IDIuNzUgMTYuOTA2OSAyLjc1IDE1LjI1VjYuNzVDMi43NSA1LjA5MzE1IDQuMDkzMTUgMy43NSA1Ljc1IDMuNzVIMTguMjVDMTkuOTA2OSAzLjc1IDIxLjI1IDUuMDkzMTUgMjEuMjUgNi43NVYxMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjExIiB5PSIxMiIgd2lkdGg9IjEyIiBoZWlnaHQ9IjEwIiByeD0iMiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PictureInPictureIcon: ProIcon;
export { PictureInPictureIcon }
export { PictureInPictureIcon as pictureInPicture }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNzcwNDEgMTYuMjMyOUwzLjc1IDIwLjI1MzNNMTQuOTc2MSAzLjMzNjQ1TDIwLjY2NjkgOS4wMjczQzIxLjY5MTMgMTAuMDUxNyAyMS4zMjA2IDExLjc5MTYgMTkuOTY3NiAxMi4zMDk0TDE2LjU5NTMgMTMuNkMxNS40MDcyIDE0LjA1NDcgMTQuNTA2MiAxNS4wNDc0IDE0LjE2ODUgMTYuMjczOUwxMy40ODAyIDE4Ljc3MzRDMTMuMTc0OSAxOS44ODIyIDExLjc4NjcgMjAuMjQ5MSAxMC45NzM0IDE5LjQzNThMNC41Njc1MSAxMy4wMjk5QzMuNzU0MjYgMTIuMjE2NyA0LjEyMTEyIDEwLjgyODQgNS4yMjk5NSAxMC41MjMxTDcuNzI5NSA5LjgzNDgzQzguOTU1OTUgOS40OTcxMSA5Ljk0ODY0IDguNTk2MTYgMTAuNDAzMyA3LjQwODFMMTEuNjk0IDQuMDM1OEMxMi4yMTE4IDIuNjgyNzYgMTMuOTUxNiAyLjMxMjA0IDE0Ljk3NjEgMy4zMzY0NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PinIcon: ProIcon;
export { PinIcon }
export { PinIcon as pin }

/**
 * @description Unpin
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNzcwNDMgMTYuMjMyOUwzLjc1MDAyIDIwLjI1MzNNMjAuNzE4NCAyMS43ODE2TDE0LjQ1OTUgMTUuNTIyNk0yLjIxODQ0IDMuMjgxNkw4LjQ4MDczIDkuNTQzODhNMTQuNDU5NSAxNS41MjI2QzE0LjMzODYgMTUuNzYwNCAxNC4yNDA3IDE2LjAxMTggMTQuMTY4NSAxNi4yNzM5TDEzLjQ4MDMgMTguNzczNEMxMy4xNzQ5IDE5Ljg4MjIgMTEuNzg2NyAyMC4yNDkxIDEwLjk3MzQgMTkuNDM1OEw0LjU2NzUzIDEzLjAyOTlDMy43NTQyOCAxMi4yMTY3IDQuMTIxMTMgMTAuODI4NCA1LjIyOTk3IDEwLjUyMzFMNy43Mjk1MiA5LjgzNDgzQzcuOTkxNTggOS43NjI2NiA4LjI0Mjk4IDkuNjY0NzggOC40ODA3MyA5LjU0Mzg4TTE0LjQ1OTUgMTUuNTIyNkw4LjQ4MDczIDkuNTQzODhNMTAuMjQ0OCA3Ljc2ODM0QzEwLjMwMzIgNy42NTE1NiAxMC4zNTYyIDcuNTMxMzcgMTAuNDAzMyA3LjQwODFMMTEuNjk0IDQuMDM1OEMxMi4yMTE4IDIuNjgyNzYgMTMuOTUxNyAyLjMxMjA0IDE0Ljk3NjEgMy4zMzY0NUwyMC42NjY5IDkuMDI3M0MyMS42OTEzIDEwLjA1MTcgMjEuMzIwNiAxMS43OTE2IDE5Ljk2NzYgMTIuMzA5NEwxNi41OTUzIDEzLjZDMTYuNDcyIDEzLjY0NzIgMTYuMzUxOCAxMy43MDAyIDE2LjIzNSAxMy43NTg2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const PinOffIcon: ProIcon;
export { PinOffIcon }
export { PinOffIcon as pinOff }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04LjkzMDA1IDEzLjI5MDVDOC45MzAwNSAxNC4zODc3IDguOTMwMDUgMTQuOTM2NCA5LjE2MDUxIDE1LjI1MzlDOS4zNjE1MyAxNS41MzA5IDkuNjcwNTYgMTUuNzA5NyAxMC4wMTA5IDE1Ljc0NTlDMTAuNDAxMSAxNS43ODc0IDEwLjg3NjcgMTUuNTEzOSAxMS44Mjc5IDE0Ljk2N0wxNC4wNzIyIDEzLjY3NjVDMTUuMDI4NSAxMy4xMjY2IDE1LjUwNjYgMTIuODUxNyAxNS42NjY5IDEyLjQ5MjRDMTUuODA2NyAxMi4xNzkgMTUuODA2NyAxMS44MjEgMTUuNjY2OSAxMS41MDc2QzE1LjUwNjYgMTEuMTQ4MyAxNS4wMjg1IDEwLjg3MzQgMTQuMDcyMiAxMC4zMjM1TDExLjgyNzkgOS4wMzMwNUMxMC44NzY3IDguNDg2MDkgMTAuNDAxMSA4LjIxMjYyIDEwLjAxMDkgOC4yNTQxMUM5LjY3MDU2IDguMjkwMzEgOS4zNjE1MyA4LjQ2OTA5IDkuMTYwNTEgOC43NDYwOEM4LjkzMDA1IDkuMDYzNjMgOC45MzAwNSA5LjYxMjI2IDguOTMwMDUgMTAuNzA5NVYxMy4yOTA1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PlayCircularIcon: ProIcon;
export { PlayCircularIcon }
export { PlayCircularIcon as playCircular }

/**
 * @description Start, Resume
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuNSAxMlY1LjYyMzk3QzUuNSAzLjY1MDI1IDcuNjc5ODQgMi40NTQ4OSA5LjM0NDA2IDMuNTE2MDFMMTkuMzQ0IDkuODkyMDRDMjAuODg1MiAxMC44NzQ4IDIwLjg4NTIgMTMuMTI1MiAxOS4zNDQgMTQuMTA4TDkuMzQ0MDYgMjAuNDg0QzcuNjc5ODQgMjEuNTQ1MSA1LjUgMjAuMzQ5OCA1LjUgMTguMzc2VjEyWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PlayIcon: ProIcon;
export { PlayIcon }
export { PlayIcon as play }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuNzUgMTdWMTguMDVDNi43NSAxOS4xNzAxIDYuNzUgMTkuNzMwMiA2Ljk2Nzk5IDIwLjE1OEM3LjE1OTczIDIwLjUzNDMgNy40NjU2OSAyMC44NDAzIDcuODQyMDIgMjEuMDMyQzguMjY5ODQgMjEuMjUgOC44Mjk4OSAyMS4yNSA5Ljk1IDIxLjI1SDE0LjA1QzE1LjE3MDEgMjEuMjUgMTUuNzMwMiAyMS4yNSAxNi4xNTggMjEuMDMyQzE2LjUzNDMgMjAuODQwMyAxNi44NDAzIDIwLjUzNDMgMTcuMDMyIDIwLjE1OEMxNy4yNSAxOS43MzAyIDE3LjI1IDE5LjE3MDEgMTcuMjUgMTguMDVWMTdNNi43NSAxN1YxNS45NUM2Ljc1IDE0LjgyOTkgNi43NSAxNC4yNjk4IDYuOTY3OTkgMTMuODQyQzcuMTU5NzMgMTMuNDY1NyA3LjQ2NTY5IDEzLjE1OTcgNy44NDIwMiAxMi45NjhDOC4yNjk4NCAxMi43NSA4LjgyOTkgMTIuNzUgOS45NSAxMi43NUgxNC4wNUMxNS4xNzAxIDEyLjc1IDE1LjczMDIgMTIuNzUgMTYuMTU4IDEyLjk2OEMxNi41MzQzIDEzLjE1OTcgMTYuODQwMyAxMy40NjU3IDE3LjAzMiAxMy44NDJDMTcuMjUgMTQuMjY5OCAxNy4yNSAxNC44Mjk5IDE3LjI1IDE1Ljk1VjE3TTYuNzUgMTdINS45NUM0LjgyOTkgMTcgNC4yNjk4NCAxNyAzLjg0MjAyIDE2Ljc4MkMzLjQ2NTY5IDE2LjU5MDMgMy4xNTk3MyAxNi4yODQzIDIuOTY3OTkgMTUuOTA4QzIuNzUgMTUuNDgwMiAyLjc1IDE0LjkyMDEgMi43NSAxMy44VjEwLjhDMi43NSA5LjExOTg0IDIuNzUgOC4yNzk3NiAzLjA3Njk4IDcuNjM4MDNDMy4zNjQ2IDcuMDczNTQgMy44MjM1NCA2LjYxNDYgNC4zODgwMyA2LjMyNjk4QzUuMDI5NzYgNiA1Ljg2OTg0IDYgNy41NSA2SDE2LjQ1QzE4LjEzMDIgNiAxOC45NzAyIDYgMTkuNjEyIDYuMzI2OThDMjAuMTc2NSA2LjYxNDYgMjAuNjM1NCA3LjA3MzU0IDIwLjkyMyA3LjYzODAzQzIxLjI1IDguMjc5NzYgMjEuMjUgOS4xMTk4NCAyMS4yNSAxMC44VjEzLjhDMjEuMjUgMTQuOTIwMSAyMS4yNSAxNS40ODAyIDIxLjAzMiAxNS45MDhDMjAuODQwMyAxNi4yODQzIDIwLjUzNDMgMTYuNTkwMyAyMC4xNTggMTYuNzgyQzE5LjczMDIgMTcgMTkuMTcwMSAxNyAxOC4wNSAxN0gxNy4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02Ljc1IDQuMjVDNi43NSAzLjQyMTU3IDcuNDIxNTcgMi43NSA4LjI1IDIuNzVIMTUuNzVDMTYuNTc4NCAyLjc1IDE3LjI1IDMuNDIxNTcgMTcuMjUgNC4yNVY2SDYuNzVWNC4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const PrinterIcon: ProIcon;
export { PrinterIcon }
export { PrinterIcon as printer }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuNDU5MjYgMTguNTQwN0M3LjEzMzE4IDIwLjIxNDcgOS40NDU2OCAyMS4yNSAxMiAyMS4yNUMxNy4xMDg2IDIxLjI1IDIxLjI1IDE3LjEwODYgMjEuMjUgMTJDMjEuMjUgOS40NDU2OCAyMC4yMTQ3IDcuMTMzMTggMTguNTQwNyA1LjQ1OTI2TTUuNDU5MjYgMTguNTQwN0MzLjc4NTM0IDE2Ljg2NjggMi43NSAxNC41NTQzIDIuNzUgMTJDMi43NSA2Ljg5MTM3IDYuODkxMzcgMi43NSAxMiAyLjc1QzE0LjU1NDMgMi43NSAxNi44NjY4IDMuNzg1MzQgMTguNTQwNyA1LjQ1OTI2TTUuNDU5MjYgMTguNTQwN0wxOC41NDA3IDUuNDU5MjYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ProhibitedIcon: ProIcon;
export { ProhibitedIcon }
export { ProhibitedIcon as prohibited }

declare class ProIcon {
    #private;
    /** The name of the icon in Friendly Form */
    name: string;
    /** The name of the icon in kebab-case */
    kebabCase: string;
    /** The name of the icon in camelCase */
    camelCase: string;
    /** The icon as an `SVGSVGElement`. Use the `outerHTML` property on this to return the icon as a string. */
    element: SVGSVGElement;
    /** The category of the icon. */
    category: string;
    /** An array of the icon's tags. */
    tags: string[];
    /**
     * The raw SVG string of the icon, with the default properties
     * Use `toSvg()` instead to use custom properties
     */
    raw: string;
    /**
     *
     * @param name The name of the icon in Friendly Form
     * @param kebabCase The name of the icon in kebab-case
     * @param camelCase The name of the icon in camelCase
     * @param category The category of the icon.
     * @param tags An array of the icon's tags.
     */
    constructor(name: string, tags: string[], category: string, nodes: IconNode[]);
    /**
     * Returns an SVG string from the icon with the provided options
     * Note that this also works outside of a browser environment
     * @param options Customization options for the icon
     */
    toSvg(options?: ProIconsOptions): string;
}

declare interface ProIconReplaceConfig extends ProIconsOptions {
    /** The attribute name that is checked for when converting elements to icons. Defaults to `proicon`. */
    attributeName?: string;
    /** Determines whether to overwrite elements when converting to icons. Setting this to `auto` will overwrite only if the element does not have any children. Defaults to `auto`. */
    overwrite?: boolean | 'auto';
    /** Determines whether to apply existing HTML attributes such as styles to the converted SVGs. Defaults to `true` */
    useAttributes?: false;
}

declare interface ProIconsOptions {
    /** Determines the color of the icons. Defaults to `currentColor`. */
    color?: string;
    /** Determines the default stroke width of the icon. Defaults to `1.5`. This only works on SVG elements with existing strokes; add `strokeFilledElements` for this property to affect such elements. */
    strokeWidth?: number;
    /** Apply strokes to filled SVG elements, such as circles, by the provided amount with `1.5` (default stroke value) subtracted, if `strokeWidth` is set to a value above `1.5`. Defaults to `false`
     * @example If `strokeWidth` is set to `2`, filled SVG elements will have an additional `0.5`px stroke
     */
    strokeFilledElements?: boolean;
    /** Defaults to `round` */
    strokeCaps?: 'round' | 'square' | 'butt';
    /** Defaults to `round` */
    strokeJoin?: 'round' | 'miter' | 'bevel';
    /** Determines the corner radius of SVG elements. Does not apply to all rounded elements. */
    cornerRadius?: number;
    /** Determines the size of the icon in pixels. Defaults to `24` */
    size?: number;
    /**
     * Attributes to merge with the generated icon
     * @example
     * {
     *   attributes: {
     *     'data-myattr': 'Example',
     *     id: 'myIcon'
     *   }
     * }
     */
    attributes: Record<string, string>;
}

/**
 * @description Programming
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDcuNUg3LjVNMTIgMTYuNUgxNi41TTE2LjUgMTYuNUgxOC4wMjE1QzE4LjgyODUgMTYuNSAxOS42NTQ5IDE2LjMxMjIgMjAuMTUxNiAxNS42NzYzQzIwLjY4MjIgMTQuOTk3MiAyMS4yNSAxMy44NDA1IDIxLjI1IDEyQzIxLjI1IDEwLjE1OTUgMjAuNjgyMiA5LjAwMjggMjAuMTUxNiA4LjMyMzY5QzE5LjY1NDkgNy42ODc3NiAxOC44Mjg1IDcuNSAxOC4wMjE1IDcuNUgxNi41TTE2LjUgMTYuNVYxOC4wMjE1QzE2LjUgMTguODI4NSAxNi4zMTIyIDE5LjY1NDkgMTUuNjc2MyAyMC4xNTE2QzE0Ljk5NzIgMjAuNjgyMiAxMy44NDA1IDIxLjI1IDEyIDIxLjI1QzEwLjE1OTUgMjEuMjUgOS4wMDI4IDIwLjY4MjIgOC4zMjM2OSAyMC4xNTE2QzcuNjg3NzYgMTkuNjU0OSA3LjUgMTguODI4NSA3LjUgMTguMDIxNVYxNi41TTcuNSA3LjVINS45Nzg0NUM1LjE3MTQ4IDcuNSA0LjM0NTE1IDcuNjg3NzYgMy44NDgzNSA4LjMyMzY5QzMuMzE3ODIgOS4wMDI4IDIuNzUgMTAuMTU5NSAyLjc1IDEyQzIuNzUgMTMuODQwNSAzLjMxNzgyIDE0Ljk5NzIgMy44NDgzNSAxNS42NzYzQzQuMzQ1MTUgMTYuMzEyMiA1LjE3MTQ4IDE2LjUgNS45Nzg0NSAxNi41SDcuNU03LjUgNy41VjUuOTc4NDVDNy41IDUuMTcxNDggNy42ODc3NiA0LjM0NTE1IDguMzIzNjkgMy44NDgzNUM5LjAwMjggMy4zMTc4MiAxMC4xNTk1IDIuNzUgMTIgMi43NUMxMy44NDA1IDIuNzUgMTQuOTk3MiAzLjMxNzgyIDE1LjY3NjMgMy44NDgzNUMxNi4zMTIyIDQuMzQ1MTUgMTYuNSA1LjE3MTQ4IDE2LjUgNS45Nzg0NVY3LjVNNy41IDE2LjVWMTRDNy41IDEyLjg5NTQgOC4zOTU0MyAxMiA5LjUgMTJIMTQuNUMxNS42MDQ2IDEyIDE2LjUgMTEuMTA0NiAxNi41IDEwVjcuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNSAxOC41QzE1IDE4LjkxNDIgMTQuNjY0MiAxOS4yNSAxNC4yNSAxOS4yNUMxMy44MzU4IDE5LjI1IDEzLjUgMTguOTE0MiAxMy41IDE4LjVDMTMuNSAxOC4wODU4IDEzLjgzNTggMTcuNzUgMTQuMjUgMTcuNzVDMTQuNjY0MiAxNy43NSAxNSAxOC4wODU4IDE1IDE4LjVaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik04Ljk5OTk0IDUuNUM4Ljk5OTk0IDUuMDg1NzkgOS4zMzU3MyA0Ljc1IDkuNzQ5OTQgNC43NUMxMC4xNjQyIDQuNzUgMTAuNDk5OSA1LjA4NTc5IDEwLjQ5OTkgNS41QzEwLjQ5OTkgNS45MTQyMSAxMC4xNjQyIDYuMjUgOS43NDk5NCA2LjI1QzkuMzM1NzMgNi4yNSA4Ljk5OTk0IDUuOTE0MjEgOC45OTk5NCA1LjVaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 * @updated v4.10.0
 */
declare const PythonIcon: ProIcon;
export { PythonIcon }
export { PythonIcon as python }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iMi43NSIgd2lkdGg9IjcuNSIgaGVpZ2h0PSI3LjUiIHJ4PSIyLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIxMy43NSIgeT0iMi43NSIgd2lkdGg9IjcuNSIgaGVpZ2h0PSI3LjUiIHJ4PSIyLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSIyLjc1IiB5PSIxMy43NSIgd2lkdGg9IjcuNSIgaGVpZ2h0PSI3LjUiIHJ4PSIyLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cmVjdCB4PSI1IiB5PSI1IiB3aWR0aD0iMyIgaGVpZ2h0PSIzIiByeD0iMS41IiBmaWxsPSIjZmZmZmZmIi8+CjxyZWN0IHg9IjE2IiB5PSI1IiB3aWR0aD0iMyIgaGVpZ2h0PSIzIiByeD0iMS41IiBmaWxsPSIjZmZmZmZmIi8+CjxyZWN0IHg9IjUiIHk9IjE2IiB3aWR0aD0iMyIgaGVpZ2h0PSIzIiByeD0iMS41IiBmaWxsPSIjZmZmZmZmIi8+CjxyZWN0IHg9IjEzIiB5PSIxMyIgd2lkdGg9IjMiIGhlaWdodD0iMyIgcng9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8cmVjdCB4PSIxNiIgeT0iMTYiIHdpZHRoPSIzIiBoZWlnaHQ9IjMiIHJ4PSIxLjUiIGZpbGw9IiNmZmZmZmYiLz4KPHJlY3QgeD0iMTkiIHk9IjE5IiB3aWR0aD0iMyIgaGVpZ2h0PSIzIiByeD0iMS41IiBmaWxsPSIjZmZmZmZmIi8+CjxyZWN0IHg9IjE5IiB5PSIxMyIgd2lkdGg9IjMiIGhlaWdodD0iMyIgcng9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8cmVjdCB4PSIxMyIgeT0iMTkiIHdpZHRoPSIzIiBoZWlnaHQ9IjMiIHJ4PSIxLjUiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const QrCodeIcon: ProIcon;
export { QrCodeIcon }
export { QrCodeIcon as qrCode }

/**
 * @description Help, Support
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMzAxMTYgOS43MDg4NEM5LjMwMTE2IDkuMjY1MDIgOS40MTA2MiA4LjgyODA0IDkuNjE5ODQgOC40MzY2MkM5LjgyOTA1IDguMDQ1MiAxMC4xMzE2IDcuNzExNDIgMTAuNTAwNiA3LjQ2NDg1QzEwLjg2OTYgNy4yMTgyNyAxMS4yOTM4IDcuMDY2NTEgMTEuNzM1NSA3LjAyMzAxQzEyLjE3NzIgNi45Nzk1IDEyLjYyMjggNy4wNDU2IDEzLjAzMjggNy4yMTU0NUMxMy40NDI4IDcuMzg1MjkgMTMuODA0NyA3LjY1MzY0IDE0LjA4NjIgNy45OTY3MkMxNC4zNjc4IDguMzM5OCAxNC41NjA0IDguNzQ3MDMgMTQuNjQ3IDkuMTgyMzNDMTQuNzMzNiA5LjYxNzYyIDE0LjcxMTUgMTAuMDY3NiAxNC41ODI2IDEwLjQ5MjNDMTQuNDg5NyAxMC43OTg1IDE0LjM0MzQgMTEuMDg0OCAxNC4xNTE0IDExLjMzODNDMTQuMTQ5MiAxMS4zNDEyIDE0LjE0ODEgMTEuMzQyNiAxNC4wNjU4IDExLjQzMjFDMTQuMDI0MSAxMS40Nzc0IDEzLjg3ODkgMTEuNjE2MyAxMy44MzE4IDExLjY1NTlDMTMuNzM4OCAxMS43MzQxIDEzLjY5MzcgMTEuNzY1MiAxMy42MDM2IDExLjgyNzRMMTIuNjI1NCAxMi41MDE5QzEyLjEzNDQgMTIuODQwNSAxMS44NDEyIDEzLjM5ODggMTEuODQxMiAxMy45OTUyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iMTEuODI4MSIgY3k9IjE2Ljc0IiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iMTIiIHI9IjkuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const QuestionCircleIcon: ProIcon;
export { QuestionCircleIcon }
export { QuestionCircleIcon as questionCircle }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuODE2OCA4LjgwODE5QzcuODE2OCA4LjEyMDI2IDcuOTg2NDYgNy40NDI5NSA4LjMxMDc1IDYuODM2MjVDOC42MzUwNCA2LjIyOTU1IDkuMTAzOTQgNS43MTIxOSA5LjY3NTk0IDUuMzNDMTAuMjQ3OSA0Ljk0NzggMTAuOTA1MyA0LjcxMjU3IDExLjU5IDQuNjQ1MTRDMTIuMjc0NiA0LjU3NzcyIDEyLjk2NTMgNC42ODAxNyAxMy42MDA4IDQuOTQzNDNDMTQuMjM2NCA1LjIwNjY5IDE0Ljc5NzIgNS42MjI2MyAxNS4yMzM2IDYuMTU0NEMxNS42NzAxIDYuNjg2MTggMTUuOTY4NiA3LjMxNzM4IDE2LjEwMjggNy45OTIwOUMxNi4yMzcgOC42NjY4IDE2LjIwMjcgOS4zNjQyIDE2LjAwMzEgMTAuMDIyNUMxNS44NTkxIDEwLjQ5NzEgMTUuNjMyMyAxMC45NDA5IDE1LjMzNDcgMTEuMzMzOUMxNS4zMzEzIDExLjMzODMgMTUuMzI5NiAxMS4zNDA1IDE1LjIwMiAxMS40NzkyQzE1LjEzNzQgMTEuNTQ5NCAxNC45MTIzIDExLjc2NDcgMTQuODM5MyAxMS44MjYxQzE0LjY5NTEgMTEuOTQ3NCAxNC42MjUzIDExLjk5NTYgMTQuNDg1NiAxMi4wOTE5TDEyLjk2OTQgMTMuMTM3NUMxMi4yMDgzIDEzLjY2MjMgMTEuNzUzOSAxNC41Mjc2IDExLjc1MzkgMTUuNDUyMSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjExLjc1MzkiIGN5PSIxOS4xNDA4IiByPSIwLjk4NDI4IiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const QuestionIcon: ProIcon;
export { QuestionIcon }
export { QuestionIcon as question }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuOTM3MTIgMTAuNDUyOUw5LjkyNjMgMTAuNTgyOEM5LjkyNjMgMTMuOTMzNSA3Ljg4OTQ0IDE1LjY5NzcgNS4yOTYzMyAxNi42NDA2TTkuOTM3MTIgMTAuNDUyOUM5LjkzNzEyIDEyLjE2MTYgOC41NTI1NiAxMy41NDY5IDYuODQzODYgMTMuNTQ2OUM1LjEzNTE3IDEzLjU0NjkgMy43NSAxMi4xNjE3IDMuNzUgMTAuNDUzQzMuNzUgOC43NDQzIDUuMTM1MTcgNy4zNTkxMyA2Ljg0Mzg2IDcuMzU5MTNDOC41NTI1NiA3LjM1OTEzIDkuOTM3MTIgOC43NDQyMiA5LjkzNzEyIDEwLjQ1MjlaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIwLjI1IDEwLjQ1MjlMMjAuMjM5MiAxMC41ODI4QzIwLjIzOTIgMTMuOTMzNSAxOC4yMDIzIDE1LjY5NzcgMTUuNjA5MiAxNi42NDA2TTIwLjI1IDEwLjQ1MjlDMjAuMjUgMTIuMTYxNiAxOC44NjU0IDEzLjU0NjkgMTcuMTU2NyAxMy41NDY5QzE1LjQ0ODEgMTMuNTQ2OSAxNC4wNjI5IDEyLjE2MTcgMTQuMDYyOSAxMC40NTNDMTQuMDYyOSA4Ljc0NDMgMTUuNDQ4MSA3LjM1OTEzIDE3LjE1NjcgNy4zNTkxM0MxOC44NjU0IDcuMzU5MTMgMjAuMjUgOC43NDQyMiAyMC4yNSAxMC40NTI5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const QuoteIcon: ProIcon;
export { QuoteIcon }
export { QuoteIcon as quote }

/**
 * @description Framework, JavaScript, Meta, Facebook
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDguMDEyN0M2LjYxNTIyIDguMDEyNyAyLjI1IDkuNzk3OSAyLjI1IDEyLjAwMDFDMi4yNSAxNC4yMDIyIDYuNjE1MjIgMTUuOTg3NCAxMiAxNS45ODc0QzE3LjM4NDggMTUuOTg3NCAyMS43NSAxNC4yMDIyIDIxLjc1IDEyLjAwMDFDMjEuNzUgOS43OTc5IDE3LjM4NDggOC4wMTI3IDEyIDguMDEyN1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuNDIzMiAxMC4wMDY0QzEyLjczMDggNS4zMDIxIDkuMDE1NTggMi4zODExNSA3LjEyNTAzIDMuNDgyMjNDNS4yMzQ0OCA0LjU4MzMyIDUuODg0NSA5LjI4OTQ3IDguNTc2ODkgMTMuOTkzN0MxMS4yNjkzIDE4LjY5OCAxNC45ODQ1IDIxLjYxODkgMTYuODc1IDIwLjUxNzhDMTguNzY1NiAxOS40MTY4IDE4LjExNTYgMTQuNzEwNiAxNS40MjMyIDEwLjAwNjRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjQyMzMgMTMuOTkzN0MxOC4xMTU3IDkuMjg5NDEgMTguNzY1NyA0LjU4MzI2IDE2Ljg3NTIgMy40ODIxN0MxNC45ODQ2IDIuMzgxMDkgMTEuMjY5NCA1LjMwMjA0IDguNTc3MDEgMTAuMDA2M0M1Ljg4NDYzIDE0LjcxMDUgNS4yMzQ2MSAxOS40MTY3IDcuMTI1MTUgMjAuNTE3OEM5LjAxNTcgMjEuNjE4OSAxMi43MzA5IDE4LjY5NzkgMTUuNDIzMyAxMy45OTM3WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iMTIiIHI9IjEuNSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.11.0
 */
declare const ReactjsIcon: ProIcon;
export { ReactjsIcon }
export { ReactjsIcon as reactjs }

/**
 * @description Recording, Voice
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iMTIiIHI9IjUiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.10.0
 */
declare const RecordIcon: ProIcon;
export { RecordIcon }
export { RecordIcon as record }

/**
 * @description Recording, Voice
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMiIgcj0iOS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjgiIHk9IjgiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHJ4PSIyIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.10.0
 */
declare const RecordStopIcon: ProIcon;
export { RecordStopIcon }
export { RecordStopIcon as recordStop }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC43NSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTQuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const RectangleWideIcon: ProIcon;
export { RectangleWideIcon }
export { RectangleWideIcon as rectangleWide }

/**
 * @description RegExp, Text, Match
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNi43NSIgY3k9IjE3LjI1IiByPSIzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE2IDMuNzVMMTYuMDAyNSA4Ljc0NTY3TDIwLjI1IDYuMjVMMTYuMDA0OSA4Ljc1TDIwLjI1IDExLjI1TDE2LjAwMjUgOC43NTQzM0wxNiAxMy43NUwxNS45OTc1IDguNzU0MzNMMTEuNzUgMTEuMjVMMTUuOTk1MSA4Ljc1TDExLjc1IDYuMjVMMTUuOTk3NSA4Ljc0NTY3TDE2IDMuNzVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const RegularExpressionIcon: ProIcon;
export { RegularExpressionIcon }
export { RegularExpressionIcon as regularExpression }

/**
 * Converts all elements with the `proicon` attribute (which can be customised in the config) on the page to an icon corresponding to the attribute value.
 * Note that this only works in a browser environment, and also breaks tree-shaking.
 * @param rootElm The element to search inside for children with the `proicon` attribute. Defaults to `document.body`.
 * @param config An optional configuration to customise the behaviour of the replace method
 */
export declare function replace(rootElm?: Element, config?: ProIconReplaceConfig): void;

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjAwNDUgMTguMzIyOUMxOS4wMjQgMTkuMTA3MSAyMC41IDE4LjM4MDMgMjAuNSAxNy4wOTQxVjYuOTA1OTJDMjAuNSA1LjYxOTY4IDE5LjAyNCA0Ljg5Mjg5IDE4LjAwNDUgNS42NzcxMkwxMS43Nzk2IDEwLjg2ODdDMTEuMDczNSAxMS40NTc2IDExLjA3MzUgMTIuNTQyNCAxMS43Nzk2IDEzLjEzMTNMMTguMDA0NSAxOC4zMjI5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC43NTQ0OCAxOC4zMjI5QzkuNzczOTggMTkuMTA3MSAxMS4yNSAxOC4zODAzIDExLjI1IDE3LjA5NDFWNi45MDU5MkMxMS4yNSA1LjYxOTY4IDkuNzczOTggNC44OTI4OSA4Ljc1NDQ4IDUuNjc3MTJMMi41Mjk2MyAxMC44Njg3QzEuODIzNDcgMTEuNDU3NiAxLjgyMzQ3IDEyLjU0MjQgMi41Mjk2MyAxMy4xMzEzTDguNzU0NDggMTguMzIyOVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ReverseIcon: ProIcon;
export { ReverseIcon }
export { ReverseIcon as reverse }

/**
 * @description Diamond
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzc0ODYgMTQuNDc0OUMyLjQwODAzIDEzLjEwODEgMi40MDgwMyAxMC44OTIgMy43NzQ4NiA5LjUyNTE4TDkuNTI1MTEgMy43NzQ5MkMxMC44OTE5IDIuNDA4MDkgMTMuMTA4IDIuNDA4MDkgMTQuNDc0OSAzLjc3NDkyTDIwLjIyNTEgOS41MjUxN0MyMS41OTE5IDEwLjg5MiAyMS41OTE5IDEzLjEwODEgMjAuMjI1MSAxNC40NzQ5TDE0LjQ3NDkgMjAuMjI1MkMxMy4xMDggMjEuNTkyIDEwLjg5MTkgMjEuNTkyIDkuNTI1MTEgMjAuMjI1MkwzLjc3NDg2IDE0LjQ3NDlaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const RhombusIcon: ProIcon;
export { RhombusIcon }
export { RhombusIcon as rhombus }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjQwOTQgOS4xNTk0QzE4LjQwOTQgMTEuMTkzNyAxNy40NjE3IDEzLjAwNjYgMTUuOTgzNyAxNC4xODA4QzE0Ljg4OTggMTUuMDQ5NyAxMy41MDU1IDE1LjU2ODggMTIgMTUuNTY4OEMxMC40OTQ0IDE1LjU2ODggOS4xMTAxMyAxNS4wNDk3IDguMDE2MjggMTQuMTgwN0M2LjUzODI5IDEzLjAwNjYgNS41OTA1OCAxMS4xOTM3IDUuNTkwNTggOS4xNTk0QzUuNTkwNTggNS42MTk1OSA4LjQ2MDE2IDIuNzUgMTIgMi43NUMxNS41Mzk4IDIuNzUgMTguNDA5NCA1LjYxOTU5IDE4LjQwOTQgOS4xNTk0WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS45ODM3IDE0LjE4MDdWMjEuMjVMMTIgMTguMjY2Nkw4LjAxNjMgMjEuMjVWMTQuMTgwNyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const RibbonIcon: ProIcon;
export { RibbonIcon }
export { RibbonIcon as ribbon }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const RibbonStarIcon: ProIcon;
export { RibbonStarIcon }
export { RibbonStarIcon as ribbonStar }

/**
 * @description Gaming, Studio, Bloxy, Player
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNi4zMzYyNCIgeT0iMi4xOSIgd2lkdGg9IjE2LjAxOTciIGhlaWdodD0iMTYuMDE5NyIgcng9IjIuNSIgdHJhbnNmb3JtPSJyb3RhdGUoMTUgNi4zMzYyNCAyLjE5KSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxyZWN0IHg9IjEwLjExMjEiIHk9IjguNzI5OTgiIHdpZHRoPSI1LjMzOTg5IiBoZWlnaHQ9IjUuMzM5ODkiIHJ4PSIwLjgiIHRyYW5zZm9ybT0icm90YXRlKDE1IDEwLjExMjEgOC43Mjk5OCkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const RobloxIcon: ProIcon;
export { RobloxIcon }
export { RobloxIcon as roblox }

/**
 * @description Measure, Length, Meter, Foot, Metre, Feet, Yard
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMTUuNzEyMyIgeT0iMS45MjM4MyIgd2lkdGg9IjkiIGhlaWdodD0iMTkuNSIgcng9IjIiIHRyYW5zZm9ybT0icm90YXRlKDQ1IDE1LjcxMjMgMS45MjM4MykiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC44MTgwMiA4LjgxODEyTDEyIDEyLjAwMDEiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTIgNS42MzYxMUwxNS4xODIgOC44MTgwOSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik01LjYzNjA1IDEyLjAwMDFMOC44MTgwMyAxNS4xODIxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.11.0
 */
declare const RulerDiagonalIcon: ProIcon;
export { RulerDiagonalIcon }
export { RulerDiagonalIcon as rulerDiagonal }

/**
 * @description Measure, Length, Meter, Foot, Metre, Feet, Yard
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iNi43NSIgeT0iMi43NSIgd2lkdGg9IjkuNSIgaGVpZ2h0PSIxOC41IiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik02Ljc1IDEySDExLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTYuNzUgNy41SDExLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTYuNzUgMTYuNUgxMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const RulerIcon: ProIcon;
export { RulerIcon }
export { RulerIcon as ruler }

/**
 * @description Floppy Disk
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const SaveAsIcon: ProIcon;
export { SaveAsIcon }
export { SaveAsIcon as saveAs }

/**
 * @description Floppy Disk
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNTU3NjkgMy43NUg3LjI1QzUuMzE3IDMuNzUgMy43NSA1LjMxNyAzLjc1IDcuMjVWMTcuMDc2OUMzLjc1IDE4LjgyOTQgNS4xNzA2MyAyMC4yNSA2LjkyMzA4IDIwLjI1VjIwLjI1TTcuNTU3NjkgMy43NVY2LjE5MjMxQzcuNTU3NjkgNy4yOTY4OCA4LjQ1MzEyIDguMTkyMzEgOS41NTc2OSA4LjE5MjMxSDExLjkwMzhDMTMuMDA4NCA4LjE5MjMxIDEzLjkwMzggNy4yOTY4OCAxMy45MDM4IDYuMTkyMzFWMy43NU03LjU1NzY5IDMuNzVIMTMuOTAzOE0xMy45MDM4IDMuNzVIMTMuOTMwNEMxNC43MjYxIDMuNzUgMTUuNDg5MSA0LjA2NjA3IDE2LjA1MTggNC42Mjg2OEwxOS4yMjQ5IDcuODAxOEMxOS44ODEzIDguNDU4MTcgMjAuMjUgOS4zNDg0MSAyMC4yNSAxMC4yNzY3VjE3LjA3NjlDMjAuMjUgMTguODI5NCAxOC44Mjk0IDIwLjI1IDE3LjA3NjkgMjAuMjVWMjAuMjVNNi45MjMwOCAyMC4yNVYxNUM2LjkyMzA4IDEzLjM0MzEgOC4yNjYyMiAxMiA5LjkyMzA4IDEySDE0LjA3NjlDMTUuNzMzOCAxMiAxNy4wNzY5IDEzLjM0MzEgMTcuMDc2OSAxNVYyMC4yNU02LjkyMzA4IDIwLjI1SDE3LjA3NjkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const SaveIcon: ProIcon;
export { SaveIcon }
export { SaveIcon as save }

/**
 * @description Aspect Ratio
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC4yNSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTUuNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNi43NSAxMi4yNVY4LjI1SDEwLjc1TTE3LjI1IDExLjc1VjE1Ljc1SDEzLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ScreenSizeIcon: ProIcon;
export { ScreenSizeIcon }
export { ScreenSizeIcon as screenSize }

/**
 * @description Macro
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjI1MDYgMjEuMjVINS4yNTA2MUg0LjAwMDYxQzIuNzU3OTcgMjEuMjUgMS43NTA2MSAyMC4yNDI2IDEuNzUwNjEgMTlWMTcuNzVDMS43NTA2MSAxNi45MjE2IDIuNDIyMTggMTYuMjUgMy4yNTA2MSAxNi4yNUg0Ljc1TTE1LjI1MDYgMjEuMjVDMTYuNjMxMyAyMS4yNSAxNy43NTA2IDIwLjEzMDcgMTcuNzUwNiAxOC43NVY3Ljc1TTE1LjI1MDYgMjEuMjVDMTMuODY5OSAyMS4yNSAxMi43NSAyMC4xMzA3IDEyLjc1IDE4Ljc1VjE3LjI1QzEyLjc1IDE2LjY5NzcgMTIuMzAyMyAxNi4yNSAxMS43NSAxNi4yNUg0Ljc1TTIwLjEyNTYgMi43NUg4LjI1QzYuMzE3IDIuNzUgNC43NSA0LjMxNyA0Ljc1IDYuMjVWMTUuMjVWMTYuMjVNMTcuNzUwNiA3Ljc1SDIxLjI0OTRDMjEuODAxNyA3Ljc1IDIyLjI0OTQgNy4zMDIyOCAyMi4yNDk0IDYuNzVWNUMyMi4yNDk0IDMuNzU3MzYgMjEuMjQyIDIuNzUgMTkuOTk5NCAyLjc1QzE4Ljc1NjcgMi43NSAxNy43NDk0IDMuNzU3MzYgMTcuNzQ5NCA1TDE3Ljc1MDYgNy43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const Script2Icon: ProIcon;
export { Script2Icon }
export { Script2Icon as script2 }

/**
 * @description Macro
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjI1MDYgMjEuMjVINS4yNTA2MUg0LjAwMDYxQzIuNzU3OTcgMjEuMjUgMS43NTA2MSAyMC4yNDI2IDEuNzUwNjEgMTlWMTcuNzVDMS43NTA2MSAxNi45MjE2IDIuNDIyMTggMTYuMjUgMy4yNTA2MSAxNi4yNUg0Ljc1TTE1LjI1MDYgMjEuMjVDMTYuNjMxMyAyMS4yNSAxNy43NTA2IDIwLjEzMDcgMTcuNzUwNiAxOC43NVY3Ljc1TTE1LjI1MDYgMjEuMjVDMTMuODY5OSAyMS4yNSAxMi43NSAyMC4xMzA3IDEyLjc1IDE4Ljc1VjE3LjI1QzEyLjc1IDE2LjY5NzcgMTIuMzAyMyAxNi4yNSAxMS43NSAxNi4yNUg0Ljc1TTIwLjEyNTYgMi43NUg4LjI1QzYuMzE3IDIuNzUgNC43NSA0LjMxNyA0Ljc1IDYuMjVWMTUuMjVWMTYuMjVNMTcuNzUwNiA3Ljc1SDIxLjI0OTRDMjEuODAxNyA3Ljc1IDIyLjI0OTQgNy4zMDIyOCAyMi4yNDk0IDYuNzVWNUMyMi4yNDk0IDMuNzU3MzYgMjEuMjQyIDIuNzUgMTkuOTk5NCAyLjc1QzE4Ljc1NjcgMi43NSAxNy43NDk0IDMuNzU3MzYgMTcuNzQ5NCA1TDE3Ljc1MDYgNy43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC41IDcuMjVIMTQuNU04LjUgMTEuMjVIMTIuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ScriptIcon: ProIcon;
export { ScriptIcon }
export { ScriptIcon as script }

/**
 * Searches for icons with names or tags that contain `key` and returns them as `ProIcon`.
 *
 * Note: This will import all icons and breaks tree-shaking
 */
export declare function search(query: string): ProIcon[];

/**
 * @description No Results, Clear Search
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgZmlsbD0ibm9uZSIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgc3Ryb2tlLXdpZHRoPSIxLjUiIGQ9Im04LjQ0IDEyLjY4MiAyLjEyLTIuMTIxbTAgMCAyLjEyMi0yLjEyMm0tMi4xMjEgMi4xMjIgMi4xMiAyLjEybS0yLjEyLTIuMTJMOC40MzkgOC40MzltNy4xMTQgNy4xMTRhNy4wNiA3LjA2IDAgMSAwLTkuOTg1LTkuOTg1IDcuMDYgNy4wNiAwIDAgMCA5Ljk4NSA5Ljk4NW0wIDBMMjAgMjAiLz48cGF0aCBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgc3Ryb2tlLXdpZHRoPSIxLjUiIGQ9Ik0xNS41NTMgNS41NjhhNy4wNiA3LjA2IDAgMSAxLTkuOTg1IDkuOTg1IDcuMDYgNy4wNiAwIDAgMSA5Ljk4NS05Ljk4NSIvPjwvc3ZnPg==)
 * @added v4.9.0
 */
declare const SearchCancelIcon: ProIcon;
export { SearchCancelIcon }
export { SearchCancelIcon as searchCancel }

/**
 * @description Find, Look
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjU1MzIgMTUuNTUzMkMxOC4zMTA1IDEyLjc5NTggMTguMzEwNSA4LjMyNTMzIDE1LjU1MzIgNS41NjhDMTIuNzk1OCAyLjgxMDY3IDguMzI1MzMgMi44MTA2NyA1LjU2OCA1LjU2OEMyLjgxMDY3IDguMzI1MzMgMi44MTA2NyAxMi43OTU4IDUuNTY4IDE1LjU1MzJDOC4zMjUzMyAxOC4zMTA1IDEyLjc5NTggMTguMzEwNSAxNS41NTMyIDE1LjU1MzJaTTE1LjU1MzIgMTUuNTUzMkwyMCAyMCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
export declare const SearchIcon: ProIcon;

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMTJIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNCAyLjc1VjUuNUM0IDYuNjA0NTcgNC44OTU0MyA3LjUgNiA3LjVIMThDMTkuMTA0NiA3LjUgMjAgNi42MDQ1NyAyMCA1LjVWMi43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik00IDIxLjI1VjE4LjVDNCAxNy4zOTU0IDQuODk1NDMgMTYuNSA2IDE2LjVIMThDMTkuMTA0NiAxNi41IDIwIDE3LjM5NTQgMjAgMTguNVYyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const SectionBreakIcon: ProIcon;
export { SectionBreakIcon }
export { SectionBreakIcon as sectionBreak }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0Ljc2MDMgMTJINy4wMTgxNUg2LjgzMTgyTTYuODMxODIgMTJDNi44MzE4MiAxMS43MjQ2IDYuNzc0OTggMTEuNDQ5MiA2LjY2MTI5IDExLjE5MTlMNC4yODU4NSA1LjgxNDI0QzMuNTI2MTkgNC4wOTQ0NyA1LjM0Mzg5IDIuMzcxOCA3LjAyMDQzIDMuMjIyNjVMMjAuODAxNCAxMC4yMTY1QzIyLjI2MTIgMTAuOTU3NCAyMi4yNjEyIDEzLjA0MjYgMjAuODAxNCAxMy43ODM1TDcuMDIwMzkgMjAuNzc3M0M1LjM0Mzg1IDIxLjYyODIgMy41MjYxNCAxOS45MDU1IDQuMjg1ODIgMTguMTg1N0w2LjY2MTI4IDEyLjgwODFDNi43NzQ5NyAxMi41NTA3IDYuODMxODIgMTIuMjc1NCA2LjgzMTgyIDEyWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const SendIcon: ProIcon;
export { SendIcon }
export { SendIcon as send }

/**
 * @description Internet
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iMi43NTEyNSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iNy41IiByeD0iMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjYuMjUiIGN5PSI2LjUwMTI1IiByPSIxLjI1IiBmaWxsPSIjZmZmZmZmIi8+CjxjaXJjbGUgY3g9IjEwLjI1IiBjeT0iNi41MDEyNSIgcj0iMS4yNSIgZmlsbD0iI2ZmZmZmZiIvPgo8cmVjdCB4PSIyLjc1IiB5PSIxMy43NDg3IiB3aWR0aD0iMTguNSIgaGVpZ2h0PSI3LjUiIHJ4PSIyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iNi4yNSIgY3k9IjE3LjQ5ODciIHI9IjEuMjUiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTAuMjUiIGN5PSIxNy40OTg3IiByPSIxLjI1IiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const ServerIcon: ProIcon;
export { ServerIcon }
export { ServerIcon as server }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik03LjA0OTEzIDYuNDYxODVDOC4yMDYgNi44NjkyMSA5LjQ1MzYzIDYuMTQ4ODkgOS42NzkyNyA0Ljk0MzMzTDEwLjAwMTMgMy4yMjI3MkMxMC42NDQxIDMuMDc2OTYgMTEuMzEzMSAzIDEyIDNDMTIuNjg2OSAzIDEzLjM1NTkgMy4wNzY5NiAxMy45OTg3IDMuMjIyNzJMMTQuMzIwNyA0Ljk0MzM4QzE0LjU0NjQgNi4xNDg5MyAxNS43OTQgNi44NjkyNiAxNi45NTA5IDYuNDYxODlMMTguNiA1Ljg4MTE3QzE5LjUwNjIgNi44NTgxNCAyMC4xOTgxIDguMDM2NjQgMjAuNjAxIDkuMzQxOTZMMTkuMjcxNiAxMC40ODE1QzE4LjM0MDQgMTEuMjc5NyAxOC4zNDA0IDEyLjcyMDMgMTkuMjcxNiAxMy41MTg1TDIwLjYwMSAxNC42NThDMjAuMTk4MSAxNS45NjM0IDE5LjUwNjIgMTcuMTQxOSAxOC42IDE4LjExODhMMTYuOTUwOSAxNy41MzgxQzE1Ljc5NCAxNy4xMzA3IDE0LjU0NjQgMTcuODUxMSAxNC4zMjA3IDE5LjA1NjZMMTMuOTk4NyAyMC43NzczQzEzLjM1NTkgMjAuOTIzIDEyLjY4NjkgMjEgMTIgMjFDMTEuMzEzMSAyMSAxMC42NDQxIDIwLjkyMyAxMC4wMDEzIDIwLjc3NzNMOS42NzkyNyAxOS4wNTY3QzkuNDUzNjMgMTcuODUxMSA4LjIwNiAxNy4xMzA4IDcuMDQ5MTMgMTcuNTM4Mkw1LjM5OTk5IDE4LjExODlDNC40OTM4MSAxNy4xNDE5IDMuODAxODkgMTUuOTYzNCAzLjM5ODk2IDE0LjY1OEw0LjcyODQgMTMuNTE4NUM1LjY1OTYyIDEyLjcyMDMgNS42NTk2MiAxMS4yNzk3IDQuNzI4NCAxMC40ODE1TDMuMzk4OTYgOS4zNDE5NkMzLjgwMTg5IDguMDM2NjMgNC40OTM4MSA2Ljg1ODExIDUuMzk5OTkgNS44ODExM0w3LjA0OTEzIDYuNDYxODVaTTEyIDlDMTMuNjU2OSA5IDE1IDEwLjM0MzEgMTUgMTJDMTUgMTMuNjU2OSAxMy42NTY5IDE1IDEyIDE1QzEwLjM0MzEgMTUgOSAxMy42NTY5IDkgMTJDOSAxMC4zNDMxIDEwLjM0MzEgOSAxMiA5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const SettingsIcon: ProIcon;
export { SettingsIcon }
export { SettingsIcon as settings }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEuOTk3NTYgNS43NUMxLjk5NzU2IDMuNjc4OTMgMy42NzY0OSAyIDUuNzQ3NTYgMkgxMi43NDc2QzE0LjgxODYgMiAxNi40OTc2IDMuNjc4OTMgMTYuNDk3NiA1Ljc1VjcuNUgxNS43NDc2SDExLjI1MjRDOS4xODEzNyA3LjUgNy41MDI0NCA5LjE3ODkzIDcuNTAyNDQgMTEuMjVWMTUuNzVWMTYuNUg1Ljc0NzU2QzMuNjc2NDkgMTYuNSAxLjk5NzU2IDE0LjgyMTEgMS45OTc1NiAxMi43NVY1Ljc1WiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNNy41MDI0NCAxNi41SDguMjUyNDRIMTIuNzQ3NkMxNC44MTg2IDE2LjUgMTYuNDk3NiAxNC44MjExIDE2LjQ5NzYgMTIuNzVWOC4yNVY3LjVIMTguMjUyNEMyMC4zMjM1IDcuNSAyMi4wMDI0IDkuMTc4OTMgMjIuMDAyNCAxMS4yNVYxOC4yNUMyMi4wMDI0IDIwLjMyMTEgMjAuMzIzNSAyMiAxOC4yNTI0IDIySDExLjI1MjRDOS4xODEzNyAyMiA3LjUwMjQ0IDIwLjMyMTEgNy41MDI0NCAxOC4yNVYxNi41WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ShapeDifferenceIcon: ProIcon;
export { ShapeDifferenceIcon }
export { ShapeDifferenceIcon as shapeDifference }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjc0NzYgMTUuNzVDMTQuNDA0NCAxNS43NSAxNS43NDc2IDE0LjQwNjkgMTUuNzQ3NiAxMi43NVY4LjI1SDExLjI1MjRDOS41OTU1OSA4LjI1IDguMjUyNDQgOS41OTMxNSA4LjI1MjQ0IDExLjI1VjE1Ljc1SDEyLjc0NzZaIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik04LjI1MjQ0IDE1Ljc1VjE4LjI1QzguMjUyNDQgMTkuOTA2OSA5LjU5NTU5IDIxLjI1IDExLjI1MjQgMjEuMjVIMTguMjUyNEMxOS45MDkzIDIxLjI1IDIxLjI1MjQgMTkuOTA2OSAyMS4yNTI0IDE4LjI1VjExLjI1QzIxLjI1MjQgOS41OTMxNSAxOS45MDkzIDguMjUgMTguMjUyNCA4LjI1SDE1Ljc0NzZNOC4yNTI0NCAxNS43NVYxMS4yNUM4LjI1MjQ0IDkuNTkzMTUgOS41OTU1OSA4LjI1IDExLjI1MjQgOC4yNUgxNS43NDc2TTguMjUyNDQgMTUuNzVIMTIuNzQ3NkMxNC40MDQ0IDE1Ljc1IDE1Ljc0NzYgMTQuNDA2OSAxNS43NDc2IDEyLjc1VjguMjVNOC4yNTI0NCAxNS43NUg1Ljc0NzU2QzQuMDkwNyAxNS43NSAyLjc0NzU2IDE0LjQwNjkgMi43NDc1NiAxMi43NVY1Ljc1QzIuNzQ3NTYgNC4wOTMxNSA0LjA5MDcgMi43NSA1Ljc0NzU2IDIuNzVIMTIuNzQ3NkMxNC40MDQ0IDIuNzUgMTUuNzQ3NiA0LjA5MzE1IDE1Ljc0NzYgNS43NVY4LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ShapeIntersectIcon: ProIcon;
export { ShapeIntersectIcon }
export { ShapeIntersectIcon as shapeIntersect }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjc0NzYgMi43NUg1Ljc0NzU2QzQuMDkwNyAyLjc1IDIuNzQ3NTYgNC4wOTMxNSAyLjc0NzU2IDUuNzVWMTIuNzVDMi43NDc1NiAxNC40MDY5IDQuMDkwNyAxNS43NSA1Ljc0NzU2IDE1Ljc1SDguMjUyNDRWMTEuMjVDOC4yNTI0NCA5LjU5MzE1IDkuNTk1NTkgOC4yNSAxMS4yNTI0IDguMjVIMTUuNzQ3NlY1Ljc1QzE1Ljc0NzYgNC4wOTMxNSAxNC40MDQ0IDIuNzUgMTIuNzQ3NiAyLjc1WiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNOC4yNTI0NCAxNS43NVYxOC4yNUM4LjI1MjQ0IDE5LjkwNjkgOS41OTU1OSAyMS4yNSAxMS4yNTI0IDIxLjI1SDE4LjI1MjRDMTkuOTA5MyAyMS4yNSAyMS4yNTI0IDE5LjkwNjkgMjEuMjUyNCAxOC4yNVYxMS4yNUMyMS4yNTI0IDkuNTkzMTUgMTkuOTA5MyA4LjI1IDE4LjI1MjQgOC4yNUgxNS43NDc2TTguMjUyNDQgMTUuNzVWMTEuMjVDOC4yNTI0NCA5LjU5MzE1IDkuNTk1NTkgOC4yNSAxMS4yNTI0IDguMjVIMTUuNzQ3Nk04LjI1MjQ0IDE1Ljc1SDUuNzQ3NTZDNC4wOTA3IDE1Ljc1IDIuNzQ3NTYgMTQuNDA2OSAyLjc0NzU2IDEyLjc1VjUuNzVDMi43NDc1NiA0LjA5MzE1IDQuMDkwNyAyLjc1IDUuNzQ3NTYgMi43NUgxMi43NDc2QzE0LjQwNDQgMi43NSAxNS43NDc2IDQuMDkzMTUgMTUuNzQ3NiA1Ljc1VjguMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ShapeSubtractIcon: ProIcon;
export { ShapeSubtractIcon }
export { ShapeSubtractIcon as shapeSubtract }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzQ3NTYgNS43NUMyLjc0NzU2IDQuMDkzMTUgNC4wOTA3IDIuNzUgNS43NDc1NiAyLjc1SDEyLjc0NzZDMTQuNDA0NCAyLjc1IDE1Ljc0NzYgNC4wOTMxNSAxNS43NDc2IDUuNzVWMTIuNzVDMTUuNzQ3NiAxNC40MDY5IDE0LjQwNDQgMTUuNzUgMTIuNzQ3NiAxNS43NUg1Ljc0NzU2QzQuMDkwNyAxNS43NSAyLjc0NzU2IDE0LjQwNjkgMi43NDc1NiAxMi43NVY1Ljc1WiIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNOC4yNTI0NCAxMS4yNUM4LjI1MjQ0IDkuNTkzMTUgOS41OTU1OSA4LjI1IDExLjI1MjQgOC4yNUgxOC4yNTI0QzE5LjkwOTMgOC4yNSAyMS4yNTI0IDkuNTkzMTUgMjEuMjUyNCAxMS4yNVYxOC4yNUMyMS4yNTI0IDE5LjkwNjkgMTkuOTA5MyAyMS4yNSAxOC4yNTI0IDIxLjI1SDExLjI1MjRDOS41OTU1OSAyMS4yNSA4LjI1MjQ0IDE5LjkwNjkgOC4yNTI0NCAxOC4yNVYxMS4yNVoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTIuNzQ3NTYgNS43NUMyLjc0NzU2IDQuMDkzMTUgNC4wOTA3IDIuNzUgNS43NDc1NiAyLjc1SDEyLjc0NzZDMTQuNDA0NCAyLjc1IDE1Ljc0NzYgNC4wOTMxNSAxNS43NDc2IDUuNzVWMTIuNzVDMTUuNzQ3NiAxNC40MDY5IDE0LjQwNDQgMTUuNzUgMTIuNzQ3NiAxNS43NUg1Ljc0NzU2QzQuMDkwNyAxNS43NSAyLjc0NzU2IDE0LjQwNjkgMi43NDc1NiAxMi43NVY1Ljc1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04LjI1MjQ0IDExLjI1QzguMjUyNDQgOS41OTMxNSA5LjU5NTU5IDguMjUgMTEuMjUyNCA4LjI1SDE4LjI1MjRDMTkuOTA5MyA4LjI1IDIxLjI1MjQgOS41OTMxNSAyMS4yNTI0IDExLjI1VjE4LjI1QzIxLjI1MjQgMTkuOTA2OSAxOS45MDkzIDIxLjI1IDE4LjI1MjQgMjEuMjVIMTEuMjUyNEM5LjU5NTU5IDIxLjI1IDguMjUyNDQgMTkuOTA2OSA4LjI1MjQ0IDE4LjI1VjExLjI1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ShapeUnionIcon: ProIcon;
export { ShapeUnionIcon }
export { ShapeUnionIcon as shapeUnion }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjI1IDEwLjkwNzNWNy4yNzIxOEMyMC4yNSA2LjQ0MzE2IDE5LjYxNjYgNS43NTA2MyAxOC43OTY3IDUuNjI3OTVDMTcuODQ1OCA1LjQ4NTY4IDE2LjYxNzggNS4yNTI0OSAxNS43MTg4IDQuOTA2MjVDMTQuODEyIDQuNTU3MDUgMTMuNzIxNSAzLjg5ODY4IDEyLjk1NjYgMy40MDA5QzEyLjM3NzUgMy4wMjQwMSAxMS42MjI1IDMuMDI0MDEgMTEuMDQzNCAzLjQwMDlDMTAuMjc4NSAzLjg5ODY4IDkuMTg3OTUgNC41NTcwNSA4LjI4MTI1IDQuOTA2MjVDNy4zODIyMyA1LjI1MjQ5IDYuMTU0MTkgNS40ODU2OCA1LjIwMzMyIDUuNjI3OTVDNC4zODM0MyA1Ljc1MDYzIDMuNzUgNi40NDMxNiAzLjc1IDcuMjcyMThWMTAuOTA3M0MzLjc1IDEyLjY2NzggNC4yMDg4MyAxNC4zOTggNS4wODEyNiAxNS45MjcyQzYuMDI4NTYgMTcuNTg3NiA3LjQyNjM0IDE4Ljk0NjEgOS4xMTMwOCAxOS44NDU3TDkuMzQzNzUgMTkuOTY4OEwxMS4zMDQ5IDIwLjkxNDdDMTEuNzQ0MSAyMS4xMjY2IDEyLjI1NTkgMjEuMTI2NiAxMi42OTUxIDIwLjkxNDdMMTQuNjU2MiAxOS45Njg4TDE0Ljg4NjkgMTkuODQ1N0MxNi41NzM3IDE4Ljk0NjEgMTcuOTcxNCAxNy41ODc2IDE4LjkxODcgMTUuOTI3MkMxOS43OTEyIDE0LjM5OCAyMC4yNSAxMi42Njc4IDIwLjI1IDEwLjkwNzNaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkuNSA5LjVMMTQuNSAxNC41TTE0LjUgOS41TDkuNSAxNC41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ShieldCancelIcon: ProIcon;
export { ShieldCancelIcon }
export { ShieldCancelIcon as shieldCancel }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjI1IDEwLjkwNzNWNy4yNzIxOEMyMC4yNSA2LjQ0MzE2IDE5LjYxNjYgNS43NTA2MyAxOC43OTY3IDUuNjI3OTVDMTcuODQ1OCA1LjQ4NTY4IDE2LjYxNzggNS4yNTI0OSAxNS43MTg4IDQuOTA2MjVDMTQuODEyIDQuNTU3MDUgMTMuNzIxNSAzLjg5ODY4IDEyLjk1NjYgMy40MDA5QzEyLjM3NzUgMy4wMjQwMSAxMS42MjI1IDMuMDI0MDEgMTEuMDQzNCAzLjQwMDlDMTAuMjc4NSAzLjg5ODY4IDkuMTg3OTUgNC41NTcwNSA4LjI4MTI1IDQuOTA2MjVDNy4zODIyMyA1LjI1MjQ5IDYuMTU0MTkgNS40ODU2OCA1LjIwMzMyIDUuNjI3OTVDNC4zODM0MyA1Ljc1MDYzIDMuNzUgNi40NDMxNiAzLjc1IDcuMjcyMThWMTAuOTA3M0MzLjc1IDEyLjY2NzggNC4yMDg4MyAxNC4zOTggNS4wODEyNiAxNS45MjcyQzYuMDI4NTYgMTcuNTg3NiA3LjQyNjM0IDE4Ljk0NjEgOS4xMTMwOCAxOS44NDU3TDkuMzQzNzUgMTkuOTY4OEwxMS4zMDQ5IDIwLjkxNDdDMTEuNzQ0MSAyMS4xMjY2IDEyLjI1NTkgMjEuMTI2NiAxMi42OTUxIDIwLjkxNDdMMTQuNjU2MiAxOS45Njg4TDE0Ljg4NjkgMTkuODQ1N0MxNi41NzM3IDE4Ljk0NjEgMTcuOTcxNCAxNy41ODc2IDE4LjkxODcgMTUuOTI3MkMxOS43OTEyIDE0LjM5OCAyMC4yNSAxMi42Njc4IDIwLjI1IDEwLjkwNzNaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjUwODYgMTBMMTEuNDMyNiAxNC4wNzYxQzExLjE5ODQgMTQuMzEwMyAxMC44MTg3IDE0LjMxMDQgMTAuNTg0NCAxNC4wNzY0TDguNDkxMzkgMTEuOTg2NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ShieldCheckmarkIcon: ProIcon;
export { ShieldCheckmarkIcon }
export { ShieldCheckmarkIcon as shieldCheckmark }

/**
 * @description Security
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjI1IDEwLjkwNzNWNy4yNzIxOEMyMC4yNSA2LjQ0MzE2IDE5LjYxNjYgNS43NTA2MyAxOC43OTY3IDUuNjI3OTVDMTcuODQ1OCA1LjQ4NTY4IDE2LjYxNzggNS4yNTI0OSAxNS43MTg4IDQuOTA2MjVDMTQuODEyIDQuNTU3MDUgMTMuNzIxNSAzLjg5ODY4IDEyLjk1NjYgMy40MDA5QzEyLjM3NzUgMy4wMjQwMSAxMS42MjI1IDMuMDI0MDEgMTEuMDQzNCAzLjQwMDlDMTAuMjc4NSAzLjg5ODY4IDkuMTg3OTUgNC41NTcwNSA4LjI4MTI1IDQuOTA2MjVDNy4zODIyMyA1LjI1MjQ5IDYuMTU0MTkgNS40ODU2OCA1LjIwMzMyIDUuNjI3OTVDNC4zODM0MyA1Ljc1MDYzIDMuNzUgNi40NDMxNiAzLjc1IDcuMjcyMThWMTAuOTA3M0MzLjc1IDEyLjY2NzggNC4yMDg4MyAxNC4zOTggNS4wODEyNiAxNS45MjcyQzYuMDI4NTYgMTcuNTg3NiA3LjQyNjM0IDE4Ljk0NjEgOS4xMTMwOCAxOS44NDU3TDkuMzQzNzUgMTkuOTY4OEwxMS4zMDQ5IDIwLjkxNDdDMTEuNzQ0MSAyMS4xMjY2IDEyLjI1NTkgMjEuMTI2NiAxMi42OTUxIDIwLjkxNDdMMTQuNjU2MiAxOS45Njg4TDE0Ljg4NjkgMTkuODQ1N0MxNi41NzM3IDE4Ljk0NjEgMTcuOTcxNCAxNy41ODc2IDE4LjkxODcgMTUuOTI3MkMxOS43OTEyIDE0LjM5OCAyMC4yNSAxMi42Njc4IDIwLjI1IDEwLjkwNzNaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ShieldIcon: ProIcon;
export { ShieldIcon }
export { ShieldIcon as shield }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjI1IDEwLjkwNzNWNy4yNzIxOEMyMC4yNSA2LjQ0MzE2IDE5LjYxNjYgNS43NTA2MyAxOC43OTY3IDUuNjI3OTVDMTcuODQ1OCA1LjQ4NTY4IDE2LjYxNzggNS4yNTI0OSAxNS43MTg4IDQuOTA2MjVDMTQuODEyIDQuNTU3MDUgMTMuNzIxNSAzLjg5ODY4IDEyLjk1NjYgMy40MDA5QzEyLjM3NzUgMy4wMjQwMSAxMS42MjI1IDMuMDI0MDEgMTEuMDQzNCAzLjQwMDlDMTAuMjc4NSAzLjg5ODY4IDkuMTg3OTUgNC41NTcwNSA4LjI4MTI1IDQuOTA2MjVDNy4zODIyMyA1LjI1MjQ5IDYuMTU0MTkgNS40ODU2OCA1LjIwMzMyIDUuNjI3OTVDNC4zODM0MyA1Ljc1MDYzIDMuNzUgNi40NDMxNiAzLjc1IDcuMjcyMThWMTAuOTA3M0MzLjc1IDEyLjY2NzggNC4yMDg4MyAxNC4zOTggNS4wODEyNiAxNS45MjcyQzYuMDI4NTYgMTcuNTg3NiA3LjQyNjM0IDE4Ljk0NjEgOS4xMTMwOCAxOS44NDU3TDkuMzQzNzUgMTkuOTY4OEwxMS4zMDQ5IDIwLjkxNDdDMTEuNzQ0MSAyMS4xMjY2IDEyLjI1NTkgMjEuMTI2NiAxMi42OTUxIDIwLjkxNDdMMTQuNjU2MiAxOS45Njg4TDE0Ljg4NjkgMTkuODQ1N0MxNi41NzM3IDE4Ljk0NjEgMTcuOTcxNCAxNy41ODc2IDE4LjkxODcgMTUuOTI3MkMxOS43OTEyIDE0LjM5OCAyMC4yNSAxMi42Njc4IDIwLjI1IDEwLjkwNzNaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iMTIiIGN5PSIxMC41IiByPSIyIiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik0xMiAxNC43NVYxMi4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const ShieldKeyholeIcon: ProIcon;
export { ShieldKeyholeIcon }
export { ShieldKeyholeIcon as shieldKeyhole }

/**
 * @description Skeleton, Emoji, Bones, Head, Spooky, Poison, Pirate, Kill, Blood, Death, Die,
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3Ljk5IDE3LjI4NEMyMC4yMTU0IDE1Ljc1NjIgMjEuMjUgMTMuODQxOCAyMS4yNSAxMS4xMkMyMS4yNSA2LjQ5OTU2IDE3LjEwODYgMi43NSAxMiAyLjc1QzYuODkxMzcgMi43NSAyLjc1IDYuNDk5NTYgMi43NSAxMS4xMkMyLjc1IDEzLjg0MTkgNC4xODcyIDE1Ljc1NjIgNi40MTI3IDE3LjI4NEM2LjIzNzUzIDE3Ljg5NDUgNi4yODE0OSAxOS41MzUxIDYuNiAyMC4wNjQxQzcuMDEzNzEgMjAuNzUxMiA3LjgxODgyIDIxLjI1IDguNDY5NzkgMjEuMjVDOS4yMTMwNyAyMS4yNSA5Ljg2NTU2IDIwLjc3NjUgMTAuMjM1IDIwLjA2MzZDMTAuNjA0NSAyMC43NzY1IDExLjI1NyAyMS4yNSAxMi4wMDAzIDIxLjI1QzEyLjc0MzQgMjEuMjUgMTMuMzk1OCAyMC43NzY3IDEzLjc2NTMgMjAuMDY0MUMxNC4xMzQ5IDIwLjc3NjcgMTQuNzg3MiAyMS4yNSAxNS41MzAzIDIxLjI1QzE2LjE4MTMgMjEuMjUgMTYuOTgzNyAyMC43NTEyIDE3LjQ3IDIwLjA2NDFDMTcuODQ0NCAxOS41MzUxIDE3Ljk5IDE3Ljg5NDQgMTcuOTkgMTcuMjg0WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik01Ljc1IDEwLjI1QzUuNzUgOC44NjkyOSA2Ljg2OTI5IDcuNzUgOC4yNSA3Ljc1QzkuNjMwNzEgNy43NSAxMC43NSA4Ljg2OTI5IDEwLjc1IDEwLjI1VjExLjI1QzEwLjc1IDEyLjA3ODQgMTAuMDc4NCAxMi43NSA5LjI1IDEyLjc1SDguMjVDNi44NjkyOSAxMi43NSA1Ljc1IDExLjYzMDcgNS43NSAxMC4yNVoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTEzLjI1IDEwLjI1QzEzLjI1IDguODY5MjkgMTQuMzY5MyA3Ljc1IDE1Ljc1IDcuNzVDMTcuMTMwNyA3Ljc1IDE4LjI1IDguODY5MjkgMTguMjUgMTAuMjVDMTguMjUgMTEuNjMwNyAxNy4xMzA3IDEyLjc1IDE1Ljc1IDEyLjc1SDE0Ljc1QzEzLjkyMTYgMTIuNzUgMTMuMjUgMTIuMDc4NCAxMy4yNSAxMS4yNVYxMC4yNVoiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTExLjQ3NzEgMTMuMTc5N0wxMC4yNTMgMTUuMzU1OEMxMC4wMjggMTUuNzU1OCAxMC4zMTcgMTYuMjUgMTAuNzc1OSAxNi4yNUgxMy4yMjQxQzEzLjY4MyAxNi4yNSAxMy45NzIgMTUuNzU1OCAxMy43NDcgMTUuMzU1OEwxMi41MjI5IDEzLjE3OTdDMTIuMjkzNiAxMi43NzE5IDExLjcwNjQgMTIuNzcxOSAxMS40NzcxIDEzLjE3OTdaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const SkullIcon: ProIcon;
export { SkullIcon }
export { SkullIcon as skull }

/**
 * @description Command
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuNSA3TDkuNSAxNyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const SlashBoxIcon: ProIcon;
export { SlashBoxIcon }
export { SlashBoxIcon as slashBox }

/**
 * @description Audio, EQ, Waveform, mp3
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIwLjc1VjMuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjAgMTQuOTU5MlY5LjA0MTAyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTQgMTQuOTU5MVY5LjA0MDg5IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE2IDE3LjkxMjJWNi4wODc4OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04IDE3LjkxMjJWNi4wODc4OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const SoundwaveIcon: ProIcon;
export { SoundwaveIcon }
export { SoundwaveIcon as soundwave }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMTBWMTIuNUMzLjc1IDEzLjYwNDYgNC42NDU0MyAxNC41IDUuNzUgMTQuNUgxOC4yNUMxOS4zNTQ2IDE0LjUgMjAuMjUgMTMuNjA0NiAyMC4yNSAxMi41VjEwIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const SpacebarIcon: ProIcon;
export { SpacebarIcon }
export { SpacebarIcon as spacebar }

/**
 * @description Flare, Gemini
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTExLjI1NTggMy41NjcwM0MxMS41MjIxIDIuODkxNzEgMTIuNDc3OSAyLjg5MTcxIDEyLjc0NDIgMy41NjcwM0wxNC43OTE1IDguNzU3OUMxNC44NzI4IDguOTY0MDcgMTUuMDM2IDkuMTI3MjggMTUuMjQyMiA5LjIwODU5TDIwLjQzMyAxMS4yNTU4QzIxLjEwODMgMTEuNTIyMiAyMS4xMDgzIDEyLjQ3NzkgMjAuNDMzIDEyLjc0NDNMMTUuMjQyMiAxNC43OTE1QzE1LjAzNiAxNC44NzI4IDE0Ljg3MjggMTUuMDM2IDE0Ljc5MTUgMTUuMjQyMkwxMi43NDQyIDIwLjQzMzFDMTIuNDc3OSAyMS4xMDg0IDExLjUyMjEgMjEuMTA4NCAxMS4yNTU4IDIwLjQzMzFMOS4yMDg1MyAxNS4yNDIyQzkuMTI3MjIgMTUuMDM2IDguOTY0MDEgMTQuODcyOCA4Ljc1NzgzIDE0Ljc5MTVMMy41NjY5NyAxMi43NDQzQzIuODkxNjUgMTIuNDc3OSAyLjg5MTY1IDExLjUyMjIgMy41NjY5NyAxMS4yNTU4TDguNzU3ODMgOS4yMDg1OUM4Ljk2NDAxIDkuMTI3MjggOS4xMjcyMiA4Ljk2NDA3IDkuMjA4NTMgOC43NTc5TDExLjI1NTggMy41NjcwM1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSI1LjI1IiBjeT0iNS4yNSIgcj0iMS4yNSIgZmlsbD0iI2ZmZmZmZiIvPgo8Y2lyY2xlIGN4PSIxOSIgY3k9IjE5IiByPSIxIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const SparkleIcon: ProIcon;
export { SparkleIcon }
export { SparkleIcon as sparkle }

/**
 * @description Loading
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIxLjI1QzEzLjgyOTUgMjEuMjUgMTUuNjE3OSAyMC43MDc1IDE3LjEzOSAxOS42OTExQzE4LjY2MDIgMTguNjc0NyAxOS44NDU4IDE3LjIzIDIwLjU0NTkgMTUuNTM5OEMyMS4yNDYgMTMuODQ5NiAyMS40MjkyIDExLjk4OTcgMjEuMDcyMyAxMC4xOTU0QzIwLjcxNTQgOC40MDEwOSAxOS44MzQ0IDYuNzUyOSAxOC41NDA3IDUuNDU5MjZDMTcuMjQ3MSA0LjE2NTYzIDE1LjU5ODkgMy4yODQ2NSAxMy44MDQ2IDIuOTI3NzRDMTIuMDEwMyAyLjU3MDgyIDEwLjE1MDQgMi43NTQgOC40NjAxOCAzLjQ1NDExQzYuNzY5OTYgNC4xNTQyMiA1LjMyNTMxIDUuMzM5ODIgNC4zMDg5MSA2Ljg2MDk3QzMuMjkyNSA4LjM4MjEzIDIuNzUgMTAuMTcwNSAyLjc1IDEyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const SpinnerIcon: ProIcon;
export { SpinnerIcon }
export { SpinnerIcon as spinner }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const SquareIcon: ProIcon;
export { SquareIcon }
export { SquareIcon as square }

/**
 * @description Favourite, Favorite
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjcwMzkgNC4zMjUzOEMxMS4yODI1IDMuMzMxOTggMTIuNzE3NyAzLjMzMTk4IDEzLjI5NjMgNC4zMjUzOEwxNS4xMTM2IDcuNDQ1NTZDMTUuMzI1NSA3LjgwOTQ2IDE1LjY4MDcgOC4wNjc1IDE2LjA5MjMgOC4xNTY2M0wxOS42MjEzIDguOTIwODNDMjAuNzQ0OSA5LjE2NDE0IDIxLjE4ODQgMTAuNTI5IDIwLjQyMjQgMTEuMzg2M0wxOC4wMTY1IDE0LjA3ODlDMTcuNzM2IDE0LjM5MjkgMTcuNjAwMyAxNC44MTA0IDE3LjY0MjcgMTUuMjI5NEwxOC4wMDY1IDE4LjgyMTlDMTguMTIyMyAxOS45NjU3IDE2Ljk2MTIgMjAuODA5MiAxNS45MDkyIDIwLjM0NTZMMTIuNjA1IDE4Ljg4OTVDMTIuMjE5NiAxOC43MTk3IDExLjc4MDYgMTguNzE5NyAxMS4zOTUyIDE4Ljg4OTVMOC4wOTA5NyAyMC4zNDU2QzcuMDM4OTYgMjAuODA5MiA1Ljg3NzkyIDE5Ljk2NTcgNS45OTM3MiAxOC44MjE5TDYuMzU3NDYgMTUuMjI5NEM2LjM5OTg4IDE0LjgxMDQgNi4yNjQyMiAxNC4zOTI5IDUuOTgzNjMgMTQuMDc4OUwzLjU3Nzc1IDExLjM4NjNDMi44MTE3NyAxMC41MjkgMy4yNTUyNSA5LjE2NDE0IDQuMzc4ODMgOC45MjA4M0w3LjkwNzg4IDguMTU2NjNDOC4zMTk0NyA4LjA2NzUgOC42NzQ2MyA3LjgwOTQ2IDguODg2NTggNy40NDU1NkwxMC43MDM5IDQuMzI1MzhaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const StarIcon: ProIcon;
export { StarIcon }
export { StarIcon as star }

/**
 * @description Line Thickness, Border, Weight, Outline
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNC41SDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIwLjUgMTBIMy41QzMuMDg1NzkgMTAgMi43NSAxMC4zMzU4IDIuNzUgMTAuNzVDMi43NSAxMS4xNjQyIDMuMDg1NzkgMTEuNSAzLjUgMTEuNUgyMC41QzIwLjkxNDIgMTEuNSAyMS4yNSAxMS4xNjQyIDIxLjI1IDEwLjc1QzIxLjI1IDEwLjMzNTggMjAuOTE0MiAxMCAyMC41IDEwWiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xOS43NSAxN0g0LjI1QzMuNDIxNTcgMTcgMi43NSAxNy42NzE2IDIuNzUgMTguNUMyLjc1IDE5LjMyODQgMy40MjE1NyAyMCA0LjI1IDIwSDE5Ljc1QzIwLjU3ODQgMjAgMjEuMjUgMTkuMzI4NCAyMS4yNSAxOC41QzIxLjI1IDE3LjY3MTYgMjAuNTc4NCAxNyAxOS43NSAxN1oiIGZpbGw9IiNmZmZmZmYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const StrokeThicknessIcon: ProIcon;
export { StrokeThicknessIcon }
export { StrokeThicknessIcon as strokeThickness }

/**
 * @description Minus, Minimize, Line Horizonal, Subtract
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMTJIMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const SubtractIcon: ProIcon;
export { SubtractIcon }
export { SubtractIcon as subtract }

/**
 * @description SvelteKit, Framework, JavaScript, Compiler
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4Ljg3NzcgMTAuODgxNEMyMC4yNDA2IDEzLjUzMTIgMTkuMjk5IDE2LjgxNDMgMTYuNjk2OCAxOC4zMjA4TDEyLjkzOTUgMjAuNDk2MUMxMC4yNTg5IDIyLjA0ODEgNi44MzEyOCAyMS4xMjcxIDUuMjgzNjQgMTguNDM5QzQuMzA3MyAxNi43NDMyIDQuMzEyNDEgMTQuNzQ5MyA1LjEyMjI2IDEzLjExODZDMy43NTk0MSAxMC40Njg4IDQuNzAxMDMgNy4xODU3NCA3LjMwMzE5IDUuNjc5MkwxMS4wNjA1IDMuNTAzODlDMTMuNzQxMSAxLjk1MTk0IDE3LjE2ODcgMi44NzI5NCAxOC43MTY0IDUuNTYxQzE5LjY5MjcgNy4yNTY3OSAxOS42ODc2IDkuMjUwNzMgMTguODc3NyAxMC44ODE0WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNi4wMTEgOC45MTIyNUMxNi4xNDggOC4zNzI4OCAxNi4wODMgNy43ODA1MiAxNS43ODI5IDcuMjU5MzFDMTUuMTc0NiA2LjIwMjg1IDEzLjgzMTIgNS44Mzg3NiAxMi43ODIxIDYuNDQ2MUw4Ljk4MzMxIDguNjQ1NDZDNy45MzQyOSA5LjI1MjggNy41NzY5OCAxMC42MDE2IDguMTg1MjQgMTEuNjU4QzguNzkzNDkgMTIuNzE0NSAxMC4xMzcgMTMuMDc4NiAxMS4xODYgMTIuNDcxMkwxMi44MTQxIDExLjUyODdDMTMuODYzMSAxMC45MjEzIDE1LjIwNjYgMTEuMjg1NCAxNS44MTQ4IDEyLjM0MTlDMTYuNDIzMSAxMy4zOTgzIDE2LjA2NTggMTQuNzQ3MSAxNS4wMTY3IDE1LjM1NDRMMTEuMjE3OSAxNy41NTM4QzEwLjE2ODkgMTguMTYxMSA4LjgyNTQxIDE3Ljc5NzEgOC4yMTcxNiAxNi43NDA2QzcuOTE3MDcgMTYuMjE5NCA3Ljg1MjAxIDE1LjYyNyA3Ljk4OTA3IDE1LjA4NzciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.10.0
 * @updated v4.11.0
 */
declare const SvelteIcon: ProIcon;
export { SvelteIcon }
export { SvelteIcon as svelte }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const SymbolsIcon: ProIcon;
export { SymbolsIcon }
export { SymbolsIcon as symbols }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iMy43NSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTYuNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSA3Ljc1SDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTRIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC45MTk5OCA3Ljc1TDguOTE5OTggMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuMDkgNy43NUwxNS4wOSAyMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TableIcon: ProIcon;
export { TableIcon }
export { TableIcon as table }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy43NSA5LjI1SDIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTMuNzUgMTQuNzVIMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOS4yNSAzLjc1TDkuMjUgMjAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuNzUgMy43NUwxNC43NSAyMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TableSimpleIcon: ProIcon;
export { TableSimpleIcon }
export { TableSimpleIcon as tableSimple }

/**
 * @description iPad
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC41IiB3aWR0aD0iMTguNSIgaGVpZ2h0PSIxNSIgcng9IjMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTAgMTZIMTQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TabletIcon: ProIcon;
export { TabletIcon }
export { TabletIcon as tablet }

/**
 * @description Label
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjE2MTYgMTAuOTI1NEwxMy43MTY0IDQuNDgwMjhDMTMuMjQ3NiA0LjAxMTQ0IDEyLjYxMTcgMy43NDgwNSAxMS45NDg3IDMuNzQ4MDVMNi43NDgwOCAzLjc0ODA1QzUuMDkxMjIgMy43NDgwNSAzLjc0ODA4IDUuMDkxMiAzLjc0ODA4IDYuNzQ4MDVMMy43NDgwOCAxMS45NDg2QzMuNzQ4MDggMTIuNjExNyA0LjAxMTQ3IDEzLjI0NzYgNC40ODAzMSAxMy43MTY0TDEwLjkyNTUgMjAuMTYxNkMxMi40ODc2IDIxLjcyMzcgMTUuMDIwMiAyMS43MjM3IDE2LjU4MjMgMjAuMTYxNkwyMC4xNjE2IDE2LjU4MjNDMjEuNzIzNyAxNS4wMjAyIDIxLjcyMzcgMTIuNDg3NSAyMC4xNjE2IDEwLjkyNTRaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TagAccentIcon: ProIcon;
export { TagAccentIcon }
export { TagAccentIcon as tagAccent }

/**
 * @description Label
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjE2MTYgMTAuOTI1NUwxMy43MTY0IDQuNDgwMzhDMTMuMjQ3NiA0LjAxMTU0IDEyLjYxMTcgMy43NDgxNSAxMS45NDg3IDMuNzQ4MTVMNi43NDgwNyAzLjc0ODE1QzUuMDkxMjEgMy43NDgxNSAzLjc0ODA3IDUuMDkxMjkgMy43NDgwNyA2Ljc0ODE1TDMuNzQ4MDcgMTEuOTQ4N0MzLjc0ODA3IDEyLjYxMTggNC4wMTE0NiAxMy4yNDc3IDQuNDgwMyAxMy43MTY1TDEwLjkyNTQgMjAuMTYxN0MxMi40ODc1IDIxLjcyMzggMTUuMDIwMiAyMS43MjM4IDE2LjU4MjMgMjAuMTYxN0wxOC4zNzE5IDE4LjM3MkwyMC4xNjE2IDE2LjU4MjRDMjEuNzIzNyAxNS4wMjAzIDIxLjcyMzcgMTIuNDg3NiAyMC4xNjE2IDEwLjkyNTVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iNy43MzgzOCIgY3k9IjcuNzM4NCIgcj0iMS4yNzcyNSIgdHJhbnNmb3JtPSJyb3RhdGUoLTQ1IDcuNzM4MzggNy43Mzg0KSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TagIcon: ProIcon;
export { TagIcon }
export { TagIcon as tag }

/**
 * @description Tags
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjgyOCA5LjYyODg0TDEzLjM0OCA0LjEzNjc4QzEyLjc2NjggMy41NTQyNSAxMS45NzM4IDMuMjM0MjYgMTEuMTUyIDMuMjUwNkw2LjgyODA4IDMuMzM2NTZDNS40NzY4MiAzLjM2MzQyIDQuMzg3ODMgNC40NTQ4MiA0LjM2MTAyIDUuODA5MDVMNC4yNzUyNSAxMC4xNDI1QzQuMjU4OTUgMTAuOTY2MiA0LjU3ODI0IDExLjc2MDkgNS4xNTk0OCAxMi4zNDM0TDEwLjYzOTQgMTcuODM1NUMxMS44MTkyIDE5LjAxNzggMTMuNzMyIDE5LjAxNzggMTQuOTExNyAxNy44MzU1TDE4LjgyOCAxMy45MTA2QzIwLjAwNzggMTIuNzI4MiAyMC4wMDc4IDEwLjgxMTIgMTguODI4IDkuNjI4ODRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTQuMjUgMTUuNzEzNUw4LjUwMzU2IDE5Ljk3NjRDMTAuODYzMSAyMi4zNDEyIDE0LjY4ODYgMjIuMzQxMiAxNy4wNDgxIDE5Ljk3NjRMMjAuMjUgMTYuNzY3NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03Ljk2NzAyIDUuNzk3NzNDOC42MDIxNCA1Ljc5NzczIDkuMTE3MDIgNi4zMTE3NyA5LjExNzAyIDYuOTQ1ODhDOS4xMTcwMiA3LjU3OTk4IDguNjAyMTQgOC4wOTQwMiA3Ljk2NzAyIDguMDk0MDJDNy4zMzE4OSA4LjA5NDAyIDYuODE3MDIgNy41Nzk5OCA2LjgxNzAyIDYuOTQ1ODhDNi44MTcwMiA2LjMxMTc3IDcuMzMxODkgNS43OTc3MyA3Ljk2NzAyIDUuNzk3NzNaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const TagMultipleIcon: ProIcon;
export { TagMultipleIcon }
export { TagMultipleIcon as TagMultipleVarIcon }
export { TagMultipleIcon as tagMultiple }
export { TagMultipleIcon as tagMultipleVar }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjI1IDQuNUwyMS4yNSA0LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy4yNSAzLjA1MzU5TDQuMzU3MTQgNS45NDY0NUwyLjc1IDQuMzM5MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMC4yNSAxMkwyMS4yNSAxMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03LjI1IDEwLjU1MzZMNC4zNTcxNCAxMy40NDY0TDIuNzUgMTEuODM5MyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMC4yNSAxOS41TDIxLjI1IDE5LjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy4yNSAxOC4wNTM2TDQuMzU3MTQgMjAuOTQ2NEwyLjc1IDE5LjMzOTMiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TaskListIcon: ProIcon;
export { TaskListIcon }
export { TaskListIcon as taskList }

/**
 * @description Cmd, Command Prompt, Bash, Powershell, Ps
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC4yNSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTUuNSIgcng9IjMuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik03LjI1IDlMMTAuMjUgMTJMNy4yNSAxNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMi43NSAxNUgxNi43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TerminalIcon: ProIcon;
export { TerminalIcon }
export { TerminalIcon as terminal }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjI1IDguMzg4ODlMMTguNjMwMyA3LjE1NDI0QzE4LjEyMTMgNi4xNDAxNSAxNy4wODM3IDUuNSAxNS45NDkxIDUuNUg4LjA1MDkyQzYuOTE2MjYgNS41IDUuODc4NjkgNi4xNDAxNSA1LjM2OTcgNy4xNTQyNEw0Ljc1IDguMzg4ODlNMTIgNS41VjExLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTE3LjUgMjNDMjAuNTM3NiAyMyAyMyAyMC41Mzc2IDIzIDE3LjVDMjMgMTQuNDYyNCAyMC41Mzc2IDEyIDE3LjUgMTJDMTQuNDYyNCAxMiAxMiAxNC40NjI0IDEyIDE3LjVDMTIgMjAuNTM3NiAxNC40NjI0IDIzIDE3LjUgMjNaTTE3LjUgMTQuMDA2NkMxNy43NzYxIDE0LjAwNjYgMTggMTQuMjMwNCAxOCAxNC41MDY2VjE3LjAwMDFIMjAuNDkzNEMyMC43Njk2IDE3LjAwMDEgMjAuOTkzNCAxNy4yMjM5IDIwLjk5MzQgMTcuNTAwMUMyMC45OTM0IDE3Ljc3NjIgMjAuNzY5NiAxOC4wMDAxIDIwLjQ5MzQgMTguMDAwMUgxOFYyMC40OTM0QzE4IDIwLjc2OTYgMTcuNzc2MSAyMC45OTM0IDE3LjUgMjAuOTkzNEMxNy4yMjM5IDIwLjk5MzQgMTcgMjAuNzY5NiAxNyAyMC40OTM0VjE4LjAwMDFIMTQuNTA2NkMxNC4yMzA0IDE4LjAwMDEgMTQuMDA2NiAxNy43NzYyIDE0LjAwNjYgMTcuNTAwMUMxNC4wMDY2IDE3LjIyMzkgMTQuMjMwNCAxNy4wMDAxIDE0LjUwNjYgMTcuMDAwMUgxN1YxNC41MDY2QzE3IDE0LjIzMDQgMTcuMjIzOSAxNC4wMDY2IDE3LjUgMTQuMDA2NloiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextAddIcon: ProIcon;
export { TextAddIcon }
export { TextAddIcon as textAdd }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuMjUgNS4yNUgxOC43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDEySDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTcgMTguNzVIMTciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextAlignCenterIcon: ProIcon;
export { TextAlignCenterIcon }
export { TextAlignCenterIcon as textAlignCenter }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNS4yNUgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDEySDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTguNzVIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextAlignJustifyIcon: ProIcon;
export { TextAlignJustifyIcon }
export { TextAlignJustifyIcon as textAlignJustify }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNS4yNUgxNi4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDEySDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTguNzVIMTIuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextAlignLeftIcon: ProIcon;
export { TextAlignLeftIcon }
export { TextAlignLeftIcon as textAlignLeft }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNzUgNS4yNUgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDEySDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTExLjI1IDE4Ljc1SDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextAlignRightIcon: ProIcon;
export { TextAlignRightIcon }
export { TextAlignRightIcon as textAlignRight }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNSAxMS43NzU5SDEyLjA1MTNDMTMuNzYyNiAxMS43NzU5IDE1LjE1IDEwLjM3MSAxNS4xNSA4LjYzNzkzQzE1LjE1IDYuOTA0OSAxMy43NjI2IDUuNSAxMi4wNTEzIDUuNUg4LjVDNy45NDc3MiA1LjUgNy41IDUuOTQ3NzIgNy41IDYuNVYxMS43NzU5Wk03LjUgMTEuNzc1OUgxMy4xMjVDMTQuOTg5IDExLjc3NTkgMTYuNSAxMy4yODExIDE2LjUgMTUuMTM3OUMxNi41IDE2Ljk5NDggMTQuOTg5IDE4LjUgMTMuMTI1IDE4LjVIOC41QzcuOTQ3NzIgMTguNSA3LjUgMTguMDUyMyA3LjUgMTcuNVYxMS43NzU5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjMiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextBoldIcon: ProIcon;
export { TextBoldIcon }
export { TextBoldIcon as textBold }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNC40NDI5NSIgY3k9IjUuMDgwNjQiIHI9IjEuMzMwNjQiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTkuMTIyNjggNS4wODA1N0gyMC44ODc2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGNpcmNsZSBjeD0iNC40NDI5NSIgY3k9IjEyLjAwMDEiIHI9IjEuMzMwNjQiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTkuMTIyNjggMTJIMjAuODg3NiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjQuNDQyOTUiIGN5PSIxOC45MTk0IiByPSIxLjMzMDY0IiBmaWxsPSIjZmZmZmZmIi8+CjxwYXRoIGQ9Ik05LjEyMjY4IDE4LjkxOTRIMjAuODg3NiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextBulletListIcon: ProIcon;
export { TextBulletListIcon }
export { TextBulletListIcon as textBulletList }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNy44NzcyIiBjeT0iOC4yNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTEuMDYxOCA4LjI1SDE2LjM3MjciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSI3Ljg3NzIiIGN5PSIxMiIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTEuMDYxOSAxMkgxMi4zNzI4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPGNpcmNsZSBjeD0iNy44NzcyIiBjeT0iMTUuNzUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTIwLjI1IDEwLjI1VjcuNzVDMjAuMjUgNS41NDA4NiAxOC40NTkxIDMuNzUgMTYuMjUgMy43NUg3Ljc1QzUuNTQwODYgMy43NSAzLjc1IDUuNTQwODYgMy43NSA3Ljc1VjE2LjI1QzMuNzUgMTguNDU5MSA1LjU0MDg2IDIwLjI1IDcuNzUgMjAuMjVIMTAuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTE3LjUgMjNDMjAuNTM3NiAyMyAyMyAyMC41Mzc2IDIzIDE3LjVDMjMgMTQuNDYyNCAyMC41Mzc2IDEyIDE3LjUgMTJDMTQuNDYyNCAxMiAxMiAxNC40NjI0IDEyIDE3LjVDMTIgMjAuNTM3NiAxNC40NjI0IDIzIDE3LjUgMjNaTTE3LjUgMTQuMDA2NkMxNy43NzYxIDE0LjAwNjYgMTggMTQuMjMwNCAxOCAxNC41MDY2VjE3LjAwMDFIMjAuNDkzNEMyMC43Njk2IDE3LjAwMDEgMjAuOTkzNCAxNy4yMjM5IDIwLjk5MzQgMTcuNTAwMUMyMC45OTM0IDE3Ljc3NjIgMjAuNzY5NiAxOC4wMDAxIDIwLjQ5MzQgMTguMDAwMUgxOFYyMC40OTM0QzE4IDIwLjc2OTYgMTcuNzc2MSAyMC45OTM0IDE3LjUgMjAuOTkzNEMxNy4yMjM5IDIwLjk5MzQgMTcgMjAuNzY5NiAxNyAyMC40OTM0VjE4LjAwMDFIMTQuNTA2NkMxNC4yMzA0IDE4LjAwMDEgMTQuMDA2NiAxNy43NzYyIDE0LjAwNjYgMTcuNTAwMUMxNC4wMDY2IDE3LjIyMzkgMTQuMjMwNCAxNy4wMDAxIDE0LjUwNjYgMTcuMDAwMUgxN1YxNC41MDY2QzE3IDE0LjIzMDQgMTcuMjIzOSAxNC4wMDY2IDE3LjUgMTQuMDA2NloiIGZpbGw9IiNmZmZmZmYiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextBulletListSquareAddIcon: ProIcon;
export { TextBulletListSquareAddIcon }
export { TextBulletListSquareAddIcon as textBulletListSquareAdd }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iNy44NzcyIiBjeT0iOC4yNSIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTEuMDYxOCA4LjI1SDE2LjM3MjciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSI3Ljg3NzIiIGN5PSIxMiIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTEuMDYxOSAxMkgxNi4zNzI4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPGNpcmNsZSBjeD0iNy44NzcyIiBjeT0iMTUuNzUiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPHBhdGggZD0iTTExLjA2MTkgMTUuNzVIMTYuMzcyOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxyZWN0IHg9IjMuNzUiIHk9IjMuNzUiIHdpZHRoPSIxNi41IiBoZWlnaHQ9IjE2LjUiIHJ4PSI0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextBulletListSquareIcon: ProIcon;
export { TextBulletListSquareIcon }
export { TextBulletListSquareIcon as textBulletListSquare }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuODEgMTIuOTE4NUw5LjczNTkgMTIuOTA0NEM2LjY4Njk2IDEyLjMyNTkgMy4wNiAxMi40MTQ1IDMuMDYgMTUuNDU5MkMzLjA2IDE2LjMxMzQgMy41NTEwNCAxNy4xMTY3IDQuMjY2MTcgMTcuNTU0MUM0Ljk3NTU3IDE3Ljk4ODEgNS44NzAwNiAxOCA2LjcwNjIgMThDNy44NTUzIDE4IDkuMTE1OTcgMTcuMzUgOS42MjAyMiAxNi4zMzc3QzkuNzE2MzQgMTYuMTQ0NyA5Ljc4MTg5IDE1LjkyNTUgOS44MSAxNS42ODA4VjE0LjUxMzhNOS44MSAxMi45MTg1VjEyLjMxQzkuODEgMTEuNTQ4MSA5LjcxOTg3IDEwLjU0MiA5LjI2Mjc4IDkuOTI1OTRDOC43NjU3NyA5LjI1NjAxIDcuODgzOTEgOC41IDYuNDM1IDguNUM0LjA0MTk1IDguNSAzLjI2OTM1IDEwLjE1NDQgMy4yNjkzNSAxMC4xNTQ0TTkuODEgMTIuOTE4NVYxNC41MTM4TTkuODEgMTcuODk2NlYxNC41MTM4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTEzLjU2IDYuNVYxOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMS41NiAxNEMyMS41NiAxNi4yMDkxIDE5Ljc2OTEgMTggMTcuNTYgMThDMTUuMzUwOSAxOCAxMy41NiAxNi4yMDkxIDEzLjU2IDE0QzEzLjU2IDExLjc5MDkgMTUuMzUwOSAxMCAxNy41NiAxMEMxOS43NjkxIDEwIDIxLjU2IDExLjc5MDkgMjEuNTYgMTRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextCaseLowercaseIcon: ProIcon;
export { TextCaseLowercaseIcon }
export { TextCaseLowercaseIcon as textCaseLowercase }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEuODggMThMMy43MTAzNiAxMy41OTY0TTMuNzEwMzYgMTMuNTk2NEgxMC4yOTk2TTMuNzEwMzYgMTMuNTk2NEw2LjUxNDk3IDYuODQ4NzhDNi43MDgyNyA2LjM4Mzc0IDcuMzAxNzQgNi4zODM3NCA3LjQ5NTA0IDYuODQ4NzhMMTAuMjk5NiAxMy41OTY0TTEwLjI5OTYgMTMuNTk2NEwxMi4xMyAxOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC43OSA2LjVWMThNMjIuMzgwMSAxNC4yMDQ5QzIyLjM4MDEgMTYuMzAwOSAyMC42ODEgMTggMTguNTg1IDE4QzE2LjQ4OTEgMTggMTQuNzkgMTYuMzAwOSAxNC43OSAxNC4yMDQ5QzE0Ljc5IDEyLjEwOSAxNi40ODkxIDEwLjQwOTkgMTguNTg1IDEwLjQwOTlDMjAuNjgxIDEwLjQwOTkgMjIuMzgwMSAxMi4xMDkgMjIuMzgwMSAxNC4yMDQ5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextCaseTitleIcon: ProIcon;
export { TextCaseTitleIcon }
export { TextCaseTitleIcon as textCaseTitle }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEuMDEwMDEgMThMMi45Mjk2NSAxMy41OTY0TTIuOTI5NjUgMTMuNTk2NEg5Ljg0MDM3TTIuOTI5NjUgMTMuNTk2NEw1Ljg3MTA3IDYuODQ4NzhDNi4wNzM3OSA2LjM4Mzc0IDYuNjk2MjIgNi4zODM3NCA2Ljg5ODk1IDYuODQ4NzhMOS44NDAzNyAxMy41OTY0TTkuODQwMzcgMTMuNTk2NEwxMS43NiAxOCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNC43NiAxMi4wNTE3SDE4LjgwNTZDMjAuMzI2OCAxMi4wNTE3IDIxLjU2IDEwLjgwODkgMjEuNTYgOS4yNzU4NkMyMS41NiA3Ljc0MjggMjAuMzI2OCA2LjUgMTguODA1NiA2LjVIMTQuNzZWMTIuMDUxN1pNMTQuNzYgMTIuMDUxN0gxOS43NkMyMS40MTY5IDEyLjA1MTcgMjIuNzYgMTMuMzgzMyAyMi43NiAxNS4wMjU5QzIyLjc2IDE2LjY2ODQgMjEuNDE2OSAxOCAxOS43NiAxOEgxNC43NlYxMi4wNTE3WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextCaseUppercaseIcon: ProIcon;
export { TextCaseUppercaseIcon }
export { TextCaseUppercaseIcon as textCaseUppercase }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE0Ljc3MDkgMjIuMjUxOUgyMS4yNDYxTTExLjU1NjEgMTQuNTE4N0wxNy40ODE0IDIwLjQ0NE0xMS4yODY0IDE5LjYzNTdMMTIuMzY0MyAyMC43MTM2QzEzLjIxMjcgMjEuNTYyIDEzLjYzNjkgMjEuOTg2MiAxNC4xMjYgMjIuMTQ1MUMxNC41NTYzIDIyLjI4NDkgMTUuMDE5NyAyMi4yODQ5IDE1LjQ1IDIyLjE0NTFDMTUuOTM5MSAyMS45ODYyIDE2LjM2MzMgMjEuNTYyIDE3LjIxMTcgMjAuNzEzNkwyMC43MTM2IDE3LjIxMTdDMjEuNTYyIDE2LjM2MzMgMjEuOTg2MiAxNS45MzkxIDIyLjE0NTEgMTUuNDVDMjIuMjg1IDE1LjAxOTcgMjIuMjg1IDE0LjU1NjMgMjIuMTQ1MSAxNC4xMjZDMjEuOTg2MiAxMy42MzY5IDIxLjU2MiAxMy4yMTI3IDIwLjcxMzYgMTIuMzY0M0wxOS42MzU3IDExLjI4NjRDMTguNzg3MyAxMC40MzggMTguMzYzMSAxMC4wMTM4IDE3Ljg3NCA5Ljg1NDg1QzE3LjQ0MzcgOS43MTUwNSAxNi45ODAzIDkuNzE1MDUgMTYuNTUgOS44NTQ4NUMxNi4wNjA5IDEwLjAxMzggMTUuNjM2NyAxMC40MzggMTQuNzg4MyAxMS4yODY0TDExLjI4NjQgMTQuNzg4M0MxMC40MzggMTUuNjM2NyAxMC4wMTM4IDE2LjA2MDkgOS44NTQ4NSAxNi41NUM5LjcxNTA1IDE2Ljk4MDMgOS43MTUwNSAxNy40NDM3IDkuODU0ODUgMTcuODc0QzEwLjAxMzggMTguMzYzMSAxMC40MzggMTguNzg3MyAxMS4yODY0IDE5LjYzNTdaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTIuNDI2OEw0LjMyNzc0IDguNzIxM000LjMyNzc0IDguNzIxM0gxMC4wMDc2TTQuMzI3NzQgOC43MjEzTDYuNzQ1MjYgMy4wNDM0OEM2LjkxMTg4IDIuNjUyMTcgNy40MjM0NSAyLjY1MjE3IDcuNTkwMDYgMy4wNDM0OEwxMC4wMDc2IDguNzIxM00xMC4wMDc2IDguNzIxM0wxMS4xNDU0IDExLjM5MzdNMTQuMDkgMi43NVY4LjQ4OUwxNC4yMDE4IDguMzkyNzZDMTQuNTcwOCA3LjAzNjk0IDE1LjgxMDcgNi4wNDAwMiAxNy4yODM0IDYuMDQwMDJDMTguODEyNyA2LjA0MDAyIDIwLjA5MDkgNy4xMTUwNSAyMC40MDM2IDguNTUwNjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextClearFormattingIcon: ProIcon;
export { TextClearFormattingIcon }
export { TextClearFormattingIcon as textClearFormatting }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTI1IDQuNUgyMS42MjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy4xMjUgMTkuNUgyMS42MjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuMTI1IDkuNUgyMS42MjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuMTI1IDE0LjVIMjEuNjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik02Ljg3NSAxNi41QzkuMzYwMjggMTYuNSAxMS4zNzUgMTQuNDg1MyAxMS4zNzUgMTJDMTEuMzc1IDkuNTE0NzIgOS4zNjAyOCA3LjUgNi44NzUgNy41QzQuMzg5NzIgNy41IDIuMzc1IDkuNTE0NzIgMi4zNzUgMTJDMi4zNzUgMTQuNDg1MyA0LjM4OTcyIDE2LjUgNi44NzUgMTYuNVpNNC44NzQzNiAxMS41QzQuNTk4MjEgMTEuNSA0LjM3NDM2IDExLjcyMzggNC4zNzQzNiAxMkM0LjM3NDM2IDEyLjI3NjEgNC41OTgyMSAxMi41IDQuODc0MzYgMTIuNUg4Ljg3NTYzQzkuMTUxNzggMTIuNSA5LjM3NTYzIDEyLjI3NjEgOS4zNzU2MyAxMkM5LjM3NTYzIDExLjcyMzggOS4xNTE3OCAxMS41IDguODc1NjMgMTEuNUg0Ljg3NDM2WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextCollapseIcon: ProIcon;
export { TextCollapseIcon }
export { TextCollapseIcon as textCollapse }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQuMjUgMTguMzk3QzQuMjUgMTcuNTY4NSA0LjkyMTU3IDE2Ljg5NyA1Ljc1IDE2Ljg5N0gxOC4yNUMxOS4wNzg0IDE2Ljg5NyAxOS43NSAxNy41Njg1IDE5Ljc1IDE4LjM5N1YxOS43NDk5QzE5Ljc1IDIwLjU3ODMgMTkuMDc4NCAyMS4yNDk5IDE4LjI1IDIxLjI0OTlINS43NUM0LjkyMTU3IDIxLjI0OTkgNC4yNSAyMC41NzgzIDQuMjUgMTkuNzQ5OVYxOC4zOTdaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextColorAccentIcon: ProIcon;
export { TextColorAccentIcon }
export { TextColorAccentIcon as textColorAccent }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTUzOTMgMTMuMDg4Mkw4Ljg4NDY2IDkuMTI5NDdNOC44ODQ2NiA5LjEyOTQ3SDE1LjExNTNNOC44ODQ2NiA5LjEyOTQ3TDExLjUzNjYgMy4wNjM1NEMxMS43MTk0IDIuNjQ1NDggMTIuMjgwNiAyLjY0NTQ5IDEyLjQ2MzMgMy4wNjM1NUwxNS4xMTUzIDkuMTI5NDdNMTUuMTE1MyA5LjEyOTQ3TDE2Ljg0NiAxMy4wODgyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHJlY3QgeD0iNC4yNSIgeT0iMTYuODk3IiB3aWR0aD0iMTUuNSIgaGVpZ2h0PSI0LjM1Mjk0IiByeD0iMS41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextColorIcon: ProIcon;
export { TextColorIcon }
export { TextColorIcon as textColor }

/**
 * @description Text edit, Text pencil
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuMjUgMTQuMjUwMkw1LjEyNSA5Ljg0NjYxTTUuMTI1IDkuODQ2NjFIMTEuODc1TTUuMTI1IDkuODQ2NjFMNy45OTgwMiAzLjA5OTAyQzguMTk2MDIgMi42MzM5OCA4LjgwMzk4IDIuNjMzOTggOS4wMDE5OCAzLjA5OTAyTDExLjg3NSA5Ljg0NjYxTTExLjg3NSA5Ljg0NjYxTDEyLjQ0OTUgMTEuMTk1OCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMy4zMzU5IDIwLjY4NTlDMTMuNzk3NCAyMC41ODA1IDE0LjIxOTggMjAuMzQ3MSAxNC41NTQ2IDIwLjAxMjZMMjAuMDA5NCAxNC41NjI5QzIwLjk5NjUgMTMuNTc2OCAyMC45OTY5IDExLjk3NzEgMjAuMDEwNCAxMC45OTA0QzE5LjAyNDEgMTAuMDAzOSAxNy40MjQ4IDEwLjAwMzggMTYuNDM4NCAxMC45OTAyTDEwLjk4NjQgMTYuNDQyMkMxMC42NTA5IDE2Ljc3NzcgMTAuNDE3MSAxNy4yMDEyIDEwLjMxMTggMTcuNjYzOEw5Ljc3NTg2IDIwLjAxODRDOS42MTExOSAyMC43NDE4IDEwLjI1ODggMjEuMzg4OSAxMC45ODIyIDIxLjIyMzdMMTMuMzM1OSAyMC42ODU5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextEditStyleIcon: ProIcon;
export { TextEditStyleIcon }
export { TextEditStyleIcon as textEditStyle }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const TextEffectsIcon: ProIcon;
export { TextEffectsIcon }
export { TextEffectsIcon as textEffects }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuMTI1IDQuNUgyMS42MjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNy4xMjUgMTkuNUgyMS42MjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuMTI1IDkuNUgyMS42MjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuMTI1IDE0LjVIMjEuNjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik02Ljg3NSAxNi41QzkuMzYwMjggMTYuNSAxMS4zNzUgMTQuNDg1MyAxMS4zNzUgMTJDMTEuMzc1IDkuNTE0NzIgOS4zNjAyOCA3LjUgNi44NzUgNy41QzQuMzg5NzIgNy41IDIuMzc1IDkuNTE0NzIgMi4zNzUgMTJDMi4zNzUgMTQuNDg1MyA0LjM4OTcyIDE2LjUgNi44NzUgMTYuNVpNNi44NzQ5NyA5LjQ5OTM2QzcuMTUxMTEgOS40OTkzNiA3LjM3NDk3IDkuNzIzMjEgNy4zNzQ5NyA5Ljk5OTM2VjExLjVIOC44NzU2M0M5LjE1MTc4IDExLjUgOS4zNzU2MyAxMS43MjM4IDkuMzc1NjMgMTJDOS4zNzU2MyAxMi4yNzYxIDkuMTUxNzggMTIuNSA4Ljg3NTYzIDEyLjVINy4zNzQ5N1YxNC4wMDA2QzcuMzc0OTcgMTQuMjc2OCA3LjE1MTExIDE0LjUwMDYgNi44NzQ5NyAxNC41MDA2QzYuNTk4ODMgMTQuNTAwNiA2LjM3NDk3IDE0LjI3NjggNi4zNzQ5NyAxNC4wMDA2VjEyLjVINC44NzQzNkM0LjU5ODIxIDEyLjUgNC4zNzQzNiAxMi4yNzYxIDQuMzc0MzYgMTJDNC4zNzQzNiAxMS43MjM4IDQuNTk4MjEgMTEuNSA0Ljg3NDM2IDExLjVINi4zNzQ5N1Y5Ljk5OTM2QzYuMzc0OTcgOS43MjMyMSA2LjU5ODgzIDkuNDk5MzYgNi44NzQ5NyA5LjQ5OTM2WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextExpandIcon: ProIcon;
export { TextExpandIcon }
export { TextExpandIcon as textExpand }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIwLjA3OTEgMjEuMjUwMUwxNy45NDY3IDE2LjQwNzhNMTcuOTQ2NyAxNi40MDc4SDEwLjI2OTdNMTcuOTQ2NyAxNi40MDc4TDE0LjY3OTEgOC45ODgwMkMxNC40NTM5IDguNDc2NjUgMTMuNzYyNSA4LjQ3NjY1IDEzLjUzNzMgOC45ODgwMkwxMC4yNjk3IDE2LjQwNzhNMTAuMjY5NyAxNi40MDc4TDguMTM3MjYgMjEuMjUwMU02Ljk2Mjg5IDIxLjI1MDFIOS43NzUzNk0xOC40Mzc2IDIxLjI1MDFIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNC40MjI2OSA4LjgxOTIxTDIuNzUgMTIuNTg1NE00LjQyMjY5IDguODE5MjFIMTAuNDQ0NEw3Ljg4MTM2IDMuMDQ4M0M3LjcwNDcyIDIuNjUwNTcgNy4xNjIzNiAyLjY1MDU3IDYuOTg1NzIgMy4wNDgzTDQuNDIyNjkgOC44MTkyMVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextFontIcon: ProIcon;
export { TextFontIcon }
export { TextFontIcon as textFont }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMTcuNzVMNC42MjUgMTMuMzQ2NE00LjYyNSAxMy4zNDY0SDExLjM3NU00LjYyNSAxMy4zNDY0TDcuNDk4MDIgNi41OTg3OEM3LjY5NjAyIDYuMTMzNzQgOC4zMDM5OCA2LjEzMzc0IDguNTAxOTggNi41OTg3OEwxMS4zNzUgMTMuMzQ2NE0xMS4zNzUgMTMuMzQ2NEwxMy4yNSAxNy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMy4yNSAxNy43NUwxNC42Nzg2IDE0LjQ3MjlNMTQuNjc4NiAxNC40NzI5SDE5LjgyMTRNMTQuNjc4NiAxNC40NzI5TDE2Ljg2NzUgOS40NTE0NUMxNy4wMTg0IDkuMTA1MzggMTcuNDgxNiA5LjEwNTM4IDE3LjYzMjUgOS40NTE0NUwxOS44MjE0IDE0LjQ3MjlNMTkuODIxNCAxNC40NzI5TDIxLjI1IDE3Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextFontSizeIcon: ProIcon;
export { TextFontSizeIcon }
export { TextFontSizeIcon as textFontSize }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMTcuMjQ4Mkw0LjE5MDk0IDEzLjg2NE00LjE5MDk0IDEzLjg2NEg5LjM3ODMzTTQuMTkwOTQgMTMuODY0TDYuMzk4ODYgOC42Nzg0NEM2LjU1MTAzIDguMzIxMDUgNy4wMTgyNCA4LjMyMTA1IDcuMTcwNDEgOC42Nzg0NEw5LjM3ODMzIDEzLjg2NE05LjM3ODMzIDEzLjg2NEwxMC44MTkzIDE3LjI0ODIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuMjE2OSA4LjQxMDRWMTcuMjQ4Mk0xOS4wNDk5IDE0LjMzMTdDMTkuMDQ5OSAxNS45NDI0IDE3Ljc0NDIgMTcuMjQ4MiAxNi4xMzM0IDE3LjI0ODJDMTQuNTIyNyAxNy4yNDgyIDEzLjIxNjkgMTUuOTQyNCAxMy4yMTY5IDE0LjMzMTdDMTMuMjE2OSAxMi43MjA5IDE0LjUyMjcgMTEuNDE1MiAxNi4xMzM0IDExLjQxNTJDMTcuNzQ0MiAxMS40MTUyIDE5LjA0OTkgMTIuNzIwOSAxOS4wNDk5IDE0LjMzMTdaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE5LjA1IDYuNjI1TDIxLjI1IDUuMjVWMTAuNzUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextFootnoteIcon: ProIcon;
export { TextFootnoteIcon }
export { TextFootnoteIcon as textFootnote }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik03Ljc1IDMuNzVDNS41NDA4NiAzLjc1IDMuNzUgNS41NDA4NiAzLjc1IDcuNzVWMTYuMjVDMy43NSAxOC40NTkxIDUuNTQwODYgMjAuMjUgNy43NSAyMC4yNUgxNi4yNUMxOC40NTkxIDIwLjI1IDIwLjI1IDE4LjQ1OTEgMjAuMjUgMTYuMjVWNy43NUMyMC4yNSA1LjU0MDg2IDE4LjQ1OTEgMy43NSAxNi4yNSAzLjc1SDcuNzVaTTEwLjczNTcgMTIuMTg2NkwxMiA5LjI5NDc3TDEzLjI2NDMgMTIuMTg2NkgxMC43MzU3Wk0xMC43MzQxIDE0LjY4NjZIMTMuMjY1OUwxNC4xNDY1IDE2LjcwMUMxNC41MzM3IDE3LjU4NjYgMTUuNTY1NCAxNy45OTA2IDE2LjQ1MSAxNy42MDM1QzE3LjMzNjYgMTcuMjE2MyAxNy43NDA2IDE2LjE4NDUgMTcuMzUzNSAxNS4yOTlMMTMuOTYyIDcuNTQxNjFDMTMuMjA5MSA1LjgxOTQ3IDEwLjc5MDkgNS44MTk0NSAxMC4wMzggNy41NDE2MUw2LjY0NjU0IDE1LjI5OUM2LjI1OTM4IDE2LjE4NDUgNi42NjM0MiAxNy4yMTYzIDcuNTQ4OTkgMTcuNjAzNUM4LjQzNDU1IDE3Ljk5MDYgOS40NjYzIDE3LjU4NjYgOS44NTM0NiAxNi43MDFMMTAuNzM0MSAxNC42ODY2Wk0xMy4wNDU4IDcuOTQyMTlMMTYuNDM3MiAxNS42OTk2QzE2LjYwMzEgMTYuMDc5MSAxNi40MyAxNi41MjEzIDE2LjA1MDQgMTYuNjg3MkMxNS42NzA5IDE2Ljg1MzEgMTUuMjI4NyAxNi42OCAxNS4wNjI4IDE2LjMwMDRMMTMuOTIwMSAxMy42ODY2SDEwLjA3OTlMOC45MzcyIDE2LjMwMDRDOC43NzEyNyAxNi42OCA4LjMyOTA5IDE2Ljg1MzEgNy45NDk1NiAxNi42ODcyQzcuNTcwMDQgMTYuNTIxMyA3LjM5Njg4IDE2LjA3OTEgNy41NjI4IDE1LjY5OTZMMTAuOTU0MiA3Ljk0MjE5QzExLjM1NzcgNy4wMTkyNyAxMi42NDIzIDcuMDE5MjcgMTMuMDQ1OCA3Ljk0MjE5WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextHighlightColorAccentIcon: ProIcon;
export { TextHighlightColorAccentIcon }
export { TextHighlightColorAccentIcon as textHighlightColorAccent }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOC4yNSAxNkw5LjU4OTI5IDEyLjkzNjZNOS41ODkyOSAxMi45MzY2SDE0LjQxMDdNOS41ODkyOSAxMi45MzY2TDExLjY0MTQgOC4yNDI2M0MxMS43ODI5IDcuOTE5MTIgMTIuMjE3MSA3LjkxOTEyIDEyLjM1ODYgOC4yNDI2M0wxNC40MTA3IDEyLjkzNjZNMTQuNDEwNyAxMi45MzY2TDE1Ljc1IDE2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextHighlightColorIcon: ProIcon;
export { TextHighlightColorIcon }
export { TextHighlightColorIcon as textHighlightColor }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE5LjI1IDguMzg4ODlMMTguNjMwMyA3LjE1NDI0QzE4LjEyMTMgNi4xNDAxNSAxNy4wODM3IDUuNSAxNS45NDkxIDUuNUg4LjA1MDkyQzYuOTE2MjYgNS41IDUuODc4NjkgNi4xNDAxNSA1LjM2OTcgNy4xNTQyNEw0Ljc1IDguMzg4ODlNMTIgNS41VjE4LjVNMTIgMTguNUgxMC41NU0xMiAxOC41SDEzLjQ1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextIcon: ProIcon;
export { TextIcon }
export { TextIcon as text }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMDAwMTIgMTcuNTAxN0gyMC4wMDAxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTguMDAwMTIgNi40OTgyOUgyMC4wMDAxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTExIDEyLjAwMTdIMjAiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNNS44MTAwNiA5LjE5NDU4TDMuMDAzMDQgMTIuMDAxNkw1LjgxMDA2IDE0LjgwODYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextIndentDecreaseIcon: ProIcon;
export { TextIndentDecreaseIcon }
export { TextIndentDecreaseIcon as textIndentDecrease }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTguMDAwMTIgMTcuNTAxN0gyMC4wMDAxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTguMDAwMTIgNi40OTgyOUgyMC4wMDAxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTExIDEyLjAwMTdIMjAiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNNC4wMDAxMiA5LjE5NDU4TDYuODA3MTQgMTIuMDAxNkw0LjAwMDEyIDE0LjgwODYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextIndentIncreaseIcon: ProIcon;
export { TextIndentIncreaseIcon }
export { TextIndentIncreaseIcon as textIndentIncrease }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuMjUgNC43NUgxOC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik00Ljc1IDE5LjI1SDEzLjc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPHBhdGggZD0iTTkgMTkuMjVMMTQuMjYyNyA0Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextItalicIcon: ProIcon;
export { TextItalicIcon }
export { TextItalicIcon as textItalic }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuNSAxOS4yMDdMNy44MjE0MyAxMy44ODE3TTcuODIxNDMgMTMuODgxN0gxNi4xNzg2TTcuODIxNDMgMTMuODgxN0wxMS4zNzg1IDUuNzIxODNDMTEuNjIzNiA1LjE1OTQ2IDEyLjM3NjQgNS4xNTk0NiAxMi42MjE1IDUuNzIxODNMMTYuMTc4NiAxMy44ODE3TTE2LjE3ODYgMTMuODgxN0wxOC41IDE5LjIwNyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextLargeIcon: ProIcon;
export { TextLargeIcon }
export { TextLargeIcon as textLarge }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNTk5OTggMTYuOTM2Nkw5LjE3MTQgMTMuMTU2TTkuMTcxNCAxMy4xNTZIMTQuODI4NU05LjE3MTQgMTMuMTU2TDExLjU3OTMgNy4zNjI5MkMxMS43NDUyIDYuOTYzNjYgMTIuMjU0NyA2Ljk2MzY2IDEyLjQyMDcgNy4zNjI5MkwxNC44Mjg1IDEzLjE1Nk0xNC44Mjg1IDEzLjE1NkwxNi40IDE2LjkzNjYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjEuMjUgMjAuMjVWMy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDIwLjI1TDIuNzUgMy43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextLetterSpacingIcon: ProIcon;
export { TextLetterSpacingIcon }
export { TextLetterSpacingIcon as textLetterSpacing }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzQ5NjMgMTguMzQ0NUw0Ljc0MjAxIDIwLjM4MjJDNC45NzczNyAyMC42MjI5IDUuMjg4NjggMjAuNzQzMiA1LjYgMjAuNzQzMk04LjQ1MDQxIDE4LjM0NDVMNi40NTgwMyAyMC4zODIyQzYuMjIyNjYgMjAuNjIyOSA1LjkxMTMzIDIwLjc0MzIgNS42IDIwLjc0MzJNMi43NDk3NCA1LjYwOTkyTDQuNzUxNiAzLjYwODA2QzQuOTg1ODggMy4zNzM3OCA1LjI5Mjk0IDMuMjU2NjMgNS42IDMuMjU2NTlNOC40NTA1MiA1LjYwOTkyTDYuNDQ4NjYgMy42MDgwNkM2LjIxNDMxIDMuMzczNzIgNS45MDcxNSAzLjI1NjU2IDUuNiAzLjI1NjU5TTUuNiAyMC43NDMyVjIwLjM4NDZMNS42IDMuNjk3MDhWMy4yNTY1OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS41NTA0IDQuMjVIMjEuMjUwNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS41NTA0IDE5Ljc1SDIxLjI1MDQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuMTE5MSAxNS41OTM4TDE0LjI5MSAxMi44NDE1TTE0LjI5MSAxMi44NDE1SDE4LjUwOThNMTQuMjkxIDEyLjg0MTVMMTYuMDg2NyA4LjYyNDI0QzE2LjIxMDQgOC4zMzM1OSAxNi41OTA0IDguMzMzNTkgMTYuNzE0MSA4LjYyNDI0TDE4LjUwOTggMTIuODQxNU0xOC41MDk4IDEyLjg0MTVMMTkuNjgxNiAxNS41OTM4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextLineHeightIcon: ProIcon;
export { TextLineHeightIcon }
export { TextLineHeightIcon as textLineHeight }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzQ5NjMgMTguMzQ0NUw0Ljc0MjAxIDIwLjM4MjJDNC45NzczNyAyMC42MjI5IDUuMjg4NjggMjAuNzQzMiA1LjYgMjAuNzQzMk04LjQ1MDQxIDE4LjM0NDVMNi40NTgwMyAyMC4zODIyQzYuMjIyNjYgMjAuNjIyOSA1LjkxMTMzIDIwLjc0MzIgNS42IDIwLjc0MzJNMi43NDk3NCA1LjYwOTkyTDQuNzUxNiAzLjYwODA2QzQuOTg1ODggMy4zNzM3OCA1LjI5Mjk0IDMuMjU2NjMgNS42IDMuMjU2NTlNOC40NTA1MiA1LjYwOTkyTDYuNDQ4NjYgMy42MDgwNkM2LjIxNDMxIDMuMzczNzIgNS45MDcxNSAzLjI1NjU2IDUuNiAzLjI1NjU5TTUuNiAzLjI1NjU5VjMuNjk3MDhMNS42IDIwLjM4NDZWMjAuNzQzMiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS41NTA0IDQuMjVIMjEuMjUwNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS41NTA0IDkuNDE5OTJIMjEuMjUwNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS41NTA0IDE0LjU4OThIMjEuMjUwNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMS41NTA0IDE5Ljc2SDE4LjI1MDQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextLineSpacingIcon: ProIcon;
export { TextLineSpacingIcon }
export { TextLineSpacingIcon as textLineSpacing }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTkuNzQ5OTMgNS4yNDY1OEgxOS43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik05Ljc0OTkzIDEySDE5Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkuNzQ5OTMgMTguNzUzNEgxOS43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0zLjY5NDQgNC4xMjMzMUw1LjQ5NDQxIDNWNy40OTMyNCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0zLjI3MTAyIDExLjA3NUMzLjI3MTAyIDEwLjg1NzYgMy4zMjQ2OSAxMC42NDM3IDMuNDI3MyAxMC40NTJDMy41Mjk5IDEwLjI2MDMgMy42NzgyNiAxMC4wOTY5IDMuODU5MjMgOS45NzYxNEM0LjA0MDIxIDkuODU1NCA0LjI0ODIyIDkuNzgxMDggNC40NjQ4MiA5Ljc1OTc4QzQuNjgxNDMgOS43Mzg0OCA0Ljg5OTk2IDkuNzcwODUgNS4xMDEwNSA5Ljg1NDAxQzUuMzAyMTQgOS45MzcxOCA1LjQ3OTU4IDEwLjA2ODYgNS42MTc2NiAxMC4yMzY2QzUuNzU1NzQgMTAuNDA0NiA1Ljg1MDIgMTAuNjA0IDUuODkyNjYgMTAuODE3MUM1LjkzNTEyIDExLjAzMDMgNS45MjQyOCAxMS4yNTA2IDUuODYxMSAxMS40NTg2QzUuNzk3OTIgMTEuNjY2NiA1LjY4NDM0IDExLjg1NTggNS41MzA0NCAxMi4wMDk0TDMuNTM1NzIgMTMuOTgyM1YxNC4yNDY3SDUuODYxMSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0zLjU5NDc1IDE2LjUwNjhINS45MzkwNEwzLjgzNjA3IDE4LjQzNDVINC44NzI5N0M1LjQ2MTc0IDE4LjQzNDUgNS45MzkwNCAxOC45MTExIDUuOTM5MDQgMTkuNDk5QzUuOTM5MDQgMjAuMDg2OSA1Ljc2NjY2IDIwLjc0MDggNC42OTc5NCAyMC45ODE4QzQuMTEwNjggMjEuMTE0MiAzLjI1IDIwLjQ5OTkgMy4yNSAyMC4wMTgiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextNumberListIcon: ProIcon;
export { TextNumberListIcon }
export { TextNumberListIcon as textNumberList }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIuNzVWMTUuNzUxNlYxNi4xMjg2TTUuNzEyODkgMTAuNDYyOUwxMC45MzkzIDE1LjY4OTNDMTEuMjMyMiAxNS45ODIyIDExLjYxNjEgMTYuMTI4NiAxMiAxNi4xMjg2TTE4LjI4NyAxMC40NjI5TDEzLjA2MDYgMTUuNjg5M0MxMi43Njc3IDE1Ljk4MjIgMTIuMzgzOSAxNi4xMjg2IDEyIDE2LjEyODYiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAyMS4yNUgyMS4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TextPositionBottomIcon: ProIcon;
export { TextPositionBottomIcon }
export { TextPositionBottomIcon as textPositionBottom }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIuNzVWOC43ODY1VjguODM1NzdNOS4wODA5OSA2LjMzMDk4TDExLjI5MjkgOC41NDI4OEMxMS40ODgyIDguNzM4MTUgMTEuNzQ0MSA4LjgzNTc4IDEyIDguODM1NzdNMTQuOTE5IDYuMzMwOThMMTIuNzA3MSA4LjU0Mjg4QzEyLjUxMTggOC43MzgxNCAxMi4yNTU5IDguODM1NzcgMTIgOC44MzU3NyIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xMiAyMS4yNTAxVjE1LjIxMzZWMTUuMTY0M005LjA4MDk5IDE3LjY2OTFMMTEuMjkyOSAxNS40NTcyQzExLjQ4ODIgMTUuMjYxOSAxMS43NDQxIDE1LjE2NDMgMTIgMTUuMTY0M00xNC45MTkgMTcuNjY5MUwxMi43MDcxIDE1LjQ1NzJDMTIuNTExOCAxNS4yNjE5IDEyLjI1NTkgMTUuMTY0MyAxMiAxNS4xNjQzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTJIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextPositionMiddleIcon: ProIcon;
export { TextPositionMiddleIcon }
export { TextPositionMiddleIcon as textPositionMiddle }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyIDIxLjI1VjguMjQ4MzNWNy44NzEzNE01LjcxMjg5IDEzLjUzNzFMMTAuOTM5MyA4LjMxMDY4QzExLjIzMjIgOC4wMTc3NyAxMS42MTYxIDcuODcxMzMgMTIgNy44NzEzNE0xOC4yODcgMTMuNTM3MUwxMy4wNjA2IDguMzEwNjhDMTIuNzY3NyA4LjAxNzggMTIuMzgzOSA3Ljg3MTM1IDEyIDcuODcxMzQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMi43NSAyLjc1SDIxLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextPositionTopIcon: ProIcon;
export { TextPositionTopIcon }
export { TextPositionTopIcon as textPositionTop }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuNSAxOC4xMzc2TDguNDY0MjkgMTMuNjMxNU04LjQ2NDI5IDEzLjYzMTVIMTUuNTM1N004LjQ2NDI5IDEzLjYzMTVMMTEuNDc0MSA2LjcyNzAxQzExLjY4MTUgNi4yNTExNSAxMi4zMTg1IDYuMjUxMTUgMTIuNTI1OSA2LjcyNzAxTDE1LjUzNTcgMTMuNjMxNU0xNS41MzU3IDEzLjYzMTVMMTcuNSAxOC4xMzc2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextSmallIcon: ProIcon;
export { TextSmallIcon }
export { TextSmallIcon as textSmall }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE3LjA1ODkgOC4xMTM0OUMxNy4wNTg5IDguMTEzNDkgMTYuMzQ5MSA0Ljc1IDExLjE5NzggNC43NUM5LjI3NDg5IDQuNzUgNi43Nzc0IDYuMzUxMzkgNi43Nzc0IDguNTg3NjRDNi43Nzc0IDkuMDgwOSA2Ljg2NTQ2IDkuNTA4MDEgNy4wMzY5NCA5Ljg4QzcuMTY1ODIgMTAuMTU5NiA3LjM0MTgzIDEwLjQwOCA3LjU2MzAxIDEwLjYzTTcuMDM2OTQgMTYuOTk1QzcuMDM2OTQgMTYuOTk1IDguMzgxODQgMjAgMTIuMzYzNSAyMEMxNC41ODA1IDIwIDE3LjIyMjYgMTguOTIyNCAxNy4yMjI2IDE2LjQ1NjNDMTcuMjIyNiAxNC44ODQ4IDE2LjMwNTUgMTMuODI2NiAxNC44MTUgMTMuMTI1TTQuNzUgMTMuMTI1SDE0LjgxNU0xOS4yNSAxMy4xMjVIMTQuODE1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextStrikethroughIcon: ProIcon;
export { TextStrikethroughIcon }
export { TextStrikethroughIcon as textStrikethrough }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNSAxOS4yNUwxNS41IDQuNzVNMy41IDQuNzVMMTIuMDg2MSAxNS4xMjQ5TDE0LjEyNjIgMTcuNTkiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuMTc2NSAxNS42NjE4QzE2LjE3NjUgMTUuMzQ3NCAxNi4yNTQgMTUuMDM3OCAxNi40MDIyIDE0Ljc2MDZDMTYuNTUwNCAxNC40ODMzIDE2Ljc2NDcgMTQuMjQ2OSAxNy4wMjYxIDE0LjA3MjJDMTcuMjg3NSAxMy44OTc1IDE3LjU4OCAxMy43OSAxNy45MDA4IDEzLjc1OTJDMTguMjEzNyAxMy43Mjg0IDE4LjUyOTQgMTMuNzc1MiAxOC44MTk4IDEzLjg5NTVDMTkuMTEwMyAxNC4wMTU4IDE5LjM2NjYgMTQuMjA1OSAxOS41NjYgMTQuNDQ5QzE5Ljc2NTUgMTQuNjkyIDE5LjkwMTkgMTQuOTgwNCAxOS45NjMzIDE1LjI4ODhDMjAuMDI0NiAxNS41OTcxIDIwLjAwODkgMTUuOTE1OSAxOS45MTc3IDE2LjIxNjdDMTkuODI2NCAxNi41MTc2IDE5LjY2MjQgMTYuNzkxMyAxOS40NDAxIDE3LjAxMzZMMTYuNTU4OCAxOS44Njc2VjIwLjI1SDE5LjkxNzciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextSubscriptIcon: ProIcon;
export { TextSubscriptIcon }
export { TextSubscriptIcon as textSubscript }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQgNC43NUwxNiAxOS4yNU00IDE5LjI1TDE0LjYyNjIgNi40MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNi42NzY1IDQuNjYxNzZDMTYuNjc2NSA0LjM0NzM3IDE2Ljc1NCA0LjAzNzgzIDE2LjkwMjIgMy43NjA1N0MxNy4wNTA0IDMuNDgzMyAxNy4yNjQ3IDMuMjQ2ODYgMTcuNTI2MSAzLjA3MjE5QzE3Ljc4NzUgMi44OTc1MiAxOC4wODggMi43OTAwMiAxOC40MDA4IDIuNzU5MjFDMTguNzEzNyAyLjcyODM5IDE5LjAyOTQgMi43NzUyMSAxOS4zMTk4IDIuODk1NTJDMTkuNjEwMyAzLjAxNTg0IDE5Ljg2NjYgMy4yMDU5MyAyMC4wNjYgMy40NDg5NUMyMC4yNjU1IDMuNjkxOTggMjAuNDAxOSAzLjk4MDQ1IDIwLjQ2MzMgNC4yODg4QzIwLjUyNDYgNC41OTcxNSAyMC41MDg5IDQuOTE1ODcgMjAuNDE3NyA1LjIxNjcyQzIwLjMyNjQgNS41MTc1NyAyMC4xNjI0IDUuNzkxMjggMTkuOTQwMSA2LjAxMzU5TDE3LjA1ODggOC44Njc2NVY5LjI1SDIwLjQxNzciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TextSuperscriptIcon: ProIcon;
export { TextSuperscriptIcon }
export { TextSuperscriptIcon as textSuperscript }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuMjUgMTguMjVMNC4xMjUgMTMuODQ2NE00LjEyNSAxMy44NDY0SDEwLjg3NU00LjEyNSAxMy44NDY0TDYuOTk4MDIgNy4wOTg3OEM3LjE5NjAyIDYuNjMzNzQgNy44MDM5OCA2LjYzMzc0IDguMDAxOTggNy4wOTg3OEwxMC44NzUgMTMuODQ2NE0xMC44NzUgMTMuODQ2NEwxMi43NSAxOC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yMS43NSAxMy4zMDI3TDIxLjY4IDEzLjI4OTFDMTguNzk5MSAxMi43MzE1IDE1LjM3MjIgMTIuODE3IDE1LjM3MjIgMTUuNzUxM0MxNS4zNzIyIDE2LjU3NDUgMTUuODM2MiAxNy4zNDg2IDE2LjUxMTkgMTcuNzcwMkMxNy4xODIxIDE4LjE4ODQgMTguMDI3MyAxOC4xOTk5IDE4LjgxNzMgMTguMTk5OUMxOS45MDMxIDE4LjE5OTkgMjEuMDk0MiAxNy41NzM1IDIxLjU3MDcgMTYuNTk3OUMyMS42NjE1IDE2LjQxMTkgMjEuNzIzNCAxNi4yMDA3IDIxLjc1IDE1Ljk2NDhWMTQuODQwMk0yMS43NSAxMy4zMDI3VjEyLjcxNjJDMjEuNzUgMTEuOTgyIDIxLjY2NDggMTEuMDEyNCAyMS4yMzI5IDEwLjQxODdDMjAuNzYzMyA5Ljc3MzAzIDE5LjkzMDEgOS4wNDQ0MyAxOC41NjExIDkuMDQ0NDNDMTYuMyA5LjA0NDQzIDE1LjU3IDEwLjYzODkgMTUuNTcgMTAuNjM4OU0yMS43NSAxMy4zMDI3VjE0Ljg0MDJNMjEuNzUgMTguMTAwMlYxNC44NDAyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextTypographyIcon: ProIcon;
export { TextTypographyIcon }
export { TextTypographyIcon as textTypography }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTYuNSA0Ljc1VjExLjI1QzYuNSAxNC4yODc2IDguOTYyNDMgMTYuNzUgMTIgMTYuNzVWMTYuNzVDMTUuMDM3NiAxNi43NSAxNy41IDE0LjI4NzYgMTcuNSAxMS4yNVY0Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTYuNSAxOS43NUgxNy41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const TextUnderlineIcon: ProIcon;
export { TextUnderlineIcon }
export { TextUnderlineIcon as textUnderline }

/**
 * @description Dislike
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const ThumbsDownIcon: ProIcon;
export { ThumbsDownIcon }
export { ThumbsDownIcon as thumbsDown }

/**
 * @description Like
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy4yNSIgeT0iNy4yMDA5MyIgd2lkdGg9IjQuMiIgaGVpZ2h0PSIxMy4yOTU3IiByeD0iMS41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTcuNDQ5OTUgMTIuNTUyNkg2LjY5OTk1QzYuNjk5OTUgMTIuOTY2OCA3LjAzNTc0IDEzLjMwMjYgNy40NDk5NSAxMy4zMDI2VjEyLjU1MjZaTTcuNDQ5OTUgOS41MjU1M0w2LjgyMzQgOS4xMTMzQzYuNzQyODcgOS4yMzU3IDYuNjk5OTUgOS4zNzkwMSA2LjY5OTk1IDkuNTI1NTNINy40NDk5NVpNNy40NDk5NyAxMi41NTI2SDguMTk5OTdDOC4xOTk5NyAxMi4xMzg0IDcuODY0MTkgMTEuODAyNiA3LjQ0OTk3IDExLjgwMjZWMTIuNTUyNlpNMTkuNzM1NCAxOC42NTM3TDE5LjAxMTcgMTguNDU2NkwxOS43MzU0IDE4LjY1MzdaTTIxLjY5MzQgMTEuNDY2TDIwLjk2OTcgMTEuMjY4OFYxMS4yNjg4TDIxLjY5MzQgMTEuNDY2Wk0xNS4xODYzIDguMzA4ODhIMTQuNDM2M0MxNC40MzYzIDguNzIzMDkgMTQuNzcyIDkuMDU4ODggMTUuMTg2MyA5LjA1ODg4VjguMzA4ODhaTTExLjQ3OTcgMy40MDA3MkwxMi4xMDYyIDMuODEyOTVMMTIuMTA2MiAzLjgxMjk1TDExLjQ3OTcgMy40MDA3MlpNOC4xOTk5NSAxMi41NTI2VjkuNTI1NTNINi42OTk5NVYxMi41NTI2SDguMTk5OTVaTTcuNDQ5OTcgMTEuODAyNkg3LjQ0OTk1VjEzLjMwMjZINy40NDk5N1YxMS44MDI2Wk04LjE5OTk3IDE3LjQ5NjZWMTIuNTUyNkg2LjY5OTk3VjE3LjQ5NjZIOC4xOTk5N1pNMTAuNDUgMTkuNzQ2NkM5LjIwNzMzIDE5Ljc0NjYgOC4xOTk5NyAxOC43MzkzIDguMTk5OTcgMTcuNDk2Nkg2LjY5OTk3QzYuNjk5OTcgMTkuNTY3NyA4LjM3ODkgMjEuMjQ2NiAxMC40NSAyMS4yNDY2VjE5Ljc0NjZaTTE3LjMyMzMgMTkuNzQ2NkgxMC40NVYyMS4yNDY2SDE3LjMyMzNWMTkuNzQ2NlpNMTkuMDExNyAxOC40NTY2QzE4LjgwNDMgMTkuMjE4MiAxOC4xMTI2IDE5Ljc0NjYgMTcuMzIzMyAxOS43NDY2VjIxLjI0NjZDMTguNzg5MiAyMS4yNDY2IDIwLjA3MzcgMjAuMjY1MiAyMC40NTkgMTguODUwOEwxOS4wMTE3IDE4LjQ1NjZaTTIwLjk2OTcgMTEuMjY4OEwxOS4wMTE3IDE4LjQ1NjZMMjAuNDU5IDE4Ljg1MDhMMjIuNDE3IDExLjY2MzFMMjAuOTY5NyAxMS4yNjg4Wk0xOS4yODEyIDkuMDU4ODhDMjAuNDM0OSA5LjA1ODg4IDIxLjI3MjkgMTAuMTU1NyAyMC45Njk3IDExLjI2ODhMMjIuNDE3IDExLjY2MzFDMjIuOTgwMSA5LjU5NTg0IDIxLjQyMzggNy41NTg4OCAxOS4yODEyIDcuNTU4ODhWOS4wNTg4OFpNMTUuMTg2MyA5LjA1ODg4SDE5LjI4MTJWNy41NTg4OEgxNS4xODYzVjkuMDU4ODhaTTE0LjQzNjMgNy4wODc0VjguMzA4ODhIMTUuOTM2M1Y3LjA4NzRIMTQuNDM2M1pNMTQuNDM2MyA3LjA4NjlWNy4wODc0SDE1LjkzNjNWNy4wODY5SDE0LjQzNjNaTTE0LjQzNjMgNC41VjcuMDg2OUgxNS45MzYzVjQuNUgxNC40MzYzWk0xMy4xODYzIDMuMjVDMTMuODc2NiAzLjI1IDE0LjQzNjMgMy44MDk2NCAxNC40MzYzIDQuNUgxNS45MzYzQzE1LjkzNjMgMi45ODEyMiAxNC43MDUgMS43NSAxMy4xODYzIDEuNzVWMy4yNVpNMTMuMTUwNSAzLjI1SDEzLjE4NjNWMS43NUgxMy4xNTA1VjMuMjVaTTEyLjEwNjIgMy44MTI5NUMxMi4zMzc0IDMuNDYxNTUgMTIuNzI5OCAzLjI1IDEzLjE1MDUgMy4yNVYxLjc1QzEyLjIyNTEgMS43NSAxMS4zNjE4IDIuMjE1NDIgMTAuODUzMSAyLjk4ODQ5TDEyLjEwNjIgMy44MTI5NVpNOC4wNzY1IDkuOTM3NzZMMTIuMTA2MiAzLjgxMjk1TDEwLjg1MzEgMi45ODg0OUw2LjgyMzQgOS4xMTMzTDguMDc2NSA5LjkzNzc2WiIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ThumbsUpIcon: ProIcon;
export { ThumbsUpIcon }
export { ThumbsUpIcon as thumbsUp }

/**
 * @description ByteDance, Now, Shorts, Social, Videos
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.8.0
 */
declare const TiktokIcon: ProIcon;
export { TiktokIcon }
export { TiktokIcon as tiktok }

/**
 * @description Stopwatch
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjAyMTcgOC44NjIyQzE2LjYxMjEgNy4wMTIyOCAxNC4zODU4IDUuODE4MzQgMTEuODgwNiA1LjgxODM0QzcuNjE5MjMgNS44MTgzNCA0LjE2NDczIDkuMjcyODQgNC4xNjQ3MyAxMy41MzQyQzQuMTY0NzMgMTcuNzk1NSA3LjYxOTIzIDIxLjI1IDExLjg4MDYgMjEuMjVDMTYuMTQxOSAyMS4yNSAxOS41OTY0IDE3Ljc5NTUgMTkuNTk2NCAxMy41MzQyQzE5LjU5NjQgMTEuNzc4MSAxOS4wMDk3IDEwLjE1OSAxOC4wMjE3IDguODYyMlpNMTguMDIxNyA4Ljg2MjJDMTguMDIxNyA4Ljg2MjIgMTkuMTI3IDcuNzU2ODYgMTkuODM1MiA3LjA0ODYyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkuMjgwOTQgMi43NUgxNC40ODAyIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTExLjg4MDYgOS45NjUyMUwxMS44ODA2IDEzLjUzNDIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TimerIcon: ProIcon;
export { TimerIcon }
export { TimerIcon as timer }

/**
 * @description Suitcase, Work
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgOS45OTk5OUMyLjc1IDguMzQzMTMgNC4wOTMxNSA2Ljk5OTk4IDUuNzUgNi45OTk5OEgxOC4yNUMxOS45MDY5IDYuOTk5OTggMjEuMjUgOC4zNDMxMyAyMS4yNSA5Ljk5OTk4VjEzLjIxNDlWMTcuNUMyMS4yNSAxOS4xNTY4IDE5LjkwNjkgMjAuNSAxOC4yNSAyMC41SDUuNzVDNC4wOTMxNSAyMC41IDIuNzUgMTkuMTU2OCAyLjc1IDE3LjVWMTMuMjE0OVY5Ljk5OTk5WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04IDUuNUM4IDQuMzk1NDMgOC44OTU0MyAzLjUgMTAgMy41SDE0QzE1LjEwNDYgMy41IDE2IDQuMzk1NDMgMTYgNS41VjdIOFY1LjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTguNSAxMUw4LjUgMTQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTUuNSAxMUwxNS41IDE0IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTIuNzUgMTIuNUwyMS4yNSAxMi41IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const ToolboxIcon: ProIcon;
export { ToolboxIcon }
export { ToolboxIcon as toolbox }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuNzMyMjUgMjAuNUMzLjQ0MjI1IDIwLjUgMi4wMDkyNiAxOC4wMDE5IDMuMTUwNzYgMTUuOTk5N0w5LjQxODUxIDUuMDA2MjJDMTAuNTYzNSAyLjk5NzkzIDEzLjQzNjUgMi45OTc5MyAxNC41ODE1IDUuMDA2MjJMMjAuODQ5MiAxNS45OTk3QzIxLjk5MDcgMTguMDAxOSAyMC41NTc3IDIwLjUgMTguMjY3NyAyMC41SDUuNzMyMjVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const TriangleIcon: ProIcon;
export { TriangleIcon }
export { TriangleIcon as triangle }

/**
 * @description Customize, Sliders, Controls, Settings, Options, Customise
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgMTJIMTMuMjVNMTMuMjUgMTJDMTMuMjUgMTMuMzgwNyAxNC4zNjkzIDE0LjUgMTUuNzUgMTQuNUMxNy4xMzA3IDE0LjUgMTguMjUgMTMuMzgwNyAxOC4yNSAxMk0xMy4yNSAxMkMxMy4yNSAxMC42MTkzIDE0LjM2OTMgOS41IDE1Ljc1IDkuNUMxNy4xMzA3IDkuNSAxOC4yNSAxMC42MTkzIDE4LjI1IDEyTTE4LjI1IDEySDIxLjI1TTcuNzUgNS4yNUgyMS4yNU03Ljc1IDUuMjVDNy43NSA2LjYzMDcxIDYuNjMwNzEgNy43NSA1LjI1IDcuNzVDMy44NjkyOSA3Ljc1IDIuNzUgNi42MzA3MSAyLjc1IDUuMjVDMi43NSAzLjg2OTI5IDMuODY5MjkgMi43NSA1LjI1IDIuNzVDNi42MzA3MSAyLjc1IDcuNzUgMy44NjkyOSA3Ljc1IDUuMjVaTTIuNzUgMTguNzVINS43NU01Ljc1IDE4Ljc1QzUuNzUgMjAuMTMwNyA2Ljg2OTI5IDIxLjI1IDguMjUgMjEuMjVDOS42MzA3MSAyMS4yNSAxMC43NSAyMC4xMzA3IDEwLjc1IDE4Ljc1TTUuNzUgMTguNzVDNS43NSAxNy4zNjkzIDYuODY5MjkgMTYuMjUgOC4yNSAxNi4yNUM5LjYzMDcxIDE2LjI1IDEwLjc1IDE3LjM2OTMgMTAuNzUgMTguNzVNMTAuNzUgMTguNzVIMjEuMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TuneIcon: ProIcon;
export { TuneIcon }
export { TuneIcon as tune }

/**
 * @description Television
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNCIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTMiIHJ4PSIzIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTcgMjBIMTciIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const TvIcon: ProIcon;
export { TvIcon }
export { TvIcon as tv }

/**
 * @description Programming, Web, TS, Microsoft
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy43NSIgeT0iMy43NSIgd2lkdGg9IjE2LjUiIGhlaWdodD0iMTYuNSIgcng9IjIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTcuMjUgMTEuMjVIMTUuMjVDMTQuNjk3NyAxMS4yNSAxNC4yNSAxMS42OTc3IDE0LjI1IDEyLjI1VjEzLjI1QzE0LjI1IDEzLjgwMjMgMTQuNjk3NyAxNC4yNSAxNS4yNSAxNC4yNUgxNi4yNUMxNi44MDIzIDE0LjI1IDE3LjI1IDE0LjY5NzcgMTcuMjUgMTUuMjVWMTYuMjVDMTcuMjUgMTYuODAyMyAxNi44MDIzIDE3LjI1IDE2LjI1IDE3LjI1SDE0LjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkuNSAxMS4yNVYxNy4yNU03LjUgMTEuMjVIMTEuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.11.0
 */
declare const TypescriptIcon: ProIcon;
export { TypescriptIcon }
export { TypescriptIcon as typescript }

/**
 * @description Canonical, Linux, Mark Shuttleworth, Open Source
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTIuNzUiIGN5PSIxMi4wMDAxIiByPSI0Ljc1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxwYXRoIGQ9Ik0xNC41NDU5IDIwLjA1NEMxMy45Njc4IDIwLjE4MjQgMTMuMzY2OCAyMC4yNTAxIDEyLjc1IDIwLjI1MDFDOS4wNTQ4IDIwLjI1MDEgNS45MjY5OSAxNy44MjA2IDQuODc2NzEgMTQuNDcxOU0xOC44MjYgMTcuNTgwOUMyMC4xNzU5IDE2LjExMiAyMSAxNC4xNTIzIDIxIDEyLjAwMDFDMjEgOS44NDc5MSAyMC4xNzU5IDcuODg4MjMgMTguODI2MSA2LjQxOTM1TTE0LjU0NiAzLjk0NjExQzEzLjk2NzggMy44MTc3NSAxMy4zNjY4IDMuNzUwMDYgMTIuNzUgMy43NTAwNkM5LjA1NDggMy43NTAwNiA1LjkyNjk5IDYuMTc5NDkgNC44NzY3MSA5LjUyODI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjYyNTEgMTYuOTc5NkMxNi44MjA4IDE2LjI4OTIgMTguMzQ5OCAxNi42OTg5IDE5LjA0MDEgMTcuODk0NkMxOS43MzA1IDE5LjA5MDQgMTkuMzIwOCAyMC42MTk0IDE4LjEyNTEgMjEuMzA5N0MxNi45MjkzIDIyLjAwMDEgMTUuNDAwMyAyMS41OTA0IDE0LjcxIDIwLjM5NDZDMTQuMDE5NiAxOS4xOTg5IDE0LjQyOTMgMTcuNjY5OSAxNS42MjUxIDE2Ljk3OTZaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxwYXRoIGQ9Ik00LjUgOS41MDAwNkM1Ljg4MDcxIDkuNTAwMDYgNyAxMC42MTkzIDcgMTIuMDAwMUM3IDEzLjM4MDggNS44ODA3MSAxNC41MDAxIDQuNSAxNC41MDAxQzMuMTE5MjkgMTQuNTAwMSAyIDEzLjM4MDggMiAxMi4wMDAxQzIgMTAuNjE5MyAzLjExOTI5IDkuNTAwMDYgNC41IDkuNTAwMDZaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+CjxwYXRoIGQ9Ik0xNS42MjQ5IDIuNjkwMjdDMTYuODIwNyAxLjk5OTkyIDE4LjM0OTYgMi40MDk2MSAxOS4wNCAzLjYwNTM0QzE5LjczMDMgNC44MDEwNyAxOS4zMjA3IDYuMzMwMDQgMTguMTI0OSA3LjAyMDRDMTYuOTI5MiA3LjcxMDc2IDE1LjQwMDIgNy4zMDEwNyAxNC43MDk5IDYuMTA1MzRDMTQuMDE5NSA0LjkwOTYxIDE0LjQyOTIgMy4zODA2MyAxNS42MjQ5IDIuNjkwMjdaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+Cjwvc3ZnPg==)
 * @added v4.10.0
 */
declare const UbuntuIcon: ProIcon;
export { UbuntuIcon }
export { UbuntuIcon as ubuntu }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgMTEuNzVDMy43NSAxMC42NDU0IDQuNjQ1NDMgOS43NSA1Ljc1IDkuNzVIMTguMjVDMTkuMzU0NiA5Ljc1IDIwLjI1IDEwLjY0NTQgMjAuMjUgMTEuNzVWMTcuNzVIMy43NVYxMS43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8Y2lyY2xlIGN4PSI3IiBjeT0iMTMiIHI9IjEiIGZpbGw9IiNmZmZmZmYiLz4KPGNpcmNsZSBjeD0iMTciIGN5PSIxMyIgcj0iMSIgZmlsbD0iI2ZmZmZmZiIvPgo8cGF0aCBkPSJNMTAgMTQuNzVIMTQiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNi4yNzEyNyA1LjU2NjUxQzYuNTU4NjggNC43NzYxMyA3LjMwOTg0IDQuMjUgOC4xNTA4NSA0LjI1SDE1Ljg0OTFDMTYuNjkwMiA0LjI1IDE3LjQ0MTMgNC43NzYxNCAxNy43Mjg3IDUuNTY2NTFMMTkuMjUgOS43NUg0Ljc1TDYuMjcxMjcgNS41NjY1MVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy43NSAxNy43NUg3LjE4NzVWMTkuNDVDNy4xODc1IDIwLjE2OCA2LjYwNTQ3IDIwLjc1IDUuODg3NSAyMC43NUg1LjA1QzQuMzMyMDMgMjAuNzUgMy43NSAyMC4xNjggMy43NSAxOS40NVYxNy43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuODEyNSAxNy43NUgyMC4yNVYxOS40NUMyMC4yNSAyMC4xNjggMTkuNjY4IDIwLjc1IDE4Ljk1IDIwLjc1SDE4LjExMjVDMTcuMzk0NSAyMC43NSAxNi44MTI1IDIwLjE2OCAxNi44MTI1IDE5LjQ1VjE3Ljc1WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const VehicleCarIcon: ProIcon;
export { VehicleCarIcon }
export { VehicleCarIcon as vehicleCar }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNC4yNSIgd2lkdGg9IjE4LjUiIGhlaWdodD0iMTUuNSIgcng9IjMuNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04LjgzMDAyIDEzLjI5MDVDOC44MzAwMiAxNC4zODc3IDguODMwMDIgMTQuOTM2NCA5LjA2MDQ4IDE1LjI1MzlDOS4yNjE1IDE1LjUzMDkgOS41NzA1MyAxNS43MDk3IDkuOTEwODYgMTUuNzQ1OUMxMC4zMDEgMTUuNzg3NCAxMC43NzY2IDE1LjUxMzkgMTEuNzI3OSAxNC45NjdMMTMuOTcyMiAxMy42NzY1QzE0LjkyODQgMTMuMTI2NiAxNS40MDY2IDEyLjg1MTcgMTUuNTY2OSAxMi40OTI0QzE1LjcwNjYgMTIuMTc5IDE1LjcwNjYgMTEuODIxIDE1LjU2NjkgMTEuNTA3NkMxNS40MDY2IDExLjE0ODMgMTQuOTI4NCAxMC44NzM0IDEzLjk3MjIgMTAuMzIzNUwxMS43Mjc5IDkuMDMzMDVDMTAuNzc2NiA4LjQ4NjA5IDEwLjMwMSA4LjIxMjYyIDkuOTEwODYgOC4yNTQxMUM5LjU3MDUzIDguMjkwMzEgOS4yNjE1IDguNDY5MDkgOS4wNjA0OCA4Ljc0NjA4QzguODMwMDIgOS4wNjM2MyA4LjgzMDAyIDkuNjEyMjYgOC44MzAwMiAxMC43MDk1VjEzLjI5MDVaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41Ii8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const VideoClipIcon: ProIcon;
export { VideoClipIcon }
export { VideoClipIcon as videoClip }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMi43NSIgeT0iNiIgd2lkdGg9IjEzLjUiIGhlaWdodD0iMTIiIHJ4PSIzLjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuMjUgOS43NEwxOS44MDQyIDcuOTdDMjAuNDY5IDcuNjM4OTIgMjEuMjUgOC4xMjI0NiAyMS4yNSA4Ljg2NTE0VjE1LjEzMzRDMjEuMjUgMTUuODc2NCAyMC40Njg0IDE2LjM2IDE5LjgwMzUgMTYuMDI4MkwxNi4yNSAxNC4yNTVWOS43NFoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const VideoIcon: ProIcon;
export { VideoIcon }
export { VideoIcon as video }

/**
 * @description VSCode, VS Code, IDE, Text Editor, Microsoft
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE1LjY5NTQgMTYuMzE3OUwxMC4zMzMyIDEyTTE1LjY5NTQgMTYuMzE3OVY3LjY4MjA5TTE1LjY5NTQgMTYuMzE3OVYxOC40OTc1QzE1LjY5NTQgMTkuMTc3OSAxNS40MjUyIDE5LjgzMDQgMTQuOTQ0MSAyMC4zMTE0VjIwLjMxMTRNMTAuMzMzMiAxMkwxNS42OTU0IDcuNjgyMDlNMTAuMzMzMiAxMkw3LjgyODA1IDkuOTgyNzZNMTUuNjk1NCA3LjY4MjA5VjUuNTAyNDJDMTUuNjk1NCA0LjgyMjA4IDE1LjQyNTIgNC4xNjk2IDE0Ljk0NDEgMy42ODg1MlYzLjY4ODUyTTcuODI4MDUgMTQuMDE3Mkw0LjMxMjM2IDE2Ljg0ODJDNC4wNjk3OSAxNy4wNDM1IDMuNzE4OTMgMTcuMDI0MyAzLjQ5OTEzIDE2LjgwMzZMMi40Mjc1MSAxNS43Mjc5QzIuMTgyMDYgMTUuNDgxNSAyLjE5MjUxIDE1LjA3OTkgMi40NTA0NCAxNC44NDY2TDUuNTk3NzcgMTJNNy44MjgwNSAxNC4wMTcyTDE0LjI4NDUgMTkuODU2OEMxNC40ODYzIDIwLjAzOTQgMTQuNzA4NCAyMC4xOTEzIDE0Ljk0NDEgMjAuMzExNE03LjgyODA1IDE0LjAxNzJMNS41OTc3NyAxMk01LjU5Nzc3IDEyTDIuNDUwNDQgOS4xNTMzMkMyLjE5MjUxIDguOTIwMDIgMi4xODIwNiA4LjUxODQ0IDIuNDI3NTEgOC4yNzIwNEwzLjQ5OTEzIDcuMTk2MzJDMy43MTg5MyA2Ljk3NTY4IDQuMDY5NzkgNi45NTY0OCA0LjMxMjM2IDcuMTUxOEw3LjgyODA1IDkuOTgyNzZNNy44MjgwNSA5Ljk4Mjc2TDE0LjI4NDUgNC4xNDMxNUMxNC40ODYzIDMuOTYwNTUgMTQuNzA4NCAzLjgwODYxIDE0Ljk0NDEgMy42ODg1Mk0xNC45NDQxIDIwLjMxMTRDMTUuMTgyOSAyMC40MzMyIDE1LjQzNTcgMjAuNTIyMiAxNS42OTU0IDIwLjU3NzJDMTYuMjc1MSAyMC43IDE2Ljg4OTQgMjAuNjUzNiAxNy40NjA5IDIwLjQyNDFMMTkuNzk1IDE5LjQ4NjlDMjAuMzcxOSAxOS4yNTUyIDIwLjc1IDE4LjY5NiAyMC43NSAxOC4wNzQzVjUuOTI1NjFDMjAuNzUgNS4zMDM5MiAyMC4zNzE5IDQuNzQ0NzEgMTkuNzk1IDQuNTEzMDZMMTcuNDYwOSAzLjU3NTg2QzE2Ljg4OTQgMy4zNDYzOCAxNi4yNzUxIDMuMjk5OTUgMTUuNjk1NCAzLjQyMjc3QzE1LjQzNTcgMy40Nzc3OSAxNS4xODMgMy41NjY3OSAxNC45NDQxIDMuNjg4NTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const VisualStudioCodeIcon: ProIcon;
export { VisualStudioCodeIcon }
export { VisualStudioCodeIcon as visualStudioCode }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjI1MjcgMTkuNDAwOEw3Ljk5MDg4IDE1Ljc4MTNDNy44MTAxMiAxNS42Mjc3IDcuNTgwNjkgMTUuNTQzNSA3LjM0MzUzIDE1LjU0MzVINC43NUMzLjY0NTQzIDE1LjU0MzUgMi43NSAxNC42NDggMi43NSAxMy41NDM1VjEwLjQ1NjVDMi43NSA5LjM1MTkyIDMuNjQ1NDMgOC40NTY0OCA0Ljc1IDguNDU2NDhINy4zNDM1M0M3LjU4MDY4IDguNDU2NDggNy44MTAxMiA4LjM3MjIgNy45OTA4OCA4LjIxODY4TDEyLjI1MjcgNC41OTkwN0MxMi45MDIyIDQuMDQ3MzkgMTMuOSA0LjUwOTA0IDEzLjkgNS4zNjEyN1YxOC42Mzg2QzEzLjkgMTkuNDkwOSAxMi45MDIyIDE5Ljk1MjUgMTIuMjUyNyAxOS40MDA4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuNjY0MSA4LjU0MTkyQzE3LjE0NDkgOC44OTIzOCAxNy41NDQxIDkuMzk2NDUgMTcuODIxNyAxMC4wMDM1QzE4LjA5OTMgMTAuNjEwNSAxOC4yNDU1IDExLjI5OTEgMTguMjQ1NSAxMkMxOC4yNDU1IDEyLjcwMDkgMTguMDk5MyAxMy4zODk1IDE3LjgyMTcgMTMuOTk2NUMxNy41NDQxIDE0LjYwMzUgMTcuMTQ0OSAxNS4xMDc2IDE2LjY2NDEgMTUuNDU4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE4LjcgNi40MjM5MUMxOS40NzUzIDYuOTg5MDMgMjAuMTE5MSA3LjgwMTg0IDIwLjU2NjcgOC43ODA2NUMyMS4wMTQ0IDkuNzU5NDcgMjEuMjUgMTAuODY5OCAyMS4yNSAxMkMyMS4yNSAxMy4xMzAzIDIxLjAxNDQgMTQuMjQwNiAyMC41NjY3IDE1LjIxOTRDMjAuMTE5MSAxNi4xOTgyIDE5LjQ3NTMgMTcuMDExIDE4LjcgMTcuNTc2MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const Volume0Icon: ProIcon;
export { Volume0Icon }
export { Volume0Icon as volume0 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjI1MjcgMTkuNDAwOEw3Ljk5MDg4IDE1Ljc4MTNDNy44MTAxMiAxNS42Mjc3IDcuNTgwNjkgMTUuNTQzNSA3LjM0MzUzIDE1LjU0MzVINC43NUMzLjY0NTQzIDE1LjU0MzUgMi43NSAxNC42NDggMi43NSAxMy41NDM1VjEwLjQ1NjVDMi43NSA5LjM1MTkyIDMuNjQ1NDMgOC40NTY0OCA0Ljc1IDguNDU2NDhINy4zNDM1M0M3LjU4MDY4IDguNDU2NDggNy44MTAxMiA4LjM3MjIgNy45OTA4OCA4LjIxODY4TDEyLjI1MjcgNC41OTkwN0MxMi45MDIyIDQuMDQ3MzkgMTMuOSA0LjUwOTA0IDEzLjkgNS4zNjEyN1YxOC42Mzg2QzEzLjkgMTkuNDkwOSAxMi45MDIyIDE5Ljk1MjUgMTIuMjUyNyAxOS40MDA4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuNjY0IDguNTQxOTJDMTcuMTQ0OSA4Ljg5MjM4IDE3LjU0NDEgOS4zOTY0NSAxNy44MjE3IDEwLjAwMzVDMTguMDk5MyAxMC42MTA1IDE4LjI0NTQgMTEuMjk5MSAxOC4yNDU0IDEyQzE4LjI0NTQgMTIuNzAwOSAxOC4wOTkzIDEzLjM4OTUgMTcuODIxNyAxMy45OTY1QzE3LjU0NDEgMTQuNjAzNSAxNy4xNDQ5IDE1LjEwNzYgMTYuNjY0IDE1LjQ1OCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const Volume1Icon: ProIcon;
export { Volume1Icon }
export { Volume1Icon as volume1 }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjI1MjcgMTkuNDAwOEw3Ljk5MDg4IDE1Ljc4MTNDNy44MTAxMiAxNS42Mjc3IDcuNTgwNjkgMTUuNTQzNSA3LjM0MzUzIDE1LjU0MzVINC43NUMzLjY0NTQzIDE1LjU0MzUgMi43NSAxNC42NDggMi43NSAxMy41NDM1VjEwLjQ1NjVDMi43NSA5LjM1MTkyIDMuNjQ1NDMgOC40NTY0OCA0Ljc1IDguNDU2NDhINy4zNDM1M0M3LjU4MDY4IDguNDU2NDggNy44MTAxMiA4LjM3MjIgNy45OTA4OCA4LjIxODY4TDEyLjI1MjcgNC41OTkwN0MxMi45MDIyIDQuMDQ3MzkgMTMuOSA0LjUwOTA0IDEzLjkgNS4zNjEyN1YxOC42Mzg2QzEzLjkgMTkuNDkwOSAxMi45MDIyIDE5Ljk1MjUgMTIuMjUyNyAxOS40MDA4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuNjY0MSA4LjU0MTkyQzE3LjE0NDkgOC44OTIzOCAxNy41NDQxIDkuMzk2NDUgMTcuODIxNyAxMC4wMDM1QzE4LjA5OTMgMTAuNjEwNSAxOC4yNDU1IDExLjI5OTEgMTguMjQ1NSAxMkMxOC4yNDU1IDEyLjcwMDkgMTguMDk5MyAxMy4zODk1IDE3LjgyMTcgMTMuOTk2NUMxNy41NDQxIDE0LjYwMzUgMTcuMTQ0OSAxNS4xMDc2IDE2LjY2NDEgMTUuNDU4IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE4LjcgNi40MjM5MUMxOS40NzUzIDYuOTg5MDMgMjAuMTE5MSA3LjgwMTg0IDIwLjU2NjcgOC43ODA2NUMyMS4wMTQ0IDkuNzU5NDcgMjEuMjUgMTAuODY5OCAyMS4yNSAxMkMyMS4yNSAxMy4xMzAzIDIxLjAxNDQgMTQuMjQwNiAyMC41NjY3IDE1LjIxOTRDMjAuMTE5MSAxNi4xOTgyIDE5LjQ3NTMgMTcuMDExIDE4LjcgMTcuNTc2MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const VolumeIcon: ProIcon;
export { VolumeIcon }
export { VolumeIcon as volume }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjI1MjcgMTkuNDAwOEw3Ljk5MDg4IDE1Ljc4MTNDNy44MTAxMiAxNS42Mjc3IDcuNTgwNjkgMTUuNTQzNSA3LjM0MzUzIDE1LjU0MzVINC43NUMzLjY0NTQzIDE1LjU0MzUgMi43NSAxNC42NDggMi43NSAxMy41NDM1VjEwLjQ1NjVDMi43NSA5LjM1MTkyIDMuNjQ1NDMgOC40NTY0OCA0Ljc1IDguNDU2NDhINy4zNDM1M0M3LjU4MDY4IDguNDU2NDggNy44MTAxMiA4LjM3MjIgNy45OTA4OCA4LjIxODY4TDEyLjI1MjcgNC41OTkwN0MxMi45MDIyIDQuMDQ3MzkgMTMuOSA0LjUwOTA0IDEzLjkgNS4zNjEyN1YxOC42Mzg2QzEzLjkgMTkuNDkwOSAxMi45MDIyIDE5Ljk1MjUgMTIuMjUyNyAxOS40MDA4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTYuNTMgOS42Mzk4OUwyMS4yNSAxNC4zNTk5TTIxLjI1IDkuNjM5ODlMMTYuNTMgMTQuMzU5OSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const VolumeMuteIcon: ProIcon;
export { VolumeMuteIcon }
export { VolumeMuteIcon as volumeMute }

/**
 * @description JavaScript, Framework, Open Source, Evan You
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTUuNzAxNCA0LjU3MDAxSDguODYxOTlDOS4yNDU2MSA0LjU3MDAxIDkuNjAwOTYgNC43NzE3NiA5Ljc5NzU1IDUuMTAxMThMMTIgOC43OTE3N0wxNC4yMDI1IDUuMTAxMThDMTQuMzk5IDQuNzcxNzYgMTQuNzU0NCA0LjU3MDAxIDE1LjEzOCA0LjU3MDAxSDE4LjI5ODZNNS43MDE0IDQuNTcwMDFIMy44NDExNkMyLjk5NTQ3IDQuNTcwMDEgMi40NzIyMiA1LjQ5MTYgMi45MDU2MSA2LjIxNzgxTDExLjA2NDQgMTkuODg5NEMxMS40ODcxIDIwLjU5NzYgMTIuNTEyOSAyMC41OTc2IDEyLjkzNTYgMTkuODg5NEwyMS4wOTQ0IDYuMjE3ODFDMjEuNTI3OCA1LjQ5MTYgMjEuMDA0NSA0LjU3MDAxIDIwLjE1ODggNC41NzAwMUgxOC4yOTg2TTUuNzAxNCA0LjU3MDAxTDEyIDE1LjEyNDRMMTguMjk4NiA0LjU3MDAxIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.10.0
 */
declare const VuejsIcon: ProIcon;
export { VuejsIcon }
export { VuejsIcon as vuejs }

/**
 * @description Apple Watch, Watch, Samsung Galaxy, Clock, Time, Smartwatch, Tracker
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE4LjMxMzggMTJDMTguMzEzOCA5Ljg5MTAzIDE3LjI3OTggOC4wMjM1NiAxNS42OTExIDYuODc2ODlWMy45NTcwNkMxNS42OTExIDMuMTUyMzUgMTUuMDM4OCAyLjUgMTQuMjM0MSAyLjVIOS43NjU3OUM4Ljk2MTA4IDIuNSA4LjMwODczIDMuMTUyMzUgOC4zMDg3MyAzLjk1NzA1VjYuODc2ODlDNi43MjAwNCA4LjAyMzU2IDUuNjg2MDQgOS44OTEwMyA1LjY4NjA0IDEyTTE4LjMxMzggMTJDMTguMzEzOCAxNC4xMDkgMTcuMjc5OCAxNS45NzY0IDE1LjY5MTEgMTcuMTIzMVYyMC4wNDI5QzE1LjY5MTEgMjAuODQ3NyAxNS4wMzg4IDIxLjUgMTQuMjM0MSAyMS41SDkuNzY1NzlDOC45NjEwOCAyMS41IDguMzA4NzMgMjAuODQ3NyA4LjMwODczIDIwLjA0MjlWMTcuMTIzMUM2LjcyMDA0IDE1Ljk3NjQgNS42ODYwNCAxNC4xMDkgNS42ODYwNCAxMk0xOC4zMTM4IDEyQzE4LjMxMzggMTUuNDg3MSAxNS40ODcgMTguMzEzOSAxMS45OTk5IDE4LjMxMzlDOC41MTI4NyAxOC4zMTM5IDUuNjg2MDQgMTUuNDg3MSA1LjY4NjA0IDEyTTE4LjMxMzggMTJDMTguMzEzOCA4LjUxMjkzIDE1LjQ4NyA1LjY4NjA5IDExLjk5OTkgNS42ODYwOUM4LjUxMjg3IDUuNjg2MDkgNS42ODYwNCA4LjUxMjkzIDUuNjg2MDQgMTIiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const WatchIcon: ProIcon;
export { WatchIcon }
export { WatchIcon as watch }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNDY0ODIgMTMuNzk2M0MzLjAxNjUgMTMuMjE0MSAyLjc1IDEyLjQ4NTQgMi43NSAxMS42OTQ2QzIuNzUgOS45MDQ2OCA0LjExNTM1IDguNDMyOCA1Ljg2Mzk2IDguMjU4NDhDNi4wMTk0MyA4LjI0Mjk4IDYuMTQwMzQgOC4xMDk2NiA2LjE0MDM0IDcuOTUzNDJDNi4xNDAzNCA2LjA0NjE1IDcuNjkwNTQgNC41IDkuNjAyODIgNC41QzEwLjQ4MjEgNC41IDExLjI4NDkgNC44MjY5MiAxMS44OTU2IDUuMzY1NTVNMTYuNTYxMiAxMS40NDk0QzE2LjU2MTIgOS41NDIwOSAxNS4wMTEgNy45OTU5NCAxMy4wOTg4IDcuOTk1OTRDMTMuMDg4NiA3Ljk5NTk0IDEzLjA3ODUgNy45OTU5OCAxMy4wNjg0IDcuOTk2MDdDMTEuMTcwMSA4LjAxMjM1IDkuNjM2MjggOS41NTIyIDkuNjM2MjggMTEuNDQ5NEM5LjYzNjI4IDExLjYwNTYgOS41MTUzNyAxMS43Mzg5IDkuMzU5OSAxMS43NTQ0QzcuNjI1MTUgMTEuOTI3NCA2LjI2NzYyIDEzLjM3NzQgNi4yNDYyIDE1LjE0OEM2LjI0NjAzIDE1LjE2MjIgNi4yNDU5NCAxNS4xNzY0IDYuMjQ1OTQgMTUuMTkwNkM2LjI0NTk0IDE3LjA5NzggNy43OTYxNCAxOC42NDQgOS43MDg0MiAxOC42NDRIMTcuNzg3NUMxOS42OTk4IDE4LjY0NCAyMS4yNSAxNy4wOTc4IDIxLjI1IDE1LjE5MDZDMjEuMjUgMTMuMjgzMyAxOS42OTk4IDExLjczNzEgMTcuNzg3NSAxMS43MzcxSDE2LjgzNzVDMTYuNjgyNCAxMS43MzcxIDE2LjU2MTIgMTEuNjA0NSAxNi41NjEyIDExLjQ0OTRaIiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const WeatherCloudyIcon: ProIcon;
export { WeatherCloudyIcon }
export { WeatherCloudyIcon as weatherCloudy }

/**
 * @description Module Bundler, JavaScript
 * @preview ![Icon preview](data:image/svg+xml;base64,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)
 * @added v4.10.0
 */
declare const WebpackIcon: ProIcon;
export { WebpackIcon }
export { WebpackIcon as webpack }

/**
 * @description Internet
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgOC45ODc1OEMzLjg4MzY0IDcuNjM2NTYgNS4yOTk2MiA2LjU1MDQzIDYuODk4MjcgNS44MDU2NUM4LjQ5NjkyIDUuMDYwODcgMTAuMjM5NCA0LjY3NTUzIDEyLjAwMyA0LjY3Njc2QzEzLjc2NjYgNC42Nzc5OSAxNS41MDg2IDUuMDY1NzYgMTcuMTA2MiA1LjgxMjc4QzE4LjcwMzggNi41NTk3OSAyMC4xMTgyIDcuNjQ3OSAyMS4yNSA5LjAwMDUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNNS42NDA2MiAxMS45NjQyQzYuNDIgMTEuMDM1NCA3LjM5MzQ5IDEwLjI4ODYgOC40OTI1NiA5Ljc3NjZDOS41OTE2MyA5LjI2NDU2IDEwLjc4OTYgOC45OTk2NCAxMi4wMDIxIDkuMDAwNDlDMTMuMjE0NiA5LjAwMTM0IDE0LjQxMjEgOS4yNjc5MyAxNS41MTA1IDkuNzgxNUMxNi42MDg5IDEwLjI5NTEgMTcuNTgxMyAxMS4wNDMxIDE4LjM1OTQgMTEuOTczMSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik04LjU1NTQ4IDE1LjAwMzNDOC45Nzc2MyAxNC41MDAyIDkuNTA0OTIgMTQuMDk1OCAxMC4xMDAyIDEzLjgxODRDMTAuNjk1NSAxMy41NDExIDExLjM0NDQgMTMuMzk3NiAxMi4wMDEyIDEzLjM5OEMxMi42NTc5IDEzLjM5ODUgMTMuMzA2NiAxMy41NDI5IDEzLjkwMTUgMTMuODIxMUMxNC40OTY0IDE0LjA5OTMgMTUuMDIzMSAxNC41MDQ0IDE1LjQ0NDYgMTUuMDA4MSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxjaXJjbGUgY3g9IjEyIiBjeT0iMTcuODc3OSIgcj0iMS40NDUzMSIgZmlsbD0iI2ZmZmZmZiIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const WiFiIcon: ProIcon;
export { WiFiIcon }
export { WiFiIcon as wiFi }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTMuNzUgNy43NUMzLjc1IDUuNTQwODYgNS41NDA4NiAzLjc1IDcuNzUgMy43NUgxNi4yNUMxOC40NTkxIDMuNzUgMjAuMjUgNS41NDA4NiAyMC4yNSA3Ljc1VjE2LjI1QzIwLjI1IDE4LjQ1OTEgMTguNDU5MSAyMC4yNSAxNi4yNSAyMC4yNUg3Ljc1QzUuNTQwODYgMjAuMjUgMy43NSAxOC40NTkxIDMuNzUgMTYuMjVWNy43NVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMy43NSA4LjI1SDIwLjI1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const WindowIcon: ProIcon;
export { WindowIcon }
export { WindowIcon as window }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNzUgNi4yNUMyLjc1IDQuMzE3IDQuMzE3IDIuNzUgNi4yNSAyLjc1SDE0Ljc1QzE2LjY4MyAyLjc1IDE4LjI1IDQuMzE3IDE4LjI1IDYuMjVWMTQuNzVDMTguMjUgMTYuNjgzIDE2LjY4MyAxOC4yNSAxNC43NSAxOC4yNUg2LjI1QzQuMzE3IDE4LjI1IDIuNzUgMTYuNjgzIDIuNzUgMTQuNzVWNi4yNVoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMjEuMjUgNi43NVYxNC4yNVYxNC43NUMyMS4yNSAxOC4zMzk5IDE4LjMzOTkgMjEuMjUgMTQuNzUgMjEuMjVIMTQuMjVINi43NSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0yLjc1IDYuOTc3MjlIMTguMjUiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 * @updated v4.11.0
 */
declare const WindowMultipleIcon: ProIcon;
export { WindowMultipleIcon }
export { WindowMultipleIcon as WindowMultipleVarIcon }
export { WindowMultipleIcon as windowMultiple }
export { WindowMultipleIcon as windowMultipleVar }

/**
 * @description Configure, Spanner, Options, Mechanism, Mechanic
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwLjY5MTIgNC41NjE2M0MxMi40NjA4IDIuNzkyMDYgMTUuMDM1OCAyLjMxODg1IDE3LjIzNjIgMy4xNDIwMkMxNy42MTM2IDMuMjgzMjEgMTcuNjg2MiAzLjc2MjY3IDE3LjQwMTMgNC4wNDc2TDE0LjYxMzkgNi44MzUwMUMxNC4yMDg4IDcuMjQwMSAxNC4yMDg4IDcuODk2ODggMTQuNjEzOSA4LjMwMTk3TDE1LjY5ODIgOS4zODYzMkMxNi4xMDMzIDkuNzkxNDEgMTYuNzYwMSA5Ljc5MTQxIDE3LjE2NTIgOS4zODYzMkwxOS45NTI2IDYuNTk4OTFDMjAuMjM3NSA2LjMxMzk4IDIwLjcxNyA2LjM4NjYyIDIwLjg1ODIgNi43NjQwMUMyMS42ODEzIDguOTY0MzcgMjEuMjA4MSAxMS41Mzk0IDE5LjQzODUgMTMuMzA5QzE3Ljc0MDQgMTUuMDA3MSAxNS4zMDA2IDE1LjUxMTQgMTMuMTYxOSAxNC44MjE5QzEyLjc2NTkgMTQuNjk0MyAxMi4zMjI1IDE0Ljc2OCAxMi4wMjg0IDE1LjA2MjJMNi40ODEwMSAyMC42MDk2QzUuNjI3NjEgMjEuNDYzIDQuMjQzMjYgMjEuNDYzNyAzLjM4OTg3IDIwLjYxMDNDMi41MzY0NyAxOS43NTY5IDIuNTM3MiAxOC4zNzI1IDMuMzkwNTkgMTcuNTE5MUw4LjkzODAxIDExLjk3MTdDOS4yMzIxNCAxMS42Nzc2IDkuMzA1ODUgMTEuMjM0MiA5LjE3ODIyIDEwLjgzODNDOC40ODg3NiA4LjY5OTYgOC45OTMwOSA2LjI1OTc1IDEwLjY5MTIgNC41NjE2M1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const WrenchIcon: ProIcon;
export { WrenchIcon }
export { WrenchIcon as wrench }

/**
 * @description Twitter, X/Twitter, X Corp., Elon Musk, Bird, Tweet, Post, Social Media
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEzLjA4MSAxMC43MTE3TDguMjk0NzQgNC4wMDE1OEM4LjE4MjEzIDMuODQzNzEgOC4wMDAxOCAzLjc1IDcuODA2MjYgMy43NUw1LjI4MDI1IDMuNzUwMDNDNC43OTI0MSAzLjc1MDAzIDQuNTA4NSA0LjMwMTI5IDQuNzkxNzkgNC42OTg0NUwxMC45MTg5IDEzLjI4ODRNMTMuMDgxIDEwLjcxMTdMMTkuMjA4MSAxOS4zMDE2QzE5LjQ5MTQgMTkuNjk4NyAxOS4yMDc1IDIwLjI1IDE4LjcxOTcgMjAuMjVMMTYuMTkzNyAyMC4yNUMxNS45OTk3IDIwLjI1IDE1LjgxNzggMjAuMTU2MyAxNS43MDUyIDE5Ljk5ODVMMTAuOTE4OSAxMy4yODg0TTEzLjA4MSAxMC43MTE3TDE4LjkyMjYgMy43NU0xMC45MTg5IDEzLjI4ODRMNS4wNzc0NCAyMC4yNSIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const XTwitterIcon: ProIcon;
export { XTwitterIcon as TwitterIcon }
export { XTwitterIcon }
export { XTwitterIcon as twitter }
export { XTwitterIcon as xTwitter }

/**
 * @description Social, Shorts, Watch, Videos
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTIuNDQ5OTUgMTEuNDE4N0MyLjQ0OTk1IDguNDAxNzUgMi43NDk5NSA2Ljg5MzI1IDMuNjg3MjEgNS45NTZDNC42MjQ0NyA1LjAxODc0IDYuMTMyOTYgNS4wMTg3NCA5LjE0OTk1IDUuMDE4NzRIMTQuODVDMTcuODY2OSA1LjAxODc0IDE5LjM3NTQgNS4wMTg3NCAyMC4zMTI3IDUuOTU2QzIxLjI1IDYuODkzMjUgMjEuNTQ5OSA4LjQwMTc1IDIxLjU0OTkgMTEuNDE4N1YxMi41ODEyQzIxLjU0OTkgMTUuNTk4MiAyMS4yNSAxNy4xMDY3IDIwLjMxMjcgMTguMDQ0QzE5LjM3NTQgMTguOTgxMiAxNy44NjY5IDE4Ljk4MTIgMTQuODUgMTguOTgxMkg5LjE0OTk1QzYuMTMyOTYgMTguOTgxMiA0LjYyNDQ3IDE4Ljk4MTIgMy42ODcyMSAxOC4wNDRDMi43NDk5NSAxNy4xMDY3IDIuNDQ5OTUgMTUuNTk4MiAyLjQ0OTk1IDEyLjU4MTJWMTEuNDE4N1oiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTQuNjg1OSAxMS40OTEyTDEwLjQxOCA4LjgyMzc1QzEwLjAxODQgOC41NzM5OCA5LjUgOC44NjEyOSA5LjUgOS4zMzI1NVYxNC42Njc1QzkuNSAxNS4xMzg3IDEwLjAxODQgMTUuNDI2IDEwLjQxOCAxNS4xNzYzTDE0LjY4NTkgMTIuNTA4OEMxNS4wNjE5IDEyLjI3MzggMTUuMDYxOSAxMS43MjYyIDE0LjY4NTkgMTEuNDkxMloiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPC9zdmc+)
 * @added v4.8.0
 */
declare const YoutubeIcon: ProIcon;
export { YoutubeIcon }
export { YoutubeIcon as youtube }

/**
 * @description YT Shorts, Watch, YouTube, Vertical, TikTok
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEyLjgzNDIgMy4xODY0OEMxNC41Njg3IDIuMTg1MDQgMTYuNzg2NiAyLjc3OTM0IDE3Ljc4ODEgNC41MTM4OEMxOC43ODk1IDYuMjQ4NDEgMTguMTk1MiA4LjQ2NjM2IDE2LjQ2MDcgOS40Njc3OUwxNS43MjE2IDkuODk0NDlDMTcuMDE1NyA5Ljg1MjU1IDE4LjI5MDMgMTAuNTA2OCAxOC45ODI5IDExLjcwNjVDMTkuOTg0NCAxMy40NDEgMTkuMzkwMSAxNS42NTg5IDE3LjY1NTUgMTYuNjYwNEwxMC42MzUyIDIwLjcxMzVDOC45MDA3IDIxLjcxNSA2LjY4Mjc2IDIxLjEyMDcgNS42ODEzMyAxOS4zODYxQzQuNjc5ODkgMTcuNjUxNiA1LjI3NDE5IDE1LjQzMzcgNy4wMDg3MiAxNC40MzIyTDcuNzQ3NzkgMTQuMDA1NUM2LjQ1MzcgMTQuMDQ3NSA1LjE3OTExIDEzLjM5MzMgNC40ODY0NyAxMi4xOTM2QzMuNDg1MDMgMTAuNDU5IDQuMDc5MzMgOC4yNDEwOCA1LjgxMzg2IDcuMjM5NjVMMTIuODM0MiAzLjE4NjQ4WiIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNMTMuOTkyNCAxMS4wMTZMMTEuMiA5LjI3MDdDMTAuNDU5OSA4LjgwODE3IDkuNSA5LjM0MDIyIDkuNSAxMC4yMTI5TDkuNSAxMy43MDM1QzkuNSAxNC41NzYyIDEwLjQ1OTkgMTUuMTA4MiAxMS4yIDE0LjY0NTdMMTMuOTkyNCAxMi45MDA0QzE0LjY4ODcgMTIuNDY1MiAxNC42ODg3IDExLjQ1MTIgMTMuOTkyNCAxMS4wMTZaIiBmaWxsPSIjZmZmZmZmIi8+Cjwvc3ZnPg==)
 * @added v4.8.0
 */
declare const YoutubeShortsIcon: ProIcon;
export { YoutubeShortsIcon }
export { YoutubeShortsIcon as youtubeShorts }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNTYwNTggMTAuNTYwNUgxMy41NjA2TTEwLjU2MDYgMTMuNTYwNVY3LjU2MDU1IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjU1MzIgMTUuNTUzMkMxOC4zMTA1IDEyLjc5NTggMTguMzEwNSA4LjMyNTMzIDE1LjU1MzIgNS41NjhDMTIuNzk1OCAyLjgxMDY3IDguMzI1MzMgMi44MTA2NyA1LjU2OCA1LjU2OEMyLjgxMDY3IDguMzI1MzMgMi44MTA2NyAxMi43OTU4IDUuNTY4IDE1LjU1MzJDOC4zMjUzMyAxOC4zMTA1IDEyLjc5NTggMTguMzEwNSAxNS41NTMyIDE1LjU1MzJaTTE1LjU1MzIgMTUuNTUzMkwyMCAyMCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS41NTMyIDUuNTY4QzE4LjMxMDUgOC4zMjUzMyAxOC4zMTA1IDEyLjc5NTggMTUuNTUzMiAxNS41NTMyQzEyLjc5NTggMTguMzEwNSA4LjMyNTMzIDE4LjMxMDUgNS41NjggMTUuNTUzMkMyLjgxMDY3IDEyLjc5NTggMi44MTA2NyA4LjMyNTMzIDUuNTY4IDUuNTY4QzguMzI1MzMgMi44MTA2NyAxMi43OTU4IDIuODEwNjcgMTUuNTUzMiA1LjU2OFoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ZoomInIcon: ProIcon;
export { ZoomInIcon }
export { ZoomInIcon as zoomIn }

/**
 * @description
 * @preview ![Icon preview](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTcuNTYwNjEgMTAuNTYwNUgxMy41NjA2IiBzdHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMS41IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTE1LjU1MzIgMTUuNTUzMkMxOC4zMTA1IDEyLjc5NTggMTguMzEwNSA4LjMyNTMzIDE1LjU1MzIgNS41NjhDMTIuNzk1OCAyLjgxMDY3IDguMzI1MzMgMi44MTA2NyA1LjU2OCA1LjU2OEMyLjgxMDY3IDguMzI1MzMgMi44MTA2NyAxMi43OTU4IDUuNTY4IDE1LjU1MzJDOC4zMjUzMyAxOC4zMTA1IDEyLjc5NTggMTguMzEwNSAxNS41NTMyIDE1LjU1MzJaTTE1LjU1MzIgMTUuNTUzMkwyMCAyMCIgc3Ryb2tlPSIjZmZmZmZmIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+CjxwYXRoIGQ9Ik0xNS41NTMyIDUuNTY4QzE4LjMxMDUgOC4zMjUzMyAxOC4zMTA1IDEyLjc5NTggMTUuNTUzMiAxNS41NTMyQzEyLjc5NTggMTguMzEwNSA4LjMyNTMzIDE4LjMxMDUgNS41NjggMTUuNTUzMkMyLjgxMDY3IDEyLjc5NTggMi44MTA2NyA4LjMyNTMzIDUuNTY4IDUuNTY4QzguMzI1MzMgMi44MTA2NyAxMi43OTU4IDIuODEwNjcgMTUuNTUzMiA1LjU2OFoiIHN0cm9rZT0iI2ZmZmZmZiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4=)
 * @added v4.8.0
 */
declare const ZoomOutIcon: ProIcon;
export { ZoomOutIcon }
export { ZoomOutIcon as zoomOut }

export { }
