/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const WiFiIcon = createIcon(
  {
    name: "Wi-Fi",
    tags: ["Internet"],
    category: "Communication & Cloud",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M2.75 8.988A12.068 12.068 0 0 1 21.25 9"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M5.64 11.964a8.297 8.297 0 0 1 12.72.01m-9.805 3.029a4.495 4.495 0 0 1 6.89.005"
      },
      []
    ],
    ["circle", { cx: "12", cy: "17.878", r: "1.445", fill: "currentColor" }, []]
  ]
);
export {
  WiFiIcon
};
