/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const SearchCancelIcon = createIcon(
  {
    name: "Search Cancel",
    tags: ["No Results", "Clear Search"],
    category: "Actions",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "m8.44 12.682 2.12-2.121m0 0 2.122-2.122m-2.121 2.122 2.12 2.12m-2.12-2.12L8.439 8.439m7.114 7.114a7.06 7.06 0 1 0-9.985-9.985 7.06 7.06 0 0 0 9.985 9.985m0 0L20 20"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M15.553 5.568a7.06 7.06 0 1 1-9.985 9.985 7.06 7.06 0 0 1 9.985-9.985"
      },
      []
    ]
  ]
);
export {
  SearchCancelIcon
};
