/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const ScreenSizeIcon = createIcon(
  {
    name: "Screen Size",
    tags: ["Aspect Ratio"],
    category: "Math & Numbers",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "18.5",
        height: "15.5",
        x: "2.75",
        y: "4.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M6.75 12.25v-4h4m6.5 3.5v4h-4"
      },
      []
    ]
  ]
);
export {
  ScreenSizeIcon
};
