/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const RulerIcon = createIcon(
  {
    name: "Ruler",
    tags: ["Measure", "Length", "Meter", "Foot", "Metre", "Feet", "Yard"],
    category: "Math & Numbers",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "9.5",
        height: "18.5",
        x: "6.75",
        y: "2.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-width": "1.5",
        d: "M6.75 12h4.5m-4.5-4.5h4.5m-4.5 9h4.5"
      },
      []
    ]
  ]
);
export {
  RulerIcon
};
