/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const RulerDiagonalIcon = createIcon(
  {
    name: "Ruler Diagonal",
    tags: ["Measure", "Length", "Meter", "Foot", "Metre", "Feet", "Yard"],
    category: "Math & Numbers",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "9",
        height: "19.5",
        x: "15.712",
        y: "1.924",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "rotate(45 15.712 1.924)"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-width": "1.5",
        d: "M8.818 8.818 12 12m0-6.364 3.182 3.182M5.636 12l3.182 3.182"
      },
      []
    ]
  ]
);
export {
  RulerDiagonalIcon
};
