/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const QuestionCircleIcon = createIcon(
  {
    name: "Question Circle",
    tags: ["Help", "Support"],
    category: "Miscellaneous",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M9.301 9.709a2.699 2.699 0 1 1 4.85 1.63 4 4 0 0 1-.32.317c-.092.078-.137.11-.227.171l-.979.675a1.81 1.81 0 0 0-.784 1.493"
      },
      []
    ],
    ["circle", { cx: "11.828", cy: "16.74", r: "1", fill: "currentColor" }, []],
    [
      "circle",
      {
        cx: "12",
        cy: "12",
        r: "9.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5"
      },
      []
    ]
  ]
);
export {
  QuestionCircleIcon
};
