/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const PictureInPictureExitIcon = createIcon(
  {
    name: "Picture in Picture Exit",
    tags: [""],
    category: "Window",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M14.75 5.75h3.5a3 3 0 0 1 3 3v8.5a3 3 0 0 1-3 3H5.75a3 3 0 0 1-3-3v-3.5"
      },
      []
    ],
    [
      "rect",
      {
        width: "12",
        height: "10",
        x: "13",
        y: "12",
        fill: "currentColor",
        rx: "2",
        transform: "rotate(180 13 12)"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M18 13.667V16.4a.6.6 0 0 1-.176.424M14.667 17H17.4a.6.6 0 0 0 .424-.176M14 13l3 3 .824.824"
      },
      []
    ]
  ]
);
export {
  PictureInPictureExitIcon
};
