/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const PersonAddIcon = createIcon(
  {
    name: "Person Add",
    tags: ["Account Add", "User"],
    category: "Communication & Cloud",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M14.104 6.854a3.604 3.604 0 1 1-7.208 0 3.604 3.604 0 0 1 7.208 0M10.87 20.75H3.5a1 1 0 0 1-1-1v-1.246c0-2.806 3.974-5.004 8-5.004q.387 0 .77.027"
      },
      []
    ],
    [
      "path",
      {
        fill: "currentColor",
        "fill-rule": "evenodd",
        d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.494a.5.5 0 0 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
        "clip-rule": "evenodd"
      },
      []
    ]
  ]
);
export {
  PersonAddIcon
};
