/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const MailOpenIcon = createIcon(
  {
    name: "Mail Open",
    tags: ["Gmail", "Outlook", "Yahoo", "Inbox", "Unread", "Envelope Open"],
    category: "Communication & Cloud",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "m20.59 8.949-7.755 3.562a2 2 0 0 1-1.67 0L3.41 8.95m14.84 11.3H5.75a3 3 0 0 1-3-3v-7.215A2.5 2.5 0 0 1 3.93 7.91l7.014-4.36a2 2 0 0 1 2.112 0l7.014 4.36a2.5 2.5 0 0 1 1.18 2.124v7.215a3 3 0 0 1-3 3"
      },
      []
    ]
  ]
);
export {
  MailOpenIcon
};
