/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const LocationIcon = createIcon(
  {
    name: "Location",
    tags: [""],
    category: "Places & Transportation",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M6.4 4.76a7.92 7.92 0 0 1 11.2 11.2l-4.186 4.186a2 2 0 0 1-2.828 0L6.4 15.96a7.92 7.92 0 0 1 0-11.2Z"
      },
      []
    ],
    [
      "circle",
      {
        cx: "12",
        cy: "10.36",
        r: "3",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5"
      },
      []
    ]
  ]
);
export {
  LocationIcon
};
