/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const KeyboardIcon = createIcon(
  { name: "Keyboard", tags: ["Peripheral"], category: "Technology", deprecated: false },
  [
    [
      "rect",
      {
        width: "18.5",
        height: "13.5",
        x: "2.75",
        y: "5.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M8 15.38h8"
      },
      []
    ],
    ["circle", { cx: "7.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "10.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "13.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "16.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "7.5", cy: "11.875", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "10.5", cy: "11.875", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "13.5", cy: "11.875", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "16.5", cy: "11.875", r: "1", fill: "currentColor" }, []]
  ]
);
export {
  KeyboardIcon
};
