/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const KeyboardCommandIcon = createIcon(
  {
    name: "Keyboard Command",
    tags: ["Mac", "macOS", "Meta", "Super", "Cmd"],
    category: "Actions",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M2.75 5.751a3 3 0 0 1 3-3v0a3 3 0 0 1 3 3v3h-3a3 3 0 0 1-3-3m0 12.498a3 3 0 0 0 3 3v0a3 3 0 0 0 3-3v-3h-3a3 3 0 0 0-3 3m18.5-12.498a3 3 0 0 0-3-3v0a3 3 0 0 0-3 3v3h3a3 3 0 0 0 3-3m0 12.498a3 3 0 0 1-3 3v0a3 3 0 0 1-3-3v-3h3a3 3 0 0 1 3 3M8.75 8.751h6.5v6.5h-6.5z"
      },
      []
    ]
  ]
);
export {
  KeyboardCommandIcon
};
