/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const GithubIcon = createIcon(
  {
    name: "GitHub",
    tags: ["Open Source", "Code", "Microsoft", "Git"],
    category: "Logos & Brands",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M9.096 21.25v-3.146a3.33 3.33 0 0 1 .758-2.115c-3.005-.4-5.28-1.859-5.28-5.798 0-1.666 1.432-3.89 1.432-3.89-.514-1.13-.5-3.084.06-3.551 0 0 1.95.175 3.847 1.75 1.838-.495 3.764-.554 5.661 0 1.897-1.575 3.848-1.75 3.848-1.75.558.467.573 2.422.06 3.551 0 0 1.432 2.224 1.432 3.89 0 3.94-2.276 5.398-5.28 5.798a3.33 3.33 0 0 1 .757 2.115v3.146"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M3.086 16.57c.163.554.463 1.066.878 1.496.414.431.932.77 1.513.988a4.46 4.46 0 0 0 3.62-.216"
      },
      []
    ]
  ]
);
export {
  GithubIcon
};
