/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const GameIcon = createIcon(
  {
    name: "Game",
    tags: ["Controller", "Xbox", "PlayStation", "Arcade", "Gaming", "Steam"],
    category: "Technology",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M16.031 3.887H7.97a5.22 5.22 0 0 0-5.219 5.22v8.265c0 2.075 2.533 3.085 3.962 1.581l2.976-3.134h4.624l2.875 3.46c1.374 1.654 4.063.682 4.063-1.467V9.106a5.22 5.22 0 0 0-5.219-5.219M8.138 8.39v4m-2-2h4"
      },
      []
    ],
    ["circle", { cx: "14.662", cy: "9.39", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "16.862", cy: "11.59", r: "1", fill: "currentColor" }, []]
  ]
);
export {
  GameIcon
};
