/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const FigmaIcon = createIcon(
  {
    name: "Figma",
    tags: [
      "Design",
      "Dylan Field",
      "Sketch",
      "Icons",
      "Prototype",
      "Prototyping",
      "Adobe"
    ],
    category: "Logos & Brands",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M5.833 5.833A3.083 3.083 0 0 1 8.917 2.75H12v6.167H8.917a3.083 3.083 0 0 1-3.084-3.084m12.334 0a3.083 3.083 0 0 0-3.084-3.083H12v6.167h3.083a3.083 3.083 0 0 0 3.084-3.084"
      },
      []
    ],
    [
      "rect",
      {
        width: "6.167",
        height: "6.167",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3.083",
        transform: "matrix(-1 0 0 1 18.167 8.917)"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M5.833 12a3.083 3.083 0 0 1 3.084-3.083H12v6.166H8.917A3.083 3.083 0 0 1 5.833 12"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M5.833 18.167a3.083 3.083 0 0 1 3.084-3.084H12v3.084a3.083 3.083 0 0 1-3.083 3.083v0a3.083 3.083 0 0 1-3.084-3.083"
      },
      []
    ]
  ]
);
export {
  FigmaIcon
};
