/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const DoorOpenIcon = createIcon(
  {
    name: "Door Open",
    tags: ["Configure", "Spanner", "Options", "Mechanism", "Mechanic"],
    category: "Places & Transportation",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M16.157 20.517h.593a2.5 2.5 0 0 0 2.5-2.5V5.75a2.5 2.5 0 0 0-2.5-2.5h-9.5c-.55 0-1.06.178-1.473.48m-1.02 13.742a1.5 1.5 0 0 0 .86 1.357l5.896 2.775a1.5 1.5 0 0 0 2.138-1.358V8.387a1.5 1.5 0 0 0-.86-1.356l-7.014-3.3m0 0A2.5 2.5 0 0 0 4.75 5.75v11.722"
      },
      []
    ],
    ["circle", { cx: "10.25", cy: "12.75", r: "1.25", fill: "currentColor" }, []]
  ]
);
export {
  DoorOpenIcon
};
