/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const DollarCircleIcon = createIcon(
  {
    name: "Dollar Circle",
    tags: ["$", "Money", "Cash", "Bill", "Currency"],
    category: "Business",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-width": "1.5",
        d: "M15.099 9.723s-.377-1.783-3.001-1.977m-2.957 7.108s.761 1.8 2.957 1.912m0-10.766v1.746m0 10.754v-1.734m0-9.02a7 7 0 0 0-.476-.017c-1.14 0-2.622.95-2.622 2.275 0 1.326 1.073 1.846 2.965 2.169s3.23 1.035 3.23 2.497-1.566 2.101-2.881 2.101a4 4 0 0 1-.216-.005"
      },
      []
    ],
    [
      "circle",
      {
        cx: "12.25",
        cy: "12.25",
        r: "9.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5"
      },
      []
    ]
  ]
);
export {
  DollarCircleIcon
};
