/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const BarGraphIcon = createIcon(
  {
    name: "Bar Graph",
    tags: ["Stats", "Statistics", "Data", "Graph", "Chart"],
    category: "Layout",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M2.75 21h18.5"
      },
      []
    ],
    [
      "rect",
      {
        width: "6",
        height: "10",
        x: "4",
        y: "7.5",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ],
    [
      "rect",
      {
        width: "6",
        height: "15",
        x: "14",
        y: "2.5",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ]
  ]
);
export {
  BarGraphIcon
};
