/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AppsListIcon = createIcon(
  { name: "Apps List", tags: [""], category: "Organization", deprecated: false },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M10.25 4.5h11"
      },
      []
    ],
    [
      "rect",
      {
        width: "3.5",
        height: "3.5",
        x: "2.75",
        y: "2.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "1.2"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M10.25 12h11"
      },
      []
    ],
    [
      "rect",
      {
        width: "3.5",
        height: "3.5",
        x: "2.75",
        y: "10.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "1.2"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M10.25 19.5h11"
      },
      []
    ],
    [
      "rect",
      {
        width: "3.5",
        height: "3.5",
        x: "2.75",
        y: "17.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "1.2"
      },
      []
    ]
  ]
);
export {
  AppsListIcon
};
