/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AppsIcon = createIcon(
  {
    name: "Apps",
    tags: ["Applications", "Software", "Plugins", "Extensions"],
    category: "Actions",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        x: "3.75",
        y: "3.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M15.586 3.818a2 2 0 0 1 2.828 0l1.768 1.768a2 2 0 0 1 0 2.828l-1.768 1.768a2 2 0 0 1-2.828 0l-1.768-1.768a2 2 0 0 1 0-2.828z"
      },
      []
    ],
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        x: "3.75",
        y: "13.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "1.5"
      },
      []
    ],
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        x: "13.75",
        y: "13.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ]
  ]
);
export {
  AppsIcon
};
