/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AppsAddIcon = createIcon(
  {
    name: "Apps Add",
    tags: ["Add App", "Install"],
    category: "Actions",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        x: "3.75",
        y: "3.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M17 3.75V7m0 0v3.25M17 7h-3.25M17 7h3.25"
      },
      []
    ],
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        x: "3.75",
        y: "13.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ],
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        x: "13.75",
        y: "13.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2"
      },
      []
    ]
  ]
);
export {
  AppsAddIcon
};
