/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AlignVerticalCentersIcon = createIcon(
  {
    name: "Align Vertical Centers",
    tags: [""],
    category: "Organization",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M12 19.75v1.5m0-11v3.5m0-11v1.5"
      },
      []
    ],
    [
      "rect",
      {
        width: "6",
        height: "10",
        x: "7",
        y: "19.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "rotate(-90 7 19.75)"
      },
      []
    ],
    [
      "rect",
      {
        width: "6",
        height: "15",
        x: "4.5",
        y: "10.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "rotate(-90 4.5 10.25)"
      },
      []
    ]
  ]
);
export {
  AlignVerticalCentersIcon
};
