/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AlertTriangleIcon = createIcon(
  { name: "Alert Triangle", tags: ["Warning"], category: "Status", deprecated: false },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-width": "1.5",
        d: "M5.732 20.5c-2.29 0-3.723-2.498-2.581-4.5L9.419 5.006c1.144-2.008 4.018-2.008 5.163 0L20.849 16c1.142 2.002-.291 4.5-2.581 4.5z"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-width": "1.5",
        d: "M12 13.375V9"
      },
      []
    ],
    [
      "circle",
      {
        cx: "1.25",
        cy: "1.25",
        r: "1.25",
        fill: "currentColor",
        transform: "matrix(1 0 0 -1 10.75 17.938)"
      },
      []
    ]
  ]
);
export {
  AlertTriangleIcon
};
