from flask import Blueprint, render_template, request, redirect, url_for, flash
import requests

register_bp = Blueprint('register', __name__)  # Tworzymy blueprint dla rejestracji

API_BASE = 'https://lucy.helioho.st/php_api/index.php'
REGISTER_URL = f'{API_BASE}/User/post'

@register_bp.route('/register', methods=['GET', 'POST'])
def register():
    """
    Funkcja obsługująca rejestrację użytkownika.
    """
    if request.method == 'POST':
        # Pobranie danych z formularza
        user_data = {
            'User_ID': 'NULL',
            'Login': request.form['login'],
            'Password': request.form['password'],
            'Email': request.form['email'],
            'Name': request.form['name'],
            'Lastname': request.form['lastname'],
            'Phone_Number': request.form['phone_number']
        }

        # Wysłanie żądania POST do API rejestracji
        response = requests.post(REGISTER_URL, data=user_data)

        if response.status_code == 200:
            flash('Rejestracja zakończona sukcesem! Teraz możesz się zalogować.', 'success')
            return redirect(url_for('login.login'))
        else:
            flash('Rejestracja nie powiodła się. Spróbuj ponownie.', 'danger')

    return render_template('register.html')
