from flask import Flask
from flask_dance.contrib.google import make_google_blueprint
import os
from app.routes import login_bp, register_bp, dashboard_bp, index_bp, google_login_bp
from decouple import config

#Funkcja tworząca aplikację Flask
def create_app():
    template_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), '..', 'templates'))
    static_dir = os.path.abspath(os.path.join(os.path.dirname(__file__),'..','static'))
    app = Flask(__name__, template_folder=template_dir, static_folder=static_dir)
    app.secret_key = config('APP_SECRET_KEY')

    #Konfiguracje Google OAuth
    os.environ['OAUTHLIB_INSECURE_TRANSPORT'] = '1'  # Umożliwia HTTP (do testów lokalnych)
    google_bp = make_google_blueprint(
        client_id=config('GOOGLE_CLIENT_ID'),
        client_secret=config('GOOGLE_SECRET_CLIENT'),
        redirect_to='google_login.google_login',
        scope=["openid","https://www.googleapis.com/auth/userinfo.email",
            "https://www.googleapis.com/auth/userinfo.profile",
            "https://www.googleapis.com/auth/user.phonenumbers.read"]
    )
    app.register_blueprint(google_bp, url_prefix='/login')

    #Rejestracja blueprintów
    app.register_blueprint(login_bp)
    app.register_blueprint(index_bp)
    app.register_blueprint(dashboard_bp)
    app.register_blueprint(register_bp)
    app.register_blueprint(google_login_bp)

    return app

